/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.log;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.log.LogUtil;
import com.hs.lego.core.log.ZipRollingFileAppender;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.exception.LegoExceptionTranslator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;

public final class ConfigAppender {
    private static Map<String, ZipRollingFileAppender> zipAppenders = new HashMap<String, ZipRollingFileAppender>();

    private ConfigAppender() {
    }

    public static void configurator(Module module) {
        try {
            Appender appender;
            String logName = module.getName();
            Logger log = Logger.getLogger(module.getName());
            Enumeration enumeration = log.getAllAppenders();
            if (null != enumeration) {
                while (enumeration.hasMoreElements()) {
                    appender = (Appender)enumeration.nextElement();
                    if (!(appender instanceof ZipRollingFileAppender)) continue;
                    log.addAppender(appender);
                    return;
                }
            }
            if (null == (appender = zipAppenders.get(logName))) {
                appender = ConfigAppender.getZipRollingFileAppender(logName);
                zipAppenders.put(logName, (ZipRollingFileAppender)appender);
            }
            log.addAppender(appender);
            Category cat = log.getParent();
            if (cat instanceof Logger) {
                Logger parentLogger = (Logger)cat;
                boolean additivity = parentLogger.getAdditivity();
                log.setAdditivity(additivity);
            }
        }
        catch (Exception e) {
            throw LegoExceptionTranslator.convert(e);
        }
    }

    public static ZipRollingFileAppender getZipRollingFileAppender(String logName) throws Exception {
        ZipRollingFileAppender appender = LogUtil.getInstance().getAppender(logName);
        if (null != appender) {
            return appender;
        }
        appender = LogUtil.getInstance().getAticDefaultAppender();
        if (null == appender) {
            throw new LegoCheckedException("Can not find any log appender!");
        }
        String filePath = appender.getFile();
        if (null == filePath) {
            throw new Exception("logName[" + logName + "], appender[" + appender.getName() + "] has no file!");
        }
        filePath = filePath.replace("\\", "/");
        filePath = filePath.substring(0, filePath.lastIndexOf("/") + 1) + logName + ".log";
        return new ZipRollingFileAppender(appender, filePath);
    }
}

