/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.log;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegoLogger
implements Log {
    private Logger slfLogger;
    private String thisClassName = LegoLogger.class.getName();
    private boolean showLocSrc = true;

    protected LegoLogger(Module module) {
        this.slfLogger = LoggerFactory.getLogger(module.getName());
    }

    protected LegoLogger(LegoLogger log) {
        this.slfLogger = log.slfLogger;
        this.showLocSrc = log.showLocSrc;
    }

    @Override
    public void setShowLocSrc(boolean showLocSrc) {
        this.showLocSrc = showLocSrc;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.slfLogger.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.slfLogger.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.slfLogger.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.slfLogger.isWarnEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.slfLogger.isErrorEnabled();
    }

    @Override
    public void debug(Object message) {
        if (this.isDebugEnabled()) {
            if (this.showLocSrc) {
                this.log(10000, message, Thread.currentThread().getName(), Thread.currentThread().getStackTrace());
            } else {
                this.log(10000, message, Thread.currentThread().getName(), null);
            }
        }
    }

    @Override
    public void trace(Object message) {
        if (this.isTraceEnabled()) {
            if (this.showLocSrc) {
                this.log(5000, message, Thread.currentThread().getName(), Thread.currentThread().getStackTrace());
            } else {
                this.log(5000, message, Thread.currentThread().getName(), null);
            }
        }
    }

    @Override
    public void info(Object message) {
        if (this.isInfoEnabled()) {
            if (this.showLocSrc) {
                this.log(20000, message, Thread.currentThread().getName(), Thread.currentThread().getStackTrace());
            } else {
                this.log(20000, message, Thread.currentThread().getName(), null);
            }
        }
    }

    @Override
    public void warn(Object message) {
        if (this.isWarnEnabled()) {
            if (this.showLocSrc) {
                this.log(30000, message, Thread.currentThread().getName(), Thread.currentThread().getStackTrace());
            } else {
                this.log(30000, message, Thread.currentThread().getName(), null);
            }
        }
    }

    @Override
    public void error(Object message) {
        if (this.isErrorEnabled()) {
            if (this.showLocSrc) {
                this.log(40000, message, Thread.currentThread().getName(), Thread.currentThread().getStackTrace());
            } else {
                this.log(40000, message, Thread.currentThread().getName(), null);
            }
        }
    }

    @Override
    public void error(Object message, Throwable t) {
        if (this.isErrorEnabled()) {
            if (this.showLocSrc) {
                this.log(40000, message, t, Thread.currentThread().getName(), Thread.currentThread().getStackTrace());
            } else {
                this.log(40000, message, Thread.currentThread().getName(), null);
            }
        }
    }

    @Override
    public void fatal(Object message) {
        if (this.showLocSrc) {
            this.log(50000, message, Thread.currentThread().getName(), Thread.currentThread().getStackTrace());
        } else {
            this.log(50000, message, Thread.currentThread().getName(), null);
        }
    }

    @Override
    public void fatal(Object message, Throwable t) {
        if (this.showLocSrc) {
            this.log(50000, message, t, Thread.currentThread().getName(), Thread.currentThread().getStackTrace());
        } else {
            this.log(50000, message, Thread.currentThread().getName(), null);
        }
    }

    private void log(int level, Object message, String threadName, StackTraceElement[] ste) {
        StringBuffer msgBuf = new StringBuffer();
        msgBuf.append('[').append(message).append(']').append(this.getStackMsg(threadName, ste));
        String format = this.getFormat(level);
        switch (level) {
            case 5000: {
                this.slfLogger.trace(format.replaceAll("\t|\r|\n", ""), new Object[]{msgBuf});
                break;
            }
            case 10000: {
                this.slfLogger.debug(format.replaceAll("\t|\r|\n", ""), new Object[]{msgBuf});
                break;
            }
            case 20000: {
                this.slfLogger.info(format.replaceAll("\t|\r|\n", ""), new Object[]{msgBuf});
                break;
            }
            case 30000: {
                this.slfLogger.warn(format.replaceAll("\t|\r|\n", ""), new Object[]{msgBuf});
                break;
            }
            default: {
                this.slfLogger.error(format.replaceAll("\t|\r|\n", ""), new Object[]{msgBuf});
            }
        }
    }

    private void log(int level, Object message, Throwable t, String threadName, StackTraceElement[] ste) {
        StringBuffer msgBuf = new StringBuffer();
        msgBuf.append('[').append(message).append(']').append(this.getStackMsg(threadName, ste));
        String errorMsg = this.getErrorMsg(level, msgBuf);
        this.slfLogger.error(errorMsg.replaceAll("\t|\r|\n", ""), t);
    }

    private String getStackMsg(String threadName, StackTraceElement[] ste) {
        if (ste == null) {
            return "[][][,][]";
        }
        boolean srcFlag = false;
        for (int i = 0; i < ste.length; ++i) {
            StackTraceElement s = ste[i];
            if (srcFlag) {
                return new StringBuffer().append("[").append(s.getClassName()).append("][").append(s.getMethodName()).append(',').append(s.getLineNumber()).append("][").append(threadName).append(']').toString();
            }
            if (!this.thisClassName.equals(s.getClassName())) continue;
            srcFlag = true;
        }
        return null;
    }

    private String getErrorMsg(int level, StringBuffer msgBuf) {
        SimpleDateFormat df = new SimpleDateFormat("[yyyy/MM/dd HH:mm:ss.SSS][]");
        String format = new StringBuffer().append(df.format(new Date())).append("[]").append("[").append(Level.toLevel(level)).append("]").append(msgBuf).toString();
        return format;
    }

    private String getFormat(int level) {
        SimpleDateFormat df = new SimpleDateFormat("[yyyy/MM/dd HH:mm:ss.SSS][]");
        String format = new StringBuffer().append(df.format(new Date())).append("[]").append("[").append(Level.toLevel(level)).append("]{}").toString();
        return format;
    }
}

