/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.util;

import com.hs.lego.core.sdk.base.dataprotect.DataProtector;
import com.hs.lego.core.sdk.base.dataprotect.KmcFiles;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectConfigHelper;

public final class EncryptData {
    private static EncryptData instanse = null;
    private static DataProtector dataProtectorNew = null;
    private static DataProtector dataProtectorInit = null;
    private static long local = 0L;

    private EncryptData() {
    }

    public static synchronized EncryptData getInstanse() {
        if (instanse == null) {
            instanse = new EncryptData();
            String libFolderPath = DataProtectConfigHelper.getKmclibPath();
            String sdpConfigRootPath = DataProtectConfigHelper.getKmcConfigRootPath();
            String kmcLogConfigFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("kmcLogConfigFile");
            String initkeyStoreFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("init-keyStoreFile");
            String initkeyStoreBakFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("init-keyStoreBakFile");
            String initkmcCfgFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("init-kmcCfgFile");
            String initkmcCfgBakFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("init-kmcCfgBakFile");
            KmcFiles kfInit = new KmcFiles();
            kfInit.setKeyStoreFile(initkeyStoreFile);
            kfInit.setKeyStoreBakFile(initkeyStoreBakFile);
            kfInit.setKmcCfgFile(initkmcCfgFile);
            kfInit.setKmcCfgBakFile(initkmcCfgBakFile);
            kfInit.setLogConfigFile(kmcLogConfigFile);
            dataProtectorInit = new DataProtector(libFolderPath, kfInit);
            dataProtectorNew = new DataProtector(libFolderPath, KmcFiles.getKmcFiles());
        }
        return instanse;
    }

    public String encryptInitdata(String pucPlainText) {
        return dataProtectorInit.sdpEncrypt(local, pucPlainText);
    }

    public String decryptInitdata(String pucCipherText) {
        return dataProtectorInit.sdpDecrypt(local, pucCipherText);
    }

    public String encryptData(String pucPlainText) {
        return dataProtectorNew.sdpEncrypt(local, pucPlainText);
    }

    public String decryptdata(String pucCipherText) {
        return dataProtectorNew.sdpDecrypt(local, pucCipherText);
    }

    public final String sdpProtectInitPwd(String pucPlainText) {
        return dataProtectorInit.sdpProtectPwd(pucPlainText);
    }

    public final String sdpProtectPwd(String pucPlainText) {
        return dataProtectorNew.sdpProtectPwd(pucPlainText);
    }

    public final boolean sdpVerifyPwd(String pucPlainText, String pucCipherText) {
        boolean result = dataProtectorNew.sdpVerifyPwd(pucPlainText, pucCipherText);
        if (!result) {
            result = dataProtectorInit.sdpVerifyPwd(pucPlainText, pucCipherText);
        }
        return result;
    }
}

