/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.util;

import com.huawei.atic.util.AticInstallUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public final class CertFileUtil {
    private static final CertFileUtil INSTANCE = new CertFileUtil();

    private CertFileUtil() {
    }

    public static CertFileUtil getInstance() {
        return INSTANCE;
    }

    public Properties loadLegoCertInfoProperties() {
        return this.loadLegoCertInfoProperties(this.getCertPath());
    }

    public Properties loadLegoCertInfoProperties(String certPath) {
        String aticInstallPath = AticInstallUtil.getInstance().getAticInstallPath();
        InputStream inputStream = null;
        Properties properties = new Properties();
        try {
            String path = certPath + File.separator + "legoCertInfo.properties";
            inputStream = new FileInputStream(path);
            properties.load(inputStream);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                if (!entry.getKey().toString().endsWith(".path") || !entry.getValue().toString().startsWith("/")) continue;
                entry.setValue(aticInstallPath + entry.getValue().toString());
            }
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("file not found");
        }
        catch (RuntimeException e) {
            throw new UnsupportedOperationException("exception");
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new UnsupportedOperationException("inputStream close exception");
                }
            }
        }
        return properties;
    }

    public Properties loadCacertsProperties() {
        return this.loadCacertsProperties(this.getCertPath());
    }

    public Properties loadCacertsProperties(String certPath) {
        String aticInstallPath = AticInstallUtil.getInstance().getAticInstallPath();
        InputStream inputStream = null;
        Properties properties = new Properties();
        try {
            String path = certPath + File.separator + "cacerts.properties";
            inputStream = new FileInputStream(path);
            properties.load(inputStream);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                if (!entry.getKey().toString().endsWith(".path") || !entry.getValue().toString().startsWith("/")) continue;
                entry.setValue(aticInstallPath + entry.getValue().toString());
            }
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("file not found");
        }
        catch (RuntimeException e) {
            throw new UnsupportedOperationException("exception");
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new UnsupportedOperationException("inputStream close exception");
                }
            }
        }
        return properties;
    }

    public String getCertPath() {
        String aticInstallPath = AticInstallUtil.getInstance().getAticInstallPath();
        String path = aticInstallPath + File.separator + "LegoRuntime" + File.separator + "cert";
        return path;
    }
}

