/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.secsyslog;

import com.hs.atic.syslog.entity.SyslogServerEntity;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.log.CrashThreadHandler;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.EncryptData;
import com.hs.lego.core.system.notify.sdk.service.ISyslogSendService;
import com.huawei.atic.util.CertFileUtil;
import com.huawei.secsyslog.ServerInfoObj;
import com.huawei.secsyslog.SyslogClientAbstrat;
import com.huawei.secsyslog.TCPSysLogClientThread;
import com.huawei.secsyslog.UDPSysLogClientThread;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SysLogClient
extends Thread {
    protected static final transient Log LOGGER = LogFactory.getInstance(Module.ATIC_CBB_LOG);
    private SSLContext context = null;
    private List<String> serverList = new ArrayList<String>();
    private ConcurrentMap<String, List<byte[]>> sysLogList = new ConcurrentHashMap<String, List<byte[]>>();
    private ConcurrentMap<String, List<byte[]>> dataList = new ConcurrentHashMap<String, List<byte[]>>();
    private String keystorePath = null;
    private StringBuffer keystorePass = null;
    private String truststorePath = null;
    private StringBuffer truststorePass = null;
    private boolean flag = true;
    private Map<String, SyslogClientAbstrat> threadList = new HashMap<String, SyslogClientAbstrat>();

    public SysLogClient(String protocol, List<ServerInfoObj> serverLists, String truststorePath, String truststorePass) {
        if (null == serverLists || serverLists.isEmpty()) {
            LOGGER.error("SysLogClient-serverList is null or empty");
            return;
        }
        LOGGER.info("SysLogClient-enter SysLogClient(), protocol is " + this.getcleanedMessage(protocol) + ", serverList.size is " + serverLists.size() + ", truststorePath is ");
        this.setName("SysLogClient");
        this.truststorePath = truststorePath;
        if (null != truststorePass) {
            this.truststorePass = new StringBuffer(truststorePass);
        }
        for (ServerInfoObj serverInfoObj : serverLists) {
            String ipPort = serverInfoObj.getIp() + "," + serverInfoObj.getPort();
            this.serverList.add(ipPort);
        }
        this.creatSyslogClientList(this.serverList);
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLContext getSSLContext() {
        LOGGER.info("SysLogClient-enter getSSLContext!");
        FileInputStream kis = null;
        FileInputStream tis = null;
        if (null != this.context) {
            return this.context;
        }
        try {
            Properties properties = CertFileUtil.getInstance().loadLegoCertInfoProperties();
            if (null == this.keystorePath) {
                kis = new FileInputStream(CertFileUtil.getInstance().getCertPath() + File.separator + "mc_keystore");
                LOGGER.info("SysLogClient-keystorePath is null, default keystorePath will be use!");
            } else {
                kis = new FileInputStream(this.keystorePath);
            }
            this.keystorePass = new StringBuffer(EncryptData.getInstanse().decryptInitdata(properties.getProperty("keystore.mc.password")));
            LOGGER.info("SysLogClient-keystorePass is null, default keystorePass will be use!");
            if (null == this.truststorePath) {
                tis = new FileInputStream(CertFileUtil.getInstance().getCertPath() + File.separator + "third_truststore");
                LOGGER.info("SysLogClient-truststorePath is null, default truststorePath will be use!");
            } else {
                tis = new FileInputStream(this.truststorePath);
            }
            this.truststorePass = new StringBuffer(EncryptData.getInstanse().decryptInitdata(properties.getProperty("keystore.mc.password")));
            LOGGER.info("SysLogClient-truststorePass is null, default truststorePass will be use!");
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(kis, this.keystorePass.toString().toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, this.keystorePass.toString().toCharArray());
            KeyStore ts = KeyStore.getInstance("JKS");
            ts.load(tis, this.truststorePass.toString().toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(ts);
            TrustManager[] tm = tmf.getTrustManagers();
            this.context = SSLContext.getInstance("TLSv1.2");
            this.context.init(kmf.getKeyManagers(), tm, SecureRandom.getInstanceStrong());
        }
        catch (Throwable e) {
            try {
                LOGGER.error("SysLogClient-getSSLContext error.");
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                SysLogClient.closeStream(tis);
                SysLogClient.closeStream(kis);
            }
        }
        SysLogClient.closeStream(tis);
        SysLogClient.closeStream(kis);
        return this.context;
    }

    private void creatSyslogClientList(List<String> logServerList2) {
        String logProtocol = "udp";
        if (null != logServerList2 && !logServerList2.isEmpty()) {
            ISyslogSendService syslogSendService = ServiceContext.getInstance().getService("syslogSendService", ISyslogSendService.class);
            Map<String, Object> keysAndValuesMap = syslogSendService.getSyslogServerMapKeysAndValues();
            List keys = (List)keysAndValuesMap.get("keys");
            List values = (List)keysAndValuesMap.get("values");
            HashMap serverMap = new HashMap();
            if (null == keys || keys.size() == 0) {
                serverMap = null;
            } else {
                for (int i = 0; i < keys.size(); ++i) {
                    serverMap.put(keys.get(i), values.get(i));
                }
            }
            for (String serverIpPort : logServerList2) {
                String[] ipPort = serverIpPort.split(",");
                if (null != serverMap && !serverMap.isEmpty()) {
                    String string = logProtocol = 1 == ((SyslogServerEntity)serverMap.get(serverIpPort)).getTransferProtocol() ? "tcp" : "udp";
                }
                if ("tcp".equals(logProtocol)) {
                    if (null == this.getSSLContext()) {
                        LOGGER.error("SysLogClient-getSSLContext() is null, SysLogClient will exit!");
                        this.interrupt();
                        return;
                    }
                    ServerInfoObj serverInfo = new ServerInfoObj();
                    serverInfo.setIp(ipPort[0]);
                    serverInfo.setPort(Integer.parseInt(ipPort[1]));
                    SSLSocketFactory ssf = this.getSSLContext().getSocketFactory();
                    TCPSysLogClientThread syslogClientAbstrat = new TCPSysLogClientThread(ssf, serverInfo);
                    syslogClientAbstrat.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
                    syslogClientAbstrat.start();
                    this.threadList.put(serverIpPort, syslogClientAbstrat);
                    continue;
                }
                UDPSysLogClientThread syslogClientAbstrat = new UDPSysLogClientThread(ipPort[0], Integer.parseInt(ipPort[1]));
                syslogClientAbstrat.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
                syslogClientAbstrat.start();
                this.threadList.put(serverIpPort, syslogClientAbstrat);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOGGER.info("SysLogClient-enter run");
        try {
            while (this.flag) {
                if (!this.threadList.isEmpty() && !this.sysLogList.isEmpty()) {
                    LOGGER.info("syslogList.size() :" + this.sysLogList.size());
                    for (Map.Entry<String, SyslogClientAbstrat> syslogClientEntry : this.threadList.entrySet()) {
                        String ipPort = syslogClientEntry.getKey();
                        this.fetchSysLogList(ipPort);
                        if (null == this.dataList.get(ipPort) || ((List)this.dataList.get(ipPort)).isEmpty()) continue;
                        syslogClientEntry.getValue().addSysLogList((List)this.dataList.get(ipPort));
                        this.dataList.remove(ipPort);
                    }
                }
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    LOGGER.error("SysLogClient-run error!" + e.getMessage());
                }
            }
        }
        finally {
            this.stopClient();
        }
    }

    public void stopClient() {
        this.stopAllThread();
        this.flag = false;
        if (null != this.context) {
            this.context = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAllThread() {
        if (!this.threadList.isEmpty()) {
            Map<String, SyslogClientAbstrat> map = this.threadList;
            synchronized (map) {
                for (Map.Entry<String, SyslogClientAbstrat> threadMap : this.threadList.entrySet()) {
                    threadMap.getValue().stopClient();
                }
            }
        }
    }

    public void stopThread(String keyIpPort) {
        if (null != this.threadList.get(keyIpPort)) {
            this.threadList.get(keyIpPort).stopClient();
        }
    }

    public void addSysLogList(String keyIpPort, List<byte[]> data) {
        if (!data.isEmpty()) {
            if (null == this.sysLogList.get(keyIpPort)) {
                this.sysLogList.put(keyIpPort, data);
            } else {
                ((List)this.sysLogList.get(keyIpPort)).addAll(data);
            }
        }
    }

    private void fetchSysLogList(String keyIpPort) {
        if (null != this.sysLogList.get(keyIpPort) && !((List)this.sysLogList.get(keyIpPort)).isEmpty()) {
            if (null == this.dataList.get(keyIpPort)) {
                this.dataList.put(keyIpPort, (List<byte[]>)this.sysLogList.get(keyIpPort));
            } else {
                ((List)this.dataList.get(keyIpPort)).addAll((Collection)this.sysLogList.get(keyIpPort));
            }
            this.sysLogList.remove(keyIpPort);
        }
    }

    public void setKeystorePath(String keystorePath) {
        this.keystorePath = keystorePath;
    }

    public void setKeystorePass(StringBuffer keystorePass) {
        this.keystorePass = keystorePass;
    }

    private static void closeStream(InputStream is) {
        if (null != is) {
            try {
                is.close();
            }
            catch (IOException e) {
                LOGGER.error("SysLogClient-closeStream failed");
            }
        }
    }
}

