/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.secsyslog;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.util.AticInstallUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class SyslogServerUtil {
    private static final Log LOGGER = LogFactory.getInstance(Module.ATIC_CBB_LOG);
    private static final int SYSLOG_SERVERMAX_NUMBER = 5;
    private static final String SYSLOG_PATH = File.separator + "vsm_conf" + File.separator + "antiddos" + File.separator + "syslogServer.xml";
    private static SyslogServerUtil instance = new SyslogServerUtil();

    protected SyslogServerUtil() {
    }

    public static final SyslogServerUtil getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxNumber() {
        InputStream iStream = null;
        try {
            String pathName = AticInstallUtil.getInstance().getAticInstallPath() + SYSLOG_PATH;
            LOGGER.info("get syslog server config path success");
            Properties properties = new Properties();
            iStream = new FileInputStream(pathName);
            properties.loadFromXML(iStream);
            String maxServer = properties.getProperty("syslog.server.max.number");
            if (maxServer.isEmpty()) {
                int n = 5;
                return n;
            }
            int n = Integer.parseInt(maxServer);
            return n;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("getMaxNumber syslog file InputStream error.");
        }
        catch (IOException e) {
            LOGGER.error("getMaxNumber xml file load data error.");
        }
        finally {
            try {
                if (null != iStream) {
                    iStream.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("getMaxNumber InputStream close error.");
            }
        }
        return 5;
    }
}

