/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.secsyslog;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.secsyslog.SysLogServer;
import com.huawei.secsyslog.ThreadInfoObject;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class TCPSysLogServerThread
extends Thread {
    protected final transient Log logger = LogFactory.getInstance(Module.ATIC_CBB_LOG);
    private Socket socket = null;
    private SysLogServer server = null;
    private boolean flag = true;
    private BlockingQueue<ThreadInfoObject> threadList = new LinkedBlockingQueue<ThreadInfoObject>();

    public TCPSysLogServerThread(SysLogServer server, Socket socket, BlockingQueue<ThreadInfoObject> threadList) {
        this.setName(socket.getInetAddress().getHostName());
        this.server = server;
        this.socket = socket;
        this.threadList = threadList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String srcIp = this.socket.getInetAddress().getHostName();
        this.logger.info("TCPSysLogServerThread-enter run, ip is: " + srcIp);
        InputStream input = null;
        BufferedInputStream bis = null;
        try {
            this.socket.setSoTimeout(600000);
            input = this.socket.getInputStream();
            bis = new BufferedInputStream(input);
            while (this.flag) {
                byte[] buffer = new byte[2048];
                int readNum = bis.read(buffer);
                if (readNum <= 0) {
                    this.logger.error("TCPSysLogServerThread-run is empty, the socket will shutdown");
                    this.stopThread();
                    return;
                }
                String readStr = new String(buffer, "UTF-8");
                if (readStr.indexOf(60) < 1) continue;
                int length = Integer.parseInt(readStr.substring(0, readStr.indexOf(60) - 1));
                String msg = readStr.substring(readStr.indexOf(60), length + 4);
                this.logger.info("TCPSysLogServerThread-TCP:" + srcIp + '-' + msg);
                this.server.addMsgList(srcIp, msg);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    this.logger.error(e.getMessage());
                }
            }
        }
        catch (SocketTimeoutException ste) {
            this.stopThread();
        }
        catch (SocketException se) {
            this.logger.error("TCPSysLogServerThread run Socket connenction failed");
            this.stopThread();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage() + '-' + srcIp);
            this.stopThread();
        }
        finally {
            if (null != bis) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    this.logger.error("TCPSysLogServerThread run BufferedInputStream close failed");
                }
            }
            if (null != input) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    this.logger.error("TCPSysLogServerThread run input stream close failed");
                }
            }
        }
    }

    public void stopThread() {
        String ip = this.socket.getInetAddress().getHostName();
        try {
            this.flag = false;
            this.socket.close();
            for (ThreadInfoObject threadInfoObj : this.threadList) {
                if (ip == null || !ip.equals(threadInfoObj.getIp())) continue;
                this.threadList.remove(threadInfoObj);
                break;
            }
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            this.logger.error("stopThread socket close failed");
        }
    }
}

