/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.PersistentObjectException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.internal.Cascade;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.spi.CascadingActions;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.internal.EvictVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.RefreshEvent;
import org.hibernate.event.spi.RefreshEventListener;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;

public class DefaultRefreshEventListener
implements RefreshEventListener {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DefaultRefreshEventListener.class);

    @Override
    public void onRefresh(RefreshEvent event) throws HibernateException {
        this.onRefresh(event, new IdentityHashMap(10));
    }

    @Override
    public void onRefresh(RefreshEvent event, Map refreshedAlready) {
        Object result;
        LockMode currentLockMode;
        EntityKey key;
        Serializable id;
        EntityPersister persister;
        boolean isTransient;
        EventSource source = event.getSession();
        if (event.getEntityName() != null) {
            isTransient = !source.contains(event.getEntityName(), event.getObject());
        } else {
            boolean bl = isTransient = !source.contains(event.getObject());
        }
        if (source.getPersistenceContext().reassociateIfUninitializedProxy(event.getObject())) {
            if (isTransient) {
                source.setReadOnly(event.getObject(), source.isDefaultReadOnly());
            }
            return;
        }
        Object object = source.getPersistenceContext().unproxyAndReassociate(event.getObject());
        if (refreshedAlready.containsKey(object)) {
            LOG.trace("Already refreshed");
            return;
        }
        EntityEntry e = source.getPersistenceContext().getEntry(object);
        if (e == null) {
            persister = source.getEntityPersister(event.getEntityName(), object);
            id = persister.getIdentifier(object, event.getSession());
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Refreshing transient {0}", (Object)MessageHelper.infoString(persister, id, source.getFactory()));
            }
            key = source.generateEntityKey(id, persister);
            if (source.getPersistenceContext().getEntry(key) != null) {
                throw new PersistentObjectException("attempted to refresh transient instance when persistent instance was already associated with the Session: " + MessageHelper.infoString(persister, id, source.getFactory()));
            }
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Refreshing ", (Object)MessageHelper.infoString(e.getPersister(), e.getId(), source.getFactory()));
            }
            if (!e.isExistsInDatabase()) {
                throw new UnresolvableObjectException(e.getId(), "this instance does not yet exist as a row in the database");
            }
            persister = e.getPersister();
            id = e.getId();
        }
        refreshedAlready.put(object, object);
        Cascade.cascade(CascadingActions.REFRESH, CascadePoint.BEFORE_REFRESH, source, persister, object, refreshedAlready);
        if (e != null) {
            key = source.generateEntityKey(id, persister);
            source.getPersistenceContext().removeEntity(key);
            if (persister.hasCollections()) {
                new EvictVisitor(source, object).process(object, persister);
            }
        }
        if (persister.canWriteToCache()) {
            Object previousVersion = null;
            if (persister.isVersionPropertyGenerated()) {
                previousVersion = persister.getVersion(object);
            }
            EntityDataAccess cache = persister.getCacheAccessStrategy();
            Object ck = cache.generateCacheKey(id, persister, source.getFactory(), source.getTenantIdentifier());
            SoftLock lock = cache.lockItem(source, ck, previousVersion);
            cache.remove(source, ck);
            source.getActionQueue().registerProcess((success, session) -> cache.unlockItem(session, ck, lock));
        }
        this.evictCachedCollections(persister, id, source);
        String previousFetchProfile = source.getLoadQueryInfluencers().getInternalFetchProfile();
        source.getLoadQueryInfluencers().setInternalFetchProfile("refresh");
        LockOptions lockOptionsToUse = event.getLockOptions();
        LockMode requestedLockMode = lockOptionsToUse.getLockMode();
        LockMode postRefreshLockMode = null;
        if (e != null && (currentLockMode = e.getLockMode()).greaterThan(requestedLockMode)) {
            lockOptionsToUse = LockOptions.copy(event.getLockOptions(), new LockOptions());
            if (currentLockMode == LockMode.WRITE) {
                lockOptionsToUse.setLockMode(LockMode.READ);
                postRefreshLockMode = LockMode.WRITE;
            } else {
                lockOptionsToUse.setLockMode(currentLockMode);
            }
        }
        if ((result = persister.load(id, object, lockOptionsToUse, (SharedSessionContractImplementor)source)) != null) {
            if (postRefreshLockMode != null) {
                source.getPersistenceContext().getEntry(result).setLockMode(postRefreshLockMode);
            }
            if (!persister.isMutable()) {
                source.setReadOnly(result, true);
            } else {
                source.setReadOnly(result, e == null ? source.isDefaultReadOnly() : e.isReadOnly());
            }
        }
        source.getLoadQueryInfluencers().setInternalFetchProfile(previousFetchProfile);
        UnresolvableObjectException.throwIfNull(result, id, persister.getEntityName());
    }

    private void evictCachedCollections(EntityPersister persister, Serializable id, EventSource source) {
        this.evictCachedCollections(persister.getPropertyTypes(), id, source);
    }

    private void evictCachedCollections(Type[] types, Serializable id, EventSource source) throws HibernateException {
        for (Type type : types) {
            if (type.isCollectionType()) {
                CollectionPersister collectionPersister = source.getFactory().getMetamodel().collectionPersister(((CollectionType)type).getRole());
                if (!collectionPersister.hasCache()) continue;
                CollectionDataAccess cache = collectionPersister.getCacheAccessStrategy();
                Object ck = cache.generateCacheKey(id, collectionPersister, source.getFactory(), source.getTenantIdentifier());
                SoftLock lock = cache.lockItem(source, ck, null);
                cache.remove(source, ck);
                source.getActionQueue().registerProcess((success, session) -> cache.unlockItem(session, ck, lock));
                continue;
            }
            if (!type.isComponentType()) continue;
            CompositeType actype = (CompositeType)type;
            this.evictCachedCollections(actype.getSubtypes(), id, source);
        }
    }
}

