/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.sdk.util;

import com.hs.atic.sdk.system.form.BasicInfoForm;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.util.AticInstallUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public final class BasicInfoUtil {
    public static final String INSTALL_CONFIG_FILE_NAME = "legoPlatInstalled.xml";
    private static final transient Log LOGGER = LogFactory.getInstance(Module.ATIC_CBB_LOG);

    private BasicInfoUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BasicInfoForm getBasicInfo() {
        BasicInfoForm form = new BasicInfoForm();
        String installedFile = "";
        SAXReader saxReader = new SAXReader();
        FileInputStream fin = null;
        try {
            form.setInstallPath(AticInstallUtil.getInstance().getAticInstallPath());
            installedFile = AticInstallUtil.getInstance().getLegoPlatInstalledXMLPath();
            saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            saxReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            saxReader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Document document = saxReader.read(new File(installedFile));
            Element rootElem = document.getRootElement();
            Element propMapElem = rootElem.element("propMap");
            List entryElems = propMapElem.elements("entry");
            form.setDbType(BasicInfoUtil.praseEntryValue(entryElems, "lego.db.type"));
            form.setHost(BasicInfoUtil.praseEntryValue(entryElems, "lego.db.ipaddress"));
            form.setPort(Integer.valueOf(BasicInfoUtil.praseEntryValue(entryElems, "lego.db.port")));
            form.setUser(BasicInfoUtil.praseEntryValue(entryElems, "lego.db.username"));
            form.setPassword(BasicInfoUtil.praseEntryValue(entryElems, "lego.db.password.encrypt"));
            String configFile = AticInstallUtil.getInstance().getAticInstallPath() + File.separator + "LegoRuntime" + File.separator + "conf" + File.separator + "version.txt";
            Properties config = new Properties();
            fin = new FileInputStream(configFile);
            config.load(fin);
            String version = config.getProperty("Server", "VSB");
            version = version.split("=")[1].trim();
            form.setVersion(version);
        }
        catch (SAXException e) {
            LOGGER.error("getBasicInfo the feature could not be changed.");
            BasicInfoForm basicInfoForm = null;
            return basicInfoForm;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("getBasicInfo configFile found failed");
            BasicInfoForm basicInfoForm = null;
            return basicInfoForm;
        }
        catch (DocumentException e) {
            LOGGER.error("getBasicInfo DocumentException:SAXReader parse file falied");
            BasicInfoForm basicInfoForm = null;
            return basicInfoForm;
        }
        catch (IOException e) {
            LOGGER.error("getBasicInfo IOException:load file failed");
            BasicInfoForm basicInfoForm = null;
            return basicInfoForm;
        }
        finally {
            if (null != fin) {
                try {
                    fin.close();
                }
                catch (IOException e) {
                    LOGGER.error("close fin IOException:close stream failed");
                }
            }
        }
        return form;
    }

    private static String praseEntryValue(List<Element> entryElems, String entryType) {
        String entryValue = "";
        for (Element element : entryElems) {
            String type = element.elementText("string");
            Element tempElem = element.element("com.huawei.elog.base.model.ContextPropVal");
            String value = tempElem.elementText("value");
            if (!entryType.equals(type)) continue;
            entryValue = value;
            break;
        }
        return entryValue;
    }
}

