/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.secsyslog;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IpTransformer {
    private static final transient Log LOGGER = LogFactory.getInstance(Module.ATIC_CBB_LOG);
    private static final Long UNKNOWN_IPV6_LONG = 0L;

    protected IpTransformer() {
    }

    public static long address2LongFormat(InetAddress address) {
        byte[] values = address.getAddress();
        return IpTransformer.bytes2Long(values);
    }

    public static long bytes2Long(byte[] address) {
        byte[] values = address;
        int ch1 = values[0] & 0xFF;
        int ch2 = values[1] & 0xFF;
        int ch3 = values[2] & 0xFF;
        int ch4 = values[3] & 0xFF;
        return (long)ch1 << 24 | (long)ch2 << 16 | (long)ch3 << 8 | (long)ch4 << 0;
    }

    public static byte[] long2Bytes(long ip) {
        byte[] values = new byte[]{(byte)(ip >> 24), (byte)(ip >> 16), (byte)(ip >> 8), (byte)ip};
        return values;
    }

    public static String long2StringFormat(long address) {
        byte[] values = new byte[]{(byte)(address >>> 24 & 0xFFL), (byte)(address >>> 16 & 0xFFL), (byte)(address >>> 8 & 0xFFL), (byte)(address >>> 0 & 0xFFL)};
        return (values[0] & 0xFF) + "." + (values[1] & 0xFF) + "." + (values[2] & 0xFF) + "." + (values[3] & 0xFF);
    }

    public static long string2LongFormat(String ipaddress) {
        byte[] byteFormat = new byte[4];
        String[] split = ipaddress.split("\\.");
        if (split.length != 4) {
            LOGGER.info("IP is not IPv4: " + ipaddress);
            return UNKNOWN_IPV6_LONG;
        }
        for (int i = 0; i < 4; ++i) {
            byteFormat[i] = (byte)Short.parseShort(split[i]);
        }
        return IpTransformer.bytes2Long(byteFormat);
    }

    public static String byte2String(byte[] address) {
        byte[] values = address;
        return (values[0] & 0xFF) + "." + (values[1] & 0xFF) + "." + (values[2] & 0xFF) + "." + (values[3] & 0xFF);
    }

    public static boolean ipEquals(String firstIp, String secIp) {
        return IpTransformer.formatIpAddress(firstIp).equals(IpTransformer.formatIpAddress(secIp));
    }

    public static boolean checkIpInvaild(String ip) {
        return IpTransformer.isIpV4(ip) || IpTransformer.isIpv6(ip);
    }

    public static boolean isIpV4(String ip) {
        if (null == ip) {
            return false;
        }
        Matcher m = Pattern.compile("((25[0-5]|2[0-4]\\d|1\\d{2}|0?[1-9]\\d|0?0?\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d{2}|0?[1-9]\\d|0?0?\\d)").matcher(ip);
        return m.matches();
    }

    public static boolean isIpv6(String ip) {
        if (null == ip) {
            return false;
        }
        int idx = ip.indexOf("::");
        if (-1 == idx) {
            return Pattern.compile("([a-fA-F0-9]{1,4}:){7}[a-fA-F0-9]{1,4}").matcher(ip).matches();
        }
        if (idx != ip.lastIndexOf("::")) {
            return false;
        }
        String[] items = ip.split("::");
        int length = 0;
        for (int i = 0; i < items.length; ++i) {
            if (null == items[i] || "".equals(items[i])) continue;
            length += items[i].split(":").length;
            if (Pattern.compile("([a-fA-F0-9]{1,4}:)*[a-fA-F0-9]{1,4}").matcher(items[i]).matches()) continue;
            return false;
        }
        return length <= 7;
    }

    public static String formatIpAddress(String ip) {
        if (!IpTransformer.isIpv6(ip)) {
            return ip;
        }
        String ipV6 = IpTransformer.convert2CompleteIpV6(ip);
        StringBuilder finalReturnStr = new StringBuilder();
        String[] items = ipV6.split(":");
        for (int i = 0; i < items.length; ++i) {
            int intValue = Integer.parseInt(items[i], 16);
            finalReturnStr.append(Integer.toHexString((intValue & 0xFFFF) >> 12));
            finalReturnStr.append(Integer.toHexString((intValue & 0xFFF) >> 8));
            finalReturnStr.append(Integer.toHexString((intValue & 0xFF) >> 4));
            finalReturnStr.append(Integer.toHexString(intValue & 0xF));
            if (i == items.length - 1) continue;
            finalReturnStr.append(':');
        }
        return finalReturnStr.toString().toLowerCase(Locale.ENGLISH);
    }

    private static String convert2CompleteIpV6(String ip) {
        String ipV6 = ip;
        int idx = ip.indexOf("::");
        if (idx > 0) {
            String[] s = ip.split(":");
            int len = 0;
            for (String m : s) {
                if (null == m || m.isEmpty()) continue;
                ++len;
            }
            int size = 8 - len;
            StringBuilder tmp = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                tmp.append(":0");
            }
            if (ip.length() - 2 != idx) {
                tmp.append(':');
            }
            ipV6 = ip.replace("::", tmp.toString());
        } else if (idx == 0) {
            if (ip.length() == 2) {
                ipV6 = ip.replace("::", "0:0:0:0:0:0:0:0");
            } else {
                int i;
                String[] s = ip.split(":");
                int len = 0;
                String[] size = s;
                int tmp = size.length;
                for (i = 0; i < tmp; ++i) {
                    String m = size[i];
                    if (null == m || m.isEmpty()) continue;
                    ++len;
                }
                int size2 = 8 - len;
                StringBuilder tmp2 = new StringBuilder();
                for (i = 0; i < size2; ++i) {
                    tmp2.append("0:");
                }
                ipV6 = ip.replace("::", tmp2.toString());
            }
        }
        return ipV6;
    }

    public static String compressIPv6(String ip) {
        block15: {
            if (!IpTransformer.isIpv6(ip)) {
                return ip;
            }
            ip = IpTransformer.convert2CompleteIpV6(ip);
            int x = 0;
            String t = null;
            String[] ips = ip.split(":");
            StringBuffer sb = new StringBuffer(256);
            for (int i = 0; i < ips.length; ++i) {
                x = Integer.parseInt(ips[i], 16);
                ips[i] = t = Integer.toHexString(x);
                sb.append(t);
                if (i == ips.length - 1) continue;
                sb.append(':');
            }
            ip = sb.toString();
            int pt = -1;
            int cn = 0;
            HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
            for (int i = 0; i < ips.length; ++i) {
                String s = ips[i];
                if ("0".equals(s)) {
                    if (cn == 0) {
                        pt = i;
                        map.put(pt, 0);
                    }
                    ++cn;
                } else {
                    if (cn > 0) {
                        map.put(pt, cn);
                    }
                    if (i != ips.length - 1) {
                        pt = -1;
                        cn = 0;
                    }
                }
                if (i != ips.length - 1 || !map.containsKey(pt)) continue;
                map.put(pt, cn);
            }
            Set set = map.entrySet();
            Map.Entry[] entries = set.toArray(new Map.Entry[set.size()]);
            Arrays.sort(entries, new Comparator<Map.Entry<Integer, Integer>>(){

                @Override
                public int compare(Map.Entry<Integer, Integer> o1, Map.Entry<Integer, Integer> o2) {
                    return o2.getValue().compareTo(o1.getValue());
                }
            });
            Map.Entry[] entryArray = entries;
            int n = entryArray.length;
            int n2 = 0;
            if (n2 >= n) break block15;
            Map.Entry e = entryArray[n2];
            int key = (Integer)e.getKey();
            int value = (Integer)e.getValue();
            int adx = 0;
            int bdx = 0;
            for (int i = 0; i < key; ++i) {
                adx += ips[i].length();
                ++adx;
            }
            bdx = adx + 2 * value;
            if (key + value == 8 && key == 0) {
                ip = "::";
            } else if (key == 0) {
                ip = "::" + ip.substring(bdx);
            } else if (key + value == 8) {
                ip = ip.substring(0, adx) + ":";
            } else {
                String a = ip.substring(0, adx);
                String b = ip.substring(bdx);
                StringBuilder sx = new StringBuilder();
                sx.append(a).append(':').append(b);
                ip = sx.toString();
            }
        }
        return ip;
    }

    public static byte[] string2Bytes(String ip) {
        byte[] b = new byte[16];
        if (IpTransformer.isIpV4(ip)) {
            String[] split = ip.split("\\.");
            for (int i = 0; i < 4; ++i) {
                b[i] = (byte)Short.parseShort(split[i]);
            }
        }
        if (IpTransformer.isIpv6(ip)) {
            ip = IpTransformer.convert2CompleteIpV6(ip);
            String[] ip6Str = ip.split(":");
            int j = 0;
            for (int i = 0; i < ip6Str.length; ++i) {
                int t = Integer.parseInt(ip6Str[i], 16);
                int h = t & 0xFF00;
                int l = t & 0xFF;
                b[j] = (byte)(h >> 8);
                b[j + 1] = (byte)l;
                j += 2;
            }
        }
        return b;
    }
}

