/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.unicom;

import com.hs.atic.sdk.bis.unicom.service.UnicomPermissionScriptService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.util.AticInstallUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class ControlUnicomScript {
    private static final String UNICOMPATH = File.separator + "vsm_conf" + File.separator + "antiddos" + File.separator + "unicom" + File.separator + "unicom.xml";
    private static Log log = LogFactory.getInstance((Module)Module.ATIC_UNICOM_SOC);
    private boolean isOpen = false;

    public ControlUnicomScript() {
        this.initConf();
    }

    public void controlUnicomScript() {
        log.info((Object)("ControlUnicomScript unicom isOpen is :" + this.isOpen));
        boolean hasPermissionScript = this.getService().isHasPermissionScript();
        if (this.isOpen) {
            if (!hasPermissionScript) {
                this.getService().savePermissionScript();
            }
        } else {
            this.getService().deletePermissionScript();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConf() {
        InputStream iStream = null;
        try {
            String pathName = AticInstallUtil.getInstance().getAticInstallPath() + UNICOMPATH;
            Properties properties = new Properties();
            iStream = new FileInputStream(pathName);
            properties.loadFromXML(iStream);
            this.isOpen = Boolean.parseBoolean(properties.getProperty("atic.unicom.isOpen"));
            log.info((Object)"ControlUnicomScript unicom");
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
        }
        finally {
            try {
                if (null != iStream) {
                    iStream.close();
                }
            }
            catch (IOException e) {
                log.error((Object)e.getMessage());
            }
        }
    }

    private UnicomPermissionScriptService getService() {
        return (UnicomPermissionScriptService)ServiceContext.getInstance().getService("unicomPermissionScriptService", UnicomPermissionScriptService.class);
    }
}

