/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.unicom.action;

import com.hs.atic.sdk.bis.unicom.entity.TaskOperateUnicomEntity;
import com.hs.atic.sdk.bis.unicom.entity.TaskUnicomEntity;
import com.hs.atic.sdk.bis.unicom.service.OperateTaskUnicomService;
import com.hs.atic.sdk.bis.unicom.service.TaskUnicomService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class TaskUnicomAction
extends BaseAction {
    private static final long serialVersionUID = -5871892782877275874L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_UNICOM_SOC);
    private List<TaskUnicomEntity> list;
    private List<TaskOperateUnicomEntity> taskOperateList;
    private String taskId;
    private String searchTaskId;
    private String searchCleanEqIp;
    private String sortType = null;
    private String sortField = null;

    public String queryTaskList() {
        Map<String, String> conditionMap = this.getConditions();
        TaskUnicomService taskUnicomService = (TaskUnicomService)ServiceContext.getInstance().getService("taskUnicomService", TaskUnicomService.class);
        if (null == this.sortType && null == this.sortField) {
            this.sortType = "desc";
            this.sortField = "createTime";
        }
        if ("showCreateTime".equals(this.sortField)) {
            this.sortField = "createTime";
        }
        conditionMap.put("sortName", this.sortField);
        conditionMap.put("sortType", this.sortType);
        this.logger.info((Object)("queryTaskList start = " + this.start + " pageSize = " + this.pageSize + " sortField = " + this.sortField + " sortType = " + this.sortType));
        Paging paging = taskUnicomService.getTaskByPage(conditionMap, this.start, this.pageSize);
        this.list = paging.getData();
        this.total = paging.getCount();
        return "success";
    }

    public String queryOperateTaskList() {
        OperateTaskUnicomService operateTaskUnicomService = (OperateTaskUnicomService)ServiceContext.getInstance().getService("operateTaskUnicomService", OperateTaskUnicomService.class);
        Paging paging = operateTaskUnicomService.getOperateTaskUnicomByTaskId(this.taskId, this.start, this.pageSize);
        this.total = paging.getCount();
        this.taskOperateList = paging.getData();
        return "success";
    }

    private Map<String, String> getConditions() {
        HashMap<String, String> conditionMap = new HashMap<String, String>();
        if (!StringUtils.isEmpty((CharSequence)this.searchTaskId)) {
            conditionMap.put("taskId", this.searchTaskId);
        }
        if (!StringUtils.isEmpty((CharSequence)this.searchCleanEqIp)) {
            conditionMap.put("cleanEqIps", this.searchCleanEqIp);
        }
        return conditionMap;
    }

    public boolean validateCleanEqIp() {
        if (AticUtil.isNull((String)this.searchCleanEqIp)) {
            return true;
        }
        return AticUtil.validateIpv4((String)this.searchCleanEqIp);
    }

    public List<TaskUnicomEntity> getList() {
        return this.list;
    }

    public void setList(List<TaskUnicomEntity> list) {
        this.list = list;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public String getSearchTaskId() {
        return this.searchTaskId;
    }

    public void setSearchTaskId(String searchTaskId) {
        this.searchTaskId = searchTaskId;
    }

    public String getSearchCleanEqIp() {
        return this.searchCleanEqIp;
    }

    public void setSearchCleanEqIp(String searchCleanEqIp) {
        this.searchCleanEqIp = searchCleanEqIp;
    }

    public List<TaskOperateUnicomEntity> getTaskOperateList() {
        return this.taskOperateList;
    }

    public void setTaskOperateList(List<TaskOperateUnicomEntity> taskOperateList) {
        this.taskOperateList = taskOperateList;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }
}

