/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.unicom.action;

import com.hs.atic.bis.unicom.service.impl.UnicomConfigServiceImpl;
import com.hs.atic.cert.model.CertManagementForm;
import com.hs.atic.cert.service.ICertManagementService;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.core.system.syslog.service.SysOptLogImpl;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.secservice.unicom.model.UnicomConfigInfoForm;
import com.restful.util.HttpsConnection;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;

@Service
public class UnicomConfigAction
extends BaseAction {
    private static final long serialVersionUID = 8341915845454429519L;
    private static final long LONG_MAX = Integer.MAX_VALUE;
    private UnicomConfigInfoForm unicomConfigInfoForm;
    @Autowired
    @Qualifier(value="unicomConfigService")
    private UnicomConfigServiceImpl unicomConfigService;
    @Autowired
    @Qualifier(value="certManagementService")
    private ICertManagementService certManagementService;
    private List<CertManagementForm> allCertList;
    private String result;
    private String url;

    public String queryUnicomConfig() {
        this.unicomConfigInfoForm = this.unicomConfigService.queryUnicomConfig();
        ICertManagementService certManagementService = (ICertManagementService)ServiceContext.getInstance().getService("certManagementService", ICertManagementService.class);
        this.allCertList = certManagementService.queryAllCerts();
        return "success";
    }

    public String saveUnicomConfig() {
        if (null == this.unicomConfigInfoForm) {
            this.saveFailedLog();
            this.result = "failed";
            return "error";
        }
        if (0L == this.unicomConfigInfoForm.getPkid() || this.unicomConfigInfoForm.getPkid() > Integer.MAX_VALUE) {
            this.saveFailedLog();
            this.result = "failed";
            return "error";
        }
        if (null == this.unicomConfigInfoForm.getCertAlias()) {
            this.saveFailedLog();
            this.result = "failed";
            return "error";
        }
        try {
            UnicomConfigInfoForm form = this.unicomConfigService.queryUnicomConfig();
            this.unicomConfigInfoForm.setOpen(form.isOpen());
            this.unicomConfigInfoForm.setPkid(form.getPkid());
            this.unicomConfigService.saveUnicomConfig(this.unicomConfigInfoForm);
            this.insertSysOptLog("atic.public.button.confirm", "atic.bis.unicom", "atic.Certificate.Management.unicom.soc.config", true, true, SysoplogLevel.info, "atic.Certificate.Management.unicom.soc.config.save.success", new String[0]);
            this.result = "success";
        }
        catch (DataAccessException e) {
            this.saveFailedLog();
            throw e;
        }
        catch (RuntimeException e) {
            this.saveFailedLog();
            throw e;
        }
        catch (Exception e) {
            this.saveFailedLog();
            throw e;
        }
        return "success";
    }

    private void saveFailedLog() {
        this.insertSysOptLog("atic.public.button.confirm", "atic.bis.unicom", "atic.Certificate.Management.unicom.soc.config", true, false, SysoplogLevel.normal, "atic.Certificate.Management.unicom.soc.config.save.failed", new String[0]);
    }

    public UnicomConfigInfoForm getUnicomConfigInfoForm() {
        return this.unicomConfigInfoForm;
    }

    public void setUnicomConfigInfoForm(UnicomConfigInfoForm unicomConfigInfoForm) {
        this.unicomConfigInfoForm = unicomConfigInfoForm;
    }

    public boolean validateCertAlias(String certAlias) {
        if (null == certAlias) {
            return true;
        }
        Pattern pattern = Pattern.compile("^(?!_)(?![0-9])[a-zA-Z_0-9]+$");
        Matcher matcher = pattern.matcher(certAlias);
        if (!matcher.matches()) {
            return false;
        }
        return certAlias.length() > 0 && certAlias.length() <= 128;
    }

    public String testUnicomConfig() {
        if (null == this.unicomConfigInfoForm) {
            this.insertSysOptLog("atic.Certificate.Management.unicom.soc.config.unicom.test", "atic.bis.unicom", "atic.Certificate.Management.unicom.soc.config", true, false, SysoplogLevel.normal, "atic.Certificate.Management.unicom.soc.config.unicom.test.failed", new String[0]);
            this.result = "failedcommon";
            return "error";
        }
        if (null == this.unicomConfigInfoForm.getCertAlias()) {
            this.insertSysOptLog("atic.Certificate.Management.unicom.soc.config.unicom.test", "atic.bis.unicom", "atic.Certificate.Management.unicom.soc.config", true, false, SysoplogLevel.normal, "atic.Certificate.Management.unicom.soc.config.unicom.test.failed", new String[0]);
            this.result = "failedcommon";
            return "error";
        }
        try {
            HttpsConnection.getInstance().doHttpsRequest(this.unicomConfigInfoForm.getCleanlog(), this.unicomConfigInfoForm.getCertAlias());
        }
        catch (LegoCheckedException e) {
            this.insertSysOptLog("atic.Certificate.Management.unicom.soc.config.unicom.test", "atic.bis.unicom", "atic.Certificate.Management.unicom.soc.config.cleanlog", true, false, SysoplogLevel.normal, "atic.Certificate.Management.unicom.soc.config.unicom.test.failed", new String[0]);
            this.result = "certfailed";
            this.url = "atic.Certificate.Management.unicom.soc.config.cleanlog";
            return "success";
        }
        try {
            HttpsConnection.getInstance().doHttpsRequest(this.unicomConfigInfoForm.getCleanAlarm(), this.unicomConfigInfoForm.getCertAlias());
        }
        catch (LegoCheckedException e) {
            this.insertSysOptLog("atic.Certificate.Management.unicom.soc.config.unicom.test", "atic.bis.unicom", "atic.Certificate.Management.unicom.soc.config.cleanAlarm", true, false, SysoplogLevel.normal, "atic.Certificate.Management.unicom.soc.config.unicom.test.failed", new String[0]);
            this.result = "certfailed";
            this.url = "atic.Certificate.Management.unicom.soc.config.cleanAlarm";
            return "success";
        }
        try {
            HttpsConnection.getInstance().doHttpsRequest(this.unicomConfigInfoForm.getCleanTaskStartUri(), this.unicomConfigInfoForm.getCertAlias());
        }
        catch (LegoCheckedException e) {
            this.insertSysOptLog("atic.Certificate.Management.unicom.soc.config.unicom.test", "atic.bis.unicom", "atic.Certificate.Management.unicom.soc.config.cleanTaskStartUri", true, false, SysoplogLevel.normal, "atic.Certificate.Management.unicom.soc.config.unicom.test.failed", new String[0]);
            this.result = "certfailed";
            this.url = "atic.Certificate.Management.unicom.soc.config.cleanTaskStartUri";
            return "success";
        }
        try {
            HttpsConnection.getInstance().doHttpsRequest(this.unicomConfigInfoForm.getCleanTaskStopUri(), this.unicomConfigInfoForm.getCertAlias());
        }
        catch (LegoCheckedException e) {
            this.insertSysOptLog("atic.Certificate.Management.unicom.soc.config.unicom.test", "atic.bis.unicom", "atic.Certificate.Management.unicom.soc.config.cleanTaskStopUri", true, false, SysoplogLevel.normal, "atic.Certificate.Management.unicom.soc.config.unicom.test.failed", new String[0]);
            this.result = "certfailed";
            this.url = "atic.Certificate.Management.unicom.soc.config.cleanTaskStopUri";
            return "success";
        }
        this.insertSysOptLog("atic.Certificate.Management.unicom.soc.config.unicom.test", "atic.bis.unicom", "atic.Certificate.Management.unicom.soc.config", true, true, SysoplogLevel.info, "atic.Certificate.Management.unicom.soc.config.unicom.test.success", new String[0]);
        this.result = "success";
        return "success";
    }

    private void insertSysOptLog(String operation, String module, String target, boolean targetLocal, boolean isSuccess, SysoplogLevel sysoplogLevel, String detail, String[] detailPara) {
        ISysOptLog sysOpLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", SysOptLogImpl.class);
        SysOptLog soLog = new SysOptLog();
        User currentUser = (User)this.fetchRequest().getSession().getAttribute("currentUser");
        soLog.setDate(new Date());
        soLog.setTarget(target);
        soLog.setModule(module);
        soLog.setOperation(operation);
        soLog.setDetail(detail);
        soLog.setOperator(currentUser.getUserName());
        soLog.setTerminalIp(currentUser.getIpAdr());
        soLog.setTargetLocal(Boolean.valueOf(true));
        soLog.setLevel(sysoplogLevel.getValue());
        if (isSuccess) {
            soLog.setResult(1);
        } else {
            soLog.setResult(0);
        }
        sysOpLog.writeOptLog(soLog);
    }

    public List<CertManagementForm> getAllCertList() {
        return this.allCertList;
    }

    public String getResult() {
        return this.result;
    }

    public String getUrl() {
        return this.url;
    }
}

