/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.unicom.restful.daemon;

import com.hs.atic.sdk.bis.unicom.entity.DeployResult;
import com.hs.atic.sdk.bis.unicom.entity.TaskOperateUnicomEntity;
import com.hs.atic.sdk.bis.unicom.service.OperateTaskUnicomService;
import com.hs.atic.sdk.zone.form.ZoneIpForm;
import com.hs.atic.util.AticUtil;
import com.hs.atic.zone.model.ZoneListIpInfo;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.ddos.common.CommandPair;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.unicom.restful.daemon.MoveZoneIpData;
import com.hs.vsm.secservice.unicom.restful.daemon.MoveZoneIpThreadPool;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.service.impl.ExcmdConnectUtil;
import com.huawei.atic.secne.service.impl.ExcmdConnectionPool;
import com.huawei.atic.south.model.TelnetPara;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class MoveZoneIpStartThread
extends Thread {
    private static final long DESTROY_TIME = 120000L;
    private static final String DEPLOYZONEIP = "deployZoneIp";
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_UNICOM_SOC);
    private String deviceIp;
    private ZoneDeviceForm deviceForm;
    private IAticDeviceService aticDeviceService;
    private OperateTaskUnicomService operateTaskService;
    private boolean active = true;
    private List<MoveZoneIpData> nowProcessing = new ArrayList<MoveZoneIpData>();
    private long threadWorkMillis = System.currentTimeMillis();

    public MoveZoneIpStartThread(ZoneDeviceForm deviceForm, String deviceIp, IAticDeviceService aticDeviceService, OperateTaskUnicomService operateTaskService) {
        this.deviceForm = deviceForm;
        this.setName("MoveIpStartThread_" + deviceIp);
        this.deviceIp = deviceIp;
        this.aticDeviceService = aticDeviceService;
        this.operateTaskService = operateTaskService;
        this.logger.info((Object)("construct a move ip thread, deviceIp=" + deviceIp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.logger.info((Object)"start");
        TelnetPara telnetPara = this.aticDeviceService.getDeviceTelnetPara(this.deviceForm.getDeviceId().longValue());
        AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(this.deviceForm.getDeviceId().longValue());
        ExcmdConnectUtil excmdConnectUtil = null;
        try {
            try {
                this.logger.info((Object)"get excmdConnectUtil start");
                excmdConnectUtil = ExcmdConnectionPool.getInstance().getExcmdConnectUtil(telnetPara);
                this.logger.info((Object)"get excmdConnectUtil finish");
            }
            catch (LegoCheckedException e) {
                this.logger.info((Object)("get ExcmdConnectUtil error,continue" + e.getErrorCode()));
            }
            while (this.active) {
                List<MoveZoneIpData> moveIpDataList = this.getBatchData();
                if (null != moveIpDataList && !moveIpDataList.isEmpty()) {
                    this.logger.info((Object)("moveIpDataList size" + moveIpDataList.size()));
                    this.threadWorkMillis = System.currentTimeMillis();
                    for (MoveZoneIpData moveZoneIpData : moveIpDataList) {
                        try {
                            Map<CommandPair, DeployResult> result = this.moveDeployZoneIp(excmdConnectUtil, moveZoneIpData.getSrouceZoneDevice(), moveZoneIpData.getSourceZoneName(), moveZoneIpData.getDestZoneDevice(), moveZoneIpData.getDestZoneName(), moveZoneIpData.getZoneIptemp(), moveZoneIpData.isIpv4(), moveZoneIpData.getTaskId(), moveZoneIpData.getResultMap(), moveZoneIpData.getCommandDeployResult());
                            this.logger.info((Object)("moveDeployZoneIp method result is" + result));
                            moveZoneIpData.getCommandDeployResult().putAll(result);
                        }
                        catch (RuntimeException e) {
                            this.logger.error((Object)e.getMessage());
                        }
                    }
                    continue;
                }
                if (120000L < System.currentTimeMillis() - this.threadWorkMillis) {
                    MoveZoneIpThreadPool.removeStart(this.deviceIp);
                    this.logger.info((Object)("construct a move zone ip start thread is destroyed by pool, deviceIp=" + this.deviceIp));
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    this.logger.error((Object)e.getMessage());
                }
            }
        }
        catch (LegoCheckedException e) {
            this.logger.info((Object)("MoveZoneIpStartThread run with error" + e.getErrorCode()));
        }
        finally {
            this.logger.info((Object)"thread is destroyed and release VTY");
            ExcmdConnectionPool.getInstance().excmdConnectionRelease(aticDevice.getMoId(), excmdConnectUtil);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MoveZoneIpData> getBatchData() {
        List<MoveZoneIpData> list = this.nowProcessing;
        synchronized (list) {
            if (this.nowProcessing.size() > 0) {
                ArrayList<MoveZoneIpData> result = new ArrayList<MoveZoneIpData>();
                result.addAll(this.nowProcessing);
                this.logger.info((Object)("getnowProcessing size" + this.nowProcessing.size()));
                this.nowProcessing.clear();
                return result;
            }
        }
        return null;
    }

    private Map<CommandPair, DeployResult> moveDeployZoneIp(ExcmdConnectUtil excmdConnectUtil, ZoneDeviceForm srouceZoneDevice, String sourceZoneName, ZoneDeviceForm destZoneDevice, String destZoneName, ZoneIpForm zoneIptemp, boolean isIpv4, String taskId, Map<String, BatchOperationResult> resultMap, Map<CommandPair, DeployResult> commandDeployResult) {
        StringBuffer detail;
        TaskOperateUnicomEntity taskOperate;
        String detail2;
        List result;
        int tryCount;
        ArrayList<String> cmdIp;
        ArrayList<String> cmdSys;
        AticDevice aticDevice;
        TelnetPara telnetPara;
        String cmdDo;
        String errorMsgKey = "--";
        String errorParam = "";
        String cmdUndo = isIpv4 ? "undo ip address " : "undo ipv6 address ";
        String string = cmdDo = isIpv4 ? "ip address " : "ipv6 address ";
        if (null != srouceZoneDevice) {
            telnetPara = this.aticDeviceService.getDeviceTelnetPara(srouceZoneDevice.getDeviceId().longValue());
            aticDevice = this.aticDeviceService.getDeviceByMoid(srouceZoneDevice.getDeviceId().longValue());
            String devcieIp = aticDevice.getIpAddress();
            try {
                cmdSys = new ArrayList<String>();
                cmdSys.add("sys");
                cmdSys.add("ddos-zone name " + sourceZoneName);
                cmdIp = new ArrayList<String>();
                cmdIp.add(cmdUndo + zoneIptemp.getZoneIp() + " " + zoneIptemp.getMask());
                tryCount = 3;
                result = null;
                for (int i = 0; i < tryCount; ++i) {
                    try {
                        CmdUtil.execCmds((ExcmdConnectUtil)excmdConnectUtil, cmdSys, (boolean)true);
                        result = CmdUtil.execCmds((ExcmdConnectUtil)excmdConnectUtil, cmdIp, (boolean)false);
                        break;
                    }
                    catch (LegoCheckedException e) {
                        this.logger.info((Object)("undoDeployZoneIp error and try " + i + e.getMessage()));
                        if (2 <= i) {
                            throw e;
                        }
                        if (null != excmdConnectUtil) {
                            this.logger.info((Object)"release excmdconnection start");
                            ExcmdConnectionPool.getInstance().excmdConnectionRelease(aticDevice.getMoId(), excmdConnectUtil);
                        }
                        this.logger.info((Object)"excmdConnectUtil start");
                        excmdConnectUtil = ExcmdConnectionPool.getInstance().getExcmdConnectUtil(telnetPara);
                        this.logger.info((Object)"excmdConnectUtil finish");
                        continue;
                    }
                }
                this.logger.info((Object)("deploy srouceZone ZoneIp result is" + (null == result ? null : result.toString())));
                Boolean flag = VsmUtil.getInstance().checkCmdResult(result);
                if (flag.booleanValue() && result.toString().toLowerCase(Locale.ENGLISH).contains("warning: please specify zone id first")) {
                    this.logger.info((Object)"please specify zone id first");
                    flag = false;
                }
                if (!flag.booleanValue()) {
                    this.logger.error((Object)("err : move source action error, zone name :" + sourceZoneName + " zone ip :" + zoneIptemp.getZoneIp()));
                    detail2 = "deploy sourceZoneName undo zoneIp error!";
                    this.execRestOperLog(taskId, zoneIptemp, devcieIp, detail2, resultMap);
                    this.deployIpResult(commandDeployResult, srouceZoneDevice.getZoneId(), flag, aticDevice.getMoId(), zoneIptemp.getId(), errorMsgKey, errorParam);
                } else {
                    taskOperate = new TaskOperateUnicomEntity();
                    taskOperate.setTaskId(taskId);
                    taskOperate.setCommand(DEPLOYZONEIP);
                    taskOperate.setCleanEq(aticDevice.getIpAddress());
                    taskOperate.setProtectIp(zoneIptemp.getZoneIp() + "/" + zoneIptemp.getMask());
                    taskOperate.setExecutTime(System.currentTimeMillis() / 1000L);
                    taskOperate.setStatus(0);
                    taskOperate.setErrorCode(0);
                    taskOperate.setDetail("deploy sourceZoneName undo zoneIp successful!");
                    this.operateTaskService.saveOperateTaskUnicom(taskOperate);
                    this.execRestOperLogSuccess(zoneIptemp, devcieIp, "deploy sourceZoneName undo zoneIp successful!", resultMap);
                    this.deployIpResult(commandDeployResult, srouceZoneDevice.getZoneId(), flag, aticDevice.getMoId(), zoneIptemp.getId(), errorMsgKey, errorParam);
                }
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)("move source action error, zone name :" + sourceZoneName + " zone ip :" + zoneIptemp.getStartIp()));
                detail = new StringBuffer();
                detail.append("deploy sourceZoneName undo zoneIp error! ");
                String msg = AticUtil.getText((String)("lego.err." + e.getErrorCode()), (Locale)new Locale("en"));
                detail.append(msg);
                this.execRestOperLog(taskId, zoneIptemp, devcieIp, detail.toString(), resultMap);
                errorMsgKey = "lego.err." + e.getErrorCode();
                this.deployIpResult(commandDeployResult, srouceZoneDevice.getZoneId(), false, aticDevice.getMoId(), zoneIptemp.getId(), errorMsgKey, errorParam);
            }
        }
        if (null != destZoneDevice) {
            telnetPara = this.aticDeviceService.getDeviceTelnetPara(destZoneDevice.getDeviceId().longValue());
            aticDevice = this.aticDeviceService.getDeviceByMoid(destZoneDevice.getDeviceId().longValue());
            String devIp = aticDevice.getIpAddress();
            try {
                cmdSys = new ArrayList();
                cmdSys.add("sys");
                cmdSys.add("ddos-zone name " + destZoneName);
                cmdIp = new ArrayList();
                cmdIp.add(cmdDo + zoneIptemp.getZoneIp() + " " + zoneIptemp.getMask());
                tryCount = 3;
                result = null;
                for (int i = 0; i < tryCount; ++i) {
                    try {
                        CmdUtil.execCmds((ExcmdConnectUtil)excmdConnectUtil, cmdSys, (boolean)true);
                        result = CmdUtil.execCmds((ExcmdConnectUtil)excmdConnectUtil, cmdIp, (boolean)false);
                        break;
                    }
                    catch (LegoCheckedException e) {
                        this.logger.info((Object)("undoDeployZoneIp error and try " + i + e.getMessage()));
                        if (2 <= i) {
                            throw e;
                        }
                        if (null != excmdConnectUtil) {
                            this.logger.info((Object)"release excmdconnection start");
                            ExcmdConnectionPool.getInstance().excmdConnectionRelease(aticDevice.getMoId(), excmdConnectUtil);
                        }
                        this.logger.info((Object)"excmdConnectUtil start");
                        excmdConnectUtil = ExcmdConnectionPool.getInstance().getExcmdConnectUtil(telnetPara);
                        this.logger.info((Object)"excmdConnectUtil finish");
                        continue;
                    }
                }
                this.logger.info((Object)("deploy destZone ZoneIp result is" + (null == result ? null : result.toString())));
                Boolean flag = VsmUtil.getInstance().checkCmdResult(result);
                if (flag.booleanValue() && result.toString().toLowerCase(Locale.ENGLISH).contains("warning: please specify zone id first")) {
                    this.logger.info((Object)"please specify zone id first");
                    flag = false;
                }
                if (!flag.booleanValue()) {
                    detail2 = " ";
                    int errorIp = 0;
                    for (String cmd : result) {
                        if (cmd.contains("Error: IP address conflict .")) {
                            detail2 = "IP address conflict";
                            errorMsgKey = "lego.err.630018";
                            errorIp = 1;
                            break;
                        }
                        if (cmd.contains("Error: The number of IP addresses of current zone reaches limit already! No more IP addresses could be added to the zone")) {
                            detail2 = "The number of IP addresses of current zone reaches limit already! No more IP addresses could be added to the zone";
                            errorMsgKey = "lego.err.630016";
                            errorIp = 2;
                            break;
                        }
                        if (cmd.contains("Error: The number of IP addresses configured in the device reaches limit already ! No more IP addresses could be added to the device")) {
                            detail2 = "The number of IP addresses configured in the device reaches limit already ! No more IP addresses could be added to the device";
                            errorMsgKey = "lego.err.630017";
                            errorIp = 3;
                            break;
                        }
                        if (!cmd.contains("Warning: Please specify zone ID first")) continue;
                        detail2 = "Warning: Please specify zone ID first";
                        errorMsgKey = "lego.err.630009";
                        errorIp = 4;
                        break;
                    }
                    StringBuffer error = new StringBuffer();
                    if (errorIp != 0) {
                        for (int i = 1; i < cmdIp.size(); ++i) {
                            error.append((String)cmdIp.get(i));
                        }
                    }
                    errorParam = error.toString();
                    this.logger.error((Object)("err : move destination action error, zone name :" + destZoneName + " zone ip :" + zoneIptemp.getStartIp()));
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("deploy zoneIp error! ");
                    buffer.append(detail2);
                    this.execRestOperLog(taskId, zoneIptemp, devIp, buffer.toString(), resultMap);
                    this.deployIpResult(commandDeployResult, zoneIptemp.getZoneId(), flag, aticDevice.getMoId(), zoneIptemp.getId(), errorMsgKey, errorParam);
                } else {
                    taskOperate = new TaskOperateUnicomEntity();
                    taskOperate.setTaskId(taskId);
                    taskOperate.setCommand(DEPLOYZONEIP);
                    taskOperate.setCleanEq(aticDevice.getIpAddress());
                    taskOperate.setProtectIp(zoneIptemp.getZoneIp() + "/" + zoneIptemp.getMask());
                    taskOperate.setExecutTime(System.currentTimeMillis() / 1000L);
                    taskOperate.setStatus(0);
                    taskOperate.setErrorCode(0);
                    taskOperate.setDetail("deploy zoneIp successful!");
                    this.operateTaskService.saveOperateTaskUnicom(taskOperate);
                    this.execRestOperLogSuccess(zoneIptemp, devIp, "deploy zoneIp successful!", resultMap);
                    this.deployIpResult(commandDeployResult, zoneIptemp.getZoneId(), flag, aticDevice.getMoId(), zoneIptemp.getId(), errorMsgKey, errorParam);
                }
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)("move destination action error, zone name :" + destZoneName + " zone ip :" + zoneIptemp.getZoneIp()));
                detail = new StringBuffer();
                detail.append("deploy zoneIp error! ");
                String msg = AticUtil.getText((String)("lego.err." + e.getErrorCode()), (Locale)new Locale("en"));
                detail.append(msg);
                this.execRestOperLog(taskId, zoneIptemp, devIp, detail.toString(), resultMap);
                errorMsgKey = "lego.err." + e.getErrorCode();
                this.deployIpResult(commandDeployResult, zoneIptemp.getZoneId(), false, aticDevice.getMoId(), zoneIptemp.getId(), errorMsgKey, errorParam);
            }
        }
        return commandDeployResult;
    }

    private void deployIpResult(Map<CommandPair, DeployResult> commandDeployResult, Long zoneId, boolean flag, Long deviceId, Long id, String errorMsgKey, String errorParam) {
        Set<CommandPair> commandPairSet = commandDeployResult.keySet();
        this.logger.info((Object)("zoneId = " + zoneId + "; deviceId = " + deviceId + "; id = " + id + "; flag = " + flag));
        if (null != id) {
            CommandPair curCommand = new CommandPair(zoneId, deviceId, ZoneListIpInfo.class.getSimpleName(), id);
            DeployResult deployResult = new DeployResult();
            if (flag) {
                if (!commandPairSet.contains(curCommand)) {
                    deployResult.setIsDeployOk(true);
                    deployResult.setErrorMsgKey("--");
                    deployResult.setErrorParam("");
                    commandDeployResult.put(curCommand, deployResult);
                }
            } else if (!commandPairSet.contains(curCommand) || commandDeployResult.get(curCommand).getIsDeployOk().booleanValue()) {
                deployResult.setIsDeployOk(false);
                deployResult.setErrorMsgKey(errorMsgKey);
                deployResult.setErrorParam(errorParam);
                commandDeployResult.put(curCommand, deployResult);
            }
        }
    }

    private void execRestOperLog(String taskId, ZoneIpForm zoneIptemp, String devcieIp, String detail, Map<String, BatchOperationResult> resultMap) {
        TaskOperateUnicomEntity taskOperate = new TaskOperateUnicomEntity();
        taskOperate.setTaskId(taskId);
        taskOperate.setCommand(DEPLOYZONEIP);
        taskOperate.setCleanEq(devcieIp);
        taskOperate.setProtectIp(zoneIptemp.getZoneIp() + "/" + zoneIptemp.getMask());
        taskOperate.setExecutTime(System.currentTimeMillis() / 1000L);
        taskOperate.setStatus(1);
        taskOperate.setErrorCode(2);
        taskOperate.setDetail(detail);
        this.operateTaskService.saveOperateTaskUnicom(taskOperate);
        BatchOperationResult batchOperationResult = this.createDeployResult("protectIp:" + zoneIptemp.getZoneIp() + "/" + zoneIptemp.getMask() + " " + taskOperate.getDetail());
        if (null == resultMap.get(devcieIp)) {
            resultMap.put(devcieIp, batchOperationResult);
        } else {
            BatchOperationResult boLast = resultMap.get(devcieIp);
            List resultLast = boLast.getResult();
            List resultTemp = batchOperationResult.getResult();
            for (BatchOperation b : resultTemp) {
                resultLast.add(b);
            }
            boLast.setResult(resultLast);
            boLast.setFailCount(boLast.getFailCount() + batchOperationResult.getFailCount());
            boLast.setSucceedCount(boLast.getSucceedCount() + batchOperationResult.getSucceedCount());
            boLast.setTotalCount(boLast.getTotalCount() + batchOperationResult.getTotalCount());
            resultMap.put(devcieIp, boLast);
        }
    }

    private void execRestOperLogSuccess(ZoneIpForm zoneIptemp, String devcieIp, String detail, Map<String, BatchOperationResult> resultMap) {
        BatchOperationResult batchOperationResult = this.createDeployResultSuccess("protectIp:" + zoneIptemp.getZoneIp() + "/" + zoneIptemp.getMask() + " " + detail);
        if (null == resultMap.get(devcieIp)) {
            resultMap.put(devcieIp, batchOperationResult);
        } else {
            BatchOperationResult boLast = resultMap.get(devcieIp);
            List resultLast = boLast.getResult();
            List resultTemp = batchOperationResult.getResult();
            for (BatchOperation b : resultTemp) {
                resultLast.add(b);
            }
            boLast.setResult(resultLast);
            boLast.setFailCount(boLast.getFailCount() + batchOperationResult.getFailCount());
            boLast.setSucceedCount(boLast.getSucceedCount() + batchOperationResult.getSucceedCount());
            boLast.setTotalCount(boLast.getTotalCount() + batchOperationResult.getTotalCount());
            resultMap.put(devcieIp, boLast);
        }
    }

    private BatchOperationResult createDeployResult(String detail) {
        this.logger.info((Object)"deploy zoneIp fail start!");
        BatchOperationResult operationResult = new BatchOperationResult();
        ArrayList<BatchOperation> result = new ArrayList<BatchOperation>();
        BatchOperation bo = new BatchOperation();
        bo.setOptDetail(detail);
        result.add(bo);
        operationResult.setFailCount(1);
        operationResult.setSucceedCount(0);
        operationResult.setTotalCount(1);
        operationResult.setResult(result);
        this.logger.info((Object)"deploy zoneIp fail end!");
        return operationResult;
    }

    private BatchOperationResult createDeployResultSuccess(String detail) {
        this.logger.info((Object)"deploy zoneIp success start!");
        BatchOperationResult operationResult = new BatchOperationResult();
        ArrayList<BatchOperation> result = new ArrayList<BatchOperation>();
        BatchOperation bo = new BatchOperation();
        bo.setOptDetail(detail);
        result.add(bo);
        operationResult.setFailCount(0);
        operationResult.setSucceedCount(1);
        operationResult.setTotalCount(1);
        operationResult.setResult(result);
        return operationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMoveZoneIptData(MoveZoneIpData moveIpList) {
        List<MoveZoneIpData> list = this.nowProcessing;
        synchronized (list) {
            this.nowProcessing.add(moveIpList);
            this.logger.info((Object)("add one moveIpList,nowProcessing size:" + this.nowProcessing.size() + "  " + moveIpList.getTaskId()));
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

