/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.unicom.restful.daemon;

import com.hs.atic.bis.unicom.service.impl.UnicomConfigServiceImpl;
import com.hs.atic.sdk.bis.form.DivertTacticsForm;
import com.hs.atic.sdk.bis.unicom.entity.DeployResult;
import com.hs.atic.sdk.bis.unicom.entity.RestCleanStartProtectDetailInfo;
import com.hs.atic.sdk.bis.unicom.entity.RestCleanStartTaskInfo;
import com.hs.atic.sdk.bis.unicom.entity.TaskOperateUnicomEntity;
import com.hs.atic.sdk.bis.unicom.entity.TaskUnicomEntity;
import com.hs.atic.sdk.bis.unicom.service.OperateTaskUnicomService;
import com.hs.atic.sdk.bis.unicom.service.TaskUnicomService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.form.ZoneIpForm;
import com.hs.atic.sdk.zone.form.ZoneListIpForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.ddos.common.CommandPair;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.nfa.util.JSONUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceDeployStatusForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceDeployStatusService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.hs.vsm.secservice.sdk.unicom.restful.model.RestCleanEqStatus;
import com.hs.vsm.secservice.sdk.unicom.restful.model.RestCleanTaskStartResultInfo;
import com.hs.vsm.secservice.sdk.unicom.restful.service.CleanTaskBufferService;
import com.hs.vsm.secservice.sdk.unicom.restful.service.RestfulCleanService;
import com.hs.vsm.secservice.unicom.model.UnicomConfigInfoForm;
import com.hs.vsm.secservice.unicom.restful.daemon.MoveZoneIpData;
import com.hs.vsm.secservice.unicom.restful.daemon.MoveZoneIpStartThread;
import com.hs.vsm.secservice.unicom.restful.daemon.MoveZoneIpThreadPool;
import com.hs.vsm.secservice.unicom.restful.daemon.UpdateZoneStatusTools;
import com.hs.vsm.secservice.unicom.util.AticUtil;
import com.hs.vsm.secservice.unicom.util.UnicomConfigStartup;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.policy.third.service.IDivertForPolicy;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.south.model.TelnetPara;
import com.huawei.atic.util.AticInstallUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class RestCleanTaskStartThread
extends Thread {
    private static final Object LOCK = new Object();
    private static final String DATEFORMATE = "yyyy-MM-dd HH:mm:ss";
    private static final String CLEANTASKSTART = "cleanTaskStart";
    private boolean isOpen = false;
    private int conCurNum = 3;
    private String cleanTaskStartUrl = "http://host:port/rest";
    private String alias;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_UNICOM_SOC);
    private RestfulCleanService restfulCleanService;
    private UnicomConfigStartup unicomConfigStartup;
    private CleanTaskBufferService cleanTaskBufferService;
    private IZoneService zoneService;
    private IAticDeviceService aticDeviceService;
    private IZoneDeviceDeployStatusService zoneDeviceDeployStatusService;
    private IZoneDeviceService zoneDeviceService;
    private TaskUnicomService taskUnicomService;
    private OperateTaskUnicomService operateTaskService;
    private UpdateZoneStatusTools updateZoneStatusTools;
    @Autowired
    @Qualifier(value="unicomConfigService")
    private UnicomConfigServiceImpl unicomConfigService;

    public RestCleanTaskStartThread() {
        this.setName("RestCleanTaskStartThread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configThread() {
        UnicomConfigInfoForm unicomConfigInfoForm = AticUtil.queryUnicomConfig(this.unicomConfigService);
        this.isOpen = unicomConfigInfoForm.isOpen();
        this.cleanTaskStartUrl = unicomConfigInfoForm.getCleanTaskStartUri();
        this.alias = unicomConfigInfoForm.getCertAlias();
        String unicomPath = File.separator + "vsm_conf" + File.separator + "antiddos" + File.separator + "unicom" + File.separator + "unicom.xml";
        String pathName = AticInstallUtil.getInstance().getAticInstallPath() + unicomPath;
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(pathName);
            properties.loadFromXML(fileInputStream);
            int conCurrentNum = Integer.parseInt(properties.getProperty("unicom.concurrent.num"));
            if (conCurrentNum > 0 && conCurrentNum <= 20) {
                this.conCurNum = conCurrentNum;
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"IOException saveUnicomConfig");
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"RuntimeException saveUnicomConfig");
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                this.logger.error((Object)"load close file failed");
            }
        }
        this.logger.info((Object)("unicom.properties file:[isOpen:" + this.isOpen + "]."));
    }

    @Override
    public void run() {
        this.logger.info((Object)"RestCleanTaskStartThread is  open!");
        this.configThread();
        RestCleanStartTaskInfo cleanTaskStart = null;
        this.logger.info((Object)("RestCleanTaskStartThread start, concurnum=" + this.conCurNum));
        ExecutorService executp = Executors.newFixedThreadPool(this.conCurNum);
        subCleanTaskStartThread subStartTask = null;
        while (this.isOpen) {
            try {
                cleanTaskStart = this.cleanTaskBufferService.takeCleanStartTask();
                this.logger.info((Object)("CleanTaskBuffer:  StartQueue data  has data,begin exec cleanTask:" + cleanTaskStart.getTaskId()));
                subStartTask = new subCleanTaskStartThread(cleanTaskStart);
                executp.execute(subStartTask);
            }
            catch (RuntimeException e) {
                this.logger.error((Object)("RestCleanTaskStartThread occur exception:" + e.getMessage()));
            }
        }
    }

    private void cleanTaskStart(RestCleanStartTaskInfo restCleanStartInfo) {
        String taskId = restCleanStartInfo.getTaskId();
        String userName = restCleanStartInfo.getUserName();
        HashMap<String, BatchOperationResult> resultMap = new HashMap<String, BatchOperationResult>();
        this.moveDeployZoneIp(restCleanStartInfo, resultMap, userName);
        this.logger.info((Object)("start taskId=" + taskId + ",resultMap=" + resultMap.size()));
        RestCleanTaskStartResultInfo cleanTaskStartResultInfo = this.handleBatchOperationResult(resultMap, taskId);
        TaskUnicomEntity taskEntity = this.taskUnicomService.getTaskUnicomById(taskId);
        if (null == taskEntity) {
            return;
        }
        if ("0".equals(cleanTaskStartResultInfo.getStartStatus())) {
            taskEntity.setStatus("2");
        } else if ("1".equals(cleanTaskStartResultInfo.getStartStatus())) {
            taskEntity.setStatus("3");
        } else {
            taskEntity.setStatus("4");
        }
        this.taskUnicomService.saveTaskUnicom(taskEntity);
        this.logger.info((Object)"RestCleanTaskStartThread update to TaskUnicomEntity success!");
        try {
            String json = JSONUtil.getInstance().toJSON((Object)cleanTaskStartResultInfo);
            UnicomConfigInfoForm unicomConfigInfoForm = AticUtil.queryUnicomConfig(this.unicomConfigService);
            this.cleanTaskStartUrl = unicomConfigInfoForm.getCleanTaskStartUri();
            this.alias = unicomConfigInfoForm.getCertAlias();
            this.restfulCleanService.restCleanTaskStartResult(json, this.cleanTaskStartUrl, this.alias);
            this.logger.info((Object)"RestCRestCleanTaskStartThread restful over");
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"RestCleanTaskStartThread occur exception when Calling unicom interface.");
        }
    }

    private void moveDeployZoneIp(RestCleanStartTaskInfo restCleanStartInfo, Map<String, BatchOperationResult> resultMap, String userName) {
        this.logger.info((Object)"RestCleanTaskStartThread  begin!");
        String taskId = restCleanStartInfo.getTaskId();
        List<RestCleanStartProtectDetailInfo> protectDetailInfos = restCleanStartInfo.getProtectDetail();
        String destZoneName = "";
        Long destZoneId = null;
        Iterator<RestCleanStartProtectDetailInfo> iterator = protectDetailInfos.iterator();
        if (iterator.hasNext()) {
            RestCleanStartProtectDetailInfo reStartProtectDetailInfo = iterator.next();
            destZoneName = reStartProtectDetailInfo.getStrategyName();
            ZoneInfoForm zoneInfoForm = this.zoneService.getZoneByName(destZoneName);
            Long l = destZoneId = zoneInfoForm == null ? Long.valueOf(0L) : zoneInfoForm.getZoneId();
        }
        if (null == destZoneId) {
            return;
        }
        Map<CommandPair, DeployResult> commandDeployResult = this.moveZoneAndDeployZoneIp(restCleanStartInfo, destZoneName, destZoneId, userName, resultMap);
        try {
            this.updateZoneStatusTools.saveDeployStatus(commandDeployResult);
        }
        catch (RuntimeException e) {
            this.logger.error((Object)("saveDeployStatus error!" + e.getMessage()));
        }
        for (int k = 0; k < protectDetailInfos.size(); ++k) {
            RestCleanStartProtectDetailInfo protectDetailInfo = protectDetailInfos.get(k);
            List<String> deviceIPs = protectDetailInfo.getDeviceIPs();
            TaskOperateUnicomEntity taskOperate = new TaskOperateUnicomEntity();
            BatchOperationResult result = null;
            int deviceIPsLeng = deviceIPs.size();
            for (int i = 0; i < deviceIPsLeng; ++i) {
                AticDevice device = this.aticDeviceService.getDeviceByIp(deviceIPs.get(i));
                Long deviceId = device.getMoId();
                ZoneDeviceDeployStatusForm zoneDeviceDeployStatusForm = this.zoneDeviceDeployStatusService.getByZoneIdAndDeviceId(destZoneId, deviceId);
                if (null != zoneDeviceDeployStatusForm) continue;
                result = this.createStartResult(restCleanStartInfo, deviceIPs.get(i));
                this.logger.warn((Object)"RestCleanTaskStartThread zone not deploy to device!");
                if (null == resultMap.get(deviceIPs.get(i))) {
                    resultMap.put(deviceIPs.get(i), result);
                } else {
                    BatchOperationResult boLast = resultMap.get(deviceIPs.get(i));
                    List resultLast = boLast.getResult();
                    List resultTemp = result.getResult();
                    for (BatchOperation b : resultTemp) {
                        resultLast.add(b);
                    }
                    boLast.setResult(resultLast);
                    boLast.setFailCount(boLast.getFailCount() + result.getFailCount());
                    boLast.setSucceedCount(boLast.getSucceedCount() + result.getSucceedCount());
                    boLast.setTotalCount(boLast.getTotalCount() + result.getTotalCount());
                    resultMap.put(deviceIPs.get(i), boLast);
                }
                taskOperate.setTaskId(taskId);
                taskOperate.setCommand(CLEANTASKSTART);
                taskOperate.setCleanEq(deviceIPs.get(i));
                taskOperate.setProtectIp("--");
                taskOperate.setExecutTime(System.currentTimeMillis() / 1000L);
                taskOperate.setStatus(1);
                taskOperate.setErrorCode(2);
                taskOperate.setDetail("create failed, because zone not deploy to device!");
                this.operateTaskService.saveOperateTaskUnicom(taskOperate);
            }
        }
        this.logger.info((Object)"RestCleanTaskStartThread over");
    }

    private Map<CommandPair, DeployResult> moveZoneAndDeployZoneIp(RestCleanStartTaskInfo restCleanStartInfo, String destZoneName, Long zoneId, String userName, Map<String, BatchOperationResult> resultMap) {
        ConcurrentHashMap<CommandPair, DeployResult> moveIpDeployResult = new ConcurrentHashMap<CommandPair, DeployResult>();
        List<String> protectIPs = restCleanStartInfo.getProtectIPs();
        String terminalIp = restCleanStartInfo.getClientIp();
        String taskId = restCleanStartInfo.getTaskId();
        int totalCount = 0;
        HashSet<String> totalThreadName = new HashSet<String>();
        HashMap<CommandPair, DeployResult> operationMap = new HashMap<CommandPair, DeployResult>();
        for (String proectIp : protectIPs) {
            String[] zoneIpDetails = proectIp.split("/");
            String zoneIp = zoneIpDetails[0];
            String mask = zoneIpDetails[1];
            boolean isIpv4 = IPUtil.isIpv4((String)zoneIp);
            ZoneIpForm zoneIptemp = new ZoneIpForm();
            zoneIptemp.setZoneIp(zoneIp);
            zoneIptemp.setMask(Integer.valueOf(Integer.parseInt(mask)));
            String[] rangeIps = IPUtil.getSubnetRange((String)zoneIp, (int)Integer.parseInt(mask));
            zoneIptemp.setStartIp(rangeIps[0]);
            zoneIptemp.setEndIp(rangeIps[1]);
            List existForms = this.zoneService.findExistIp(zoneIptemp);
            if (null != existForms && !existForms.isEmpty()) {
                IDivertForPolicy divertTacticsService;
                List divertTacticsForms;
                ZoneIpForm sourceZoneIpForm = (ZoneIpForm)existForms.get(0);
                String sourceZoneIp = sourceZoneIpForm.getZoneIp();
                Integer sourceMask = sourceZoneIpForm.getMask();
                String[] sourceRangeIps = IPUtil.getSubnetRange((String)sourceZoneIp, (int)sourceMask);
                Long sourceZoneId = sourceZoneIpForm.getZoneId();
                ZoneInfoForm sourceZoneForm = this.zoneService.getZoneNOIpById(sourceZoneId);
                if (null == sourceZoneForm) {
                    this.logger.info((Object)"sourceZoneForm data is null.");
                    continue;
                }
                String sourceZoneName = sourceZoneForm.getZoneName();
                ZoneIpForm destZoneIpForm = zoneIptemp;
                ZoneListIpForm destZoneListIpForm = new ZoneListIpForm();
                destZoneListIpForm.setEndIp(zoneIptemp.getEndIp());
                destZoneListIpForm.setStartIp(zoneIptemp.getStartIp());
                destZoneListIpForm.setIntMask(zoneIptemp.getMask().intValue());
                destZoneListIpForm.setIpType(0);
                destZoneListIpForm.setMaskType(0);
                destZoneListIpForm.setZoneIp(zoneIptemp.getZoneIp());
                destZoneListIpForm.setDeleteFlag(Integer.valueOf(0));
                ZoneInfoForm destZoneForm = this.zoneService.getCustomZoneByName(destZoneName);
                ArrayList sourceZoneDevicelist = this.zoneDeviceService.queryZoneDeviceFormsByZoneID(sourceZoneForm.getZoneId());
                if (null == sourceZoneDevicelist || sourceZoneDevicelist.isEmpty()) {
                    this.logger.info((Object)"sourceZone not bonded devices");
                    continue;
                }
                List destZoneDevicelist = this.zoneDeviceService.queryZoneDeviceFormsByZoneID(destZoneForm.getZoneId());
                if (null == destZoneDevicelist || destZoneDevicelist.isEmpty()) {
                    this.logger.info((Object)"destZone not bonded devices");
                    continue;
                }
                zoneIptemp.setZoneId(destZoneForm.getZoneId());
                zoneIptemp.setId(sourceZoneIpForm.getId());
                if (rangeIps[0].equals(sourceRangeIps[0]) && rangeIps[1].equals(sourceRangeIps[1])) {
                    if (destZoneName.equalsIgnoreCase(sourceZoneName)) {
                        sourceZoneDevicelist = new ArrayList();
                    } else {
                        this.zoneService.deleteSourceZoneIpAndZoneIpListAndAddDestZoneIp(sourceZoneIpForm, sourceZoneId.longValue(), zoneIp, destZoneIpForm, destZoneListIpForm, destZoneForm.getZoneId().longValue());
                    }
                } else {
                    sourceZoneDevicelist = new ArrayList();
                }
                try {
                    MoveZoneIpStartThread moveIpStartThread;
                    MoveZoneIpStartThread startThread;
                    MoveZoneIpData moveIpData;
                    Object aticDevice;
                    TelnetPara telnetPara;
                    if (0 != sourceZoneDevicelist.size()) {
                        for (ZoneDeviceForm deviceForm : sourceZoneDevicelist) {
                            telnetPara = this.aticDeviceService.getDeviceTelnetPara(deviceForm.getDeviceId().longValue());
                            aticDevice = this.aticDeviceService.getDeviceByMoid(deviceForm.getDeviceId().longValue());
                            if (null == aticDevice || null == telnetPara || 8 == aticDevice.getDeviceType() || 9 == aticDevice.getDeviceType()) continue;
                            moveIpData = new MoveZoneIpData();
                            moveIpData.setSrouceZoneDevice(deviceForm);
                            moveIpData.setSourceZoneName(sourceZoneName);
                            moveIpData.setDestZoneDevice(null);
                            moveIpData.setDestZoneName(null);
                            moveIpData.setZoneIptemp(zoneIptemp);
                            moveIpData.setIpv4(isIpv4);
                            moveIpData.setTaskId(taskId);
                            moveIpData.setResultMap(resultMap);
                            moveIpData.setCommandDeployResult(moveIpDeployResult);
                            startThread = MoveZoneIpThreadPool.getStart(aticDevice.getIpAddress() + ":" + taskId);
                            if (null == startThread) {
                                moveIpStartThread = new MoveZoneIpStartThread(deviceForm, aticDevice.getIpAddress() + ":" + taskId, this.aticDeviceService, this.operateTaskService);
                                moveIpStartThread.start();
                                MoveZoneIpThreadPool.putStart(aticDevice.getIpAddress() + ":" + taskId, moveIpStartThread);
                            }
                            MoveZoneIpThreadPool.getStart(aticDevice.getIpAddress() + ":" + taskId).addMoveZoneIptData(moveIpData);
                            if (null == zoneIptemp.getId()) continue;
                            ++totalCount;
                            totalThreadName.add(aticDevice.getIpAddress() + ":" + taskId);
                        }
                    }
                    for (ZoneDeviceForm deviceForm : destZoneDevicelist) {
                        telnetPara = this.aticDeviceService.getDeviceTelnetPara(deviceForm.getDeviceId().longValue());
                        aticDevice = this.aticDeviceService.getDeviceByMoid(deviceForm.getDeviceId().longValue());
                        if (null == aticDevice || null == telnetPara || 8 == aticDevice.getDeviceType() || 9 == aticDevice.getDeviceType()) continue;
                        moveIpData = new MoveZoneIpData();
                        moveIpData.setSrouceZoneDevice(null);
                        moveIpData.setSourceZoneName(null);
                        moveIpData.setDestZoneDevice(deviceForm);
                        moveIpData.setDestZoneName(destZoneName);
                        moveIpData.setZoneIptemp(zoneIptemp);
                        moveIpData.setIpv4(isIpv4);
                        moveIpData.setTaskId(taskId);
                        moveIpData.setResultMap(resultMap);
                        moveIpData.setCommandDeployResult(moveIpDeployResult);
                        startThread = MoveZoneIpThreadPool.getStart(aticDevice.getIpAddress() + ":" + taskId);
                        if (null == startThread) {
                            moveIpStartThread = new MoveZoneIpStartThread(deviceForm, aticDevice.getIpAddress() + ":" + taskId, this.aticDeviceService, this.operateTaskService);
                            moveIpStartThread.start();
                            MoveZoneIpThreadPool.putStart(aticDevice.getIpAddress() + ":" + taskId, moveIpStartThread);
                        }
                        MoveZoneIpThreadPool.getStart(aticDevice.getIpAddress() + ":" + taskId).addMoveZoneIptData(moveIpData);
                        if (null == zoneIptemp.getId()) continue;
                        ++totalCount;
                        totalThreadName.add(aticDevice.getIpAddress() + ":" + taskId);
                    }
                }
                catch (LegoCheckedException e) {
                    this.logger.error((Object)("deploy zoneIp error!" + e.getMessage()));
                }
                if ((divertTacticsForms = (divertTacticsService = ZoneReferUtil.getDivertForPolicyService()).getDivertTacticsByIp(zoneIptemp.getStartIp(), zoneIptemp.getEndIp())).isEmpty()) continue;
                ArrayList<BatchOperation> boList = new ArrayList<BatchOperation>();
                for (DivertTacticsForm divertTacticsForm : divertTacticsForms) {
                    BatchOperation bo = new BatchOperation();
                    bo.setTargetId(divertTacticsForm.getId().longValue());
                    bo.setTargetName("(" + divertTacticsForm.getDeviceName() + ", IP :" + zoneIp + ")");
                    boList.add(bo);
                }
                BatchOperationResult boResult = divertTacticsService.deleteDivertTactics(boList, true, userName, terminalIp + "(restful)");
                if (boResult.getFailCount() > 0) {
                    this.logger.info((Object)("boResult is ok" + boResult.toString()));
                    continue;
                }
                this.logger.info((Object)("boResult is fail" + boResult.toString()));
                continue;
            }
            ZoneIpForm destZoneIpForm = zoneIptemp;
            ZoneListIpForm destZoneListIpForm = new ZoneListIpForm();
            destZoneListIpForm.setEndIp(zoneIptemp.getEndIp());
            destZoneListIpForm.setStartIp(zoneIptemp.getStartIp());
            destZoneListIpForm.setIntMask(zoneIptemp.getMask().intValue());
            destZoneListIpForm.setIpType(0);
            destZoneListIpForm.setMaskType(0);
            destZoneListIpForm.setZoneIp(zoneIptemp.getZoneIp());
            destZoneListIpForm.setDeleteFlag(Integer.valueOf(0));
            this.zoneService.deleteSourceZoneIpAndZoneIpListAndAddDestZoneIp(null, 0L, zoneIp, destZoneIpForm, destZoneListIpForm, zoneId.longValue());
            List destZoneDevicelist = this.zoneDeviceService.queryZoneDeviceFormsByZoneID(zoneId);
            try {
                if (null == destZoneDevicelist || destZoneDevicelist.isEmpty()) continue;
                for (ZoneDeviceForm deviceForm : destZoneDevicelist) {
                    TelnetPara telnetPara = this.aticDeviceService.getDeviceTelnetPara(deviceForm.getDeviceId().longValue());
                    AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(deviceForm.getDeviceId().longValue());
                    if (null == aticDevice || null == telnetPara || 8 == aticDevice.getDeviceType() || 9 == aticDevice.getDeviceType()) continue;
                    MoveZoneIpData moveIpData = new MoveZoneIpData();
                    moveIpData.setSrouceZoneDevice(null);
                    moveIpData.setSourceZoneName(null);
                    moveIpData.setDestZoneDevice(deviceForm);
                    moveIpData.setDestZoneName(destZoneName);
                    moveIpData.setZoneIptemp(zoneIptemp);
                    moveIpData.setIpv4(isIpv4);
                    moveIpData.setTaskId(taskId);
                    moveIpData.setResultMap(resultMap);
                    moveIpData.setCommandDeployResult(moveIpDeployResult);
                    MoveZoneIpStartThread startThread = MoveZoneIpThreadPool.getStart(aticDevice.getIpAddress() + ":" + taskId);
                    if (null == startThread) {
                        MoveZoneIpStartThread moveIpStartThread = new MoveZoneIpStartThread(deviceForm, aticDevice.getIpAddress() + ":" + taskId, this.aticDeviceService, this.operateTaskService);
                        moveIpStartThread.start();
                        MoveZoneIpThreadPool.putStart(aticDevice.getIpAddress() + ":" + taskId, moveIpStartThread);
                    }
                    MoveZoneIpThreadPool.getStart(aticDevice.getIpAddress() + ":" + taskId).addMoveZoneIptData(moveIpData);
                    ++totalCount;
                    totalThreadName.add(aticDevice.getIpAddress() + ":" + taskId);
                }
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)("deploy zoneIp error!" + e.getMessage()));
            }
        }
        this.logger.info((Object)("deploy ip totalCount is " + totalCount));
        int count = 0;
        do {
            Iterator iterator = moveIpDeployResult.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry rs = iterator.next();
                operationMap.put((CommandPair)rs.getKey(), (DeployResult)rs.getValue());
                this.logger.info((Object)("taskId:" + taskId + "finish moveIPtask:" + ++count + ":" + totalCount));
                iterator.remove();
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                this.logger.info((Object)("sleep with error:" + count));
            }
            if (this.checkAllThreadStatus(totalThreadName).booleanValue()) continue;
            this.logger.error((Object)"All thread is finish,but some task without excute");
            break;
        } while (count < totalCount);
        for (String threadName : totalThreadName) {
            this.logger.info((Object)("finish thread Name:" + threadName));
            MoveZoneIpThreadPool.removeStart(threadName);
        }
        return operationMap;
    }

    private Boolean checkAllThreadStatus(Set<String> totalThreadName) {
        for (String threadName : totalThreadName) {
            if (MoveZoneIpThreadPool.getStart(threadName) == null) continue;
            return true;
        }
        return false;
    }

    private RestCleanTaskStartResultInfo handleBatchOperationResult(Map<String, BatchOperationResult> resultMap, String taskId) {
        this.logger.info((Object)"RestCleanTaskStartThread  begin convert  to RestCleanTaskStartResultInfo!");
        RestCleanTaskStartResultInfo cleanResult = new RestCleanTaskStartResultInfo();
        ArrayList<RestCleanEqStatus> restCleanEqStatus = new ArrayList<RestCleanEqStatus>();
        cleanResult.setCommand(CLEANTASKSTART);
        cleanResult.setTaskId(taskId);
        String status = "0";
        BatchOperationResult bor = null;
        int totalCount = 0;
        int failCount = 0;
        for (Map.Entry<String, BatchOperationResult> entry : resultMap.entrySet()) {
            RestCleanEqStatus cleanEqStatus = new RestCleanEqStatus();
            String deviceIp = entry.getKey();
            bor = resultMap.get(deviceIp);
            cleanEqStatus.setCleanEqIp(deviceIp);
            this.handleBatchOperation(bor, cleanEqStatus);
            restCleanEqStatus.add(cleanEqStatus);
            totalCount += bor.getTotalCount();
            failCount += bor.getFailCount();
        }
        if (totalCount != failCount && 0 != failCount) {
            status = "1";
            this.logger.info((Object)"RestCleanTaskStartThread has success divert task!");
        }
        if (totalCount == failCount) {
            status = "2";
        }
        String startTime = new SimpleDateFormat(DATEFORMATE).format(new Date());
        this.logger.info((Object)("RestCleanTaskStartThread  get startTime:" + startTime));
        cleanResult.setStartTime(startTime);
        cleanResult.setStartStatus(status);
        if ("0".equals(status)) {
            cleanResult.setStartMsg("all success!");
        } else if ("1".equals(status)) {
            cleanResult.setStartMsg("part success!");
        } else {
            cleanResult.setStartMsg("all fail!");
        }
        cleanResult.setCleanEqStatus(restCleanEqStatus);
        this.logger.info((Object)"RestCleanTaskStartThread  end convert  to RestCleanTaskStartResultInfo!");
        return cleanResult;
    }

    private void handleBatchOperation(BatchOperationResult bor, RestCleanEqStatus cleanEqStatus) {
        int size;
        this.logger.info((Object)"RestCleanTaskStartThread  begin  convert BatchOperationResult into RestCleanTaskStartResultInfo!");
        List bo = null;
        StringBuffer temp = new StringBuffer();
        cleanEqStatus.setStatus("1");
        if (bor.getSucceedCount() > 0) {
            cleanEqStatus.setStatus("0");
        }
        if ((size = (bo = bor.getResult()).size()) > 0) {
            for (int i = 0; i < size; ++i) {
                temp.append(((BatchOperation)bo.get(i)).getOptDetail());
            }
            cleanEqStatus.setMsg(temp.toString());
        }
        this.logger.info((Object)("RestCleanTaskStartThread  RestCleanEqStatus infomation: " + temp.toString()));
        this.logger.info((Object)"RestCleanTaskStartThread  end  convert BatchOperationResult into RestCleanTaskStartResultInfo!");
    }

    private BatchOperationResult createStartResult(RestCleanStartTaskInfo startTaskInfo, String deviceIp) {
        this.logger.info((Object)"RestCleanTaskStartThread createStartResult ,because device not deploy!");
        BatchOperationResult operationResult = new BatchOperationResult();
        ArrayList<BatchOperation> result = new ArrayList<BatchOperation>();
        BatchOperation bo = new BatchOperation();
        bo.setOptDetail("zone not deploy to device!");
        result.add(bo);
        operationResult.setFailCount(1);
        operationResult.setSucceedCount(0);
        operationResult.setTotalCount(1);
        operationResult.setResult(result);
        this.logger.info((Object)"RestCleanTaskStartThread createStartResult ,because device not deploy!");
        return operationResult;
    }

    public RestfulCleanService getRestfulCleanService() {
        return this.restfulCleanService;
    }

    public void setRestfulCleanService(RestfulCleanService restfulCleanService) {
        this.restfulCleanService = restfulCleanService;
    }

    public CleanTaskBufferService getCleanTaskBufferService() {
        return this.cleanTaskBufferService;
    }

    public void setCleanTaskBufferService(CleanTaskBufferService cleanTaskBufferService) {
        this.cleanTaskBufferService = cleanTaskBufferService;
    }

    public IZoneService getZoneService() {
        return this.zoneService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IZoneDeviceDeployStatusService getZoneDeviceDeployStatusService() {
        return this.zoneDeviceDeployStatusService;
    }

    public void setZoneDeviceDeployStatusService(IZoneDeviceDeployStatusService zoneDeviceDeployStatusService) {
        this.zoneDeviceDeployStatusService = zoneDeviceDeployStatusService;
    }

    public TaskUnicomService getTaskUnicomService() {
        return this.taskUnicomService;
    }

    public void setTaskUnicomService(TaskUnicomService taskUnicomService) {
        this.taskUnicomService = taskUnicomService;
    }

    public IZoneDeviceService getZoneDeviceService() {
        return this.zoneDeviceService;
    }

    public void setZoneDeviceService(IZoneDeviceService zoneDeviceService) {
        this.zoneDeviceService = zoneDeviceService;
    }

    public OperateTaskUnicomService getOperateTaskService() {
        return this.operateTaskService;
    }

    public void setOperateTaskService(OperateTaskUnicomService operateTaskService) {
        this.operateTaskService = operateTaskService;
    }

    public UpdateZoneStatusTools getUpdateZoneStatusTools() {
        return this.updateZoneStatusTools;
    }

    public void setUpdateZoneStatusTools(UpdateZoneStatusTools updateZoneStatusTools) {
        this.updateZoneStatusTools = updateZoneStatusTools;
    }

    public UnicomConfigStartup getUnicomConfigStartup() {
        return this.unicomConfigStartup;
    }

    public void setUnicomConfigStartup(UnicomConfigStartup unicomConfigStartup) {
        this.unicomConfigStartup = unicomConfigStartup;
    }

    private class subCleanTaskStartThread
    extends Thread {
        RestCleanStartTaskInfo cleanTask = null;

        subCleanTaskStartThread(RestCleanStartTaskInfo cleanTask) {
            this.setName("CleanTaskStartThread" + cleanTask.getTaskId());
            this.cleanTask = cleanTask;
        }

        @Override
        public void run() {
            RestCleanTaskStartThread.this.cleanTaskStart(this.cleanTask);
        }
    }
}

