/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.unicom.restful.daemon;

import com.hs.atic.bis.unicom.service.impl.UnicomConfigServiceImpl;
import com.hs.atic.sdk.bis.unicom.entity.DeployResult;
import com.hs.atic.sdk.bis.unicom.entity.RestCleanStartInfo;
import com.hs.atic.sdk.bis.unicom.entity.RestCleanStartProtectDetailInfo;
import com.hs.atic.sdk.bis.unicom.entity.RestCleanStopTaskInfo;
import com.hs.atic.sdk.bis.unicom.entity.TaskUnicomEntity;
import com.hs.atic.sdk.bis.unicom.service.OperateTaskUnicomService;
import com.hs.atic.sdk.bis.unicom.service.TaskUnicomService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.form.ZoneIpForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.zone.dao.ZoneIpDao;
import com.hs.atic.zone.model.ZoneIpInfo;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.ddos.common.CommandPair;
import com.hs.vsm.secservice.nfa.util.JSONUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.hs.vsm.secservice.sdk.unicom.restful.model.RestCleanEqStatus;
import com.hs.vsm.secservice.sdk.unicom.restful.model.RestCleanTaskStopResultInfo;
import com.hs.vsm.secservice.sdk.unicom.restful.service.CleanTaskBufferService;
import com.hs.vsm.secservice.sdk.unicom.restful.service.RestfulCleanService;
import com.hs.vsm.secservice.unicom.model.UnicomConfigInfoForm;
import com.hs.vsm.secservice.unicom.restful.daemon.MoveZoneIpData;
import com.hs.vsm.secservice.unicom.restful.daemon.MoveZoneIpStopThread;
import com.hs.vsm.secservice.unicom.restful.daemon.MoveZoneIpThreadPool;
import com.hs.vsm.secservice.unicom.restful.daemon.UpdateZoneStatusTools;
import com.hs.vsm.secservice.unicom.util.AticUtil;
import com.hs.vsm.secservice.unicom.util.UnicomConfigStartup;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.util.AticInstallUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class RestCleanTaskStopThread
extends Thread {
    private static final String DATEFORMATE = "yyyy-MM-dd HH:mm:ss";
    private static final String CLEANTASKSTOP = "cleanTaskStop";
    private boolean isOpen = false;
    private int conCurNum = 3;
    private String cleanTaskStopUrl = "http://host:port/rest";
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_UNICOM_SOC);
    private RestfulCleanService restfulCleanService;
    private UnicomConfigStartup unicomConfigStartup;
    private IZoneService zoneService;
    private IAticDeviceService aticDeviceService;
    private TaskUnicomService taskUnicomService;
    private OperateTaskUnicomService operateTaskService;
    private IZoneDeviceService zoneDeviceService;
    private UpdateZoneStatusTools updateZoneStatusTools;
    private ZoneIpDao zoneIpDao;
    private String alias;
    @Autowired
    @Qualifier(value="unicomConfigService")
    private UnicomConfigServiceImpl unicomConfigService;
    private CleanTaskBufferService cleanTaskBufferService;

    public RestCleanTaskStopThread() {
        this.setName("RestCleanTaskStopThread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configThread() {
        UnicomConfigInfoForm unicomConfigInfoForm = AticUtil.queryUnicomConfig(this.unicomConfigService);
        this.isOpen = unicomConfigInfoForm.isOpen();
        this.cleanTaskStopUrl = unicomConfigInfoForm.getCleanTaskStopUri();
        this.alias = unicomConfigInfoForm.getCertAlias();
        String unicomPath = File.separator + "vsm_conf" + File.separator + "antiddos" + File.separator + "unicom" + File.separator + "unicom.xml";
        String pathName = AticInstallUtil.getInstance().getAticInstallPath() + unicomPath;
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(pathName);
            properties.loadFromXML(fileInputStream);
            int conCurrentNum = Integer.parseInt(properties.getProperty("unicom.concurrent.num"));
            if (conCurrentNum > 0 && conCurrentNum <= 20) {
                this.conCurNum = conCurrentNum;
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"IOException saveUnicomConfig");
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"RuntimeException saveUnicomConfig");
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                this.logger.error((Object)"load close file failed");
            }
        }
        this.logger.info((Object)("unicom.properties file:[isOpen:" + this.isOpen + "]."));
    }

    @Override
    public void run() {
        this.configThread();
        RestCleanStopTaskInfo cleanTaskStop = null;
        this.logger.info((Object)("RestCleanTaskStopThread start, concurnum=" + this.conCurNum));
        ExecutorService executp = Executors.newFixedThreadPool(this.conCurNum);
        subCleanTaskStopThread subStopTask = null;
        while (this.isOpen) {
            try {
                this.logger.info((Object)"RestCleanTaskStopThread  is open!");
                cleanTaskStop = this.cleanTaskBufferService.takeCleanStopTask();
                this.logger.info((Object)"CleanTaskBuffer:  StopQueue  has data,begin exec stopTask!");
                subStopTask = new subCleanTaskStopThread(cleanTaskStop);
                executp.execute(subStopTask);
            }
            catch (RuntimeException e) {
                this.logger.error((Object)"RestCleanTaskStopThread occur exception.");
            }
        }
    }

    private void cleanTaskStop(RestCleanStopTaskInfo stopTaskInfo) {
        String taskId = stopTaskInfo.getTaskId();
        HashMap<String, BatchOperationResult> resultMap = new HashMap<String, BatchOperationResult>();
        this.moveDeployZoneIp(stopTaskInfo, resultMap);
        RestCleanTaskStopResultInfo cleanTaskStopResultInfo = null;
        cleanTaskStopResultInfo = this.handleBatchOperationResult(resultMap, taskId);
        TaskUnicomEntity taskEntity = this.taskUnicomService.getTaskUnicomById(taskId);
        if (null == taskEntity) {
            return;
        }
        if ("0".equals(cleanTaskStopResultInfo.getStopStatus())) {
            taskEntity.setStatus("2");
        } else if ("1".equals(cleanTaskStopResultInfo.getStopStatus())) {
            taskEntity.setStatus("3");
        } else {
            taskEntity.setStatus("4");
        }
        this.taskUnicomService.saveTaskUnicom(taskEntity);
        this.logger.info((Object)"RestCleanTaskStopThread  update to TaskUnicomEntity success!");
        String json = null;
        try {
            json = JSONUtil.getInstance().toJSON((Object)cleanTaskStopResultInfo);
            UnicomConfigInfoForm unicomConfigInfoForm = AticUtil.queryUnicomConfig(this.unicomConfigService);
            this.cleanTaskStopUrl = unicomConfigInfoForm.getCleanTaskStopUri();
            this.alias = unicomConfigInfoForm.getCertAlias();
            this.restfulCleanService.restCleanTaskStopResult(json, this.cleanTaskStopUrl, this.alias);
        }
        catch (RuntimeException e) {
            this.logger.error((Object)("RestCleanTaskStopThread occur exception when Calling unicom interface :" + e.getMessage()));
        }
    }

    private void moveDeployZoneIp(RestCleanStopTaskInfo stopTaskInfo, Map<String, BatchOperationResult> resultMap) {
        this.logger.info((Object)"RestCleanTaskStopThread begin to get divertTacticsForm by deviceId,zoneId,protectIp!");
        TaskUnicomEntity taskEntity = null;
        String taskId = stopTaskInfo.getTaskId();
        taskEntity = this.taskUnicomService.getTaskUnicomById(taskId);
        if (taskEntity == null) {
            return;
        }
        String protectDetailInfosJson = "{\"protect_detail\":" + taskEntity.getProtectDetail() + "}";
        RestCleanStartInfo startInfos = (RestCleanStartInfo)JSONUtil.getInstance().fromJSON(protectDetailInfosJson, RestCleanStartInfo.class);
        List<Object> protectDetailInfos = new ArrayList();
        if (startInfos != null) {
            protectDetailInfos = startInfos.getProtectDetail();
        }
        String protectIpstr = taskEntity.getProtectIps();
        protectIpstr = protectIpstr.substring(1, protectIpstr.lastIndexOf("]"));
        List<String> protectIpList01 = Arrays.asList(protectIpstr.split(","));
        String destZoneName = "";
        Long zoneId = null;
        List<String> deviceIps = new ArrayList<String>();
        Iterator<Object> iterator = protectDetailInfos.iterator();
        if (iterator.hasNext()) {
            RestCleanStartProtectDetailInfo reStartProtectDetailInfo = (RestCleanStartProtectDetailInfo)iterator.next();
            destZoneName = reStartProtectDetailInfo.getStrategyName();
            ZoneInfoForm zoneInfoForm = this.zoneService.getZoneByName(destZoneName);
            zoneId = zoneInfoForm == null ? Long.valueOf(0L) : zoneInfoForm.getZoneId();
            deviceIps = reStartProtectDetailInfo.getDeviceIPs();
        }
        if (null == zoneId) {
            return;
        }
        Map<CommandPair, DeployResult> commandDeployResult = this.deleteZoneIpAndDeployZoneIp(taskId, destZoneName, zoneId, deviceIps, protectIpList01, resultMap);
        try {
            this.updateZoneStatusTools.deleteZoneIp(commandDeployResult, protectIpList01, zoneId);
            this.updateZoneStatusTools.saveDeployStatus(commandDeployResult);
        }
        catch (RuntimeException e) {
            this.logger.error((Object)("saveDeployStatus error!" + e.getMessage()));
        }
        this.logger.info((Object)"RestCleanTaskStopThread end!");
    }

    private Map<CommandPair, DeployResult> deleteZoneIpAndDeployZoneIp(String taskId, String destZoneName, Long zoneId, List<String> deviceIPs, List<String> protectIPs, Map<String, BatchOperationResult> resultMap) {
        ConcurrentHashMap<CommandPair, DeployResult> moveIpDeployResult = new ConcurrentHashMap<CommandPair, DeployResult>();
        HashMap<CommandPair, DeployResult> commandDeployResult = new HashMap<CommandPair, DeployResult>();
        int totalCount = 0;
        HashSet<String> totalThreadName = new HashSet<String>();
        List destZoneDevicelist = this.zoneDeviceService.queryZoneDeviceFormsByZoneID(zoneId);
        if (null != destZoneDevicelist && !destZoneDevicelist.isEmpty()) {
            for (ZoneDeviceForm deviceForm : destZoneDevicelist) {
                AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(deviceForm.getDeviceId().longValue());
                String devIp = aticDevice.getIpAddress();
                for (String protectIp : protectIPs) {
                    String[] zoneIps = protectIp.split("/");
                    String zoneIp = zoneIps[0].trim();
                    String mask = zoneIps[1].trim();
                    boolean isIpv4 = IPUtil.isIpv4((String)zoneIp);
                    ZoneIpForm zoneIptemp = new ZoneIpForm();
                    zoneIptemp.setZoneId(zoneId);
                    zoneIptemp.setZoneIp(zoneIp);
                    zoneIptemp.setMask(Integer.valueOf(Integer.parseInt(mask)));
                    String[] rangeIps = IPUtil.getSubnetRange((String)zoneIp, (int)Integer.parseInt(mask));
                    zoneIptemp.setStartIp(rangeIps[0]);
                    zoneIptemp.setEndIp(rangeIps[1]);
                    List zoneIpInfos = this.zoneIpDao.findIpbyStartIpAndEndIpAndZoneId(zoneIptemp.getZoneId(), zoneIptemp.getStartIp(), zoneIptemp.getEndIp());
                    if (null != zoneIpInfos && !zoneIpInfos.isEmpty()) {
                        for (ZoneIpInfo zoneIpInfo : zoneIpInfos) {
                            if (!zoneIpInfo.getZoneIp().equals(zoneIptemp.getZoneIp())) continue;
                            zoneIptemp.setId(zoneIpInfo.getId());
                        }
                    }
                    if (null != zoneIptemp.getId()) {
                        ++totalCount;
                    }
                    MoveZoneIpData moveIpData = new MoveZoneIpData();
                    moveIpData.setDeviceId(deviceForm.getDeviceId());
                    moveIpData.setDestZoneName(destZoneName);
                    moveIpData.setZoneIptemp(zoneIptemp);
                    moveIpData.setIpv4(isIpv4);
                    moveIpData.setTaskId(taskId);
                    moveIpData.setResultMap(resultMap);
                    moveIpData.setCommandDeployResult(moveIpDeployResult);
                    this.logger.info((Object)("addUndoZoneIpData: " + devIp + "; zoneIp:" + zoneIp));
                    MoveZoneIpStopThread stopThread = MoveZoneIpThreadPool.getStop(devIp + ":" + taskId);
                    if (null == stopThread) {
                        MoveZoneIpStopThread moveIpStopThread = new MoveZoneIpStopThread(deviceForm, devIp + ":" + taskId, this.aticDeviceService, this.operateTaskService);
                        moveIpStopThread.start();
                        MoveZoneIpThreadPool.putStop(devIp + ":" + taskId, moveIpStopThread);
                    }
                    MoveZoneIpThreadPool.getStop(devIp + ":" + taskId).addUndoZoneIpData(moveIpData);
                    totalThreadName.add(aticDevice.getIpAddress() + ":" + taskId);
                }
            }
        }
        this.logger.info((Object)("deploy undo ip totalCount is " + totalCount));
        int count = 0;
        do {
            Iterator iterator = moveIpDeployResult.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry rs = iterator.next();
                commandDeployResult.put((CommandPair)rs.getKey(), (DeployResult)rs.getValue());
                this.logger.info((Object)("finish moveIPtask:" + ++count + ":" + totalCount));
                iterator.remove();
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                this.logger.info((Object)("sleep with error:" + count));
            }
            if (this.checkAllThreadStatus(totalThreadName).booleanValue()) continue;
            this.logger.error((Object)"All thread is finish,but some task without excute");
            break;
        } while (count < totalCount);
        for (String threadName : totalThreadName) {
            this.logger.info((Object)("finish thread Name:" + threadName));
            MoveZoneIpThreadPool.removeStop(threadName);
        }
        return commandDeployResult;
    }

    private Boolean checkAllThreadStatus(Set<String> totalThreadName) {
        for (String threadName : totalThreadName) {
            if (MoveZoneIpThreadPool.getStop(threadName) == null) continue;
            return true;
        }
        return false;
    }

    private RestCleanTaskStopResultInfo handleBatchOperationResult(Map<String, BatchOperationResult> resultMap, String taskId) {
        this.logger.info((Object)"RestCleanTaskStopThread  begin convert  to RestCleanTaskstopResultInfo!");
        RestCleanTaskStopResultInfo cleanResult = new RestCleanTaskStopResultInfo();
        ArrayList<RestCleanEqStatus> restCleanEqStatus = new ArrayList<RestCleanEqStatus>();
        cleanResult.setCommand(CLEANTASKSTOP);
        cleanResult.setTaskId(taskId);
        String status = "0";
        BatchOperationResult bor = null;
        int totalCount = 0;
        int failCount = 0;
        for (Map.Entry<String, BatchOperationResult> entry : resultMap.entrySet()) {
            RestCleanEqStatus cleanEqStatus = new RestCleanEqStatus();
            String deviceIp = entry.getKey();
            bor = resultMap.get(deviceIp);
            cleanEqStatus.setCleanEqIp(deviceIp);
            this.handleBatchOperation(bor, cleanEqStatus);
            restCleanEqStatus.add(cleanEqStatus);
            totalCount += bor.getTotalCount();
            failCount += bor.getFailCount();
        }
        if (totalCount != failCount && 0 != failCount) {
            status = "1";
            this.logger.info((Object)"RestCleanTaskStopThread, Partial divert task success!");
        }
        if (totalCount == failCount) {
            status = "2";
        }
        String startTime = new SimpleDateFormat(DATEFORMATE).format(new Date());
        this.logger.info((Object)("RestCleanTaskStopThread  get startTime:" + startTime));
        cleanResult.setStopTime(startTime);
        cleanResult.setStopStatus(status);
        if ("0".equals(status)) {
            cleanResult.setStopMsg("all success!");
        } else if ("1".equals(status)) {
            cleanResult.setStopMsg("part success!");
        } else {
            cleanResult.setStopMsg("all fail!");
        }
        cleanResult.setCleanEqStatus(restCleanEqStatus);
        this.logger.info((Object)"RestCleanTaskStopThread  end convert  to RestCleanTaskStopResultInfo!");
        return cleanResult;
    }

    private void handleBatchOperation(BatchOperationResult bor, RestCleanEqStatus cleanEqStatus) {
        int size;
        this.logger.info((Object)"RestCleanTaskStopThread  begin  convert BatchOperationResult into RestCleanTaskStopResultInfo!");
        List bo = null;
        StringBuffer temp = new StringBuffer();
        cleanEqStatus.setStatus("1");
        if (bor.getSucceedCount() > 0) {
            cleanEqStatus.setStatus("0");
        }
        if ((size = (bo = bor.getResult()).size()) > 0) {
            for (int i = 0; i < size; ++i) {
                temp.append(((BatchOperation)bo.get(i)).getOptDetail());
            }
            cleanEqStatus.setMsg(temp.toString());
        }
        this.logger.info((Object)"RestCleanTaskStopThread  end  convert BatchOperationResult into RestCleanTaskStopResultInfo!");
    }

    public RestfulCleanService getRestfulCleanService() {
        return this.restfulCleanService;
    }

    public void setRestfulCleanService(RestfulCleanService restfulCleanService) {
        this.restfulCleanService = restfulCleanService;
    }

    public CleanTaskBufferService getCleanTaskBufferService() {
        return this.cleanTaskBufferService;
    }

    public void setCleanTaskBufferService(CleanTaskBufferService cleanTaskBufferService) {
        this.cleanTaskBufferService = cleanTaskBufferService;
    }

    public IZoneService getZoneService() {
        return this.zoneService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public TaskUnicomService getTaskUnicomService() {
        return this.taskUnicomService;
    }

    public void setTaskUnicomService(TaskUnicomService taskUnicomService) {
        this.taskUnicomService = taskUnicomService;
    }

    public OperateTaskUnicomService getOperateTaskService() {
        return this.operateTaskService;
    }

    public void setOperateTaskService(OperateTaskUnicomService operateTaskService) {
        this.operateTaskService = operateTaskService;
    }

    public IZoneDeviceService getZoneDeviceService() {
        return this.zoneDeviceService;
    }

    public void setZoneDeviceService(IZoneDeviceService zoneDeviceService) {
        this.zoneDeviceService = zoneDeviceService;
    }

    public UpdateZoneStatusTools getUpdateZoneStatusTools() {
        return this.updateZoneStatusTools;
    }

    public void setUpdateZoneStatusTools(UpdateZoneStatusTools updateZoneStatusTools) {
        this.updateZoneStatusTools = updateZoneStatusTools;
    }

    public ZoneIpDao getZoneIpDao() {
        return this.zoneIpDao;
    }

    public void setZoneIpDao(ZoneIpDao zoneIpDao) {
        this.zoneIpDao = zoneIpDao;
    }

    public void setUnicomConfigStartup(UnicomConfigStartup unicomConfigStartup) {
        this.unicomConfigStartup = unicomConfigStartup;
    }

    public UnicomConfigStartup getUnicomConfigStartup() {
        return this.unicomConfigStartup;
    }

    private class subCleanTaskStopThread
    extends Thread {
        RestCleanStopTaskInfo cleanTask;

        subCleanTaskStopThread(RestCleanStopTaskInfo cleanTask) {
            super("CleanTaskStopThread" + cleanTask.getTaskId());
            this.cleanTask = null;
            this.cleanTask = cleanTask;
        }

        @Override
        public void run() {
            RestCleanTaskStopThread.this.cleanTaskStop(this.cleanTask);
        }
    }
}

