/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.unicom.restful.service.impl;

import com.hs.atic.bis.unicom.service.impl.UnicomConfigServiceImpl;
import com.hs.atic.sdk.bis.unicom.entity.RestCleanStartTaskInfo;
import com.hs.atic.sdk.bis.unicom.entity.RestCleanStopTaskInfo;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.sdk.unicom.restful.service.CleanTaskBufferService;
import com.hs.vsm.secservice.unicom.model.CleanTaskBuffer;
import com.hs.vsm.secservice.unicom.model.UnicomConfigInfoForm;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class CleanTaskBufferServiceImpl
implements CleanTaskBufferService {
    private CleanTaskBuffer cleanTaskBuffer;
    @Autowired
    @Qualifier(value="unicomConfigService")
    private UnicomConfigServiceImpl unicomConfigService;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_UNICOM_SOC);

    @Override
    public boolean offerCleanStartTask(RestCleanStartTaskInfo cleanStartTaskInfo) {
        return this.cleanTaskBuffer.getStartQueue().offer(cleanStartTaskInfo);
    }

    @Override
    public RestCleanStartTaskInfo takeCleanStartTask() {
        RestCleanStartTaskInfo startTask = null;
        try {
            startTask = this.cleanTaskBuffer.getStartQueue().take();
        }
        catch (InterruptedException e) {
            this.logger.error((Object)e.getMessage());
        }
        return startTask;
    }

    @Override
    public boolean offerCleanStopTask(RestCleanStopTaskInfo cleanStopTaskInfo) {
        return this.cleanTaskBuffer.getStopQueue().offer(cleanStopTaskInfo);
    }

    @Override
    public RestCleanStopTaskInfo takeCleanStopTask() {
        RestCleanStopTaskInfo stopTask = null;
        try {
            stopTask = this.cleanTaskBuffer.getStopQueue().take();
        }
        catch (InterruptedException e) {
            this.logger.error((Object)e.getMessage());
        }
        return stopTask;
    }

    public String getConfigMapValue(String key) {
        return null;
    }

    public boolean isUnicomOpen() {
        UnicomConfigInfoForm unicomConfigInfoForm = this.unicomConfigService.queryUnicomConfig();
        return unicomConfigInfoForm.isOpen();
    }

    public CleanTaskBuffer getCleanTaskBuffer() {
        return this.cleanTaskBuffer;
    }

    public void setCleanTaskBuffer(CleanTaskBuffer cleanTaskBuffer) {
        this.cleanTaskBuffer = cleanTaskBuffer;
    }
}

