/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.unicom.restful.service.impl;

import com.hs.atic.bis.unicom.dao.OperateTaskUnicomDao;
import com.hs.atic.rmi.unicom.AticCleanLogService;
import com.hs.atic.rmi.unicom.CleanLogEntity;
import com.hs.atic.sdk.bis.unicom.entity.CleanAlarmObject;
import com.hs.atic.sdk.bis.unicom.entity.CleanLogCommandObject;
import com.hs.atic.sdk.bis.unicom.entity.CleanLogObject;
import com.hs.atic.sdk.bis.unicom.entity.TaskOperateUnicomEntity;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.CrashThreadHandler;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.unicom.restful.service.RestfulUnicomService;
import com.hs.vsm.secservice.unicom.rmi.model.CleanLogBuffer;
import com.hs.vsm.secservice.unicom.util.UnicomUtil;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secservice.nfa.restful.model.Result;
import com.huawei.atic.util.AticInstallUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class InitUnicomServiceImpl
implements InitializingBean,
DisposableBean {
    private static final int UPLOAD_RETRY_TIME = 3;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_UNICOM_SOC);
    private int maxSize = 10000;
    private String upLoadCleanLogCommand = "cleanTaskLog";
    private long outTime = 5000L;
    private long pingTimes = 5L;
    private String splitStr = "|0|0||";
    private String alarmLevel = "|1";
    private String alarmStr = "|0|1|CLEAN_SYS| CLEAN_SYS |5200|";
    private int splitSize = 100;
    private long sleepTime = 1000L;
    private String unicomEnable = "true";
    private UnicomUtil unicomUtil;
    private CleanLogBuffer cleanLogBuffer;
    private AticCleanLogService aticReceiveCleanLog;
    private RestfulUnicomService restfulCleanService;
    private IAticDeviceService aticDeviceService;
    private OperateTaskUnicomDao operateTaskUnicomDao;
    private UploadCleanLogTread uploadCleanLogTread = null;
    private UploadCleanAlarmTread uploadCleanAlarmTread = null;
    private List<CleanLogEntity> bufferTemp = new CopyOnWriteArrayList<CleanLogEntity>();

    public void destroy() throws Exception {
        if (null != this.uploadCleanLogTread) {
            this.uploadCleanLogTread.stop();
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.getUnicomConfigData();
        if (this.unicomEnable.equals("true")) {
            this.uploadCleanLogTread = new UploadCleanLogTread();
            this.uploadCleanLogTread.setName("uploadCleanLogTread");
            this.uploadCleanLogTread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)CrashThreadHandler.getInstance());
            this.uploadCleanLogTread.start();
            this.uploadCleanAlarmTread = new UploadCleanAlarmTread();
            this.uploadCleanAlarmTread.setName("uploadCleanAlarmTread");
            this.uploadCleanAlarmTread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)CrashThreadHandler.getInstance());
            this.uploadCleanAlarmTread.start();
        } else {
            this.logger.info((Object)("unicomEnable value is" + this.unicomEnable + ",can not start UploadCleanLogTread"));
        }
    }

    public List<String> getCleanAlarm(List<AticDevice> cleanAlarms) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (AticDevice device : cleanAlarms) {
            boolean pingFlag = this.ping(device.getIpAddress(), this.pingTimes, this.outTime);
            if (pingFlag) {
                this.logger.info((Object)(device.getIpAddress() + "can ping success"));
                continue;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String alarmTime = dateFormat.format(new Date(System.currentTimeMillis()));
            String cleanAlarmString = device.getIpAddress() + this.splitStr + alarmTime + this.alarmLevel + this.alarmStr + "The device Ping is blocked";
            this.logger.info((Object)(device.getIpAddress() + "ping faild"));
            returnList.add(cleanAlarmString);
        }
        return returnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ping(String ipAddress, long pingTimes2, long outTime2) {
        BufferedReader in = null;
        Runtime r = Runtime.getRuntime();
        String pingCommand = null;
        if (!AticUtil.validateIpv4((String)ipAddress) && !IPUtil.isIpv6((String)ipAddress)) {
            return false;
        }
        int version = AticInstallUtil.getInstance().getAticInstallOS();
        pingCommand = 1 == version ? "ping " + ipAddress + " -c " + pingTimes2 : "ping " + ipAddress + " -n " + pingTimes2 + " -w " + outTime2;
        try {
            this.logger.info((Object)("ping cleanDevice:" + pingCommand));
            Process p = r.exec(pingCommand);
            in = new BufferedReader(new InputStreamReader(p.getInputStream(), "UTF-8"));
            int connectedCount = 0;
            String line = null;
            while ((line = in.readLine()) != null) {
                connectedCount += InitUnicomServiceImpl.getCheckResult(line);
            }
            boolean bl = (long)connectedCount == pingTimes2;
            return bl;
        }
        catch (IOException ex) {
            this.logger.error((Object)("IOException error: " + ex.getMessage()));
            boolean bl = false;
            return bl;
        }
        catch (RuntimeException ex) {
            this.logger.error((Object)("RuntimeException error: " + ex.getMessage()));
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                }
            }
            catch (IOException e) {
                this.logger.error((Object)e.getMessage());
            }
        }
    }

    private static int getCheckResult(String line) {
        Pattern pattern = Pattern.compile("(\\d+ms)(\\s+)(TTL=\\d+)", 2);
        Matcher matcher = pattern.matcher(line);
        Pattern patternLinux = Pattern.compile("(ttl=\\d+)(\\s+)(time=[\\d+\\.]+\\s*ms)", 2);
        Matcher matcherLinux = patternLinux.matcher(line);
        if (matcher.find() || matcherLinux.find()) {
            return 1;
        }
        return 0;
    }

    private void upLoad(List<CleanLogCommandObject> objects, int upLoadTime) {
        if (upLoadTime >= 3) {
            this.logger.error((Object)("upLoad error for 3 times. drop clean logs size=" + objects.size()));
            return;
        }
        int index = 0;
        Iterator<CleanLogCommandObject> iterator = objects.iterator();
        while (iterator.hasNext()) {
            ++index;
            CleanLogCommandObject obj = iterator.next();
            Result result = this.restfulCleanService.upLoadCleanLog(obj);
            if (null == result) {
                this.logger.warn((Object)"upLoadCleanLog action return null");
                return;
            }
            if (result.getStatusCode() == 200) {
                iterator.remove();
            }
            if (0 != index % this.splitSize) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                this.logger.error((Object)("UploadCleanLogTread sleep error!" + e.getMessage()));
            }
        }
        if (!objects.isEmpty()) {
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                this.logger.error((Object)("UploadCleanLogTread sleep error! " + e.getMessage()));
            }
            this.upLoad(objects, ++upLoadTime);
        }
    }

    private List<CleanLogCommandObject> createCleanLogObject(List<CleanLogEntity> cleanLogList) {
        ArrayList<CleanLogCommandObject> tempCleanLogList = new ArrayList<CleanLogCommandObject>();
        HashMap taskMap = new HashMap();
        List<TaskOperateUnicomEntity> taskList = this.operateTaskUnicomDao.getAllStartingTaskList();
        if (taskList.isEmpty()) {
            this.logger.error((Object)"getAllStartingTaskList return empty, not create clean log");
            return tempCleanLogList;
        }
        for (CleanLogEntity entity : cleanLogList) {
            String cleanEqIp;
            String protectIp = entity.getProtectIp();
            String taskId = this.getStartingTaskId(protectIp, cleanEqIp = entity.getCleanDeviceIp(), taskList);
            if (null == taskId || taskId.isEmpty()) {
                this.logger.error((Object)("getStartingTaskId return null,do not send clean log ,protectIp=" + protectIp + ", cleanEqIp=" + cleanEqIp));
                continue;
            }
            this.logger.info((Object)("taskId from db is:" + taskId));
            this.logger.info((Object)("start to createCleanLog by entity:" + entity.toString()));
            CleanLogObject logObject = this.unicomUtil.createCleanLog(entity);
            this.logger.info((Object)("end to createCleanLog by entity:" + logObject.toString()));
            ArrayList<CleanLogObject> objectList = new ArrayList<CleanLogObject>();
            logObject.setTaskId(taskId);
            objectList.add(logObject);
            if (null != taskMap.get(taskId)) {
                ((List)taskMap.get(taskId)).add(logObject);
                continue;
            }
            taskMap.put(taskId, objectList);
        }
        if (taskMap.size() <= 0) {
            this.logger.info((Object)"Map<String, List<CleanLogObject>> taskMap is null");
            return tempCleanLogList;
        }
        CleanLogCommandObject object = null;
        for (Map.Entry entry : taskMap.entrySet()) {
            List logList = (List)entry.getValue();
            int logSize = logList.size();
            int onceNum = 100;
            for (int i = 0; i <= logSize / onceNum; ++i) {
                object = new CleanLogCommandObject();
                object.setCommand(this.upLoadCleanLogCommand);
                int startIndex = i * onceNum;
                int lastIndex = startIndex + onceNum < logSize ? startIndex + onceNum : logSize;
                object.setLogs(logList.subList(startIndex, lastIndex));
                tempCleanLogList.add(object);
            }
        }
        return tempCleanLogList;
    }

    private String getStartingTaskId(String protectIp, String cleanEqIp, List<TaskOperateUnicomEntity> taskList) {
        this.logger.info((Object)("taskList size :" + taskList.size()));
        for (TaskOperateUnicomEntity task : taskList) {
            String protectIpRange = task.getProtectIp();
            String[] ipmask = protectIpRange.split("/");
            if (ipmask.length != 2 || !cleanEqIp.equals(task.getCleanEq())) continue;
            Object[] ipRanges = IPUtil.getSubnetRange((String)ipmask[0], (int)Integer.parseInt(ipmask[1]));
            try {
                if (!IPUtil.isInIpRange((String[])ipRanges, (String)protectIp)) continue;
                return task.getTaskId();
            }
            catch (IllegalArgumentException e) {
                this.logger.info((Object)("ip invalid,ipRanges is :" + Arrays.toString(ipRanges) + ";protectIp is :" + protectIp));
            }
        }
        return null;
    }

    public void getUnicomConfigData() {
    }

    public AticCleanLogService getAticReceiveCleanLog() {
        return this.aticReceiveCleanLog;
    }

    public void setAticReceiveCleanLog(AticCleanLogService aticReceiveCleanLog) {
        this.aticReceiveCleanLog = aticReceiveCleanLog;
    }

    public RestfulUnicomService getRestfulCleanService() {
        return this.restfulCleanService;
    }

    public void setRestfulCleanService(RestfulUnicomService restfulCleanService) {
        this.restfulCleanService = restfulCleanService;
    }

    public CleanLogBuffer getCleanLogBuffer() {
        return this.cleanLogBuffer;
    }

    public void setCleanLogBuffer(CleanLogBuffer cleanLogBuffer) {
        this.cleanLogBuffer = cleanLogBuffer;
    }

    public OperateTaskUnicomDao getOperateTaskUnicomDao() {
        return this.operateTaskUnicomDao;
    }

    public void setOperateTaskUnicomDao(OperateTaskUnicomDao operateTaskUnicomDao) {
        this.operateTaskUnicomDao = operateTaskUnicomDao;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public UnicomUtil getUnicomUtil() {
        return this.unicomUtil;
    }

    public void setUnicomUtil(UnicomUtil unicomUtil) {
        this.unicomUtil = unicomUtil;
    }

    private class UploadCleanLogTread
    extends Thread {
        private UploadCleanLogTread() {
        }

        @Override
        public void run() {
            InitUnicomServiceImpl.this.logger.info((Object)"start to execute UploadCleanLogTread");
            while (true) {
                try {
                    Thread.sleep(InitUnicomServiceImpl.this.sleepTime);
                }
                catch (InterruptedException e) {
                    InitUnicomServiceImpl.this.logger.error((Object)("UploadCleanLogTread sleep error! " + e.getMessage()));
                }
                try {
                    int uploadQueueSize = InitUnicomServiceImpl.this.cleanLogBuffer.getUploadQueue().size();
                    if (uploadQueueSize <= 0) continue;
                    InitUnicomServiceImpl.this.logger.info((Object)("received cleanLogBuffer,and UploadQueue() size is:" + uploadQueueSize));
                    for (int i = 0; i < uploadQueueSize; ++i) {
                        InitUnicomServiceImpl.this.bufferTemp.addAll((Collection)InitUnicomServiceImpl.this.cleanLogBuffer.getUploadQueue().poll(500L, TimeUnit.MILLISECONDS));
                    }
                    InitUnicomServiceImpl.this.logger.info((Object)("received cleanLogBuffer,and cleanLogList.size from collector is:" + InitUnicomServiceImpl.this.bufferTemp.size()));
                    List cleanLogListTemp = InitUnicomServiceImpl.this.createCleanLogObject(InitUnicomServiceImpl.this.bufferTemp);
                    InitUnicomServiceImpl.this.bufferTemp.clear();
                    if (cleanLogListTemp.isEmpty()) {
                        InitUnicomServiceImpl.this.logger.info((Object)"after createCleanLog,The cleanLogListTemp is null");
                        continue;
                    }
                    InitUnicomServiceImpl.this.logger.info((Object)("after createCleanLog,The cleanLogListTemp.size() is:" + cleanLogListTemp.size()));
                    if (cleanLogListTemp.size() < InitUnicomServiceImpl.this.maxSize) {
                        InitUnicomServiceImpl.this.upLoad(cleanLogListTemp, 0);
                        continue;
                    }
                    InitUnicomServiceImpl.this.upLoad(cleanLogListTemp.subList(cleanLogListTemp.size() - InitUnicomServiceImpl.this.maxSize, cleanLogListTemp.size()), 0);
                    continue;
                }
                catch (RuntimeException e) {
                    InitUnicomServiceImpl.this.logger.error((Object)"execute UploadCleanLogTread run function error.");
                    continue;
                }
                catch (InterruptedException e) {
                    InitUnicomServiceImpl.this.logger.error((Object)"execute UploadCleanLogTread run function error.");
                    continue;
                }
                break;
            }
        }
    }

    private class UploadCleanAlarmTread
    extends Thread {
        private UploadCleanAlarmTread() {
        }

        @Override
        public void run() {
            InitUnicomServiceImpl.this.logger.info((Object)"start to execute UploadCleanAlarmTread");
            while (true) {
                try {
                    Thread.sleep(InitUnicomServiceImpl.this.sleepTime);
                }
                catch (InterruptedException e) {
                    InitUnicomServiceImpl.this.logger.error((Object)("sleep UploadCleanAlarmTread error: " + e.getMessage()));
                }
                try {
                    InitUnicomServiceImpl.this.logger.info((Object)"UploadCleanAlarmTread start to do ...");
                    List cleanDevices = InitUnicomServiceImpl.this.aticDeviceService.getCleanDevice();
                    List<String> unicomAlarms = InitUnicomServiceImpl.this.getCleanAlarm(cleanDevices);
                    InitUnicomServiceImpl.this.logger.info((Object)("The current CleanAlarmList is:" + unicomAlarms));
                    if (null != unicomAlarms && unicomAlarms.size() != 0) {
                        CleanAlarmObject cleanAlarmObject = new CleanAlarmObject("warnDatas", unicomAlarms);
                        InitUnicomServiceImpl.this.logger.info((Object)("The current CleanAlarmObject is:" + cleanAlarmObject.toString()));
                        Result result = InitUnicomServiceImpl.this.restfulCleanService.upLoadAlarm(cleanAlarmObject);
                        if (null == result) {
                            InitUnicomServiceImpl.this.logger.warn((Object)"upLoadAlarm action result null");
                            continue;
                        }
                    }
                }
                catch (RuntimeException e) {
                    InitUnicomServiceImpl.this.logger.error((Object)"execute UploadCleanAlarmTread error.");
                }
                InitUnicomServiceImpl.this.logger.info((Object)"UploadCleanAlarmTread end");
            }
        }
    }
}

