/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.unicom.restful.service.impl;

import com.hs.atic.bis.unicom.service.impl.UnicomConfigServiceImpl;
import com.hs.atic.sdk.bis.unicom.entity.CleanAlarmObject;
import com.hs.atic.sdk.bis.unicom.entity.CleanLogCommandObject;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.nfa.util.JSONUtil;
import com.hs.vsm.secservice.unicom.model.UnicomConfigInfoForm;
import com.hs.vsm.secservice.unicom.restful.service.RestfulUnicomService;
import com.hs.vsm.secservice.unicom.rmi.model.CleanLogBuffer;
import com.hs.vsm.secservice.unicom.util.UnicomHttpsClient;
import com.huawei.atic.secservice.nfa.restful.model.Result;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class RestfulUnicomServiceImpl
implements RestfulUnicomService {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_UNICOM_SOC);
    private UnicomHttpsClient httpsClient = UnicomHttpsClient.getInstance();
    private CleanLogBuffer cleanLogBuffer;
    @Autowired
    @Qualifier(value="unicomConfigService")
    private UnicomConfigServiceImpl unicomConfigService;

    @Override
    public Result upLoadCleanLog(CleanLogCommandObject object) {
        Result result = null;
        try {
            UnicomConfigInfoForm unicomConfigInfoForm = this.unicomConfigService.queryUnicomConfig();
            if (null == unicomConfigInfoForm.getCleanlog()) {
                this.logger.warn((Object)"can not find unicomCleanLogUri from unicom.properties");
                return null;
            }
            String json = JSONUtil.getInstance().toJSON((Object)object);
            result = this.httpsClient.doHttpsPost(json, unicomConfigInfoForm.getCleanlog(), unicomConfigInfoForm.getCertAlias());
        }
        catch (IOException e) {
            result = new Result();
            result.setJson(e.getMessage());
            this.logger.error((Object)"upLoadCleanLog method is exception.");
        }
        return result;
    }

    @Override
    public Result upLoadAlarm(CleanAlarmObject object) {
        Result result = null;
        try {
            UnicomConfigInfoForm unicomConfigInfoForm = this.unicomConfigService.queryUnicomConfig();
            if (null == unicomConfigInfoForm.getCleanlog()) {
                this.logger.warn((Object)"can not find unicomCleanAlarmUri from unicom.properties");
                return null;
            }
            String json = JSONUtil.getInstance().toJSON((Object)object);
            result = this.httpsClient.doHttpsPost(json, unicomConfigInfoForm.getCleanAlarm(), unicomConfigInfoForm.getCertAlias());
        }
        catch (IOException e) {
            result = new Result();
            result.setJson(e.getMessage());
            this.logger.error((Object)"upLoadAlarm method is exception.");
        }
        return result;
    }

    public CleanLogBuffer getCleanLogBuffer() {
        return this.cleanLogBuffer;
    }

    public void setCleanLogBuffer(CleanLogBuffer cleanLogBuffer) {
        this.cleanLogBuffer = cleanLogBuffer;
    }
}

