/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.unicom.util;

import com.hs.atic.bis.unicom.service.impl.UnicomConfigServiceImpl;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.unicom.model.UnicomConfigInfoForm;
import com.hs.vsm.secservice.unicom.util.AticUtil;
import com.huawei.atic.util.AticInstallUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class UnicomConfigStartup
implements InitializingBean {
    private Log log = LogFactory.getInstance((Module)Module.ATIC_UNICOM_SOC);
    private final String unicomPath = File.separator + "vsm_conf" + File.separator + "antiddos" + File.separator + "unicom" + File.separator + "unicom.xml";
    @Autowired
    @Qualifier(value="unicomConfigService")
    private UnicomConfigServiceImpl unicomConfigService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUnicomConfig() {
        UnicomConfigInfoForm unicomConfigInfoFormOrignal = AticUtil.queryUnicomConfig(this.unicomConfigService);
        String pathName = AticInstallUtil.getInstance().getAticInstallPath() + this.unicomPath;
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(pathName);
            properties.loadFromXML(fileInputStream);
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)"FileNotFoundException saveUnicomConfig");
        }
        catch (InvalidPropertiesFormatException e) {
            this.log.error((Object)"InvalidPropertiesFormatException saveUnicomConfig");
        }
        catch (IOException e) {
            this.log.error((Object)"IOException saveUnicomConfig");
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                this.log.error((Object)"load close file failed");
            }
        }
        String isOpen = properties.getProperty("atic.unicom.isOpen");
        String cleanTaskStartUri = properties.getProperty("unicom.uri.cleanTaskStartUri");
        String cleanTaskStopUri = properties.getProperty("unicom.uri.cleanTaskStopUri");
        String cleanlog = properties.getProperty("unicom.uri.cleanlog");
        String cleanAlarm = properties.getProperty("unicom.uri.cleanAlarm");
        UnicomConfigInfoForm unicomConfigInfoForm = new UnicomConfigInfoForm();
        unicomConfigInfoForm.setOpen(null != isOpen && (isOpen.trim().equals("true") || isOpen.trim().equals("false")) ? Boolean.parseBoolean(isOpen) : false);
        unicomConfigInfoForm.setCleanlog(cleanlog);
        unicomConfigInfoForm.setCleanAlarm(cleanAlarm);
        unicomConfigInfoForm.setCleanTaskStartUri(cleanTaskStartUri);
        unicomConfigInfoForm.setCleanTaskStopUri(cleanTaskStopUri);
        if (unicomConfigInfoFormOrignal.getPkid() == 0L) {
            this.unicomConfigService.saveUnicomConfig(unicomConfigInfoForm);
        } else {
            unicomConfigInfoFormOrignal.setOpen(unicomConfigInfoForm.isOpen());
            this.unicomConfigService.saveUnicomConfig(unicomConfigInfoFormOrignal);
        }
        this.log.info((Object)"init unicomConfigInfoForm form xml to DB is finish");
    }

    public void afterPropertiesSet() throws Exception {
        this.log.info((Object)"############ saveUnicomConfig ");
        try {
            this.saveUnicomConfig();
        }
        catch (RuntimeException e) {
            this.log.error((Object)"RuntimeException saveUnicomConfig");
        }
    }
}

