/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.unicom.util;

import com.hs.atic.util.AticConstants;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.secne.sdk.common.StringUtils;
import com.huawei.atic.secservice.nfa.restful.model.Result;
import com.huawei.atic.secservice.nfa.restful.util.MyX509TrustManager;
import com.restful.util.HttpsConnection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;

public final class UnicomHttpsClient {
    private static final UnicomHttpsClient INSTANCE = new UnicomHttpsClient();
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_UNICOM_SOC);

    private UnicomHttpsClient() {
    }

    public static UnicomHttpsClient getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Result doHttpsPost(String objectJson, String uri, String alias) throws IOException {
        Result result;
        block20: {
            this.logger.info((Object)("doHttpsPost is start.objectJson is:" + objectJson + ",and uri is:" + uri));
            result = new Result();
            SSLConnectionSocketFactory socketFactory = null;
            try {
                socketFactory = this.enableSSL(alias, uri);
            }
            catch (Exception e) {
                result.setJson("certificate is error");
                return result;
            }
            RequestConfig defaultRequestConfig = RequestConfig.custom().setCookieSpec("standard-strict").setExpectContinueEnabled(true).setTargetPreferredAuthSchemes(Arrays.asList("NTLM", "Digest")).setProxyPreferredAuthSchemes(Arrays.asList("Basic")).build();
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)socketFactory).build();
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(defaultRequestConfig).build();
            InputStream inputStream = null;
            InputStreamReader inputStreamReader = null;
            BufferedReader reader = null;
            try {
                HttpPost post = new HttpPost(uri);
                StringEntity entity = new StringEntity(objectJson);
                entity.setContentEncoding("utf-8");
                entity.setContentType("application/json");
                ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                nvps.add(new BasicNameValuePair("Content", objectJson));
                UrlEncodedFormEntity entity11 = new UrlEncodedFormEntity(nvps, "UTF-8");
                post.setEntity((HttpEntity)entity11);
                post.getParams().setParameter("Content", (Object)entity);
                CloseableHttpResponse response = null;
                try {
                    response = httpClient.execute((HttpUriRequest)post);
                }
                catch (SSLException e) {
                    this.logger.error((Object)("UnicomHttpsClient doHttpsPost SSLException e" + e.getMessage()));
                    result.setJson("certificate is error");
                    Result result2 = result;
                    this.closeReader(reader);
                    this.closeInputStreamAndInputStreamReader(inputStream, inputStreamReader);
                    this.closeHttpClient(httpClient);
                    return result2;
                }
                catch (IOException e) {
                    if (null != e.getMessage()) {
                        if (e.getMessage().contains("certificate is illegal")) {
                            result.setJson("certificate is illegal");
                        } else if (e.getMessage().contains("Connection timed out")) {
                            result.setJson("Connection timed out");
                        }
                    }
                    if (StringUtils.isEmpty((String)result.getJson())) {
                        result.setJson("certificate is error");
                    }
                    this.logger.error((Object)"doHttpsPost is over,and send data error.");
                    Result result3 = result;
                    this.closeReader(reader);
                    this.closeInputStreamAndInputStreamReader(inputStream, inputStreamReader);
                    this.closeHttpClient(httpClient);
                    return result3;
                }
                if (response != null) {
                    int httpCode = response.getStatusLine().getStatusCode();
                    result.setStatusCode(httpCode);
                    if (httpCode == 200) {
                        HttpEntity entity2 = response.getEntity();
                        inputStream = entity2.getContent();
                        inputStreamReader = new InputStreamReader(inputStream, "utf-8");
                        reader = new BufferedReader(inputStreamReader);
                        StringBuffer stringBuffer = new StringBuffer();
                        char[] cbuf = new char[2048];
                        while (reader.read(cbuf) > 0) {
                            stringBuffer.append(String.valueOf(cbuf));
                            if (stringBuffer.length() < 10000) continue;
                        }
                        if (stringBuffer.length() >= 10000) {
                            result.setJson("");
                        } else {
                            result.setJson(stringBuffer.toString().trim());
                        }
                    }
                    this.logger.info((Object)("doHttpsPost is over, result = " + result + ";json =" + objectJson));
                }
                break block20;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.closeReader(reader);
                this.closeInputStreamAndInputStreamReader(inputStream, inputStreamReader);
                this.closeHttpClient(httpClient);
            }
        }
        this.logger.info((Object)("doHttpsPost is end:objectJson is:" + objectJson + ",and uri is:" + uri + " and result is:" + result));
        return result;
    }

    private void closeHttpClient(CloseableHttpClient httpClient) {
        try {
            if (null != httpClient) {
                httpClient.close();
            }
        }
        catch (IOException e) {
            this.logger.error((Object)("closeHttpClient is failed, result = " + e.getMessage()));
        }
        finally {
            httpClient = null;
        }
    }

    private void closeReader(BufferedReader reader) {
        try {
            if (null != reader) {
                reader.close();
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"closeReader reader close failed.");
        }
        finally {
            reader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInputStreamAndInputStreamReader(InputStream inputStream, InputStreamReader inputStreamReader) {
        try {
            if (null != inputStreamReader) {
                inputStreamReader.close();
            }
            if (null != inputStream) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"close inputStreamReader or inputStream failed!");
        }
        finally {
            inputStreamReader = null;
            inputStream = null;
        }
    }

    private SSLConnectionSocketFactory enableSSL(String alias, String uri) {
        try {
            MyX509TrustManager tm = new MyX509TrustManager(alias);
            SSLContext context = SSLContext.getInstance("TLSv1.2");
            context.init(null, new TrustManager[]{tm}, new SecureRandom());
            return new SSLConnectionSocketFactory(context, new String[]{"TLSv1.2"}, AticConstants.getHttpSslSupportCiphersuites(), (HostnameVerifier)new HttpsConnection.HttpsConnectionHostnameVerifier(uri));
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error((Object)"enableSSL get context error,algorithm exception");
        }
        catch (KeyManagementException e) {
            this.logger.error((Object)"enableSSL is error for key management exception");
        }
        return null;
    }
}

