/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.unicom.util;

import com.hs.atic.rmi.unicom.CleanLogEntity;
import com.hs.atic.sdk.bis.unicom.entity.AttackSrcipTop;
import com.hs.atic.sdk.bis.unicom.entity.AttackTypes;
import com.hs.atic.sdk.bis.unicom.entity.CleanLogObject;
import com.hs.lego.cbb.i18n.sdk.I18nMrg;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;

public class UnicomUtil {
    private I18nMrg i18nMgr;

    public UnicomUtil() {
    }

    public UnicomUtil(I18nMrg i18nMgr) {
        this.i18nMgr = i18nMgr;
    }

    private Locale getOSLanguage() {
        Locale locale = null;
        String language = System.getProperty("user.language");
        locale = "zh".equalsIgnoreCase(language) ? new Locale("zh", "CN") : new Locale("en");
        return locale;
    }

    public CleanLogObject createCleanLog(CleanLogEntity entity) {
        Locale locale = this.getOSLanguage();
        ArrayList<AttackSrcipTop> attackSrcipTopList = new ArrayList<AttackSrcipTop>();
        ArrayList<AttackTypes> attackTypesList = new ArrayList<AttackTypes>();
        if (entity.getAttackSrcIpTop().size() > 0) {
            for (Map.Entry<String, Long> entry : entity.getAttackSrcIpTop().entrySet()) {
                AttackSrcipTop attackSrcipTop = new AttackSrcipTop(entry.getKey(), entry.getValue());
                attackSrcipTopList.add(attackSrcipTop);
            }
        }
        if (entity.getAttackTypes().size() > 0) {
            for (Map.Entry<Object, Long> entry : entity.getAttackTypes().entrySet()) {
                Integer iAttackType = (Integer)entry.getKey();
                if (iAttackType > 2000 && iAttackType < 80000) {
                    iAttackType = 2000;
                }
                if (iAttackType > 80000) {
                    iAttackType = 80000;
                }
                String attackType = this.i18nMgr.getString("atic.attack.type." + String.valueOf(iAttackType), locale);
                AttackTypes attackTypes = new AttackTypes(attackType, entry.getValue());
                attackTypesList.add(attackTypes);
            }
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String string = format.format(entity.getStatTime());
        return new CleanLogObject(entity.getCleanDeviceIp(), entity.getTaskId(), entity.getProtectIp(), string, entity.getStatDuration(), entity.getInFlow() * 1000L, entity.getOutFlow() * 1000L, attackTypesList, attackSrcipTopList);
    }

    public I18nMrg getI18nMgr() {
        return this.i18nMgr;
    }

    public void setI18nMgr(I18nMrg i18nMgr) {
        this.i18nMgr = i18nMgr;
    }
}

