/*
 * Decompiled with CFR 0.152.
 */
package com.unicom.restful.service.impl;

import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.service.IUserMgr;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.sdk.perfmonitor.model.CpuMemUsage;
import com.huawei.atic.sdk.perfmonitor.service.ICpuMemUsageService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.restful.util.JSONUtil;
import com.restful.util.RestAuthUtil;
import com.restful.util.RestUtil;
import com.unicom.restful.model.CommandInfo;
import com.unicom.restful.model.ResourceInfo;
import com.unicom.restful.service.RestfulCleanEqStatsService;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.struts2.ServletActionContext;

@Path(value="unicom/cleanEqStats")
@Produces(value={"application/json"})
public class RestfulCleanEqStatsServiceImpl
implements RestfulCleanEqStatsService {
    private static final double ABILITY_RATIO = 20.0;
    private static final double ONE_HUNDERD = 100.0;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_UNICOM_SOC);

    @Override
    @POST
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response queryCleanEqStats(@FormParam(value="Content") String command) {
        Response.ResponseBuilder responseBuilder = Response.ok();
        HttpServletRequest request = ServletActionContext.getRequest();
        String requestMsg = "queryCleanEqStats by command. restful request is null.";
        CommandInfo commandInfo = null;
        int responseCode = 500;
        String responseMsg = "";
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"unicom/cleanEqStats");
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            responseMsg = "illegal token.";
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)"illegal token.");
            return responseBuilder.entity((Object)responseMsg).build();
        }
        try {
            commandInfo = (CommandInfo)JSONUtil.getInstance().fromJSON(command, CommandInfo.class);
        }
        catch (IOException e1) {
            responseMsg = "json format error";
            responseCode = 400;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"convert the format from java to pojo bean failed.", (Exception)e1);
            Response.ResponseBuilder builder = Response.status((int)responseCode);
            builder.entity((Object)responseMsg);
            return builder.build();
        }
        if (!"cleanEqStats".equals(commandInfo.getCommand())) {
            responseCode = 400;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal parameter.");
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)"illegal parameter.");
            return responseBuilder.build();
        }
        ArrayList<ResourceInfo> cleanEqs = new ArrayList<ResourceInfo>();
        IAticDeviceService aticDeviceService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
        IUserMgr userMgr = ZoneReferUtil.getUserMgr();
        long userId = userMgr.getUserInfoByName(userName).getId();
        List anticDevices = aticDeviceService.getCleanDevice(userId);
        Calendar currentTime = Calendar.getInstance();
        long endMillis = currentTime.getTime().getTime();
        long startMillis = endMillis - 300000L;
        this.logger.info((Object)("startMillis = " + startMillis + "; endMillis = " + endMillis));
        Map<Long, Integer> cpuMemUageMap = this.getCpuMemUsageByTime(anticDevices, startMillis, endMillis);
        for (AticDevice aticDevice : anticDevices) {
            ResourceInfo cleanEq = new ResourceInfo();
            cleanEq.setCleanEqIp(aticDevice.getIpAddress());
            SimpleDateFormat now = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            cleanEq.setStatTime(now.format(new Date()));
            if (0 == aticDevice.getStatus()) {
                cleanEq.setCleanEqStatus(0);
                cleanEq.setEqStatusDesc("good");
            } else {
                cleanEq.setCleanEqStatus(1);
                cleanEq.setEqStatusDesc("not good");
            }
            if (null != aticDevice.getCleanCpuNumber() && 0 != aticDevice.getCleanCpuNumber()) {
                cleanEq.setTotalAbility((double)aticDevice.getCleanCpuNumber().intValue() * 20.0);
            } else if (0 != aticDevice.getCpuNumber()) {
                cleanEq.setTotalAbility((double)aticDevice.getCpuNumber() * 20.0);
            } else {
                responseMsg = "TotalAbility is a illegal parameter.";
                this.logger.error((Object)responseMsg);
                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
                Response.ResponseBuilder builder = Response.status((int)responseCode);
                builder.entity((Object)responseMsg);
                return builder.build();
            }
            double cpuMemUsage = Double.parseDouble(String.valueOf(cpuMemUageMap.get(aticDevice.getMoId())));
            this.logger.info((Object)("atic device moId = " + aticDevice.getMoId() + " ; cpuUsage() = " + cpuMemUsage));
            if (0.0 == cpuMemUsage) {
                responseMsg = "CurrentAbility is a illegal parameter.Device name : " + aticDevice.getName() + ", device status : " + aticDevice.getStatus();
                this.logger.info((Object)responseMsg);
                continue;
            }
            cleanEq.setCurrentAbility((100.0 - cpuMemUsage) * cleanEq.getTotalAbility() / 100.0);
            cleanEqs.add(cleanEq);
        }
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("command", commandInfo.getCommand());
        jsonMap.put("data", cleanEqs);
        JSONUtil instance = JSONUtil.getInstance();
        String cleanEqsJson = null;
        try {
            cleanEqsJson = instance.toJSON(jsonMap);
        }
        catch (IOException e) {
            this.logger.error((Object)e.getMessage());
        }
        responseCode = 200;
        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)cleanEqsJson);
        return Response.ok((Object)cleanEqsJson).build();
    }

    private Map<Long, Integer> getCpuMemUsageByTime(List<AticDevice> anticDevices, long startTime, long endTime) {
        ICpuMemUsageService cpuMemUsageService = (ICpuMemUsageService)ServiceContext.getInstance().getService("iCpuMemUsageService", ICpuMemUsageService.class);
        List cpuMemUageList = cpuMemUsageService.getCpuMemUsageByTime(startTime, endTime);
        this.logger.info((Object)("cpuMemUageList.keys = " + cpuMemUageList.size()));
        HashMap<Long, Integer> cpuMemUsageMap = new HashMap<Long, Integer>();
        for (AticDevice aticDevice : anticDevices) {
            CpuMemUsage cpuMemUsageMax = new CpuMemUsage();
            for (CpuMemUsage cpuMemUsage : cpuMemUageList) {
                if (aticDevice.getMoId() != cpuMemUsage.getDeviceId() || 0 != cpuMemUsageMax.getCpuUsage() && cpuMemUsageMax.getMonitorTime() >= cpuMemUsage.getMonitorTime()) continue;
                cpuMemUsageMax = cpuMemUsage;
                this.logger.info((Object)("cpuMemUsageMax.getCpuUsage() = " + cpuMemUsageMax.getCpuUsage()));
            }
            this.logger.info((Object)("aticDevice.getMoId() = " + aticDevice.getMoId() + "; cpuMemUsageMax.getCpuUsage() = " + cpuMemUsageMax.getCpuUsage()));
            cpuMemUsageMap.put(aticDevice.getMoId(), cpuMemUsageMax.getCpuUsage());
        }
        return cpuMemUsageMap;
    }
}

