/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.base.thread;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPool {
    private ThreadPoolExecutor executor;

    public ThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, int workQueueSize) {
        this.executor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(workQueueSize));
    }

    public void submitTask(FutureTask<Object> task) {
        this.executor.execute(task);
    }

    public int getRemainCapacity() {
        BlockingQueue<Runnable> workQueue = this.executor.getQueue();
        if (null != workQueue) {
            return workQueue.remainingCapacity();
        }
        return 0;
    }

    public BlockingQueue<Runnable> getWorkQueue() {
        return this.executor.getQueue();
    }
}

