/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.base.thread;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.thread.CallableTask;
import com.hs.lego.core.base.thread.RootTask;
import com.hs.lego.core.base.thread.RunnableTask;
import com.hs.lego.core.base.thread.ThreadPool;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class ThreadPoolManager
implements Runnable {
    private static final long SLEEP_TIME = 2000L;
    private static final Object LOCK = new Object();
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private static Map<Long, RootTask> sPoolTaskMap = Collections.synchronizedMap(new HashMap(5120));
    private static BlockingQueue<RootTask> sPollTaskWaitQueue = new LinkedBlockingQueue<RootTask>(5120);
    private static ConcurrentHashMap<Long, RootTask> workMap = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ThreadPool pool = null;
        InputStream instream = null;
        int corePoolSize = 10;
        int maximumPoolSize = 50;
        int workQueueSize = 200;
        long keepAliveTime = 120L;
        try {
            Properties props = new Properties();
            ClassLoader loader = this.getClass().getClassLoader();
            if (null == loader) {
                LOGGER.error((Object)"loader is null, init threadpool.properties error. use default value");
            } else {
                instream = loader.getResourceAsStream("threadpool.properties");
                if (null == instream) {
                    LOGGER.error((Object)"instream is null, init threadpool.properties error. use default value");
                } else {
                    props.load(instream);
                    corePoolSize = Integer.parseInt(props.getProperty("core_pool_size", "10"));
                    maximumPoolSize = Integer.parseInt(props.getProperty("max_pool_size", "50"));
                    workQueueSize = Integer.parseInt(props.getProperty("work_queue_size", "200"));
                    keepAliveTime = Long.parseLong(props.getProperty("keep_alive_time", "120"));
                }
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("init threadpool.properties error. use default value:" + e.getMessage()));
        }
        finally {
            if (null != instream) {
                try {
                    instream.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"close InputStream of threadpool.properties error.");
                }
            }
        }
        if (maximumPoolSize < corePoolSize || corePoolSize < 0 || maximumPoolSize < 0 || keepAliveTime < 0L || keepAliveTime < 0L) {
            LOGGER.error((Object)"the value in threadpool.properties is error. use default value");
            corePoolSize = 10;
            maximumPoolSize = 50;
            workQueueSize = 200;
            keepAliveTime = 120L;
        }
        pool = new ThreadPool(corePoolSize, maximumPoolSize, keepAliveTime, workQueueSize);
        LOGGER.info((Object)"init threadpool finish");
        while (true) {
            try {
                while (true) {
                    TimeUnit.MILLISECONDS.sleep(2000L);
                    int remainCapacity = pool.getRemainCapacity();
                    if (remainCapacity <= 0) continue;
                    this.scheduleTask(pool, remainCapacity);
                }
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)("ThreadPoolManager sleep error." + e.getMessage()));
                continue;
            }
            break;
        }
    }

    private void scheduleTask(ThreadPool pool, int remainCapacity) throws InterruptedException {
        for (int i = 0; i < remainCapacity; ++i) {
            RootTask task = sPollTaskWaitQueue.take();
            if (null == task) continue;
            pool.submitTask(task.getFutureTask());
            workMap.put(task.getTimeStamp(), task);
            long taskTimeStamp = task.getTimeStamp();
            if (!task.isPeriodTask()) {
                ThreadPoolManager.deleteTask(taskTimeStamp);
                continue;
            }
            if (!this.isTaskExists(taskTimeStamp) || sPollTaskWaitQueue.contains(task) || workMap.contains(task)) continue;
            ThreadPoolManager.addTask(task, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTaskExists(long taskTimeStamp) {
        Object object = LOCK;
        synchronized (object) {
            return sPoolTaskMap.containsKey(taskTimeStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FutureTask<?> addTask(RootTask task, boolean isSchedule) {
        Object object = LOCK;
        synchronized (object) {
            if (null == task) {
                return null;
            }
            if (sPoolTaskMap.size() > 5120) {
                LOGGER.error((Object)"sPoolTaskSet has reached max size, add task failed.");
                return null;
            }
            FutureTask<Object> futureTask = null;
            if (task instanceof RunnableTask) {
                futureTask = new FutureTask<Object>((RunnableTask)task, null);
            } else if (task instanceof CallableTask) {
                futureTask = new FutureTask((CallableTask)task);
            }
            if (null != futureTask) {
                task.setFutureTask(futureTask);
                if (!isSchedule) {
                    sPoolTaskMap.put(task.getTimeStamp(), task);
                }
                sPollTaskWaitQueue.add(task);
                return futureTask;
            }
            LOGGER.info((Object)("add task fail, task is not RunnableTask or CallableTask:" + task.toString()));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteTask(long taskTimeStamp) {
        Object object = LOCK;
        synchronized (object) {
            sPoolTaskMap.remove(taskTimeStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeWorkTask(long key, RootTask task) {
        if (workMap.contains(task)) {
            Object object = LOCK;
            synchronized (object) {
                if (workMap.contains(task)) {
                    workMap.remove(key);
                    if (sPoolTaskMap.containsKey(key) && !sPollTaskWaitQueue.contains(task) && !workMap.contains(task)) {
                        ThreadPoolManager.addTask(task, true);
                    }
                }
            }
        }
    }
}

