/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.mediation;

import com.hs.atic.util.CrashThreadHandler;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.thread.ThreadPoolManager;
import com.hs.lego.core.mediation.IFilter;
import com.hs.lego.core.mediation.IPlugin;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class Controler
implements InitializingBean,
DisposableBean {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private List<IPlugin> plugins;

    public void afterPropertiesSet() throws Exception {
        Thread threadMgr = new Thread(new ThreadPoolManager());
        threadMgr.setName("Mediation ThreadPool MgrThread");
        threadMgr.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)CrashThreadHandler.getInstance());
        threadMgr.start();
        this.plugins = new ArrayList<IPlugin>();
        LOGGER.debug((Object)"Controler init ok.");
    }

    public void destroy() {
        if (null != this.plugins) {
            for (IPlugin plugin : this.plugins) {
                plugin.destroy();
            }
        }
        LOGGER.debug((Object)"Controler destroy ok.");
    }

    public void onBindPlugin(IPlugin plugin, Map properties) {
        plugin.init();
        if (null != this.plugins) {
            this.plugins.add(plugin);
        }
    }

    public void onUnbindPlugin(IPlugin plugin, Map properties) {
        plugin.destroy();
        if (null != this.plugins) {
            this.plugins.remove(plugin);
        }
    }

    public void onBindFilter(IFilter filter, Map properties) {
    }

    public void onUnbindFilter(IFilter filter, Map properties) {
    }
}

