/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.mediation.msg;

import com.hs.lego.cbb.resource.sdk.model.ManagedObject;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.cbb.resource.dao.IResourceDao;
import com.huawei.atic.cbb.resource.util.DaoFactory;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;

public class MoStatusChange {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private BlockingDeque<DeviceStatus> deviceStatusQueue = new LinkedBlockingDeque<DeviceStatus>();

    private MoStatusChange() {
        MoStatusChangeThread thread = new MoStatusChangeThread();
        thread.setName("MoStatusChangeThread");
        thread.start();
    }

    public static MoStatusChange getInstance() {
        return ObjectHolder.instance;
    }

    public void changeMoStatus(long moId, int status) {
        LOGGER.info((Object)("recv a msg when mo status changed. moId : " + moId + " , status : " + status));
        DeviceStatus ds = new DeviceStatus(moId, status);
        boolean offer = this.deviceStatusQueue.offer(ds);
        if (!offer) {
            LOGGER.warn((Object)("offer to deviceStatusQueue error. moId : " + moId + " , status : " + status));
        }
    }

    private void modifyDeviceStatus(DeviceStatus ds) {
        LOGGER.info((Object)("mo status is changed, moId is : " + ds.getMoId()));
        IResourceDao dao = DaoFactory.getInstance().getResourceDao();
        ManagedObject mo = dao.getMoByIdAndType(ManagedObject.class, ds.getMoId(), null);
        if (mo == null) {
            LOGGER.warn((Object)("mo status is changed, mo is nullllllllllll, moid is : " + ds.getMoId()));
            return;
        }
        if (mo.getStatus() != null && mo.getStatus().intValue() == ds.getStatus()) {
            LOGGER.warn((Object)("mo status is changed, status is same, moid is : " + ds.getMoId() + " , status : " + ds.getStatus()));
            return;
        }
        mo.setStatus(Integer.valueOf(ds.getStatus()));
        dao.updateMoWithoutMsg(mo);
        IAticDeviceService aticDeviceService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
        aticDeviceService.notifyDeviceStatusInCluster(-1, ds.getMoId());
    }

    private static class ObjectHolder {
        private static MoStatusChange instance = new MoStatusChange();

        private ObjectHolder() {
        }
    }

    private class MoStatusChangeThread
    extends Thread {
        private MoStatusChangeThread() {
        }

        @Override
        public void run() {
            while (true) {
                if (null != MoStatusChange.this.deviceStatusQueue.peek()) {
                    DeviceStatus poll = (DeviceStatus)MoStatusChange.this.deviceStatusQueue.poll();
                    try {
                        if (poll == null) continue;
                        MoStatusChange.this.modifyDeviceStatus(poll);
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)("some error happened when modify mo status." + e.getMessage()));
                    }
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    LOGGER.error((Object)("some error happened." + e.getMessage()));
                    continue;
                }
                break;
            }
        }
    }

    private static class DeviceStatus {
        private long moId;
        private int status;

        public DeviceStatus(long moId, int status) {
            this.moId = moId;
            this.status = status;
        }

        public long getMoId() {
            return this.moId;
        }

        public int getStatus() {
            return this.status;
        }
    }
}

