/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.mediation.nepoll;

import com.hs.lego.cbb.resource.sdk.model.TopoObject;
import com.hs.lego.cbb.resource.sdk.model.TopoObjectQueryCondition;
import com.hs.lego.cbb.resource.sdk.service.IDataExplore;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.mediation.nepoll.PingPoll;
import com.hs.lego.core.mediation.nepoll.PollPlugin;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.List;

class InitPollThread
implements Runnable {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private IDataExplore dateExplorer = null;

    public InitPollThread(IDataExplore dateExplorer) {
        this.dateExplorer = dateExplorer;
    }

    @Override
    public void run() {
        List topoObjects;
        TopoObjectQueryCondition condition = new TopoObjectQueryCondition();
        condition.setUserId(null);
        condition.setIsManaged(Boolean.valueOf(true));
        while (true) {
            try {
                topoObjects = this.dateExplorer.getDataList(condition);
            }
            catch (RuntimeException e) {
                LOGGER.error((Object)("get topoOject with error" + e.getMessage()));
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ex) {
                    LOGGER.error((Object)("sleep error." + e.getMessage()));
                }
                continue;
            }
            break;
        }
        for (TopoObject topoMo : topoObjects) {
            long moId = topoMo.getMoId();
            String moIP = topoMo.getIpAddress();
            String moName = topoMo.getName();
            if (!topoMo.getSupportPing().booleanValue()) {
                LOGGER.error((Object)("no support ping,ip:" + moIP + ",moId:" + moId + ",moName:" + moName));
                continue;
            }
            if (topoMo.getMainType().startsWith("AntiDDoS1820NCluster")) {
                LOGGER.info((Object)("Skip the AntiDDoS1820NCluster device " + topoMo.getName() + " at the beginning"));
                continue;
            }
            if (topoMo.getMainType().startsWith("lego.dic.legosystem.maintype")) {
                LOGGER.info((Object)("Skip the man maintype " + topoMo.getName() + " at the beginning"));
                continue;
            }
            if (null == moIP) {
                LOGGER.error((Object)("moIP is null, can not add a poll task while starting, moId:" + moId));
                continue;
            }
            PollPlugin.getInstance().addPingPoll(new PingPoll(moId, moIP, moName));
        }
    }
}

