/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.mediation.nepoll;

import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.resource.sdk.model.ManagedObject;
import com.hs.lego.cbb.resource.sdk.model.TopoObject;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.mediation.nepoll.PingPoll;
import com.hs.lego.core.mediation.nepoll.PollPlugin;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.Map;

public class NeAddSubscriber {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);

    public void onMessage(Map<Long, ManagedObject> msgObj) {
        if (null == msgObj) {
            LOGGER.error((Object)"recv a null message object, message type: COMMAND_RES_ADD");
            return;
        }
        try {
            LOGGER.info((Object)("recv a COMMAND_RES_ADD message, moIds: " + msgObj.keySet()));
            Collection<ManagedObject> moList = msgObj.values();
            for (ManagedObject mo : moList) {
                if (!(mo instanceof TopoObject)) continue;
                TopoObject topoMo = (TopoObject)mo;
                String moIP = topoMo.getIpAddress();
                if (null == moIP) {
                    LOGGER.error((Object)"moIP is null, can not add a poll task.");
                    continue;
                }
                LOGGER.info((Object)("TopoObject contained in COMMAND_RES_ADD message which moId: " + topoMo.getMoId() + ", moIP: " + AticUtil.getcleanedMessage((String)moIP)));
                this.constructPollTask(moIP, topoMo);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
        }
    }

    private void constructPollTask(String moIP, TopoObject topoMo) {
        long moId = topoMo.getMoId();
        String moName = topoMo.getName();
        if (!topoMo.getSupportPing().booleanValue()) {
            LOGGER.error((Object)("no support ping,ip:" + moIP + ",moId:" + moId + ",moName:" + moName));
            return;
        }
        if (topoMo.getMainType().startsWith("AntiDDoS1820NCluster")) {
            LOGGER.info((Object)("Skip the AntiDDoS1820NCluster device " + topoMo.getName() + "when add device"));
            return;
        }
        PollPlugin.getInstance().addPingPoll(new PingPoll(moId, moIP, moName));
    }
}

