/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.alarm.service;

import com.hs.atic.collector.entity.alarm.CycleAlarmEntity;
import com.hs.atic.collector.entity.alarm.DbTableAlarmEntity;
import com.hs.atic.collector.entity.alarm.DiskSpaceAlarmEntity;
import com.hs.atic.collector.entity.alarm.DropLogAlarmEntity;
import com.hs.atic.collector.entity.alarm.FtpConnAlarmEntity;
import com.hs.atic.collector.entity.alarm.MemoryAlarmEntity;
import com.hs.atic.sdk.bis.model.AticAlarmObject;
import com.hs.atic.sdk.bis.service.IAlarmService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.atic.collector.service.dao.CollectorDao;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.Collector;
import java.util.ArrayList;
import java.util.List;

public class SecneAlarmHandler {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private IAlarmService alarmService;
    private CollectorDao collectorDao;

    public void dbTableAlarm(List<DbTableAlarmEntity> dbTabledAlarmList) {
        if (!dbTabledAlarmList.isEmpty()) {
            ArrayList<AticAlarmObject> alarmObjectList = new ArrayList<AticAlarmObject>();
            for (DbTableAlarmEntity entity : dbTabledAlarmList) {
                AticAlarmObject obj = this.generateDbTableAlarm(entity);
                alarmObjectList.add(obj);
            }
            if (!alarmObjectList.isEmpty()) {
                this.alarmService.callAlarmQueue(alarmObjectList);
            }
        }
    }

    private AticAlarmObject generateDbTableAlarm(DbTableAlarmEntity entity) {
        AticAlarmObject alarmObject = new AticAlarmObject();
        String tableName = entity.getTableName();
        String collectorIp = entity.getCollectorIp();
        String[] param = new String[3];
        Collector collector = this.collectorDao.getCollectorEntryByIp(collectorIp);
        if (null == collector) {
            return alarmObject;
        }
        param[0] = collector.getCollectorName();
        param[1] = collectorIp;
        param[2] = tableName;
        alarmObject.setAlarmId("0x0000000803240817");
        alarmObject.setAlarmParam(param);
        alarmObject.setIsAlarm(Boolean.valueOf(entity.isAlarm()));
        alarmObject.setMoId(collector.getMoId());
        alarmObject.setExtendMoId(collector.getMoId());
        alarmObject.setMoName(collector.getCollectorName());
        alarmObject.setMoIp(collectorIp);
        alarmObject.setAlertLevel(FaultEnum.AlarmSeverity.CRITICAL);
        alarmObject.setAlertTime(System.currentTimeMillis());
        return alarmObject;
    }

    public void diskSpaceAlarm(List<DiskSpaceAlarmEntity> diskSpaceList) {
        if (!diskSpaceList.isEmpty()) {
            ArrayList<AticAlarmObject> alarmObjects = new ArrayList<AticAlarmObject>();
            int alarmMaxNum = 1000;
            for (DiskSpaceAlarmEntity entity : diskSpaceList) {
                AticAlarmObject obj = this.generateDiskSpaceAlarm(entity);
                alarmObjects.add(obj);
                if (alarmObjects.size() <= alarmMaxNum) continue;
                this.alarmService.callAlarmQueue(alarmObjects);
                alarmObjects.clear();
            }
            if (!alarmObjects.isEmpty()) {
                this.alarmService.callAlarmQueue(alarmObjects);
            }
        }
    }

    private AticAlarmObject generateDiskSpaceAlarm(DiskSpaceAlarmEntity entity) {
        AticAlarmObject alarmObject = new AticAlarmObject();
        try {
            String collectorIp = entity.getCollectorIp();
            String[] param = new String[5];
            Collector collector = this.collectorDao.getCollectorEntryByIp(collectorIp);
            if (null == collector) {
                return alarmObject;
            }
            int thousand = 1024;
            Long threshold = Long.parseLong(entity.getThreshold()) / (long)thousand;
            Long crrentPercent = Long.parseLong(entity.getCrrentPercent()) / (long)thousand;
            param[0] = collector.getCollectorName();
            param[1] = collectorIp;
            param[2] = entity.getDiskName();
            param[3] = threshold.toString();
            param[4] = crrentPercent.toString();
            int severity = entity.getSeverity();
            if (3 == severity) {
                alarmObject.setAlertLevel(FaultEnum.AlarmSeverity.MAJOR);
            } else {
                alarmObject.setAlertLevel(FaultEnum.AlarmSeverity.CRITICAL);
            }
            alarmObject.setAlarmId("0x0000000803240822");
            alarmObject.setAlarmParam(param);
            alarmObject.setIsAlarm(Boolean.valueOf(entity.isAlarm()));
            alarmObject.setMoId(collector.getMoId());
            alarmObject.setExtendMoId(collector.getMoId());
            alarmObject.setMoName(collector.getCollectorName());
            alarmObject.setMoIp(collectorIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
        }
        catch (RuntimeException e) {
            logger.error((Object)("generateDiskSpaceAlarm error!! " + entity.getCollectorIp()));
        }
        return alarmObject;
    }

    public void cycleAlarm(List<CycleAlarmEntity> cycleList) {
        if (!cycleList.isEmpty()) {
            ArrayList<AticAlarmObject> alarmObjects = new ArrayList<AticAlarmObject>();
            int alarmMaxNum = 1000;
            for (CycleAlarmEntity entity : cycleList) {
                AticAlarmObject obj = this.generateCycleAlarm(entity);
                alarmObjects.add(obj);
                if (alarmObjects.size() <= alarmMaxNum) continue;
                this.alarmService.callAlarmQueue(alarmObjects);
                alarmObjects.clear();
            }
            if (!alarmObjects.isEmpty()) {
                this.alarmService.callAlarmQueue(alarmObjects);
            }
        }
    }

    private AticAlarmObject generateCycleAlarm(CycleAlarmEntity entity) {
        AticAlarmObject alarmObject = new AticAlarmObject();
        try {
            String collectorIp = entity.getCollectorIp();
            String[] param = new String[5];
            Collector collector = this.collectorDao.getCollectorEntryByIp(collectorIp);
            if (null == collector) {
                return alarmObject;
            }
            param[0] = collector.getCollectorName();
            param[1] = collectorIp;
            param[2] = entity.getDeviceIp();
            param[3] = entity.getLearnCycle();
            param[4] = entity.getConfigCycle();
            int severity = entity.getSeverity();
            if (3 == severity) {
                alarmObject.setAlertLevel(FaultEnum.AlarmSeverity.MAJOR);
            } else {
                alarmObject.setAlertLevel(FaultEnum.AlarmSeverity.CRITICAL);
            }
            alarmObject.setAlarmId("0x0000000803240837");
            alarmObject.setAlarmParam(param);
            alarmObject.setIsAlarm(Boolean.valueOf(entity.isAlarm()));
            alarmObject.setMoId(collector.getMoId());
            alarmObject.setExtendMoId(collector.getMoId());
            alarmObject.setMoName(collector.getCollectorName());
            alarmObject.setMoIp(collectorIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
        }
        catch (RuntimeException e) {
            logger.error((Object)("generateCycleAlarm error!! " + entity.getCollectorIp()));
        }
        return alarmObject;
    }

    public void memoryAlarm(List<MemoryAlarmEntity> memoryList) {
        if (!memoryList.isEmpty()) {
            ArrayList<AticAlarmObject> alarmObjects = new ArrayList<AticAlarmObject>();
            int alarmMaxNum = 1000;
            for (MemoryAlarmEntity entity : memoryList) {
                AticAlarmObject obj = this.generateMemoryAlarm(entity);
                alarmObjects.add(obj);
                if (alarmObjects.size() <= alarmMaxNum) continue;
                this.alarmService.callAlarmQueue(alarmObjects);
                alarmObjects.clear();
            }
            if (!alarmObjects.isEmpty()) {
                this.alarmService.callAlarmQueue(alarmObjects);
            }
        }
    }

    private AticAlarmObject generateMemoryAlarm(MemoryAlarmEntity entity) {
        AticAlarmObject alarmObject = new AticAlarmObject();
        try {
            String collectorIp = entity.getCollectorIp();
            String[] param = new String[15];
            Collector collector = this.collectorDao.getCollectorEntryByIp(collectorIp);
            if (null == collector) {
                return alarmObject;
            }
            param[0] = collector.getCollectorName();
            param[1] = collectorIp;
            param[2] = entity.getUsedMemory();
            param[3] = entity.getMaxMemory();
            param[4] = entity.getUsedFlow();
            param[5] = entity.getMaxFlow();
            param[6] = entity.getUsedAbnormal();
            param[7] = entity.getMaxAbnormal();
            param[8] = entity.getUsedSrcAndContent();
            param[9] = entity.getMaxSrcAndContent();
            param[10] = entity.getUsedCapture();
            param[11] = entity.getMaxCapture();
            param[12] = entity.getUsedCacheBlack();
            param[13] = entity.getUsedParseBlack();
            param[14] = entity.getMaxBlacklist();
            int severity = entity.getSeverity();
            if (3 == severity) {
                alarmObject.setAlertLevel(FaultEnum.AlarmSeverity.MAJOR);
            } else {
                alarmObject.setAlertLevel(FaultEnum.AlarmSeverity.CRITICAL);
            }
            alarmObject.setAlarmId("0x0000000803240838");
            alarmObject.setAlarmParam(param);
            alarmObject.setIsAlarm(Boolean.valueOf(entity.isAlarm()));
            alarmObject.setMoId(collector.getMoId());
            alarmObject.setExtendMoId(collector.getMoId());
            alarmObject.setMoName(collector.getCollectorName());
            alarmObject.setMoIp(collectorIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
        }
        catch (RuntimeException e) {
            logger.error((Object)("generateCycleAlarm error!! " + entity.getCollectorIp()));
        }
        return alarmObject;
    }

    public void dropLogAlarm(List<DropLogAlarmEntity> dropLogList) {
        if (!dropLogList.isEmpty()) {
            ArrayList<AticAlarmObject> alarmObjects = new ArrayList<AticAlarmObject>();
            int alarmMaxNum = 1000;
            for (DropLogAlarmEntity entity : dropLogList) {
                AticAlarmObject obj = this.generateDropLogAlarm(entity);
                alarmObjects.add(obj);
                if (alarmObjects.size() <= alarmMaxNum) continue;
                this.alarmService.callAlarmQueue(alarmObjects);
                alarmObjects.clear();
            }
            if (!alarmObjects.isEmpty()) {
                this.alarmService.callAlarmQueue(alarmObjects);
            }
        }
    }

    private AticAlarmObject generateDropLogAlarm(DropLogAlarmEntity entity) {
        AticAlarmObject alarmObject = new AticAlarmObject();
        try {
            String collectorIp = entity.getCollectorIp();
            String[] param = new String[7];
            Collector collector = this.collectorDao.getCollectorEntryByIp(collectorIp);
            if (null == collector) {
                return alarmObject;
            }
            int logType = entity.getLogType();
            int logLevel = entity.getLogLevel();
            int severity = entity.getSeverity();
            param[0] = collector.getCollectorName();
            param[1] = collectorIp;
            param[2] = Integer.toString(logLevel);
            param[3] = entity.getUsedMemory();
            param[4] = entity.getMaxMemory();
            param[5] = entity.getUsedCount();
            param[6] = entity.getMaxCount();
            if (3 == severity) {
                alarmObject.setAlertLevel(FaultEnum.AlarmSeverity.MAJOR);
            } else {
                alarmObject.setAlertLevel(FaultEnum.AlarmSeverity.CRITICAL);
            }
            if (logType > 0) {
                alarmObject.setAlarmId("0x0000000803240841");
            } else {
                alarmObject.setAlarmId("0x0000000803240842");
            }
            alarmObject.setAlarmParam(param);
            alarmObject.setIsAlarm(Boolean.valueOf(entity.isAlarm()));
            alarmObject.setMoId(collector.getMoId());
            alarmObject.setExtendMoId(collector.getMoId());
            alarmObject.setMoName(collector.getCollectorName());
            alarmObject.setMoIp(collectorIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
        }
        catch (RuntimeException e) {
            logger.error((Object)("generateCycleAlarm error!! " + entity.getCollectorIp()));
        }
        return alarmObject;
    }

    public void collectorOffLineAlarm(String collectorIp, String collectorName, Long moId) {
        try {
            AticAlarmObject alarmObject = new AticAlarmObject();
            String[] alarmParam = this.assembleCcoOffLineAlert(collectorIp, collectorName);
            alarmObject.setAlarmId("0x0000000803240802");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(true));
            alarmObject.setMoId(moId);
            alarmObject.setMoName(collectorName);
            alarmObject.setMoIp(collectorIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("collectorOffLineAlarm error:" + collectorIp));
            }
        }
        catch (Exception e) {
            logger.error((Object)("manuleDivertAlarm error!" + e.getMessage()));
        }
    }

    private String[] assembleCcoOffLineAlert(String collectorIp, String collectorName) {
        String[] param = new String[]{collectorName, collectorIp};
        return param;
    }

    public void collectorOffLineResume(String collectorIp, String collectorName, Long moId) {
        try {
            AticAlarmObject alarmObject = new AticAlarmObject();
            String[] alarmParam = this.assembleCcoOffLineAlert(collectorIp, collectorName);
            alarmObject.setAlarmId("0x0000000803240802");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(false));
            alarmObject.setMoId(moId);
            alarmObject.setMoName(collectorName);
            alarmObject.setMoIp(collectorIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("collectorOffLineResume error:" + collectorIp));
            }
        }
        catch (Exception e) {
            logger.error((Object)("manuleDivertAlarm error!" + e.getMessage()));
        }
    }

    public void nfaOfflineAlarmStart(AticDevice device, String[] param) {
        try {
            AticAlarmObject alarmObject = new AticAlarmObject();
            alarmObject.setAlarmId("0x000803220005");
            alarmObject.setAlarmParam(param);
            alarmObject.setAlertTime(System.currentTimeMillis());
            alarmObject.setIsAlarm(Boolean.valueOf(true));
            alarmObject.setAlertLevel(FaultEnum.AlarmSeverity.CRITICAL);
            if (null != device) {
                alarmObject.setMoId(Long.valueOf(device.getMoId()));
                alarmObject.setMoName(device.getName());
                alarmObject.setMoIp(device.getIpAddress());
            } else {
                alarmObject.setMoId(Long.valueOf(0L));
            }
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("nfaOfflineAlarmStartExecute error:" + this.getcleanedMessage(device.getName())));
            }
        }
        catch (Exception e) {
            logger.error((Object)("nfaOfflineAlarmStart error!" + e.getMessage()));
        }
    }

    public void nfaOfflineAlarmResume(AticDevice device, String[] param) {
        try {
            AticAlarmObject alarmObject = new AticAlarmObject();
            alarmObject.setAlarmId("0x000803220005");
            alarmObject.setAlarmParam(param);
            alarmObject.setAlertTime(System.currentTimeMillis());
            alarmObject.setIsAlarm(Boolean.valueOf(false));
            alarmObject.setAlertLevel(FaultEnum.AlarmSeverity.CRITICAL);
            if (null != device) {
                alarmObject.setMoId(Long.valueOf(device.getMoId()));
                alarmObject.setMoName(device.getName());
                alarmObject.setMoIp(device.getIpAddress());
            } else {
                alarmObject.setMoId(Long.valueOf(0L));
            }
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("nfaOfflineAlarmResumeExecute error:" + this.getcleanedMessage(device.getName())));
            }
        }
        catch (Exception e) {
            logger.error((Object)("nfaOfflineAlarmResume error!" + e.getMessage()));
        }
    }

    public void ftpConnectedAlarm(List<FtpConnAlarmEntity> ftpConnectedAlarmList) {
        if (!ftpConnectedAlarmList.isEmpty()) {
            ArrayList<AticAlarmObject> alarmObjects = new ArrayList<AticAlarmObject>();
            for (FtpConnAlarmEntity entity : ftpConnectedAlarmList) {
                String[] alarmParam = new String[]{entity.getCollectorIp()};
                AticAlarmObject alarmObject = new AticAlarmObject();
                alarmObject.setAlarmId("0x0000000803240811");
                alarmObject.setAlertTime(System.currentTimeMillis());
                alarmObject.setIsAlarm(Boolean.valueOf(entity.isAlarm()));
                alarmObject.setAlarmParam(alarmParam);
                Collector collector = this.collectorDao.getCollectorEntryByIp(entity.getCollectorIp());
                if (null == collector) continue;
                alarmObject.setMoId(collector.getMoId());
                alarmObject.setExtendMoId(Long.valueOf(0L));
                alarmObject.setMoName(collector.getCollectorName());
                alarmObject.setMoIp(collector.getIpAddress());
                alarmObjects.add(alarmObject);
            }
            try {
                this.alarmService.callAlarmQueue(alarmObjects);
            }
            catch (Exception e) {
                logger.error((Object)("generateEvent error :" + e.getMessage()));
            }
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public IAlarmService getAlarmService() {
        return this.alarmService;
    }

    public void setAlarmService(IAlarmService alarmService) {
        this.alarmService = alarmService;
    }

    public CollectorDao getCollectorDao() {
        return this.collectorDao;
    }

    public void setCollectorDao(CollectorDao collectorDao) {
        this.collectorDao = collectorDao;
    }
}

