/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.collector.action;

import com.hs.atic.bis.util.BisUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.exception.LegoUncheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.huawei.atic.collector.action.ElogBaseAction;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorDeviceService;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.collector.util.BeanComparator;
import com.huawei.atic.collector.util.JsonUtils;
import com.huawei.atic.collector.vo.VoNE;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.opensymphony.xwork2.ActionContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class SysDeviceAccessAction
extends ElogBaseAction {
    public static final int NAME_LENGTH_32 = 32;
    private static final long serialVersionUID = 1L;
    private static Log log4j = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private static final String ATIC_DEVICE_ACCESS_LIST = "atic_device_access";
    private static final String ATIC_DEVICE_ACCESS_SELECT = "select_device_access";
    private String sortField;
    private String sortType;
    private Long colId;
    private int colType;
    private String devName;
    private String ipAddress;
    private String devList;
    private transient List<VoNE> devAccesList;
    private List<VoNE> filterDevAccesList;
    private CollectorInfo collInfo = new CollectorInfo();
    private IAticDeviceService aticDeviceService;
    private ICollectorService collectorService = null;
    private ICollectorDeviceService collectorDeviceService;

    private List<AticDevice> getAllDeviceNeedCollect() {
        List<AticDevice> allDevice;
        block5: {
            long userId;
            block6: {
                allDevice = new ArrayList<AticDevice>();
                if (null == this.aticDeviceService) break block5;
                ActionContext ctx = ActionContext.getContext();
                HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
                User currentUser = (User)request.getSession().getAttribute("currentUser");
                Boolean isAdmin = currentUser.getIsAdmin().equalsIgnoreCase("true");
                userId = currentUser.getUserID();
                if (!isAdmin.booleanValue()) break block6;
                allDevice = this.aticDeviceService.getAntiDDoSDevice();
                long moid = 0L;
                for (AticDevice aticDevice : allDevice) {
                    moid = aticDevice.getMoId();
                    int statuts = this.aticDeviceService.getStatusByMoid(moid);
                    aticDevice.setStatus(statuts);
                }
                List<AticDevice> nfa2000VList = this.aticDeviceService.getClusterAndNfa();
                if (null == nfa2000VList || nfa2000VList.isEmpty()) break block5;
                for (AticDevice aticDeviceNFA : nfa2000VList) {
                    int statuts = this.aticDeviceService.getStatusByMoid(aticDeviceNFA.getMoId());
                    aticDeviceNFA.setStatus(statuts);
                    allDevice.add(aticDeviceNFA);
                }
                break block5;
            }
            allDevice = this.aticDeviceService.getAntiDDoSDevice(userId);
            long moid = 0L;
            for (AticDevice aticDevice : allDevice) {
                moid = aticDevice.getMoId();
                int statuts = this.aticDeviceService.getStatusByMoid(moid);
                aticDevice.setStatus(statuts);
            }
            List<AticDevice> nfa2000VList = this.aticDeviceService.getClusterAndNfa(userId);
            if (null != nfa2000VList && !nfa2000VList.isEmpty()) {
                for (AticDevice aticDeviceNFA : nfa2000VList) {
                    int statuts = this.aticDeviceService.getStatusByMoid(aticDeviceNFA.getMoId());
                    aticDeviceNFA.setStatus(statuts);
                    allDevice.add(aticDeviceNFA);
                }
            }
        }
        return allDevice;
    }

    public String initDevAccessList() {
        log4j.info((Object)"ENTER3----------------------");
        ArrayList<Long> moIDList = new ArrayList<Long>();
        moIDList.add(this.getColId());
        BisUtil.checkUserSecurity(moIDList);
        this.collInfo = this.collectorService.getCollectorInfo(this.getColId());
        if (this.collInfo == null) {
            throw new LegoCheckedException(570011L);
        }
        log4j.info((Object)("initDevAccessList method collectorDevServer : " + this.collectorDeviceService));
        List<Long> devListId = null;
        if (null != this.collectorDeviceService) {
            devListId = this.collectorDeviceService.getDeviceAccess(this.getColId());
        }
        log4j.info((Object)("initDevAccessList method collector id : " + this.getColId()));
        List<AticDevice> allFirewall = this.getAllDeviceNeedCollect();
        ArrayList<AticDevice> devAccesLists = new ArrayList<AticDevice>();
        if (null != devListId) {
            for (AticDevice securityNE : allFirewall) {
                if (!devListId.contains(securityNE.getMoId())) continue;
                devAccesLists.add(securityNE);
            }
        }
        this.devAccesList = this.pageElements(devAccesLists);
        log4j.info((Object)("initDevAccessList method device relating list : " + this.getcleanedMessage(this.devAccesList.toString())));
        return ATIC_DEVICE_ACCESS_LIST;
    }

    public void addDeviceAccess() {
        log4j.info((Object)"ENTER2----------------------");
        StringBuffer targets = new StringBuffer();
        try {
            this.getOperateResult().setSuccess(Boolean.FALSE);
            ArrayList<Long> devMoIdList = null;
            if (null != this.devList) {
                devMoIdList = new ArrayList<Long>();
                List list = JsonUtils.getInstance().jsonStringToObject(this.devList, List.class);
                if (list != null) {
                    for (LinkedHashMap map : list) {
                        devMoIdList.add(Long.valueOf((String)map.get("modId")));
                        targets.append((String)map.get("name")).append(',');
                    }
                }
            }
            ArrayList moIDList = new ArrayList();
            if (null != devMoIdList && !devMoIdList.isEmpty()) {
                moIDList.addAll(devMoIdList.subList(0, devMoIdList.size()));
            }
            moIDList.add(this.getColId());
            BisUtil.checkUserSecurity(moIDList);
            log4j.info((Object)("recv param devList : " + this.getcleanedMessage(this.devList)));
            if (null != this.collectorDeviceService && null != devMoIdList && !devMoIdList.isEmpty()) {
                this.batchOperationResult = this.collectorDeviceService.addDeviceAccess(this.getColId(), devMoIdList);
            }
            if (this.batchOperationResult != null && this.batchOperationResult.getResult() != null && !this.batchOperationResult.getResult().isEmpty()) {
                this.systemOpeLogBatch("common.atic.device.add", "lego.dic.module.collectorApp", false, SysoplogLevel.normal.getValue(), this.batchOperationResult.getResult());
            } else {
                this.systemOpeLog("common.atic.device.add", "lego.dic.module.collectorApp", false, new String[]{""}, "", targets.toString(), SysoplogLevel.normal.getValue(), true, null);
            }
            this.bathResult(this.batchOperationResult);
        }
        catch (LegoCheckedException ex) {
            if (this.batchOperationResult != null && this.batchOperationResult.getResult() != null && !this.batchOperationResult.getResult().isEmpty()) {
                this.systemOpeLogBatch("common.atic.device.add", "lego.dic.module.collectorApp", false, SysoplogLevel.normal.getValue(), this.batchOperationResult.getResult());
            } else {
                this.systemOpeLog("common.atic.device.add", "lego.dic.module.collectorApp", false, new String[]{""}, "", targets.toString(), SysoplogLevel.normal.getValue(), false, (Exception)((Object)ex));
            }
            this.bathResult(this.batchOperationResult);
        }
        catch (Exception ex) {
            if (this.batchOperationResult != null && this.batchOperationResult.getResult() != null && !this.batchOperationResult.getResult().isEmpty()) {
                this.systemOpeLogBatch("common.atic.device.add", "lego.dic.module.collectorApp", false, SysoplogLevel.normal.getValue(), this.batchOperationResult == null ? null : this.batchOperationResult.getResult());
            } else {
                this.systemOpeLog("common.atic.device.add", "lego.dic.module.collectorApp", false, new String[]{""}, "", targets.toString(), SysoplogLevel.normal.getValue(), false, (Exception)((Object)new LegoUncheckedException((Throwable)ex)));
            }
            this.bathResult(this.batchOperationResult == null ? null : this.batchOperationResult);
        }
    }

    public boolean validateDevList() {
        List list = null;
        try {
            list = JsonUtils.getInstance().jsonStringToObject(this.devList, List.class);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        if (list != null) {
            String testDevName = null;
            for (LinkedHashMap map : list) {
                if (Long.parseLong((String)map.get("modId")) < 0L) {
                    return false;
                }
                testDevName = (String)map.get("name");
                if (null == testDevName || testDevName.length() > 32 || !((String)map.get("name")).matches("^(?!(?i)null$)[a-zA-Z_0-9\u4e00-\u9fa5]{1}[\\w\\-\u4e00-\u9fa5\\.]*$")) {
                    return false;
                }
                if (map.keySet().size() == 2) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public String showUnAccessDevice() {
        List<Long> t;
        log4j.info((Object)"ENTER1----------------------");
        log4j.info((Object)("showUnAccessDevice method collectorDevServer : " + this.collectorDeviceService));
        HashSet<Long> devListId = new HashSet<Long>();
        if (null != this.collectorDeviceService && null != (t = this.collectorDeviceService.getAllDeviceAccess())) {
            devListId.addAll(t);
        }
        List<AticDevice> allFirewall = this.getAllDeviceNeedCollect();
        Iterator<AticDevice> iter = allFirewall.iterator();
        while (iter.hasNext()) {
            if (!devListId.contains(iter.next().getMoId())) continue;
            iter.remove();
        }
        this.filterDevAccesList = this.pageElements(allFirewall);
        log4j.info((Object)("showUnAccessDevice method allFirewall : " + this.getFilterDevAccesList()));
        return ATIC_DEVICE_ACCESS_SELECT;
    }

    public String queryByKey() {
        List<Long> t;
        log4j.info((Object)"ENTER4----------------------");
        HashSet<Long> devListId = new HashSet<Long>();
        if (null != this.collectorDeviceService && null != (t = this.collectorDeviceService.getAllDeviceAccess())) {
            devListId.addAll(t);
        }
        List<AticDevice> allFirewall = this.getAllDeviceNeedCollect();
        Iterator<AticDevice> iter = allFirewall.iterator();
        while (iter.hasNext()) {
            if (!devListId.contains(iter.next().getMoId())) continue;
            iter.remove();
        }
        List<AticDevice> queryList = this.filterCodition(allFirewall);
        if (queryList != null && !queryList.isEmpty()) {
            this.filterDevAccesList = this.pageElements(queryList);
        }
        return ATIC_DEVICE_ACCESS_SELECT;
    }

    public boolean validateDevNameOrEmpty() {
        if (StringUtils.isNotBlank((CharSequence)this.getDevName())) {
            if (this.getDevName().trim().length() > 32) {
                return false;
            }
            if (this.getDevName().trim().equalsIgnoreCase("null")) {
                return false;
            }
            String regex = "^(?!null$)[a-zA-Z_0-9\u4e00-\u9fa5]{1}[\\w\\-\u4e00-\u9fa5\\.]*$";
            Pattern pattern = Pattern.compile(regex);
            if (!pattern.matcher(this.getDevName()).matches()) {
                log4j.error((Object)("devName is error! devName=" + this.getcleanedMessage(this.devName)));
                return false;
            }
        }
        return true;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public boolean validateIpAddressOrEmpty() {
        if (null != this.ipAddress && !"".equals(this.ipAddress.trim())) {
            if (this.ipAddress.length() > 15) {
                log4j.error((Object)("ipAddress'length is out of 15, ipAddress=" + this.getcleanedMessage(this.ipAddress)));
                return false;
            }
            if (!this.ipAddress.matches("^(?:(?:[1-9]?[0-9]|1[0-9]{2}|2(?:[0-4][0-9]|5[0-5]))\\.){0,3}(?:[1-9]?[0-9]|1[0-9]{2}|2(?:[0-4][0-9]|5[0-5])){0,1}$")) {
                log4j.error((Object)("ipAddress format is error, ipAddress=" + this.getcleanedMessage(this.ipAddress)));
                return false;
            }
        }
        return true;
    }

    public void batchDelDevAccess() {
        log4j.info((Object)"ENTER5----------------------");
        StringBuffer targets = new StringBuffer();
        try {
            List list;
            this.getOperateResult().setSuccess(Boolean.FALSE);
            ArrayList<Long> delDevIdList = new ArrayList<Long>();
            log4j.info((Object)("batchDelDevAccess method recv params : " + this.getcleanedMessage(this.devList)));
            if (null != this.devList && (list = JsonUtils.getInstance().jsonStringToObject(this.devList, List.class)) != null) {
                for (LinkedHashMap map : list) {
                    delDevIdList.add(Long.valueOf((String)map.get("modId")));
                    targets.append((String)map.get("name")).append(',');
                }
            }
            ArrayList moIDList = new ArrayList();
            moIDList.addAll(delDevIdList.subList(0, delDevIdList.size()));
            moIDList.add(this.getColId());
            BisUtil.checkUserSecurity(moIDList);
            log4j.info((Object)("batchDelDevAccess method ICollectorDeviceService : " + this.collectorDeviceService));
            if (null != this.collectorDeviceService) {
                this.batchOperationResult = this.collectorDeviceService.delDeviceAccess(this.getColId(), delDevIdList);
            }
            log4j.info((Object)("batchDelDevAccess method batchOperationResult : " + this.batchOperationResult));
            if (this.batchOperationResult != null && this.batchOperationResult.getResult() != null && !this.batchOperationResult.getResult().isEmpty()) {
                this.systemOpeLogBatch("common.atic.device.del", "lego.dic.module.collectorApp", false, SysoplogLevel.normal.getValue(), this.batchOperationResult.getResult());
            } else {
                this.systemOpeLog("common.atic.device.del", "lego.dic.module.collectorApp", false, new String[]{""}, "", targets.toString(), SysoplogLevel.normal.getValue(), true, null);
            }
            this.bathResult(this.batchOperationResult);
        }
        catch (LegoCheckedException ex) {
            if (this.batchOperationResult != null && this.batchOperationResult.getResult() != null && !this.batchOperationResult.getResult().isEmpty()) {
                this.systemOpeLogBatch("common.atic.device.del", "lego.dic.module.collectorApp", false, SysoplogLevel.normal.getValue(), this.batchOperationResult.getResult());
            } else {
                this.systemOpeLog("common.atic.device.del", "lego.dic.module.collectorApp", false, new String[]{""}, "", targets.toString(), SysoplogLevel.normal.getValue(), false, (Exception)((Object)ex));
            }
            this.bathResult(this.batchOperationResult);
        }
        catch (Exception ex) {
            if (this.batchOperationResult != null && this.batchOperationResult.getResult() != null && !this.batchOperationResult.getResult().isEmpty()) {
                this.systemOpeLogBatch("common.atic.device.del", "lego.dic.module.collectorApp", false, SysoplogLevel.normal.getValue(), this.batchOperationResult.getResult());
            } else {
                this.systemOpeLog("common.atic.device.del", "lego.dic.module.collectorApp", false, new String[]{""}, "", targets.toString(), SysoplogLevel.normal.getValue(), false, (Exception)((Object)new LegoUncheckedException((Throwable)ex)));
            }
            this.bathResult(this.batchOperationResult == null ? null : this.batchOperationResult);
        }
    }

    private List<VoNE> pageElements(List<AticDevice> srcElements) {
        log4j.info((Object)"ENTER6----------------------");
        List<VoNE> retPagsEls = null;
        ArrayList<VoNE> voNEList = new ArrayList<VoNE>();
        if (srcElements != null && !srcElements.isEmpty()) {
            int j = srcElements.size();
            for (int i = 0; i < j; ++i) {
                AticDevice firewallTemp = srcElements.get(i);
                VoNE voNE = new VoNE();
                voNE.setMoId(firewallTemp.getMoId());
                voNE.setDdosType(firewallTemp.getDdosType());
                voNE.setDevOSVersionName(firewallTemp.getVersion());
                voNE.setDevTypeName(firewallTemp.getDeviceModel());
                voNE.setIpaddress(firewallTemp.getIpAddress());
                voNE.setSystemName(firewallTemp.getName());
                voNE.setStatus(firewallTemp.getStatus());
                voNEList.add(voNE);
            }
            this.setTotal(srcElements.size());
        }
        if (null != this.sortField && !this.sortField.isEmpty() && null != this.sortType) {
            BeanComparator comparator = new BeanComparator(BeanComparator.SortTypeEnum.valueOf(this.sortType.toUpperCase(Locale.getDefault())), this.sortField);
            Collections.sort(voNEList, comparator);
        }
        retPagsEls = this.page(voNEList);
        log4j.info((Object)("pageElements : " + retPagsEls));
        return retPagsEls;
    }

    private List<AticDevice> filterCodition(List<AticDevice> srcElements) {
        String regex;
        Pattern pattern;
        log4j.info((Object)"ENTER7----------------------");
        log4j.info((Object)("filterCodition method devName : " + this.getcleanedMessage(this.getDevName()) + ", ipaddress : " + this.getcleanedMessage(this.getIpAddress())));
        log4j.info((Object)("filterCodition method srcElements :" + srcElements));
        if (StringUtils.isNotBlank((CharSequence)this.getDevName()) && !(pattern = Pattern.compile(regex = "^[a-zA-Z_0-9\u4e00-\u9fa5]{1}[\\w\\-\u4e00-\u9fa5\\.]*$")).matcher(this.getDevName()).matches()) {
            log4j.error((Object)("devName is error! devName=" + this.getcleanedMessage(this.devName)));
            throw new LegoCheckedException(570505L);
        }
        if (null != this.ipAddress && !"".equals(this.ipAddress.trim()) && this.ipAddress.length() > 15) {
            log4j.error((Object)("ipAddress'length is out of 15, ipAddress=" + this.getcleanedMessage(this.ipAddress)));
            throw new LegoCheckedException(570505L);
        }
        ArrayList<AticDevice> queryList = null;
        if (null != srcElements) {
            queryList = new ArrayList<AticDevice>();
            boolean isFilter = false;
            for (AticDevice f : srcElements) {
                isFilter = false;
                if (null != this.getDevName() && !this.getDevName().isEmpty()) {
                    isFilter = f.getName().toLowerCase(Locale.getDefault()).indexOf(this.getDevName().toLowerCase(Locale.getDefault()).trim()) == -1;
                }
                if (null != this.getIpAddress() && !this.getIpAddress().isEmpty() && !isFilter) {
                    isFilter = f.getIpAddress().indexOf(this.getIpAddress().trim()) == -1;
                }
                if (isFilter) continue;
                queryList.add(f);
            }
        }
        return queryList;
    }

    private <T> List<T> page(List<T> list) {
        int end = this.start + this.pageSize;
        if (end > list.size()) {
            end = list.size();
        }
        return list.subList(this.start, end);
    }

    public static Log getLog4j() {
        return log4j;
    }

    public static void setLog4j(Log log4j) {
        SysDeviceAccessAction.log4j = log4j;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public Long getColId() {
        return this.colId;
    }

    public void setColId(Long colId) {
        this.colId = colId;
    }

    public int getColType() {
        return this.colType;
    }

    public void setColType(int colType) {
        this.colType = colType;
    }

    public String getDevName() {
        return this.devName;
    }

    public void setDevName(String devName) {
        this.devName = devName;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getDevList() {
        return this.devList;
    }

    public void setDevList(String devList) {
        this.devList = devList;
    }

    public List<VoNE> getDevAccesList() {
        return this.devAccesList;
    }

    public void setDevAccesList(List<VoNE> devAccesList) {
        this.devAccesList = devAccesList;
    }

    public List<VoNE> getFilterDevAccesList() {
        return this.filterDevAccesList;
    }

    public void setFilterDevAccesList(List<VoNE> filterDevAccesList) {
        this.filterDevAccesList = filterDevAccesList;
    }

    public static long getSerialVersionUID() {
        return 1L;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public ICollectorService getCollectorService() {
        return this.collectorService;
    }

    public void setCollectorService(ICollectorService collectorService) {
        this.collectorService = collectorService;
    }

    public ICollectorDeviceService getCollectorDeviceService() {
        return this.collectorDeviceService;
    }

    public void setCollectorDeviceService(ICollectorDeviceService collectorDeviceService) {
        this.collectorDeviceService = collectorDeviceService;
    }
}

