/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.collector.service.dao;

import com.hs.atic.sdk.bis.form.BlackholeNpForm;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.device.model.ConfigBlackholeNp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BlackholeNpDao
extends CommonDaoImpl {
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);

    public boolean isExist(String ip) {
        this.logger.info((Object)("BlackholeNpDao is exit black hole NP data by npIp=" + AticUtil.getcleanedMessage((String)ip)));
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        String hql = "from ConfigBlackholeNp where npIp = ?0";
        param.put(0, ip);
        List result = this.findByHql(hql, param);
        return result != null && !result.isEmpty();
    }

    public ConfigBlackholeNp getBlackholeNpByIp(String ip) {
        this.logger.info((Object)("query black hole NP data by npIp = " + AticUtil.getcleanedMessage((String)ip)));
        List result = new ArrayList();
        if (ip != null) {
            String hql = "from ConfigBlackholeNp where npIp = ?0";
            HashMap<Integer, String> param = new HashMap<Integer, String>();
            param.put(0, ip);
            result = this.findByHql(hql, param);
        }
        return (ConfigBlackholeNp)result.get(0);
    }

    public void remove(String ip) {
        this.logger.info((Object)"delete black hole NP data by npIp");
        String hql = "delete from ConfigBlackholeNp where npIp = ?0 ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{ip});
    }

    public Map<String, ConfigBlackholeNp> blackholeNpByEnableStatus() {
        HashMap<String, ConfigBlackholeNp> configBlackholeNpMap = new HashMap<String, ConfigBlackholeNp>();
        String hql = "from ConfigBlackholeNp";
        List result = this.findByHql(hql);
        if (!result.isEmpty()) {
            for (ConfigBlackholeNp blackholeNp : result) {
                configBlackholeNpMap.put(blackholeNp.getNpIp(), blackholeNp);
            }
        }
        return configBlackholeNpMap;
    }

    public List<BlackholeNpForm> queryAllBlackholeNP() {
        String hql = "from ConfigBlackholeNp ";
        List result = this.findByHql(hql);
        ArrayList<BlackholeNpForm> blackholeNpForms = new ArrayList<BlackholeNpForm>();
        if (result.isEmpty()) {
            return blackholeNpForms;
        }
        for (ConfigBlackholeNp configBlackholeNp : result) {
            BlackholeNpForm blackholeNpForm = new BlackholeNpForm();
            blackholeNpForm.setId(configBlackholeNp.getId());
            blackholeNpForm.setNpIp(configBlackholeNp.getNpIp());
            blackholeNpForm.setBlackholeThreshold(configBlackholeNp.getBlackholeThreshold());
            blackholeNpForm.setTimeLong(configBlackholeNp.getTimeLong());
            blackholeNpForms.add(blackholeNpForm);
        }
        return blackholeNpForms;
    }
}

