/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.collector.service.dao;

import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.resource.sdk.model.DeviceTypeRelation;
import com.hs.lego.cbb.resource.sdk.model.MainDeviceType;
import com.hs.lego.cbb.resource.sdk.model.SubDeviceType;
import com.hs.lego.cbb.user.sdk.service.CheckChildrenMoUtil;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.atic.device.model.Collector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;

public class CollectorDao
extends CommonDaoImpl {
    public Collector findById(Long id) {
        String hql = "from Collector where moId = ?0 ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, id.toString());
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (Collector)result.get(0);
    }

    public Collector findByIp(String collectorIp) {
        String hql = "from Collector where ipAddress = ?0 ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, collectorIp);
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (Collector)result.get(0);
    }

    public List<Collector> getAll() {
        return this.getAll(null);
    }

    public List<Collector> getAll(Map<String, String> conditionMap) {
        List result;
        String hql = "from Collector where (1=1) ";
        if (null != conditionMap) {
            String userId = conditionMap.get("currentUserId");
            String isAdmin = conditionMap.get("currentUserIsAdmin");
            if (!AticUtil.isNull((String)userId) && !AticUtil.isNull((String)isAdmin) && isAdmin.equalsIgnoreCase("false")) {
                long uid = Long.parseLong(userId);
                String authSql = CheckChildrenMoUtil.getInstanse().getHql(uid);
                hql = hql + " and moId in (" + authSql + ") ";
            }
        }
        if ((result = this.findByHql(hql)) != null) {
            return result;
        }
        return new ArrayList<Collector>();
    }

    public boolean isNameExists(Long id, String collectorName) {
        String hql = "from Collector where moId <> ?0 and name = ?1";
        String moId = id == null ? "-1" : id.toString();
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, moId);
        param.put(1, collectorName);
        List result = this.findByHql(hql, param);
        return result != null && !result.isEmpty();
    }

    public void delById(Long id) {
        String hql = "delete from Collector where moId = ?0 ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }

    public boolean isIpExists(Long id, String ipAddress) {
        String hql = "from Collector where moId <> ?0 and ipAddress = ?1";
        String moId = id == null ? "-1" : id.toString();
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, moId);
        param.put(1, ipAddress);
        List result = this.findByHql(hql, param);
        return result != null && !result.isEmpty();
    }

    public String[] getAllCollectorIP() {
        int i = 0;
        List<Collector> list = this.getAll();
        String[] arrIps = new String[list.size()];
        for (Collector collector : list) {
            arrIps[i++] = collector.getIpAddress();
        }
        return arrIps;
    }

    public String getCollectorByIp(String ipAddress) {
        String hql = "from Collector where ipAddress = ?0 ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, ipAddress);
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return ((Collector)result.get(0)).getCollectorName();
    }

    public Collector getCollectorEntryByIp(String ipAddress) {
        String hql = "from Collector where ipAddress = ?0 ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, ipAddress);
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (Collector)result.get(0);
    }

    public void processCollectorMO() {
        String mainType = "atic.portal.mainType.collector";
        String subType = "atic.portal.subType.ddosCollector";
        if (this.getHibernateTemplate().find("from MainDeviceType where name = ?0 ", new Object[]{mainType}).isEmpty()) {
            MainDeviceType main = new MainDeviceType();
            main.setName(mainType);
            this.getHibernateTemplate().save((Object)main);
            SubDeviceType sub = new SubDeviceType();
            sub.setName(subType);
            this.getHibernateTemplate().save((Object)sub);
            DeviceTypeRelation relation = new DeviceTypeRelation();
            relation.setParentType(mainType);
            relation.setChildType(subType);
            this.getHibernateTemplate().save((Object)relation);
        }
    }

    public void updateCollectorStates(Collector collector) {
        Session session = null;
        try {
            session = this.currentSession();
            String sql = "update lego.t_atic_collector set collector_status=?0 ,collector_cpuinfo=?1, collector_memoryinfo=?2, collector_diskinfo=?3 where moid = ?4";
            NativeQuery query = session.createSQLQuery(sql);
            query.setInteger(0, collector.getDdosCollectorStatus().intValue());
            query.setInteger(1, collector.getCollectorCpuinfo());
            query.setInteger(2, collector.getCollectorMemoryinfo());
            query.setString(3, collector.getCollectorDiskinfo());
            query.setLong(4, collector.getMoId().longValue());
            query.executeUpdate();
        }
        catch (HibernateException e) {
            this.logger.error((Object)"updateCollectorStates error");
            throw new LegoCheckedException(101L, (Throwable)e);
        }
    }
}

