/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.collector.service.impl;

import com.hs.atic.collector.entity.monitor.DeviceObj;
import com.hs.atic.rmi.SecneCollectorRMIProxy;
import com.hs.atic.rmi.SysManagerService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.base.dataprotect.service.IDataProtectService;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorDeviceService;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.collector.service.dao.CollectorDeviceDao;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceNfaCluster;
import com.huawei.atic.device.model.CollectorDevice;
import com.huawei.atic.sdk.bis.service.impl.DefendGroupServiceImpl;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.sdk.service.IClusterService;
import com.huawei.atic.secservice.policyengine.command.CommandAPI;
import com.huawei.atic.secservice.policyengine.commandutil.CmdParam;
import com.huawei.atic.util.CommonUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class CollectorDeviceServiceImpl
implements ICollectorDeviceService {
    private ReentrantLock lock = new ReentrantLock();
    private CollectorDeviceDao collectorDeviceDao;
    private IAticDeviceService aticDeviceService;
    private ICollectorService collectorService;
    private SecneCollectorRMIProxy collectorRMIProxy;
    private DefendGroupServiceImpl defendGroupService;
    private IDataProtectService dataProtectService;
    private IClusterService clusterService;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);

    @Override
    public List<Long> getDeviceAccess(Long collectorId) {
        ArrayList<Long> returnList = new ArrayList<Long>();
        List<CollectorDevice> list = this.collectorDeviceDao.getDeviceIdList(collectorId);
        if (list != null && !list.isEmpty()) {
            for (CollectorDevice cd : list) {
                returnList.add(cd.getDeviceId());
            }
        }
        return returnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchOperationResult addDeviceAccess(Long collectorId, List<Long> list) {
        this.lock.lock();
        try {
            BatchOperationResult result = new BatchOperationResult();
            ArrayList<BatchOperation> boList = new ArrayList<BatchOperation>();
            this.collectorService = (ICollectorService)ServiceContext.getInstance().getService("collectorService", ICollectorService.class);
            CollectorInfo cInfo = this.collectorService.getCollectorInfo(collectorId);
            if (null == cInfo) {
                throw new LegoCheckedException(201L);
            }
            SysManagerService sysManagerService = this.collectorRMIProxy.getSysManagerService(cInfo.getIpAddress());
            List<Long> listDevId = this.getDeviceAccess(collectorId);
            List<Long> listDevIdAll = this.getAllDeviceAccess();
            int fail = 0;
            for (Long devId : list) {
                BatchOperation bo;
                AticDevice device = null;
                try {
                    BatchOperation bo2;
                    device = this.aticDeviceService.getDeviceByMoid(devId);
                    if (listDevId.contains(devId) && 9 != device.getDeviceType()) {
                        ++fail;
                        this.logger.info((Object)("failed to associate the device to the collector by deviceId : " + devId + " because the device has been already associated to this collector"));
                        bo2 = new BatchOperation();
                        bo2.setErrorCode(570509L);
                        device = this.aticDeviceService.getDeviceByMoid(devId);
                        if (device != null) {
                            bo2.setTargetName(device.getName() + "_" + device.getIpAddress());
                        }
                        boList.add(bo2);
                        continue;
                    }
                    if (listDevIdAll.contains(devId) && 9 != device.getDeviceType()) {
                        ++fail;
                        this.logger.info((Object)("failed to associate the device to the collector by deviceId : " + devId + " because the device has been already associated to another collector"));
                        bo2 = new BatchOperation();
                        bo2.setErrorCode(570509L);
                        device = this.aticDeviceService.getDeviceByMoid(devId);
                        if (device != null) {
                            bo2.setTargetName(device.getName() + "_" + device.getIpAddress());
                        }
                        boList.add(bo2);
                        continue;
                    }
                    if (null != sysManagerService) {
                        DeviceObj deviceObj;
                        if (device.getDeviceType() == 1) {
                            this.translate(devId, cInfo, false);
                            deviceObj = new DeviceObj();
                            deviceObj.setMoId(devId.longValue());
                            deviceObj.setDeviceIp(device.getIpAddress());
                            if (AticUtil.isNull((String)device.getLogIp())) {
                                device.setLogIp(device.getIpAddress());
                            }
                            deviceObj.setLogIp(device.getLogIp());
                            deviceObj.setDeviceType(device.getDeviceType());
                            deviceObj.setServiceType(device.getDdosType());
                            deviceObj.setLogPwd(this.dataProtectService.sdpDecrypt(device.getLogPwd(), 0L).toString());
                            deviceObj.setEncryptType(device.getEncryptType());
                            sysManagerService.addDevice(deviceObj);
                        } else if (device.getDeviceType() == 9) {
                            List<AticDevice> nfaList = this.clusterService.getDeviceListByVirtualIp(device.getIpAddress());
                            for (AticDevice nfAticDevice : nfaList) {
                                this.translate((Long)nfAticDevice.getMoId(), cInfo, false);
                                DeviceObj deviceObj2 = new DeviceObj();
                                deviceObj2.setMoId(nfAticDevice.getMoId());
                                deviceObj2.setDeviceIp(device.getIpAddress());
                                deviceObj2.setLogIp(nfAticDevice.getIpAddress());
                                deviceObj2.setDeviceType(8);
                                deviceObj2.setServiceType(nfAticDevice.getDdosType());
                                deviceObj2.setLogPwd(this.dataProtectService.sdpDecrypt(nfAticDevice.getLogPwd(), 0L).toString());
                                deviceObj2.setEncryptType(nfAticDevice.getEncryptType());
                                sysManagerService.addDevice(deviceObj2);
                                this.logger.info((Object)("add collector access ip=" + deviceObj2.getDeviceIp() + "deviceId =" + deviceObj2.getMoId()));
                            }
                        } else if (device.getDeviceType() == 8) {
                            this.translate(devId, cInfo, false);
                            deviceObj = new DeviceObj();
                            deviceObj.setMoId(devId.longValue());
                            deviceObj.setDeviceIp(device.getIpAddress());
                            if (AticUtil.isNull((String)device.getLogIp())) {
                                device.setLogIp(device.getIpAddress());
                            }
                            deviceObj.setLogIp(device.getLogIp());
                            deviceObj.setDeviceType(device.getDeviceType());
                            deviceObj.setServiceType(device.getDdosType());
                            deviceObj.setLogPwd(this.dataProtectService.sdpDecrypt(device.getLogPwd(), 0L).toString());
                            deviceObj.setEncryptType(device.getEncryptType());
                            sysManagerService.addDevice(deviceObj);
                        }
                        List<CollectorDevice> collectorDevices = this.collectorDeviceDao.getByCollectorIdAndDevId(collectorId, devId);
                        if (null == collectorDevices || collectorDevices.isEmpty()) {
                            CollectorDevice cd = new CollectorDevice();
                            cd.setCollectorId(collectorId);
                            cd.setDeviceId(devId);
                            this.collectorDeviceDao.save(cd);
                        }
                        bo = new BatchOperation();
                        bo.setErrorCode(0L);
                        bo.setTargetName(device.getName() + "_" + device.getIpAddress());
                        bo.setOptDetail("common.collector.access.success");
                        bo.setDetailParam(new String[]{cInfo.getName(), device.getName()});
                        boList.add(bo);
                        continue;
                    }
                    ++fail;
                    bo2 = new BatchOperation();
                    bo2.setErrorCode(570001L);
                    bo2.setTargetName(device.getName());
                    boList.add(bo2);
                }
                catch (LegoCheckedException e) {
                    ++fail;
                    this.logger.error((Object)("save Collector device relation failed! collectorId:" + collectorId + "List<DeviceId>: " + list.toString() + " " + e.getMessage()));
                    bo = new BatchOperation();
                    bo.setErrorCode(e.getErrorCode());
                    if (null != device) {
                        bo.setTargetName(device.getName());
                    } else {
                        this.logger.error((Object)"save Collector device relation failed! device is null.");
                    }
                    boList.add(bo);
                }
                catch (Exception e) {
                    ++fail;
                    this.logger.error((Object)("save Collector device relation failed! collectorId:" + collectorId + "List<DeviceId>: " + list.toString() + " " + e.getMessage()));
                    bo = new BatchOperation();
                    bo.setErrorCode(570507L);
                    bo.setTargetName(device.getName());
                    boList.add(bo);
                }
            }
            result.setResult(boList);
            result.setFailCount(fail);
            result.setTotalCount(list.size());
            result.setSucceedCount(list.size() - fail);
            this.logger.info((Object)"leave addDeviceAccess()");
            BatchOperationResult batchOperationResult = result;
            return batchOperationResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchOperationResult resetDeviceAccess(Long collectorId, String oldIp) {
        this.lock.lock();
        try {
            BatchOperationResult result = new BatchOperationResult();
            ArrayList<BatchOperation> boList = new ArrayList<BatchOperation>();
            CollectorInfo cInfo = this.collectorService.getCollectorInfo(collectorId);
            if (null == cInfo) {
                throw new LegoCheckedException(201L);
            }
            List<Long> list = this.getDeviceAccess(collectorId);
            int fail = 0;
            for (Long devId : list) {
                BatchOperation bo;
                AticDevice device = null;
                try {
                    DeviceObj deviceObj;
                    device = this.aticDeviceService.getDeviceByMoid(devId);
                    if (device.getDeviceType() == 1) {
                        this.translate(devId, cInfo.getIpAddress(), oldIp);
                        deviceObj = new DeviceObj();
                        deviceObj.setMoId(devId.longValue());
                        deviceObj.setDeviceIp(device.getIpAddress());
                        if (AticUtil.isNull((String)device.getLogIp())) {
                            device.setLogIp(device.getIpAddress());
                        }
                        deviceObj.setLogIp(device.getLogIp());
                        deviceObj.setDeviceType(device.getDeviceType());
                        deviceObj.setServiceType(device.getDdosType());
                        deviceObj.setLogPwd(this.dataProtectService.sdpDecrypt(device.getLogPwd(), 0L).toString());
                        deviceObj.setEncryptType(device.getEncryptType());
                    } else if (device.getDeviceType() == 8) {
                        this.translate(devId, cInfo.getIpAddress(), oldIp);
                        deviceObj = new DeviceObj();
                        deviceObj.setMoId(devId.longValue());
                        deviceObj.setDeviceIp(device.getIpAddress());
                        if (AticUtil.isNull((String)device.getLogIp())) {
                            device.setLogIp(device.getIpAddress());
                        }
                        deviceObj.setLogIp(device.getLogIp());
                        deviceObj.setDeviceType(device.getDeviceType());
                        deviceObj.setServiceType(device.getDdosType());
                        deviceObj.setLogPwd(this.dataProtectService.sdpDecrypt(device.getLogPwd(), 0L).toString());
                        deviceObj.setEncryptType(device.getEncryptType());
                    }
                    List<CollectorDevice> collectorDevices = this.collectorDeviceDao.getByCollectorIdAndDevId(collectorId, devId);
                    if (null == collectorDevices || collectorDevices.isEmpty()) {
                        CollectorDevice cd = new CollectorDevice();
                        cd.setCollectorId(collectorId);
                        cd.setDeviceId(devId);
                        this.collectorDeviceDao.save(cd);
                    }
                    bo = new BatchOperation();
                    bo.setErrorCode(0L);
                    bo.setTargetName(device.getName() + "_" + device.getIpAddress());
                    bo.setOptDetail("common.collector.access.success");
                    bo.setDetailParam(new String[]{cInfo.getName(), device.getName()});
                    boList.add(bo);
                }
                catch (LegoCheckedException e) {
                    ++fail;
                    this.logger.error((Object)("save Collector device relation failed! collectorId:" + collectorId + "List<DeviceId>: " + list.toString() + " " + e.getMessage()));
                    bo = new BatchOperation();
                    bo.setErrorCode(e.getErrorCode());
                    if (null != device) {
                        bo.setTargetName(device.getName());
                    } else {
                        this.logger.error((Object)"save Collector device relation failed! device is null.");
                    }
                    boList.add(bo);
                }
                catch (Exception e) {
                    ++fail;
                    this.logger.error((Object)("save Collector device relation failed! collectorId:" + collectorId + "List<DeviceId>: " + list.toString() + " " + e.getMessage()));
                    bo = new BatchOperation();
                    bo.setErrorCode(570507L);
                    bo.setTargetName(device.getName());
                    boList.add(bo);
                }
            }
            result.setResult(boList);
            result.setFailCount(fail);
            result.setTotalCount(list.size());
            result.setSucceedCount(list.size() - fail);
            this.logger.info((Object)"leave addDeviceAccess()");
            BatchOperationResult batchOperationResult = result;
            return batchOperationResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Boolean updateLogIp(AticDevice device) {
        ArrayList<CmdParam> paramList = new ArrayList<CmdParam>();
        ArrayList<String> cmds = new ArrayList<String>();
        ArrayList<String> reComd = new ArrayList<String>();
        CmdParam tmpCmdParam = new CmdParam();
        tmpCmdParam.setCmdID("SYS");
        paramList.add(tmpCmdParam);
        paramList.add(this.getCmdParam("DEPLOY_LOCAL_IP", "localIp", device.getLogIp()));
        String xmlPath = "conf/aticCommands.xml";
        CommandAPI cAPI = new CommandAPI();
        List<String> list = cAPI.doTranslate(xmlPath, "collector", paramList);
        cmds.addAll(list);
        reComd.addAll(list);
        this.logger.warn((Object)("cmds:" + this.getcleanedMessage(((Object)cmds).toString())));
        List<String> results = null;
        StringBuffer logPwd = this.dataProtectService.sdpDecrypt(device.getLogPwd(), 0L);
        if (device.getVersion() != null) {
            if (CommonUtil.isNewDevice(device)) {
                if (device.getEncryptType() == 1) {
                    cmds.add("anti-ddos packet-capture key " + logPwd);
                    cmds.add("anti-ddos packet-capture key enable");
                    reComd.add("anti-ddos packet-capture key *** ");
                    reComd.add("anti-ddos packet-capture key enable");
                } else if (device.getEncryptType() == 2) {
                    cmds.add("undo anti-ddos packet-capture key enable");
                    reComd.add("undo anti-ddos packet-capture key enable");
                }
            } else {
                String encryptionKey = logPwd.substring(0, 32);
                cmds.add("anti-ddos packet-capture key " + encryptionKey);
                reComd.add("anti-ddos packet-capture key *** ");
            }
        }
        if (!AticUtil.isCmdSucess(results = this.aticDeviceService.execCmd(cmds, device.getMoId()))) {
            ArrayList<String> newResult = new ArrayList<String>();
            for (String string : results) {
                if (string.contains("anti-ddos packet-capture key")) {
                    newResult.add("anti-ddos packet-capture key ***");
                    continue;
                }
                newResult.add(string);
            }
            this.logger.error((Object)("execCmd failed! cmds :" + this.getcleanedMessage(((Object)reComd).toString()) + " results:" + this.getcleanedMessage(((Object)newResult).toString())));
            return false;
        }
        return true;
    }

    @Override
    public boolean updateDeviceAccess(AticDevice device, String collectorIp) {
        boolean result = false;
        SysManagerService sysManagerService = this.collectorRMIProxy.getSysManagerService(collectorIp);
        DeviceObj deviceObj = new DeviceObj();
        deviceObj.setMoId(device.getMoId());
        if (null != device.getLogIp() && !"".equals(device.getLogIp())) {
            deviceObj.setLogIp(device.getLogIp());
        } else {
            deviceObj.setLogIp(device.getIpAddress());
        }
        if (this.clusterService.isBelongCluster(device.getMoId())) {
            AticDeviceNfaCluster aticDeviceNfaCluster = this.clusterService.getClusterByNfaId(device.getMoId());
            AticDevice aDevice = this.aticDeviceService.getDeviceByMoid(aticDeviceNfaCluster.getClusterId());
            deviceObj.setDeviceIp(aDevice.getIpAddress());
        } else {
            deviceObj.setDeviceIp(device.getIpAddress());
        }
        deviceObj.setDeviceType(device.getDeviceType());
        deviceObj.setServiceType(device.getDdosType());
        deviceObj.setLogPwd(this.dataProtectService.sdpDecrypt(device.getLogPwd(), 0L).toString());
        deviceObj.setEncryptType(device.getEncryptType());
        if (null == sysManagerService) {
            return result;
        }
        try {
            result = sysManagerService.updateDevice(deviceObj);
        }
        catch (RemoteException e) {
            this.logger.error((Object)("update logIp failed! deviceIp :" + this.getcleanedMessage(device.getIpAddress())));
        }
        return result;
    }

    private void translate(Long devId, CollectorInfo cInfo, boolean isUndo) {
        ArrayList<CmdParam> paramList = new ArrayList<CmdParam>();
        ArrayList<String> cmds = new ArrayList<String>();
        ArrayList<String> reComd = new ArrayList<String>();
        CmdParam tmpCmdParam = new CmdParam();
        tmpCmdParam.setCmdID("SYS");
        paramList.add(tmpCmdParam);
        AticDevice device = this.aticDeviceService.getDeviceByMoid(devId);
        if (!isUndo) {
            String localIp = device.getLogIp();
            if (AticUtil.isNull((String)localIp)) {
                localIp = device.getIpAddress();
            }
            paramList.add(this.getCmdParam("DEPLOY_LOCAL_IP", "localIp", localIp));
            paramList.add(this.getCmdParam("DEPLOY_SERVER_IP", "serverIp", cInfo.getIpAddress()));
        } else {
            paramList.add(this.getCmdParam("UNDO_LOCAL_IP", "", ""));
            paramList.add(this.getCmdParam("UNDO_SERVER_IP", "serverIp", cInfo.getIpAddress()));
        }
        String xmlPath = "conf/aticCommands.xml";
        CommandAPI cAPI = new CommandAPI();
        List<String> list = cAPI.doTranslate(xmlPath, "collector", paramList);
        cmds.addAll(list);
        reComd.addAll(list);
        List<String> results = null;
        StringBuffer logPwd = this.dataProtectService.sdpDecrypt(device.getLogPwd(), 0L);
        if (device.getVersion() != null) {
            if (!isUndo) {
                if (CommonUtil.isNewDevice(device)) {
                    cmds.add("anti-ddos packet-capture key " + logPwd.toString());
                    reComd.add("anti-ddos packet-capture key *** ");
                    if (1 == device.getEncryptType()) {
                        cmds.add("anti-ddos packet-capture key enable");
                        reComd.add("anti-ddos packet-capture key enable");
                    }
                } else {
                    cmds.add("anti-ddos packet-capture key " + logPwd.substring(0, 32));
                    reComd.add("anti-ddos packet-capture key *** ");
                }
            } else if (CommonUtil.isNewDevice(device)) {
                cmds.add("undo anti-ddos packet-capture key enable");
                reComd.add("undo anti-ddos packet-capture key enable");
            }
        }
        if (!AticUtil.isCmdSucess(results = this.aticDeviceService.execCmd(cmds, devId))) {
            boolean flag = false;
            ArrayList<String> newResult = new ArrayList<String>();
            this.logger.info((Object)("results : " + this.getcleanedMessage(results.toString())));
            for (String string : results) {
                if (string.contains("anti-ddos packet-capture key")) {
                    newResult.add("anti-ddos packet-capture key ***");
                    flag = true;
                    continue;
                }
                newResult.add(string);
            }
            this.logger.error((Object)("execCmd failed! cmds :" + this.getcleanedMessage(((Object)reComd).toString()) + " results:" + this.getcleanedMessage(((Object)newResult).toString())));
            if (flag && AticUtil.isNull((String)device.getLogPwd())) {
                throw new LegoCheckedException(570515L);
            }
            throw new LegoCheckedException(570503L);
        }
    }

    private void translate(Long devId, String newCollectorIp, String oldCollectorIp) {
        ArrayList<CmdParam> paramList = new ArrayList<CmdParam>();
        ArrayList<String> cmds = new ArrayList<String>();
        ArrayList<String> reCmds = new ArrayList<String>();
        List<String> results = null;
        CmdParam tmpCmdParam = new CmdParam();
        tmpCmdParam.setCmdID("SYS");
        paramList.add(tmpCmdParam);
        paramList.add(this.getCmdParam("UNDO_SERVER_IP", "serverIp", oldCollectorIp));
        paramList.add(this.getCmdParam("DEPLOY_SERVER_IP", "serverIp", newCollectorIp));
        String xmlPath = "conf/aticCommands.xml";
        CommandAPI cAPI = new CommandAPI();
        List<String> list = cAPI.doTranslate(xmlPath, "collector", paramList);
        cmds.addAll(list);
        reCmds.addAll(list);
        cmds.add("undo info-center loghost " + oldCollectorIp);
        reCmds.add("undo info-center loghost " + oldCollectorIp);
        cmds.add("info-center loghost " + newCollectorIp + " port 3514");
        reCmds.add("info-center loghost " + newCollectorIp + " port 3514");
        this.logger.info((Object)("cmds : " + ((Object)cmds).toString()));
        results = this.aticDeviceService.execCmd(cmds, devId);
        if (!AticUtil.isCmdSucess(results)) {
            ArrayList<String> newResult = new ArrayList<String>();
            this.logger.info((Object)("results : " + this.getcleanedMessage(results.toString())));
            for (String string : results) {
                newResult.add(string);
            }
            this.logger.error((Object)("execCmd failed! cmds :" + this.getcleanedMessage(((Object)reCmds).toString()) + " results:" + this.getcleanedMessage(((Object)newResult).toString())));
            throw new LegoCheckedException(570503L);
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    @Override
    public Long getCollectorIdByDevId(Long devId) {
        return this.collectorDeviceDao.getCollectorIdByDevId(devId);
    }

    @Override
    public int delByCollectorId(Long collectorId) {
        return this.collectorDeviceDao.delByCollectorId(collectorId);
    }

    @Override
    public BatchOperationResult delDeviceAccess(Long collectorId, List<Long> list) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> boList = new ArrayList<BatchOperation>();
        CollectorInfo cInfo = this.collectorService.getCollectorInfo(collectorId);
        this.clusterService = (IClusterService)ServiceContext.getInstance().getService("clusterService", IClusterService.class);
        if (cInfo == null) {
            BatchOperation bo = new BatchOperation();
            bo.setErrorCode(570007L);
            boList.add(bo);
            result.setResult(boList);
            result.setFailCount(list.size());
            result.setTotalCount(list.size());
            result.setSucceedCount(0);
            return result;
        }
        String collectorIp = cInfo.getIpAddress();
        SysManagerService sysManagerService = this.collectorRMIProxy.getSysManagerService(collectorIp);
        int fail = 0;
        for (Long deviceId : list) {
            boolean isClusterNfa = this.clusterService.isBelongCluster(deviceId);
            List<CollectorDevice> listCd = null;
            if (isClusterNfa) {
                AticDeviceNfaCluster nfaCluster = this.clusterService.getClusterByNfaId(deviceId);
                listCd = this.collectorDeviceDao.getByCollectorIdAndDevId(collectorId, nfaCluster.getClusterId());
            } else {
                listCd = this.collectorDeviceDao.getByCollectorIdAndDevId(collectorId, deviceId);
            }
            if (null == listCd || listCd.isEmpty()) {
                ++fail;
                this.logger.info((Object)("failed to delete the device from the collector by deviceId : " + deviceId));
                BatchOperation bo = new BatchOperation();
                bo.setErrorCode(570510L);
                AticDevice device = this.aticDeviceService.getDeviceByMoid(deviceId);
                if (device != null) {
                    bo.setTargetName(device.getName() + "_" + device.getIpAddress());
                }
                boList.add(bo);
                continue;
            }
            for (CollectorDevice cd : listCd) {
                BatchOperation bo;
                AticDevice device = null;
                try {
                    BatchOperation bo2;
                    device = isClusterNfa ? this.aticDeviceService.getDeviceByMoid(deviceId) : this.aticDeviceService.getDeviceByMoid(cd.getDeviceId());
                    if (null != sysManagerService) {
                        if (null == device) continue;
                        if (device.getDeviceType() == 1) {
                            this.translate(cd.getDeviceId(), cInfo, true);
                            sysManagerService.deleteDevice(deviceId);
                        } else if (device.getDeviceType() == 8) {
                            this.translate(deviceId, cInfo, true);
                            sysManagerService.deleteDevice(deviceId);
                        } else if (device.getDeviceType() == 9) {
                            List<AticDevice> nfaList = this.clusterService.getDeviceListByVirtualIp(device.getIpAddress());
                            for (AticDevice nfaDevice : nfaList) {
                                this.translate((Long)nfaDevice.getMoId(), cInfo, true);
                                sysManagerService.deleteDevice(nfaDevice.getMoId());
                                sysManagerService.deleteDevice(nfaDevice.getMoId());
                            }
                        }
                        if (this.collectorDeviceDao.get(cd.getId()) == null) {
                            ++fail;
                            this.logger.info((Object)("failed to delete the device from the collector by deviceId : " + deviceId));
                            bo2 = new BatchOperation();
                            bo2.setErrorCode(570510L);
                            device = this.aticDeviceService.getDeviceByMoid(deviceId);
                            if (device != null) {
                                bo2.setTargetName(device.getName() + "_" + device.getIpAddress());
                            }
                            boList.add(bo2);
                            continue;
                        }
                        if (!isClusterNfa) {
                            this.collectorDeviceDao.remove(cd.getId());
                        }
                        bo2 = new BatchOperation();
                        bo2.setTargetName(device.getName() + "_" + device.getIpAddress());
                        bo2.setOptDetail("common.collector.access.delete.success");
                        bo2.setDetailParam(new String[]{cInfo.getName(), device.getName()});
                        boList.add(bo2);
                        continue;
                    }
                    ++fail;
                    bo2 = new BatchOperation();
                    bo2.setErrorCode(570001L);
                    if (null != device) {
                        bo2.setTargetName(device.getName());
                    }
                    boList.add(bo2);
                }
                catch (LegoCheckedException e) {
                    ++fail;
                    this.logger.error((Object)("save Collector device relation failed! collectorId:" + collectorId + "List<DeviceId>: " + list.toString() + " " + e.getMessage()));
                    bo = new BatchOperation();
                    bo.setErrorCode(e.getErrorCode());
                    if (null != device) {
                        if (!device.getName().isEmpty()) {
                            bo.setTargetName(device.getName());
                        } else {
                            this.logger.error((Object)"save Collector device relation failed! name is null.");
                        }
                    } else {
                        this.logger.error((Object)"save Collector device relation failed! device is null.");
                    }
                    boList.add(bo);
                }
                catch (Exception e) {
                    ++fail;
                    this.logger.error((Object)("save Collector device relation failed! collectorId:" + collectorId + "List<DeviceId>: " + list.toString() + " " + e.getMessage()));
                    bo = new BatchOperation();
                    bo.setErrorCode(570507L);
                    bo.setTargetName(device.getName());
                    boList.add(bo);
                }
            }
        }
        result.setResult(boList);
        result.setFailCount(fail);
        result.setTotalCount(list.size());
        result.setSucceedCount(list.size() - fail);
        this.logger.info((Object)"leave addDeviceAccess()");
        return result;
    }

    @Override
    public List<Long> getAllDeviceAccess() {
        return this.collectorDeviceDao.getDeviceIdList();
    }

    @Override
    public int getDevCountByCollectorId(Long collectorId, Map<String, String> queryMap) {
        return this.collectorDeviceDao.getDevCountByCollectorId(collectorId, queryMap);
    }

    @Override
    public void respondMsgDelDevice(List<Long> devIds) {
        for (Long devId : devIds) {
            Long collectorId = this.collectorDeviceDao.getCollectorIdByDevId(devId);
            this.clusterService = (IClusterService)ServiceContext.getInstance().getService("clusterService", IClusterService.class);
            if (collectorId == null) continue;
            this.collectorDeviceDao.delByDevId(devId);
            String collectorIp = this.collectorService.getCollectorInfo(collectorId).getIpAddress();
            SysManagerService sysManagerService = this.collectorRMIProxy.getSysManagerService(collectorIp);
            try {
                if (sysManagerService == null) continue;
                AticDevice device = this.aticDeviceService.getDeviceByMoid(devId);
                if (null != device && 9 == device.getDeviceType()) {
                    List<AticDeviceNfaCluster> nfaList = this.clusterService.getBindNfaDevice(devId);
                    for (AticDeviceNfaCluster item : nfaList) {
                        sysManagerService.deleteDevice(item.getDeviceId());
                    }
                    continue;
                }
                sysManagerService.deleteDevice(devId);
            }
            catch (RemoteException e) {
                this.logger.error((Object)("sysManagerService.deleteDevice failed! devId:" + devId + ". " + e.getMessage()));
            }
        }
    }

    private CmdParam getCmdParam(String cmdID, String paramName, String paramInput) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID(cmdID);
        if (!"".equals(paramName) && !"".equals(paramInput)) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(paramName, paramInput);
            cmdParam.setParams(params);
        }
        return cmdParam;
    }

    public SecneCollectorRMIProxy getCollectorRMIProxy() {
        return this.collectorRMIProxy;
    }

    public void setCollectorRMIProxy(SecneCollectorRMIProxy collectorRMIProxy) {
        this.collectorRMIProxy = collectorRMIProxy;
    }

    public DefendGroupServiceImpl getDefendGroupService() {
        return this.defendGroupService;
    }

    public void setDefendGroupService(DefendGroupServiceImpl defendGroupService) {
        this.defendGroupService = defendGroupService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public ICollectorService getCollectorService() {
        return this.collectorService;
    }

    public void setCollectorService(ICollectorService collectorService) {
        this.collectorService = collectorService;
    }

    public CollectorDeviceDao getCollectorDeviceDao() {
        return this.collectorDeviceDao;
    }

    public void setCollectorDeviceDao(CollectorDeviceDao collectorDeviceDao) {
        this.collectorDeviceDao = collectorDeviceDao;
    }

    public IDataProtectService getDataProtectService() {
        return this.dataProtectService;
    }

    public void setDataProtectService(IDataProtectService dataProtectService) {
        this.dataProtectService = dataProtectService;
    }

    public IClusterService getClusterService() {
        return this.clusterService;
    }

    public void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }
}

