/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.collector.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.collector.util.Pair;
import com.huawei.atic.collector.util.XMLParseProcess;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public final class SysLogCollectorUtil {
    private static Log log4j = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private static final String COLLECTORTYPEPATH = "CollectorType.xml";
    private static final List<Pair<String, String>> COLLECTORTYPE_ZH = new ArrayList<Pair<String, String>>();
    private static final List<Pair<String, String>> COLLECTORTYPE_EN = new ArrayList<Pair<String, String>>();
    private static final String ZH_CN = "zh_CN";
    private static final String EN = "en";
    private static final String NODE_KEY = "key";
    private static SysLogCollectorUtil instance = null;

    private SysLogCollectorUtil() {
    }

    public static SysLogCollectorUtil getInstance() {
        return instance == null ? new SysLogCollectorUtil() : instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadConfig() {
        InputStream input = null;
        try {
            Document doc;
            String fileName = COLLECTORTYPEPATH;
            log4j.info((Object)("loadConfig collectors - file name : " + fileName));
            ClassLoader loader = SysLogCollectorUtil.class.getClassLoader();
            if (null != loader) {
                input = loader.getResourceAsStream(fileName);
            }
            if ((doc = XMLParseProcess.read(input)) == null) {
                log4j.info((Object)("loadConfig doc is null - file name : " + fileName));
                if (null == input) return;
                SysLogCollectorUtil.closeInputStream(input);
                return;
            }
            Element rootNode = doc.getRootElement();
            List<Element> collNodes = XMLParseProcess.getChilds(rootNode, "language");
            log4j.info((Object)("loadConfig method rootNode : " + collNodes));
            if (collNodes != null) {
                for (Element et : collNodes) {
                    List els = et.elements();
                    if (StringUtils.equals((CharSequence)et.attributeValue(NODE_KEY), (CharSequence)ZH_CN)) {
                        for (Element el : els) {
                            COLLECTORTYPE_ZH.add(new Pair<String, String>(XMLParseProcess.getAtrribute(el, NODE_KEY), el.getText()));
                        }
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)et.attributeValue(NODE_KEY), (CharSequence)EN)) continue;
                    for (Element el : els) {
                        COLLECTORTYPE_EN.add(new Pair<String, String>(XMLParseProcess.getAtrribute(el, NODE_KEY), el.getText()));
                    }
                }
            }
            if (null == input) return;
        }
        catch (DocumentException e) {
            log4j.error((Object)("parse CollectorType.xml exception: " + e.getMessage()));
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (MalformedURLException e2) {
                log4j.error((Object)("parse CollectorType.xml exception: " + e2.getMessage()));
                return;
            }
        }
        finally {
            if (null != input) {
                SysLogCollectorUtil.closeInputStream(input);
            }
        }
        SysLogCollectorUtil.closeInputStream(input);
        return;
    }

    private static void closeInputStream(InputStream input) {
        try {
            input.close();
        }
        catch (IOException e) {
            log4j.error((Object)"input close error");
        }
        finally {
            if (null != input) {
                input = null;
            }
        }
    }

    public List<Pair<String, String>> getCollectorType(Locale local) {
        if (StringUtils.equals((CharSequence)local.toString(), (CharSequence)ZH_CN)) {
            return this.removeEl(COLLECTORTYPE_ZH);
        }
        return this.removeEl(COLLECTORTYPE_EN);
    }

    public String getPairValueByPairKey(String key, Locale locale) {
        Iterator<Pair<String, String>> iterator;
        String unknown = "unknown";
        Iterator<Pair<String, String>> iterator2 = iterator = locale.toString().equals(ZH_CN) ? COLLECTORTYPE_ZH.iterator() : COLLECTORTYPE_EN.iterator();
        if (iterator == null) {
            return unknown;
        }
        while (iterator.hasNext()) {
            Pair<String, String> pair = iterator.next();
            if (!pair.getKey().equalsIgnoreCase(key)) continue;
            return pair.getValue();
        }
        return unknown;
    }

    private List<Pair<String, String>> removeEl(List<Pair<String, String>> els) {
        ArrayList<Pair<String, String>> srcEls = new ArrayList<Pair<String, String>>();
        srcEls.addAll(els);
        Iterator iter = srcEls.iterator();
        Pair p = null;
        while (iter.hasNext()) {
            p = (Pair)iter.next();
            if (Integer.parseInt((String)p.getKey()) != 3) continue;
            if (null != ServiceContext.getInstance().getService("collectorService", ICollectorService.class)) break;
            iter.remove();
            break;
        }
        return srcEls;
    }

    static {
        SysLogCollectorUtil.loadConfig();
    }
}

