/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.collector.util;

import com.hs.atic.util.XmlUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public abstract class XMLParseProcess {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);

    public static Document read(File file) throws MalformedURLException, DocumentException, SAXException {
        SAXReader reader = new SAXReader();
        if (file.exists()) {
            XmlUtil.setSecureFeatureForSaxReader((SAXReader)reader);
            Document document = reader.read(file);
            return document;
        }
        return null;
    }

    public static Document read(InputStream file) throws MalformedURLException, DocumentException {
        SAXReader saxReader = new SAXReader();
        Document document = null;
        try {
            XmlUtil.setSecureFeatureForSaxReader((SAXReader)saxReader);
            document = saxReader.read(file);
        }
        catch (SAXException e) {
            logger.error((Object)("read configFile error!" + e.getMessage()));
        }
        return document;
    }

    public static boolean isExistDir(String dirStr) {
        File file = new File(dirStr);
        return file.exists();
    }

    public static Element getRootElement(Document doc) {
        if (doc == null) {
            return null;
        }
        return doc.getRootElement();
    }

    public static String getAtrribute(Element element, String attributeName) {
        if (element == null) {
            return "";
        }
        Attribute attribute = element.attribute(attributeName);
        if (attribute == null) {
            return "";
        }
        return attribute.getText();
    }

    public static List<Element> getChilds(Element element) {
        if (element == null) {
            return null;
        }
        ArrayList<Element> elesList = new ArrayList<Element>();
        Element child = null;
        Iterator i = element.elementIterator();
        while (i.hasNext()) {
            child = (Element)i.next();
            elesList.add(child);
        }
        return elesList;
    }

    public static List<Element> getChilds(Element element, String childName) {
        if (element == null) {
            return null;
        }
        ArrayList<Element> eleList = new ArrayList<Element>();
        Element child = null;
        Iterator it = element.elementIterator(childName);
        while (it.hasNext()) {
            child = (Element)it.next();
            eleList.add(child);
        }
        return eleList;
    }

    public static String getChildAtrribute(Element parent, String childName, String attributeName) {
        if (parent == null) {
            return "";
        }
        Element element = parent.element(childName);
        if (element == null) {
            return "";
        }
        return XMLParseProcess.getAtrribute(element, attributeName);
    }

    public static String getChildText(Element parent, String childName) {
        if (parent == null) {
            return "";
        }
        Element element = parent.element(childName);
        if (element == null) {
            return "";
        }
        return element.getText();
    }

    public static List<Element> getElementsByName(List<Element> elementList, Element element, String nodeName) {
        if (element.getName().equalsIgnoreCase(nodeName)) {
            elementList.add(element);
        }
        Iterator it = element.elementIterator();
        while (it.hasNext()) {
            Element child = (Element)it.next();
            XMLParseProcess.getElementsByName(elementList, child, nodeName);
        }
        return elementList;
    }

    public static Element getFirstElement(Element element, String childName) {
        List<Element> childs = XMLParseProcess.getChilds(element, childName);
        if (childs != null && !childs.isEmpty()) {
            return childs.get(0);
        }
        return null;
    }
}

