/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.comm.south.ssh;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.comm.south.util.SouthUtil;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class Ssh2Connector {
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private static final String MORE = "---- More ----";
    private static final String MORE_FLAG = "[42D";
    private static final String DEVICE_WRAP_FLAG = "\u001b[1D";
    private static final String MORE_BLANK_WRAP_FLAG = " \u001b[1D";
    private static final String LOGIN_FAIL = "Login failed";
    private static final String LOGIN_FAIL_EXT = "Failed to authenticate";
    private static final int NUMBER_FIVE_HUNDRED_AND_SEVENTEEN = 517;
    private static final int NUMBER_EIGHT = 8;
    private static final int SLEEPTIME = 500;
    private static final int NUMBER_HUNDRED = 100;
    private static final int MILLISSECOND2SECOND = 1000;
    private List<String> cliPromptRegexs = null;
    private String currentCharsetName = null;
    private boolean connected = false;
    private Channel channel = null;
    private Session session = null;
    private OutputStream out = null;
    private InputStream in = null;
    private BufferedReader reader = null;
    private PrintWriter writer = null;
    private int soTimeout = 5000;
    private int connectTimeout = 5000;
    private String host = "";
    private String hostKey = null;
    private int port = 22;
    private String userName = "";
    private StringBuffer passkey = new StringBuffer();
    private int loginMode = 0;

    public void connect(String hostIp, String userAccounts, StringBuffer userPassword) throws LegoCheckedException {
        this.connect(hostIp, this.port, userAccounts, userPassword);
    }

    public void connect(String hostIp, int hostPort, String userAccount, StringBuffer userPassword, long loginTimeOut, long respTimeOut) throws LegoCheckedException {
        this.connectTimeout = (int)loginTimeOut * 1000;
        this.soTimeout = (int)respTimeOut * 1000;
        this.connect(hostIp, hostPort, userAccount, userPassword);
    }

    public void connect(String hostIp, int hostPort, String userAccount, String rsaPrivateKey, String keyFilePass) throws LegoCheckedException {
        this.connect(hostIp, hostPort, userAccount, this.passkey);
    }

    public void connect(String hostIp, int hostPort, String userAccount, StringBuffer userPassword, String rsaPrivateKey, long loginTimeOut, long respTimeOut) throws LegoCheckedException {
        this.connectTimeout = (int)loginTimeOut * 1000;
        this.soTimeout = (int)respTimeOut * 1000;
        this.connect(hostIp, hostPort, userAccount, userPassword);
    }

    public void connect(String hostIp, int hostPort, String userAccount, StringBuffer userPassword, String rsaPrivateKey, StringBuffer keyFilePass, long loginTimeOut, long respTimeOut, int loginModes) throws LegoCheckedException {
        this.connectTimeout = (int)loginTimeOut * 1000;
        this.soTimeout = (int)respTimeOut * 1000;
        this.loginMode = loginModes;
        this.connect(hostIp, hostPort, userAccount, userPassword);
    }

    private static JSch initJsch(String ip, String hostKey) {
        JSch jsch = new JSch();
        ByteArrayInputStream in = null;
        if (null != hostKey && !"".equals(hostKey)) {
            LOG.info((Object)("hostKey will be validate hostKey=" + AticUtil.getcleanedMessage((String)hostKey) + " ,ip=" + AticUtil.getcleanedMessage((String)ip)));
            StringBuffer buffer = new StringBuffer();
            buffer.append(ip);
            buffer.append(" ");
            buffer.append("ssh-rsa");
            buffer.append(" ");
            buffer.append(hostKey);
            try {
                in = new ByteArrayInputStream(buffer.toString().getBytes("UTF-8"));
                jsch.setKnownHosts((InputStream)in);
            }
            catch (UnsupportedEncodingException e) {
                LOG.error((Object)("get hostkey info error" + e.getMessage()));
                throw new LegoCheckedException(571904L);
            }
            catch (JSchException e) {
                LOG.error((Object)(ip + "-The sftp server hostkey was not accepted by the verifier callback!"));
                throw new LegoCheckedException(571904L);
            }
            finally {
                if (null != in) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)"IOException error");
                    }
                }
            }
        }
        LOG.info((Object)"hostKey is null, hostKey will not be validate");
        return jsch;
    }

    public void connect(String hostIp, int hostPort, String userAccounts, StringBuffer userPassword) throws LegoCheckedException {
        this.connected = false;
        this.host = hostIp;
        this.port = hostPort;
        this.userName = userAccounts;
        this.passkey = userPassword;
        try {
            boolean isAuthenticated;
            LOG.info((Object)("hostKey will be validate host=" + this.host + " ,port=" + this.port));
            JSch jsch = Ssh2Connector.initJsch(this.host, this.hostKey);
            this.session = jsch.getSession(this.userName, this.host, this.port);
            if (this.session == null) {
                LOG.error((Object)"jsch get session error. session is null");
                throw new LegoCheckedException(571904L);
            }
            this.session.setConfig("cipher.c2s", "aes256-ctr");
            this.session.setConfig("mac.c2s", "hmac-sha2-256");
            this.session.setConfig("cipher.s2c", "aes256-ctr");
            this.session.setConfig("mac.s2c", "hmac-sha2-256");
            this.session.setConfig("CheckCiphers", "aes256-ctr");
            this.session.setConfig("CheckKexes", "diffie-hellman-group14-sha1");
            this.session.setConfig("kex", "diffie-hellman-group14-sha1");
            this.session.setConfig("server_host_key", "ssh-rsa");
            this.session.setPassword(this.passkey.toString());
            this.session.setConfig("StrictHostKeyChecking", "no");
            this.session.connect(this.connectTimeout);
            this.channel = this.session.openChannel("shell");
            ((ChannelShell)this.channel).setPtyType("vt102");
            this.channel.connect();
            boolean bl = isAuthenticated = this.session.isConnected() && this.channel.isConnected();
            if (!isAuthenticated) {
                throw new LegoCheckedException(527L);
            }
            LOG.info((Object)("hostKey will be validate session.isConnected()=" + this.session.isConnected() + " ,channel.isConnected()=" + this.channel.isConnected()));
            this.in = ((ChannelShell)this.channel).getInputStream();
            this.out = ((ChannelShell)this.channel).getOutputStream();
            this.reader = null != this.currentCharsetName ? new BufferedReader(new InputStreamReader(this.in, this.currentCharsetName)) : new BufferedReader(new InputStreamReader(this.in, System.getProperty("file.encoding")));
            this.writer = new PrintWriter(new OutputStreamWriter(this.out, System.getProperty("file.encoding")));
            String reString = this.getResult(false);
            this.connected = !"".equals(reString);
        }
        catch (SocketTimeoutException e) {
            this.close();
            throw new LegoCheckedException(517L);
        }
        catch (LegoCheckedException e) {
            throw new LegoCheckedException(e.getErrorCode());
        }
        catch (RuntimeException e) {
            this.close();
            throw new LegoCheckedException(527L);
        }
        catch (IOException e) {
            this.connected = false;
            LOG.error((Object)(this.host + "-The ssh server hostkey was not accepted by the verifier callback!"));
            throw new LegoCheckedException(660010L);
        }
        catch (Exception e) {
            this.close();
            LOG.error((Object)(this.host + "-The ssh server hostkey was not accepted by the verifier callback!" + e.getMessage()));
            throw new LegoCheckedException(660010L);
        }
    }

    public void reConnect() throws LegoCheckedException {
        if (this.connected) {
            this.close();
            this.connected = false;
        }
        this.connect(this.host, this.userName, this.passkey);
    }

    public void reConnectOneKeyCollect() throws LegoCheckedException {
        LOG.info((Object)"step in ssh reConnectOneKeyCollect.");
        this.close();
        this.connected = false;
        int times = 1;
        try {
            this.connect(this.host, this.userName, this.passkey);
        }
        catch (LegoCheckedException e) {
            this.tryAgain(e, times);
        }
    }

    private void tryAgain(LegoCheckedException e, int times) {
        if (e.getErrorCode() != 517L) {
            throw e;
        }
        if (times > 8) {
            throw e;
        }
        ++times;
        try {
            LOG.error((Object)("stelnet : reConnectOneKeyCollect try again times " + times));
            this.close();
            this.connected = false;
            this.connect(this.host, this.userName, this.passkey);
        }
        catch (LegoCheckedException sub) {
            this.tryAgain(sub, times);
        }
        try {
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (InterruptedException e1) {
            LOG.error((Object)("stelnet : reConnectOneKeyCollect! " + e.getMessage()));
        }
    }

    public void executeNoResultCommand(String command) {
        this.writer.print(command + "\n");
        this.writer.flush();
        try {
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        catch (InterruptedException e) {
            LOG.error((Object)("InterruptedException: " + e.getMessage()));
        }
    }

    public String executeCommand(String command) throws IOException {
        return this.executeCommand(command, null);
    }

    public String executeCommand(String command, List<String> cliPromptRegexss) throws IOException {
        this.setCliPromptRegexs(cliPromptRegexss);
        String[] commands = command.split("\r\n");
        return this.executeCommand(commands);
    }

    public String executeCommandOnekeyCollect(String command, List<String> cliPromptRegexss) throws IOException {
        this.setCliPromptRegexs(cliPromptRegexss);
        String[] commands = command.split("\r\n");
        return this.executeCommand4OnekeyCollect(commands);
    }

    public String executeCommand(String command, long respTimeOut) throws IOException {
        this.setSoTimeout((int)respTimeOut * 1000);
        return this.executeCommand(command, null);
    }

    public String executeCommand(String command, List<String> cliPromptRegexss, long respTimeOuts) throws IOException {
        this.setCliPromptRegexs(cliPromptRegexss);
        this.setSoTimeout((int)respTimeOuts * 1000);
        return this.executeCommand(command, null);
    }

    private String executeCommand4OnekeyCollect(String[] commands) throws IOException {
        StringBuilder result = new StringBuilder();
        String[] stringArray = commands;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String commandtemp;
            String command = commandtemp = stringArray[i];
            command = command.trim();
            String resp = "";
            resp = this.executeOneCommand4OnekeyCollect(command);
            result.append(resp);
        }
        return result.toString();
    }

    private String executeCommand(String[] commands) throws IOException {
        StringBuilder result = new StringBuilder();
        String[] stringArray = commands;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String commandtemp;
            String command = commandtemp = stringArray[i];
            command = command.trim();
            String resp = "";
            resp = this.executeOneCommand(command);
            result.append(resp);
        }
        return result.toString();
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private String executeOneCommand4OnekeyCollect(String command) throws IOException {
        String result = "";
        try {
            command = command.trim();
            long start = System.currentTimeMillis();
            LOG.debug((Object)("hostAddress=" + this.host + "; command"));
            this.writer.print(command + "\n");
            this.writer.flush();
            boolean isUpdateLoc = false;
            if (command.contains("update local")) {
                isUpdateLoc = true;
            }
            result = this.getResult4OnekeyCollect(isUpdateLoc);
            LOG.info((Object)("==ssh==exec command use" + (System.currentTimeMillis() - start)));
            LOG.info((Object)("==ssh==exec command sotimeout : " + this.soTimeout + " , result length : " + result.length()));
        }
        catch (IOException e) {
            LOG.error((Object)("hostAddress=" + this.host + "; port=" + this.port + "; command"));
            this.close();
            throw e;
        }
        return result.trim();
    }

    private String executeOneCommand(String command) throws IOException {
        String result = "";
        String reComd = "";
        try {
            command = command.trim();
            reComd = command.contains("anti-ddos packet-capture key") ? this.getcleanedMessage(command.substring(0, command.indexOf("anti-ddos packet-capture key"))) + "anti-ddos packet-capture key ***" : this.getcleanedMessage(command);
            LOG.debug((Object)("hostAddress=" + this.host + "; command=" + this.getcleanedMessage(reComd)));
            this.writer.print(command + "\n");
            this.writer.flush();
            boolean isUpdateLoc = false;
            if (command.contains("update local")) {
                isUpdateLoc = true;
            }
            result = this.getResult(isUpdateLoc);
        }
        catch (IOException e) {
            LOG.error((Object)("hostAddress=" + this.host + "; port=" + this.port + "; command=" + this.getcleanedMessage(reComd)));
            this.close();
            throw e;
        }
        return result.trim();
    }

    public String executeCommandExt(String command) throws IOException {
        return this.executeCommand(command, null);
    }

    public void setConnectTimeout(int timeout) {
        if (timeout >= 0) {
            this.connectTimeout = timeout;
        }
    }

    public void setSoTimeout(int timeout) {
        if (timeout >= 0) {
            this.soTimeout = timeout;
        }
    }

    private String getResult(boolean isUpdateLoc) throws IOException {
        String result = "";
        StringBuffer buffer = new StringBuffer();
        char[] buf = new char[8192];
        String tmp = "";
        boolean isMore = false;
        long startTime = System.currentTimeMillis();
        while (true) {
            if (!this.channel.isConnected()) {
                throw new SocketTimeoutException("Read timed out");
            }
            if (this.reader.ready()) {
                startTime = System.currentTimeMillis();
                int read = this.reader.read(buf);
                if (read == -1) {
                    throw new IOException(result);
                }
                tmp = new String(buf).substring(0, read);
                buffer.append(tmp);
                if (buffer.length() >= 1000000) {
                    try {
                        result = result.replace(MORE_FLAG, "");
                        result = result.replace(MORE, "");
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Exception error:" + e.getMessage()));
                    }
                    LOG.info((Object)("getResult : collect command output length too long : " + buffer.length()));
                    break;
                }
                result = buffer.toString();
                String lastLine = SouthUtil.getLastNotEmptyLine(result);
                if (null == lastLine) continue;
                if (isUpdateLoc) {
                    boolean failMark;
                    LOG.info((Object)("isUpdateLoc result : " + result));
                    String lastTwoLines = SouthUtil.getLastTwoLine(result);
                    if (lastTwoLines.toLowerCase(Locale.getDefault()).contains("the target version is in use")) {
                        result = result.replace("Error", "Info");
                    }
                    boolean sucMark = lastTwoLines.toLowerCase(Locale.getDefault()).contains("update succeeded") || result.contains("Update location identification signature database success");
                    boolean bl = failMark = lastTwoLines.toLowerCase(Locale.getDefault()).startsWith("error") || result.contains("no need update") || result.contains("the same as current database") || result.contains("remain space of CF card is less than") || result.contains("the target version is in use");
                    if (sucMark || failMark) {
                        LOG.info((Object)("update finished : " + result));
                        break;
                    }
                    LOG.info((Object)("waiting for update finished : " + result));
                    continue;
                }
                if (0 == SouthUtil.getEndTag(lastLine)) break;
                if (2 == SouthUtil.getEndTag(lastLine)) {
                    throw new LegoCheckedException(530L);
                }
                if (result.trim().endsWith(MORE)) {
                    isMore = true;
                    result = this.cutLastLine(result);
                    try {
                        TimeUnit.MILLISECONDS.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        LOG.error((Object)("Exception error: " + e.getMessage()));
                    }
                    this.writer.print(" ");
                    this.writer.flush();
                    continue;
                }
                if (!SouthUtil.isRegexMatched(lastLine, this.cliPromptRegexs)) continue;
                break;
            }
            if (System.currentTimeMillis() - startTime > (long)this.soTimeout) {
                throw new SocketTimeoutException("Read timed out startTime : " + startTime + ", soTimeout : " + this.soTimeout + ", cur time : " + System.currentTimeMillis());
            }
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e) {
                LOG.error((Object)("Exception error:" + e.getMessage()));
            }
        }
        if (isMore) {
            int index1 = result.indexOf(MORE_FLAG);
            while (index1 > 0) {
                tmp = result.substring(0, index1 - 1);
                int index2 = result.indexOf(MORE_FLAG, index1 + MORE_FLAG.length());
                if (index2 > index1) {
                    result = tmp + result.substring(index2 + MORE_FLAG.length());
                }
                index1 = result.indexOf(MORE_FLAG);
            }
            try {
                result = result.replace("---- More ----  ", "");
                result = result.replace(MORE, "");
            }
            catch (Exception e) {
                LOG.error((Object)("Exception error:" + e.getMessage()));
            }
        }
        return result;
    }

    private String cutLastLine(String input) {
        int index = input.lastIndexOf("\n");
        if (index != -1) {
            input = input.substring(0, index + 1);
        }
        return input;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getPrompt() {
        String prompt = null;
        this.writer.print("\n");
        this.writer.flush();
        try {
            TimeUnit.MILLISECONDS.sleep(100L);
        }
        catch (InterruptedException e) {
            LOG.error((Object)("InterruptedException error:" + e.getMessage()));
        }
        int read = 0;
        char[] buf = new char[50];
        try {
            read = this.reader.read(buf);
        }
        catch (IOException e) {
            throw new LegoCheckedException(103L);
        }
        if (read > 0) {
            prompt = new String(buf).substring(0, read).trim();
        }
        return prompt;
    }

    public void close() {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Exception error");
        }
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Exception error");
        }
        try {
            if (this.session != null) {
                this.session.disconnect();
            }
        }
        catch (IllegalStateException e) {
            LOG.error((Object)("Exception error:" + e.getMessage()));
        }
        try {
            if (this.channel != null) {
                this.channel.disconnect();
            }
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Exception error");
        }
        this.connected = false;
    }

    private String getResult4OnekeyCollect(boolean isUpdateLoc) throws IOException {
        String result = "";
        StringBuffer bufferx = new StringBuffer();
        char[] buf = new char[8192];
        String tmp = "";
        boolean isMore = false;
        long startTime = System.currentTimeMillis();
        while (true) {
            if (this.reader.ready()) {
                startTime = System.currentTimeMillis();
                int read = this.reader.read(buf);
                if (read == -1) {
                    throw new IOException(result);
                }
                tmp = new String(buf).substring(0, read);
                bufferx.append(tmp);
                if (bufferx.length() >= 1000000) {
                    try {
                        result = result.replace(MORE_FLAG, "");
                        result = result.replace(MORE, "");
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Exception error:" + e.getMessage()));
                    }
                    LOG.info((Object)("collect command output length too long : " + bufferx.length()));
                    break;
                }
                result = bufferx.toString();
                String lastLine = SouthUtil.getLastNotEmptyLine(result);
                if (null == lastLine) continue;
                if (isUpdateLoc) {
                    boolean failMark;
                    LOG.info((Object)("isUpdateLoc result : " + result));
                    String lastTwoLines = SouthUtil.getLastTwoLine(result);
                    if (lastTwoLines.toLowerCase(Locale.getDefault()).contains("the target version is in use")) {
                        result = result.replace("Error", "Info");
                    }
                    boolean sucMark = lastTwoLines.toLowerCase(Locale.getDefault()).contains("update succeeded") || result.contains("Update location identification signature database success");
                    boolean bl = failMark = lastTwoLines.toLowerCase(Locale.getDefault()).startsWith("error") || result.contains("no need update") || result.contains("the same as current database") || result.contains("remain space of CF card is less than") || result.contains("the target version is in use");
                    if (sucMark || failMark) {
                        LOG.info((Object)("update finished : " + result));
                        break;
                    }
                    LOG.info((Object)("waiting for update finished : " + result));
                    continue;
                }
                if (0 == SouthUtil.getEndTag(lastLine) && this.isEndSpec(lastLine)) {
                    LOG.info((Object)("getOnekeyResult  lastLine : " + lastLine));
                    break;
                }
                if (2 == SouthUtil.getEndTag(lastLine)) {
                    LOG.info((Object)"getOnekeyResult  PASSWORD_IS_EXPIRE : 2");
                    throw new LegoCheckedException(530L);
                }
                if (!this.isConnected() && (result.contains(LOGIN_FAIL) || result.contains(LOGIN_FAIL_EXT))) {
                    LOG.info((Object)"getOnekeyResult  LOGIN_FAIL : Login failed");
                    break;
                }
                if (result.trim().endsWith(MORE)) {
                    isMore = true;
                    result = this.cutLastLine(result);
                    try {
                        TimeUnit.MILLISECONDS.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        LOG.error((Object)("Exception error:" + e.getMessage()));
                    }
                    this.writer.print(" ");
                    this.writer.flush();
                    continue;
                }
                if (!SouthUtil.isRegexMatched(lastLine, this.cliPromptRegexs) || !this.isEndSpec(lastLine)) continue;
                LOG.info((Object)("getOnekeyResult  cliPromptRegexs end : " + this.cliPromptRegexs));
                break;
            }
            if (System.currentTimeMillis() - startTime > (long)this.soTimeout) {
                if (!result.trim().equals("")) {
                    LOG.info((Object)("collect command output timeout, the result length :" + result.length() + "soTimeout is :" + this.soTimeout));
                    break;
                }
                throw new SocketTimeoutException("Connect timed out");
            }
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e) {
                LOG.error((Object)("Exception error:" + e.getMessage()));
            }
        }
        if (isMore) {
            int indexOne = result.indexOf(MORE_FLAG);
            try {
                while (indexOne > 0) {
                    tmp = result.substring(0, indexOne - 1);
                    int index2 = result.indexOf(MORE_FLAG, indexOne + MORE_FLAG.length());
                    if (index2 > indexOne) {
                        result = tmp + result.substring(index2 + MORE_FLAG.length());
                    }
                    indexOne = result.indexOf(MORE_FLAG);
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Exception error:" + e.getMessage()));
            }
        }
        try {
            result = result.replace(MORE_FLAG, "");
            result = result.replace(MORE, "");
            result = result.replace(MORE_BLANK_WRAP_FLAG, "");
            result = result.replace(DEVICE_WRAP_FLAG, "");
        }
        catch (Exception e) {
            LOG.error((Object)("Exception error:" + e.getMessage()));
        }
        LOG.info((Object)"getOnekeyResult end!");
        return result;
    }

    private boolean isEndSpec(String lastLine) {
        return !lastLine.contains("-->") && !lastLine.contains("<--") && !lastLine.contains("->") && !lastLine.contains("<-");
    }

    public void setLoginMode(int loginMode) {
        this.loginMode = loginMode;
    }

    public int getLoginMode() {
        return this.loginMode;
    }

    public void setCurrentCharsetName(String charsetName) {
        this.currentCharsetName = charsetName;
    }

    public String getCurrentCharsetName() {
        return this.currentCharsetName;
    }

    private void setCliPromptRegexs(List<String> cliPromptRegexs) {
        this.cliPromptRegexs = cliPromptRegexs;
    }

    public String getUserName() {
        return this.userName;
    }

    public StringBuffer getPasskey() {
        return this.passkey;
    }

    public void setHostKey(String hostKey) {
        this.hostKey = hostKey;
    }

    public String getHostKey() {
        return this.hostKey;
    }
}

