/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.comm.south.util;

import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.atic.comm.south.ssh.Ssh1Connector;
import com.huawei.atic.comm.south.ssh.Ssh2Connector;
import com.huawei.atic.comm.south.telnet.TelnetConnector;
import com.huawei.atic.south.model.TelnetPara;
import com.huawei.atic.util.AticInstallUtil;
import java.io.File;

public class TestTelnetUtil {
    private static final Object LOCKSTATIC = new Object();
    private static TestTelnetUtil instanse = null;
    private static final String USER_NO_RIGHT = "Wrong parameter found at '^' position.";
    private static final String USER_NO_RIGHT_EXT = "Unrecognized command found at '^' position.";
    private String sshVersion;
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TestTelnetUtil getInstanse() {
        Object object = LOCKSTATIC;
        synchronized (object) {
            if (instanse == null) {
                instanse = new TestTelnetUtil();
            }
            return instanse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testResult(String deviceIp, TelnetPara telnetPara) {
        Object object = this.lock;
        synchronized (object) {
            File confFile;
            Boolean testResult = Boolean.TRUE;
            if (null == telnetPara) {
                return Boolean.FALSE;
            }
            testResult = telnetPara.getProtocolType() == 0 ? Boolean.valueOf(this.testTelnetResult(deviceIp, telnetPara)) : ((confFile = new File(AticInstallUtil.getInstance().getAticInstallPath() + File.separator + "resources" + File.separator + "conf.properties")).exists() ? Boolean.valueOf(this.testSSH1Result(deviceIp, telnetPara)) : Boolean.valueOf(this.testSSH2Result(deviceIp, telnetPara)));
            return testResult;
        }
    }

    private boolean testTelnetResult(String deviceIp, TelnetPara telnetPara) {
        int authMode = telnetPara.getAuthMode();
        Boolean testResult = Boolean.TRUE;
        int hostPort = telnetPara.getPort();
        StringBuffer userPassword = DataProtectServiceConst.sdpDecryptLocalBuffer((String)telnetPara.getLoginPwd());
        String userAccount = telnetPara.getLoginUser();
        long loginTimeOut = telnetPara.getLoginTimeout();
        long resTimeOut = telnetPara.getResponseTimeout();
        try (TelnetConnector telnetConnector = new TelnetConnector();){
            telnetConnector.connect(deviceIp, hostPort, authMode, userAccount, userPassword, loginTimeOut, resTimeOut);
            telnetConnector.executeCommand("_");
            telnetConnector.executeCommandExt("_Security");
            telnetConnector.executeCommand("sy");
            String resp = telnetConnector.executeCommand("aaa");
            if (resp.contains(USER_NO_RIGHT) || resp.contains(USER_NO_RIGHT_EXT)) {
                throw new LegoCheckedException(523L);
            }
        }
        return testResult;
    }

    private boolean testSSH2Result(String deviceIp, TelnetPara telnetPara) {
        Boolean testResult = Boolean.TRUE;
        int hostPort = telnetPara.getPort();
        int loginMode = telnetPara.getAuthMode() == 0 ? 0 : 2;
        StringBuffer userPassword = DataProtectServiceConst.sdpDecryptLocalBuffer((String)telnetPara.getLoginPwd());
        String userAccount = telnetPara.getLoginUser();
        long loginTimeOut = telnetPara.getLoginTimeout();
        long resTimeOut = telnetPara.getResponseTimeout();
        String sshRSAKey = telnetPara.getUserPrivateKey();
        StringBuffer keyPassword = DataProtectServiceConst.sdpDecryptLocalBuffer((String)telnetPara.getPrivateKeyPwd());
        ssh2Connector.setHostKey(telnetPara.getHostKey());
        try (Ssh2Connector ssh2Connector = new Ssh2Connector();){
            ssh2Connector.connect(deviceIp, hostPort, userAccount, userPassword, sshRSAKey, keyPassword, loginTimeOut, resTimeOut, loginMode);
            String resp = "";
            ssh2Connector.executeCommand("_");
            ssh2Connector.executeCommandExt("_Security");
            ssh2Connector.executeCommand("sy");
            resp = ssh2Connector.executeCommand("aaa");
            if (resp.contains(USER_NO_RIGHT) || resp.contains(USER_NO_RIGHT_EXT)) {
                throw new LegoCheckedException(523L);
            }
        }
        return testResult;
    }

    private boolean testSSH1Result(String deviceIp, TelnetPara telnetPara) {
        Boolean testResult;
        int hostPort = telnetPara.getPort();
        StringBuffer userPassword = DataProtectServiceConst.sdpDecryptLocalBuffer((String)telnetPara.getLoginPwd());
        String userAccount = telnetPara.getLoginUser();
        long loginTimeOut = telnetPara.getLoginTimeout();
        try (Ssh1Connector ssh1Connector = new Ssh1Connector();){
            testResult = ssh1Connector.connect(deviceIp, userAccount, userPassword, ":", "dumb", null, null, null, hostPort, (int)loginTimeOut);
            String resp = "";
            ssh1Connector.executeCommand("_");
            ssh1Connector.executeCommand("_Security");
            resp = ssh1Connector.executeCommandResp("sy");
            resp = resp + ssh1Connector.executeCommandResp("aaa");
            if (resp.contains(USER_NO_RIGHT) || resp.contains(USER_NO_RIGHT_EXT)) {
                throw new LegoCheckedException(523L);
            }
        }
        return testResult;
    }

    public void setSshVersion(String sshVersion) {
        this.sshVersion = sshVersion;
    }

    public String getSshVersion() {
        return this.sshVersion;
    }
}

