/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.device.license.service.impl;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.device.license.dao.LicenseDao;
import com.huawei.atic.device.license.model.LicenseInfoDb;
import com.huawei.atic.device.license.model.LicenseInfoModel;
import com.huawei.atic.device.license.service.ILicenseManagementService;
import com.huawei.atic.device.license.vo.LicenseInfo;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.resource.dao.AticDeviceDao;
import com.huawei.atic.util.CommonUtil;
import com.restful.util.HttpsConnection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import org.apache.commons.io.IOUtils;

public class LicenseManagementServiceImpl
implements ILicenseManagementService {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private LicenseDao licenseDao;
    private AticDeviceDao aticDeviceDao;

    public AticDeviceDao getAticDeviceDao() {
        return this.aticDeviceDao;
    }

    public void setAticDeviceDao(AticDeviceDao aticDeviceDao) {
        this.aticDeviceDao = aticDeviceDao;
    }

    public LicenseDao getLicenseDao() {
        return this.licenseDao;
    }

    public void setLicenseDao(LicenseDao licenseDao) {
        this.licenseDao = licenseDao;
    }

    @Override
    public List<LicenseInfo> getAllLicenses() {
        ArrayList<LicenseInfo> licenseInfoList = new ArrayList<LicenseInfo>();
        List<LicenseInfoDb> list = this.licenseDao.getAllLicenses();
        if (null == list || list.isEmpty()) {
            LOGGER.info((Object)"Licenses is null");
            return licenseInfoList;
        }
        LicenseInfo licenseInfo = null;
        long expirationDate = 0L;
        long newDate = AticUtil.convertTimeString((String)(AticUtil.convertTime2DayString((long)(System.currentTimeMillis() / 1000L)) + " 00:00:00"));
        LicenseInfoModel licenseInfoModel = null;
        for (LicenseInfoDb licenseInfoDb : list) {
            licenseInfoModel = CommonUtil.licenseInfoDbToLicenseInfoModel(licenseInfoDb);
            expirationDate = AticUtil.convertTimeString((String)(licenseInfoModel.getExpirationDate() + " 00:00:00"));
            if (expirationDate < newDate) continue;
            licenseInfo = new LicenseInfo();
            AticUtil.copyProperties((Object)licenseInfoModel, (Object)licenseInfo);
            licenseInfoList.add(licenseInfo);
        }
        return licenseInfoList;
    }

    @Override
    public void syncLicenseInfo(long moId, List<String> result, Map<String, String> params) {
        LOGGER.info((Object)"syncLicenseInfo begin");
        if (null == result || result.isEmpty()) {
            LOGGER.error((Object)"syncLicense echo is null!");
            return;
        }
        LicenseInfoModel licenseNew = this.resultAnalyze(result);
        if (null == licenseNew) {
            LOGGER.error((Object)"syncLicense echo is error!");
            return;
        }
        String licenseNumber = licenseNew.getLicenseNumber();
        String expirationDate = licenseNew.getExpirationDate();
        int expiration = this.changStrDateToInt(expirationDate);
        int defenseBindwidth = licenseNew.getDefenseBindwidth();
        int year = licenseNew.getConCurDefenseIpLimit();
        LicenseInfoModel licenseOld = this.licenseDao.getLicenseBylicenseNumber(licenseNumber);
        if (null != licenseOld && licenseOld.getDefenseBindwidth() == defenseBindwidth && (expirationDate.equals(licenseOld.getExpirationDate()) || this.changStrDateToInt(licenseOld.getExpirationDate()) > expiration)) {
            licenseOld.setUpdatedDateTime(System.currentTimeMillis());
            licenseOld.setDdosDeviceId(moId);
            this.licenseDao.saveOrUpdate(CommonUtil.licenseInfoModelToLicenseInfoDb(licenseOld));
            LOGGER.info((Object)"syncLicense, but license not up-to-date. ");
            return;
        }
        licenseNew.setConCurDefenseIpLimit(1);
        licenseNew.setConfigurableDefenseIpLimit(5);
        int count = 50 * year;
        licenseNew.setSwitchCount(count);
        if (null != licenseOld && licenseOld.getDefenseBindwidth() == defenseBindwidth && licenseOld.getRemainingNumber() > 0 && this.changStrDateToInt(licenseOld.getExpirationDate()) > this.changStrDateToInt(AticUtil.convertTime2DayString((long)(System.currentTimeMillis() / 1000L)))) {
            count += licenseOld.getRemainingNumber();
        }
        licenseNew.setRemainingNumber(count);
        licenseNew.setDdosDeviceId(moId);
        licenseNew.setUpdatedDateTime(System.currentTimeMillis());
        if (null == licenseOld) {
            this.licenseDao.save(CommonUtil.licenseInfoModelToLicenseInfoDb(licenseNew));
            LOGGER.info((Object)"save license ok!");
            return;
        }
        if (licenseOld.getDefenseBindwidth() != defenseBindwidth) {
            licenseNew.setUpdatedDateTime(System.currentTimeMillis());
            this.licenseDao.saveOrUpdate(CommonUtil.licenseInfoModelToLicenseInfoDb(licenseNew));
            this.httpsPost(licenseNumber, String.valueOf(defenseBindwidth), "", "", params);
            LOGGER.info((Object)"Updat license DefenseBindwidth!");
            return;
        }
        if (!expirationDate.equals(licenseOld.getExpirationDate())) {
            licenseNew.setUpdatedDateTime(System.currentTimeMillis());
            this.licenseDao.saveOrUpdate(CommonUtil.licenseInfoModelToLicenseInfoDb(licenseNew));
            this.httpsPost(licenseNumber, String.valueOf(defenseBindwidth), expirationDate, String.valueOf(moId), params);
            LOGGER.info((Object)"Updat license expirationDate!");
            return;
        }
        licenseNew.setUpdatedDateTime(System.currentTimeMillis());
        this.licenseDao.saveOrUpdate(CommonUtil.licenseInfoModelToLicenseInfoDb(licenseNew));
        LOGGER.info((Object)"Updat license other!");
    }

    @Override
    public LicenseInfo getLicenseByDeviceId(long deviceId) {
        if (deviceId < 0L || null == this.aticDeviceDao) {
            LOGGER.error((Object)"deviceId is error or aticDeviceDao is null");
            return null;
        }
        AticDevice device = this.aticDeviceDao.getDeviceByMoid(deviceId);
        if (null != device && 1 != device.getDeviceType()) {
            LOGGER.error((Object)"device is null or Device is not ddosDevice!");
            return null;
        }
        LicenseInfoModel model = this.licenseDao.getLicenseByDeviceId(deviceId);
        if (null == model) {
            LOGGER.info((Object)"this device's license is null!");
            return null;
        }
        LicenseInfo info = new LicenseInfo();
        AticUtil.copyProperties((Object)model, (Object)info);
        if (null == device) {
            info.setDdosDeviceName("N/A");
        } else if (1 == device.getDeviceType()) {
            info.setDdosDeviceName(device.getName());
        }
        long expirationDate = AticUtil.convertTimeString((String)(info.getExpirationDate() + " 00:00:00"));
        long newDate = AticUtil.convertTimeString((String)(AticUtil.convertTime2DayString((long)(System.currentTimeMillis() / 1000L)) + " 00:00:00"));
        if (expirationDate > newDate) {
            info.setEffectiveness(1);
        } else {
            info.setEffectiveness(0);
        }
        info.setUpdatedDateTimeStr(AticUtil.convertTimeLong((Long)(info.getUpdatedDateTime() / 1000L)));
        LOGGER.info((Object)("DeviceId :" + deviceId));
        return info;
    }

    @Override
    public boolean checkLicense(long deviceId) {
        long newDate;
        LicenseInfoModel model = this.licenseDao.getLicenseByDeviceId(deviceId);
        if (null == model) {
            LOGGER.error((Object)"license is null");
            return false;
        }
        long expirationDate = AticUtil.convertTimeString((String)(model.getExpirationDate() + " 00:00:00"));
        if (expirationDate > (newDate = AticUtil.convertTimeString((String)(AticUtil.convertTime2DayString((long)(System.currentTimeMillis() / 1000L)) + " 00:00:00")))) {
            LOGGER.info((Object)"this license is effective");
            return true;
        }
        LOGGER.info((Object)"this license is expired");
        return false;
    }

    @Override
    public boolean checkLicenseByDevIp(String deviceIp) {
        boolean checkLicense = false;
        if (deviceIp == null) {
            LOGGER.error((Object)"deviceIp is null");
            return false;
        }
        AticDevice device = this.aticDeviceDao.getDeviceByIp(deviceIp);
        if (device != null) {
            checkLicense = this.checkLicense(device.getMoId());
        } else {
            LOGGER.error((Object)"device is null");
            checkLicense = false;
        }
        return checkLicense;
    }

    @Override
    public int licenseSwitchCountBackfill(long deviceId) {
        LicenseInfoModel model = this.licenseDao.getLicenseByDeviceId(deviceId);
        if (null == model) {
            LOGGER.error((Object)"licenseSwitchCountBackfill License is null");
            return -1;
        }
        int num = model.getRemainingNumber();
        if (num > 0) {
            LOGGER.info((Object)("licenseSwitchCountBackfill license RemainingNumber" + (num + 1)));
            return num + 1;
        }
        return -1;
    }

    @Override
    public int licenseSwitchCountBackfillByDevIp(String deviceIp) {
        int fillBackCount = 0;
        if (deviceIp == null) {
            LOGGER.error((Object)"deviceIp is null");
            return -1;
        }
        AticDevice device = this.aticDeviceDao.getDeviceByIp(deviceIp);
        if (null != device) {
            fillBackCount = this.licenseSwitchCountBackfill(device.getMoId());
        } else {
            LOGGER.error((Object)"device is null");
            fillBackCount = -1;
        }
        return fillBackCount;
    }

    @Override
    public int refreshSwitchCount(long deviceId) {
        LicenseInfoModel model = this.licenseDao.getLicenseByDeviceId(deviceId);
        if (null == model) {
            LOGGER.error((Object)"refreshSwitchCount : License is null");
            return -1;
        }
        int num = model.getRemainingNumber();
        if (num > 0) {
            model.setRemainingNumber(num - 1);
            this.licenseDao.saveOrUpdate(CommonUtil.licenseInfoModelToLicenseInfoDb(model));
            LOGGER.info((Object)("refreshSwitchCount: license RemainingNumber" + (num - 1)));
            return num - 1;
        }
        return -1;
    }

    @Override
    public int refreshSwitchCountByDevIp(String deviceIp) {
        int fillBackCount = 0;
        if (deviceIp == null) {
            LOGGER.error((Object)"deviceIp is null");
            return -1;
        }
        AticDevice device = this.aticDeviceDao.getDeviceByIp(deviceIp);
        if (null != device) {
            fillBackCount = this.refreshSwitchCount(device.getMoId());
        } else {
            LOGGER.error((Object)"device is null");
            fillBackCount = -1;
        }
        return fillBackCount;
    }

    private LicenseInfoModel resultAnalyze(List<String> result) {
        String licenseNumber = "";
        String expirationDate = "";
        int defenseBindwidth = 0;
        String activatedDate = "";
        String[] resultArray = result.get(0).split("\r\n");
        for (int i = 0; i < resultArray.length; ++i) {
            if (resultArray[i].contains("Device ESN is:")) {
                licenseNumber = resultArray[i].replace("Device ESN is:", "").trim();
            }
            if (resultArray[i].contains("The time when activated is:")) {
                activatedDate = resultArray[i].replace("The time when activated is:", "").trim();
            }
            if (resultArray[i].contains("100G DDoS Cloud Defense: Enabled; service expiration time:")) {
                defenseBindwidth = 100;
                expirationDate = resultArray[i].replace("100G DDoS Cloud Defense: Enabled; service expiration time:", "").trim();
                continue;
            }
            if (resultArray[i].contains("200G DDoS Cloud Defense: Enabled; service expiration time:")) {
                defenseBindwidth = 200;
                expirationDate = resultArray[i].replace("200G DDoS Cloud Defense: Enabled; service expiration time:", "").trim();
                continue;
            }
            if (!resultArray[i].contains("500G DDoS Cloud Defense: Enabled; service expiration time:")) continue;
            defenseBindwidth = 500;
            expirationDate = resultArray[i].replace("500G DDoS Cloud Defense: Enabled; service expiration time:", "").trim();
        }
        if (AticUtil.isNull((String)licenseNumber) || AticUtil.isNull((String)expirationDate) || AticUtil.isNull((String)activatedDate) || defenseBindwidth <= 0) {
            LOGGER.error((Object)"resultAnalyze: syncLicense echo is error!");
            return null;
        }
        int expiration = this.changStrDateToInt(expirationDate);
        int activate = this.changStrDateToInt(activatedDate);
        if (0 == expiration || 0 == activate || activate > expiration) {
            LOGGER.error((Object)"resultAnalyze: license is expired!");
            return null;
        }
        long year = 0 == (expiration - activate) % 10000 ? (long)((expiration - activate) / 10000) : (long)((expiration - activate) / 10000 + 1);
        LicenseInfoModel licenseNew = new LicenseInfoModel();
        licenseNew.setLicenseNumber(licenseNumber);
        licenseNew.setExpirationDate(expirationDate);
        licenseNew.setDefenseBindwidth(defenseBindwidth);
        licenseNew.setConCurDefenseIpLimit((int)year);
        return licenseNew;
    }

    private void httpsPost(String licenseNumber, String defenseBindwidth, String expirationDate, String ddosDeviceId, Map<String, String> params) {
        try {
            String result = "";
            for (int i = 0; !(i >= 3 || null != (result = this.doHttpsPost(licenseNumber, defenseBindwidth, expirationDate, ddosDeviceId, params)) && "success".equalsIgnoreCase(result)); ++i) {
                Thread.sleep(100L);
            }
            LOGGER.info((Object)("httpsPost  info :" + result));
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)("httpsPost exception:" + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String doHttpsPost(String licenseNumber, String defenseBindwidth, String expirationDate, String ddosDeviceId, Map<String, String> params) {
        String string;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("licenseNumber", licenseNumber);
        map.put("defenseBindwidth", defenseBindwidth);
        map.put("expirationDate", expirationDate);
        map.put("ddosDeviceId", ddosDeviceId);
        String localIp = CommonUtil.getInstallXmlIp();
        map.put("Ip", localIp);
        String objectJson = "{\"licenseNumber\":\"" + licenseNumber + "\",\r\n\"defenseBindwidth\":\"" + defenseBindwidth + "\",\r\n\"expirationDate\":\"" + expirationDate + "\",\r\n\"ddosDeviceId\":\"" + ddosDeviceId + "\",\r\n\"Ip\":\"" + localIp + "\"}";
        String uri = params.get("scheme") + "://" + localIp + ":" + params.get("port") + "/rest/openapi/defense/updategroup";
        HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)new HttpsConnection.HttpsConnectionHostnameVerifier(uri));
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("TLSv1.2");
            sc.init(null, new TrustManager[]{new HttpsConnection.HttpsConnectionX509TrustManager("lego_tomcat")}, new SecureRandom());
        }
        catch (KeyManagementException e1) {
            LOGGER.error((Object)e1.getMessage());
            return null;
        }
        catch (NoSuchAlgorithmException e2) {
            LOGGER.error((Object)e2.getMessage());
            return null;
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)e.getMessage());
            return null;
        }
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        PrintWriter pw = null;
        OutputStreamWriter osw = null;
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        HttpsURLConnection conn = null;
        try {
            URL url = new URL(uri);
            conn = (HttpsURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("content-type", "application/json;charset=utf-8");
            osw = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
            pw = new PrintWriter(osw);
            pw.print(objectJson);
            pw.flush();
            inputStream = conn.getInputStream();
            inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            bufferedReader = new BufferedReader(inputStreamReader);
            String str = null;
            StringBuffer buffer = new StringBuffer();
            while ((str = bufferedReader.readLine()) != null) {
                buffer.append(str);
            }
            IOUtils.closeQuietly((Writer)pw);
            IOUtils.closeQuietly((Writer)osw);
            IOUtils.closeQuietly((Reader)bufferedReader);
            IOUtils.closeQuietly((Reader)inputStreamReader);
            IOUtils.closeQuietly((InputStream)inputStream);
            if (!buffer.toString().equals("success")) {
                LOGGER.error((Object)"doHttpsPost is failure");
                String string2 = null;
                IOUtils.closeQuietly((Writer)pw);
                IOUtils.closeQuietly((Writer)osw);
                IOUtils.closeQuietly((Reader)bufferedReader);
                IOUtils.closeQuietly((Reader)inputStreamReader);
                IOUtils.closeQuietly((InputStream)inputStream);
                if (null == conn) return string2;
                conn.disconnect();
                return string2;
            }
            string = buffer.toString().trim();
            IOUtils.closeQuietly((Writer)pw);
        }
        catch (SSLException e) {
            LOGGER.error((Object)("LicenseManagementServiceImpl doHttpsPost SSLException e" + e.getMessage()));
            String string3 = null;
            return string3;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (IOException e2) {
                LOGGER.error((Object)"doHttpsPost is failure");
                string3 = null;
                return string3;
            }
        }
        finally {
            IOUtils.closeQuietly(pw);
            IOUtils.closeQuietly(osw);
            IOUtils.closeQuietly(bufferedReader);
            IOUtils.closeQuietly(inputStreamReader);
            IOUtils.closeQuietly(inputStream);
            if (null != conn) {
                conn.disconnect();
            }
        }
        IOUtils.closeQuietly((Writer)osw);
        IOUtils.closeQuietly((Reader)bufferedReader);
        IOUtils.closeQuietly((Reader)inputStreamReader);
        IOUtils.closeQuietly((InputStream)inputStream);
        if (null == conn) return string;
        conn.disconnect();
        return string;
    }

    private int changStrDateToInt(String strDate) {
        if (strDate.length() != 10) {
            return 0;
        }
        int num = 0;
        try {
            num = Integer.parseInt(strDate.replace("-", ""));
            if (num < 20000000 || num > 40000000) {
                num = 0;
            }
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)("changStrDateToInt is Exception,e:" + e.getMessage()));
        }
        return num;
    }
}

