/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.init.thread.util;

import com.hs.atic.collector.entity.monitor.CollectorMonitorInfo;
import com.hs.atic.rmi.NotifyFaultSeverityRuleService;
import com.hs.atic.rmi.SecneCollectorRMIProxy;
import com.hs.atic.rmi.SysManagerService;
import com.hs.atic.sdk.bis.form.BlackholeNpForm;
import com.hs.atic.sdk.bis.form.FaultSeverityRuleForm;
import com.hs.atic.sdk.bis.service.FaultSeverityRuleService;
import com.hs.atic.sdk.system.form.LogHoldTimeForm;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.alarm.service.SecneAlarmHandler;
import com.huawei.atic.collector.service.dao.BlackholeNpDao;
import com.huawei.atic.collector.service.dao.CollectorDao;
import com.huawei.atic.device.model.Collector;
import com.huawei.atic.parents.servcice.FilterParentService;
import com.huawei.atic.parents.servcice.ILogHoldTimeService;
import com.huawei.atic.rmi.AticRmiServiceRegisterUtil;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;

public class CheckCollectorStateThread
extends Thread {
    private static final String COLLECTOR_CONF = "/collector.conf";
    private static final long NUM_5_MIN = 300000L;
    private static final long NUM_2_THOU = 2000L;
    private static final long CHECK_COLLECTOR_RANGE_TIME = 20000L;
    private CollectorDao collectorDao;
    private BlackholeNpDao blackholeNpDaoCollector;
    private SecneCollectorRMIProxy collectorRMIProxy;
    private FaultSeverityRuleService faultSeverityRuleService;
    private FilterParentService filterService;
    private ILogHoldTimeService logHoldTimeService;
    private SecneAlarmHandler alarmHandler;
    private String checkCcoSleepTime = "CheckCcoSleepTime";
    private long eachSleepTime = 5000L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private boolean start = Boolean.FALSE;

    @Override
    public void run() {
        try {
            InputStream inputStream = AticUtil.class.getResourceAsStream(COLLECTOR_CONF);
            this.eachSleepTime = Long.parseLong(AticUtil.getPropertyValue((InputStream)inputStream, (String)this.checkCcoSleepTime));
        }
        catch (Exception e) {
            this.logger.error((Object)("get sleepTime error!" + e.getMessage()));
        }
        while (this.start) {
            long sleepTime = 0L;
            try {
                sleepTime = this.checkCollector();
                this.logger.info((Object)("sleepTime is : " + sleepTime));
            }
            catch (Exception e) {
                this.logger.error((Object)("CheckCollectorStateThread run error:" + e.getMessage()));
            }
            try {
                Thread.sleep(sleepTime + 1000L);
            }
            catch (InterruptedException e) {
                this.logger.error((Object)("CheckCollectorStateThread InterruptedException error!" + e.getMessage()));
            }
        }
    }

    public long checkCollector() {
        long startTime = System.currentTimeMillis();
        try {
            List<Collector> collectorList = this.collectorDao.getAll();
            String serverIp = AticRmiServiceRegisterUtil.getInstance().getAticRmiServiceIp();
            this.logger.info((Object)("checkCollector, serverIp=" + serverIp));
            for (Collector each : collectorList) {
                if (this.eachSleepTime <= 300000L && this.eachSleepTime >= 0L) {
                    Thread.sleep(this.eachSleepTime);
                } else {
                    Thread.sleep(2000L);
                }
                String collectorIp = each.getIpAddress();
                try {
                    SysManagerService sysManagerService = this.collectorRMIProxy.getSysManagerService(collectorIp);
                    if (null == sysManagerService) {
                        this.logger.info((Object)("sysManagerService is null, collectorIP=" + collectorIp));
                        if (1 == each.getDdosCollectorStatus()) {
                            this.alarmHandler.collectorOffLineAlarm(collectorIp, each.getCollectorName(), each.getMoId());
                            this.offLineHandle(each);
                            this.logger.info((Object)("send the offline alarm, collectorIP=" + collectorIp));
                        }
                        this.collectorDao.updateCollectorStates(each);
                        continue;
                    }
                    CollectorMonitorInfo monitorInfo = sysManagerService.sayHello(serverIp, collectorIp);
                    if (null != monitorInfo) {
                        if (2 == each.getDdosCollectorStatus()) {
                            this.logger.info((Object)("send the online clear alarm, collectorIP=" + collectorIp));
                            this.alarmHandler.collectorOffLineResume(collectorIp, each.getCollectorName(), each.getMoId());
                            if (null == this.faultSeverityRuleService) {
                                this.faultSeverityRuleService = (FaultSeverityRuleService)ServiceContext.getInstance().getService("faultSeverityRuleService", FaultSeverityRuleService.class);
                            }
                            List<FaultSeverityRuleForm> faultSeverityRuleForms = this.faultSeverityRuleService.getAllRules();
                            List<BlackholeNpForm> blackholeForms = this.blackholeNpDaoCollector.queryAllBlackholeNP();
                            NotifyFaultSeverityRuleService client = this.collectorRMIProxy.getNotifyFaultSeverityRuleService(collectorIp);
                            if (client != null) {
                                client.batchNotifySeverityRule(faultSeverityRuleForms);
                                client.saveAllConfigBlackholeNpData(blackholeForms);
                            }
                            if (null == this.filterService) {
                                this.filterService = (FilterParentService)ServiceContext.getInstance().getService("filterService", FilterParentService.class);
                            }
                            Map<Integer, String> filterMap = this.filterService.getFilterMap();
                            this.logger.info((Object)("send collector filterMap.size:" + filterMap.size()));
                        }
                        if (1 != each.getDdosCollectorStatus()) {
                            this.updateCollectorConf(each);
                        }
                        this.onLineHandle(each, monitorInfo);
                        this.logger.info((Object)("Atic connect to collector success, collectorIP=" + collectorIp));
                    } else {
                        if (1 == each.getDdosCollectorStatus()) {
                            this.alarmHandler.collectorOffLineAlarm(collectorIp, each.getCollectorName(), each.getMoId());
                            this.logger.info((Object)("send the offline alarm because the return monitorInfo is null, collectorIP=" + collectorIp));
                        }
                        this.offLineHandle(each);
                    }
                }
                catch (RemoteException e) {
                    if (1 == each.getDdosCollectorStatus()) {
                        this.alarmHandler.collectorOffLineAlarm(collectorIp, each.getCollectorName(), each.getMoId());
                    }
                    this.offLineHandle(each);
                    this.logger.error((Object)("conne to collector failed, collectorIP=" + collectorIp + ". " + e.getMessage()));
                }
                this.collectorDao.updateCollectorStates(each);
            }
        }
        catch (InterruptedException e) {
            this.logger.error((Object)("checkCollector error! " + e.getMessage()));
        }
        catch (RuntimeException e) {
            this.logger.error((Object)("checkCollector error! " + e.getMessage()));
        }
        long endTime = System.currentTimeMillis();
        long sleepTime = 20000L - (endTime - startTime);
        return sleepTime <= 0L ? 0L : sleepTime;
    }

    private void onLineHandle(Collector each, CollectorMonitorInfo monitorInfo) {
        each.setCollectorCpuinfo(monitorInfo.getCpuUseRatio());
        each.setCollectorMemoryinfo(monitorInfo.getMemUseRatio());
        each.setCollectorDiskinfo(AticUtil.transferDiskInfo((List)monitorInfo.getDiskList()));
        each.setDdosCollectorStatus(1);
    }

    private void updateCollectorConf(Collector each) {
        SysManagerService sysManagerService = this.collectorRMIProxy.getSysManagerService(each.getIpAddress());
        if (sysManagerService != null) {
            if (null == this.logHoldTimeService) {
                this.logHoldTimeService = (ILogHoldTimeService)ServiceContext.getInstance().getService("logHoldTimeService", ILogHoldTimeService.class);
            }
            List<LogHoldTimeForm> logHoldTime = this.logHoldTimeService.findLogHoldTime();
            LogHoldTimeForm logHoldTimeForm = new LogHoldTimeForm();
            if (!logHoldTime.isEmpty()) {
                logHoldTimeForm = logHoldTime.get(0);
            }
            if (logHoldTimeForm != null) {
                try {
                    sysManagerService.updateSysVal("divert_delay_time", String.valueOf(logHoldTimeForm.getDivertDelayTime()));
                    sysManagerService.setPartitionParameter(logHoldTimeForm.getHoldOriginal(), logHoldTimeForm.getHoldHour(), logHoldTimeForm.getHoldDay());
                }
                catch (Exception e) {
                    this.logger.error((Object)("update collector conf error!" + e.getMessage()));
                }
            }
        }
    }

    private void offLineHandle(Collector each) {
        each.setCollectorCpuinfo(0);
        each.setCollectorMemoryinfo(0);
        each.setCollectorDiskinfo("");
        each.setDdosCollectorStatus(2);
    }

    public boolean isStart() {
        return this.start;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    public CollectorDao getCollectorDao() {
        return this.collectorDao;
    }

    public SecneCollectorRMIProxy getCollectorRMIProxy() {
        return this.collectorRMIProxy;
    }

    public void setCollectorDao(CollectorDao collectorDao) {
        this.collectorDao = collectorDao;
    }

    public void setCollectorRMIProxy(SecneCollectorRMIProxy collectorRMIProxy) {
        this.collectorRMIProxy = collectorRMIProxy;
    }

    public SecneAlarmHandler getAlarmHandler() {
        return this.alarmHandler;
    }

    public void setAlarmHandler(SecneAlarmHandler alarmHandler) {
        this.alarmHandler = alarmHandler;
    }

    public BlackholeNpDao getBlackholeNpDaoCollector() {
        return this.blackholeNpDaoCollector;
    }

    public void setBlackholeNpDaoCollector(BlackholeNpDao blackholeNpDaoCollector) {
        this.blackholeNpDaoCollector = blackholeNpDaoCollector;
    }
}

