/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.init.thread.util;

import com.hs.atic.cloudclean.form.CloudCleanConfigDevFlowForm;
import com.hs.atic.cloudclean.model.CloudCleanConfigDevFlow;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.Interface;
import com.huawei.atic.parents.servcice.CloudCleanAlarmHandlerService;
import com.huawei.atic.parents.servcice.ICloudCleanConfigParentsService;
import com.huawei.atic.sdk.perfmonitor.model.DeviceIfTraffic;
import com.huawei.atic.sdk.perfmonitor.service.IfTrafficService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.TableEvent;

public class MonitorDevIfTraffic {
    CloudCleanConfigDevFlow thresholdFlow;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private Map<Long, List<DeviceIfTraffic>> deviceTrafficMap = new HashMap<Long, List<DeviceIfTraffic>>();
    private IfTrafficService ifTrafficService;
    private ICloudCleanConfigParentsService iCloudCleanConfigService;
    private boolean isQuery = true;
    private List<Long> isAbnormalStatus = new ArrayList<Long>();
    private List<Long> deviceLastStatus = new ArrayList<Long>();
    private Map<Long, CloudCleanConfigDevFlow> devFlowMap = new HashMap<Long, CloudCleanConfigDevFlow>();
    private CloudCleanAlarmHandlerService cloudCleanAlarmHandler;
    private IAticDeviceService aticDeviceService;

    public void monitor() {
        List<AticDevice> deviceList = this.getAticDeviceList();
        if (null != deviceList && !deviceList.isEmpty()) {
            for (int i = 0; i < deviceList.size(); ++i) {
                AticDevice device = deviceList.get(i);
                try {
                    List<DeviceIfTraffic> trafficList = this.monitorIfTraff(device);
                    if (null != trafficList && !trafficList.isEmpty()) {
                        if (null == this.ifTrafficService) {
                            this.ifTrafficService = (IfTrafficService)ServiceContext.getInstance().getService("ifTrafficService", IfTrafficService.class);
                        }
                        this.ifTrafficService.saveIfTraffic(trafficList);
                        continue;
                    }
                    this.logger.debug((Object)("trafficList is null, deviceId is: " + device.getMoId()));
                    continue;
                }
                catch (Exception e) {
                    this.logger.error((Object)("When monitor decvice(" + device.getMoId() + ") traffic,some errors happened." + e.getMessage()));
                }
            }
        } else {
            this.deviceTrafficMap.clear();
        }
    }

    private List<AticDevice> getAticDeviceList() {
        List<AticDevice> aticDeviceList = this.aticDeviceService.getNeedMonitorDevice();
        return aticDeviceList;
    }

    private List<DeviceIfTraffic> monitorIfTraff(AticDevice device) {
        List<DeviceIfTraffic> nowData = this.monitorDevOriginalTraff(device);
        if (null == nowData || nowData.isEmpty()) {
            return null;
        }
        if (this.isQuery) {
            try {
                List<CloudCleanConfigDevFlowForm> liDevFlowForms;
                if (null == this.iCloudCleanConfigService) {
                    this.iCloudCleanConfigService = (ICloudCleanConfigParentsService)ServiceContext.getInstance().getService("cloudCleanConfigService", ICloudCleanConfigParentsService.class);
                }
                if ((liDevFlowForms = this.iCloudCleanConfigService.queryDevFlowList()) != null && !liDevFlowForms.isEmpty()) {
                    for (CloudCleanConfigDevFlowForm clDevFlowForm : liDevFlowForms) {
                        CloudCleanConfigDevFlow clDevFlow = new CloudCleanConfigDevFlow();
                        clDevFlow.setDevFlowValue(clDevFlowForm.getDevFlowValue());
                        clDevFlow.setDeviceId(clDevFlowForm.getDeviceId());
                        this.devFlowMap.put(clDevFlowForm.getDeviceId(), clDevFlow);
                        this.logger.error((Object)("monitorDevice thread start ,first query cloud clean deviceFlowValue is :" + clDevFlow.getDevFlowValue()));
                        this.isQuery = false;
                    }
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("query cloud clean threshold failed. Exception: " + e.getMessage()));
            }
        }
        List<DeviceIfTraffic> previousData = this.deviceTrafficMap.get(device.getMoId());
        this.deviceTrafficMap.put(device.getMoId(), nowData);
        if (null == previousData || nowData.size() != previousData.size()) {
            return null;
        }
        ArrayList<DeviceIfTraffic> result = new ArrayList<DeviceIfTraffic>();
        DeviceIfTraffic totalIfTraffic = new DeviceIfTraffic();
        totalIfTraffic.setMonitorTime(nowData.get(0).getMonitorTime());
        totalIfTraffic.setIfIndex(0);
        totalIfTraffic.setDeviceId(device.getMoId());
        result.add(totalIfTraffic);
        for (int i = 0; i < nowData.size(); ++i) {
            DeviceIfTraffic tmpObj = nowData.get(i);
            DeviceIfTraffic ifTrafficObj = new DeviceIfTraffic();
            ifTrafficObj.setDeviceId(tmpObj.getDeviceId());
            ifTrafficObj.setMonitorTime(tmpObj.getMonitorTime());
            ifTrafficObj.setIfIndex(tmpObj.getIfIndex());
            double intTime = (double)(nowData.get(i).getMonitorTime() - previousData.get(i).getMonitorTime()) / 1000.0;
            this.logger.debug((Object)("The time between two times monitor interface traffic is : " + intTime + ". "));
            long inKbps = (long)((double)(nowData.get(i).getInKbps() - previousData.get(i).getInKbps()) / intTime);
            long inPps = (long)((double)(nowData.get(i).getInPps() - previousData.get(i).getInPps()) / intTime);
            long outKbps = (long)((double)(nowData.get(i).getOutKbps() - previousData.get(i).getOutKbps()) / intTime);
            long outPps = (long)((double)(nowData.get(i).getOutPps() - previousData.get(i).getOutPps()) / intTime);
            if (inKbps < 0L || outKbps < 0L) {
                this.logger.info((Object)"Interface traffic is more than max of long");
                return null;
            }
            this.logger.debug((Object)("Device Id is :" + device.getMoId() + "; Time:" + tmpObj.getMonitorTime() + "; Interface index is: " + tmpObj.getIfIndex() + "; InPPS number is: " + inPps + "; InKbps is: " + inKbps + "; OutPPS number is: " + outPps + "; OutKbps is: " + outKbps + ". "));
            ifTrafficObj.setInKbps(inKbps);
            ifTrafficObj.setInPps(inPps);
            ifTrafficObj.setOutKbps(outKbps);
            ifTrafficObj.setOutPps(outPps);
            result.add(ifTrafficObj);
            if (tmpObj.getIfName().toLowerCase(Locale.getDefault()).contains("trunk") || tmpObj.getIfName().toLowerCase(Locale.getDefault()).contains(".")) continue;
            totalIfTraffic.setInKbps(inKbps + totalIfTraffic.getInKbps());
            totalIfTraffic.setInPps(inPps + totalIfTraffic.getInPps());
            totalIfTraffic.setOutKbps(outKbps + totalIfTraffic.getOutKbps());
            totalIfTraffic.setOutPps(outPps + totalIfTraffic.getOutPps());
        }
        if (null != this.devFlowMap) {
            this.logger.info((Object)("devFlowMap.size  is " + this.devFlowMap.size() + " in MonitorDevIfTraffic"));
        }
        if (null != this.devFlowMap && !this.devFlowMap.isEmpty()) {
            this.thresholdFlow = this.devFlowMap.get(device.getMoId());
            if (null != this.thresholdFlow) {
                long curInFlowVaule = totalIfTraffic.getInKbps() / 1000L;
                this.thresholdFlow.setCurFlowValue(String.valueOf(curInFlowVaule));
                this.thresholdFlow.setDeviceId(device.getMoId());
                this.thresholdFlow.setDeviceIp(device.getIpAddress());
                this.thresholdFlow.setDeviceName(device.getName());
                long devFlowValue = Long.parseLong(this.thresholdFlow.getDevFlowValue());
                long curFlowValue = Long.parseLong(this.thresholdFlow.getCurFlowValue());
                this.logger.info((Object)("cloud clean module need,curFlowValue is " + curFlowValue + ";devFlowValue is " + devFlowValue + "deviceId is " + device.getMoId()));
                if (curFlowValue > devFlowValue) {
                    if (!this.deviceLastStatus.isEmpty() && this.deviceLastStatus.contains(device.getMoId())) {
                        if (this.isAbnormalStatus.isEmpty() || !this.isAbnormalStatus.contains(device.getMoId())) {
                            this.logger.info((Object)("cloud clean module deviceFlow overrun alarm,curFlowValue is " + curFlowValue + "; devFlowValue is " + devFlowValue + "; deviceId is " + device.getMoId()));
                            if (null == this.cloudCleanAlarmHandler) {
                                this.cloudCleanAlarmHandler = (CloudCleanAlarmHandlerService)ServiceContext.getInstance().getService("cloudCleanAlarmHandler", CloudCleanAlarmHandlerService.class);
                            }
                            this.cloudCleanAlarmHandler.cloudCleanAbnormalAlarm(this.thresholdFlow);
                            this.isAbnormalStatus.add(device.getMoId());
                            this.iCloudCleanConfigService.notifyDevFlowList(this.thresholdFlow);
                            this.logger.info((Object)"cloud clean module deviceFlow overrun alarm,send notify");
                        } else {
                            try {
                                this.iCloudCleanConfigService.notifyDevFlowList(this.thresholdFlow);
                            }
                            catch (LegoCheckedException e) {
                                this.logger.error((Object)("Cloud cleaning policy enabled failed!" + e.getMessage()));
                            }
                        }
                    } else {
                        this.deviceLastStatus.add(device.getMoId());
                    }
                } else {
                    if (!this.deviceLastStatus.isEmpty() && this.deviceLastStatus.contains(device.getMoId())) {
                        this.deviceLastStatus.remove(device.getMoId());
                    }
                    if (!this.isAbnormalStatus.isEmpty() && this.isAbnormalStatus.contains(device.getMoId())) {
                        this.logger.info((Object)("cloud clean module deviceFlow overrun alarm recovery,curFlowValue is " + curFlowValue + "; devFlowValue is " + devFlowValue + "; deviceId is " + device.getMoId()));
                        if (null == this.cloudCleanAlarmHandler) {
                            this.cloudCleanAlarmHandler = (CloudCleanAlarmHandlerService)ServiceContext.getInstance().getService("cloudCleanAlarmHandler", CloudCleanAlarmHandlerService.class);
                        }
                        this.cloudCleanAlarmHandler.cloudCleanAbnormalAlarmClear(this.thresholdFlow);
                        this.isAbnormalStatus.remove(device.getMoId());
                        this.iCloudCleanConfigService.deleteByAlarm(device.getMoId());
                    }
                }
            }
        }
        return result;
    }

    private List<DeviceIfTraffic> monitorDevOriginalTraff(AticDevice aticDevice) {
        List<Interface> interfaceList = this.aticDeviceService.getIfNeedMonitor(aticDevice.getMoId());
        ArrayList<DeviceIfTraffic> resultList = new ArrayList<DeviceIfTraffic>();
        List<TableEvent> trafficList = null;
        String[] ifTrafficOid = new String[]{".1.3.6.1.2.1.31.1.1.1.6", ".1.3.6.1.2.1.31.1.1.1.10", ".1.3.6.1.2.1.31.1.1.1.7", ".1.3.6.1.2.1.31.1.1.1.8", ".1.3.6.1.2.1.31.1.1.1.9", ".1.3.6.1.2.1.31.1.1.1.11", ".1.3.6.1.2.1.31.1.1.1.12", ".1.3.6.1.2.1.31.1.1.1.13"};
        try {
            trafficList = this.aticDeviceService.snmpGetTableOrigial(ifTrafficOid, aticDevice.getMoId());
        }
        catch (Exception e) {
            this.logger.error((Object)("getSnmpAPI error, deviceId: " + aticDevice.getMoId() + ". " + e.getMessage()));
            return resultList;
        }
        if (null == trafficList || trafficList.isEmpty()) {
            return null;
        }
        for (TableEvent item : trafficList) {
            DeviceIfTraffic trafficObj = new DeviceIfTraffic();
            if (null == item.getIndex()) continue;
            int index = Integer.parseInt(item.getIndex().toString());
            boolean needMonitor = false;
            for (Interface interf : interfaceList) {
                if (interf.getIfIndex() != index) continue;
                trafficObj.setIfName(interf.getIfDescr());
                needMonitor = true;
                break;
            }
            if (!needMonitor) continue;
            VariableBinding[] vb = item.getColumns();
            long inKbps = vb[0].getVariable().toLong() * 8L / 1024L;
            long outKbps = vb[1].getVariable().toLong() * 8L / 1024L;
            long inPpsnu = vb[2].getVariable().toLong();
            long inPpsu = vb[3].getVariable().toLong();
            long inPpsb = vb[4].getVariable().toLong();
            long inPps = inPpsnu + inPpsu + inPpsb;
            long outPpsnu = vb[5].getVariable().toLong();
            long outPpsu = vb[6].getVariable().toLong();
            long outPpsb = vb[7].getVariable().toLong();
            long outPps = outPpsnu + outPpsu + outPpsb;
            long logTime = System.currentTimeMillis();
            trafficObj.setDeviceId(aticDevice.getMoId());
            trafficObj.setMonitorTime(logTime);
            trafficObj.setIfIndex(index);
            trafficObj.setInKbps(inKbps);
            trafficObj.setInPps(inPps);
            trafficObj.setOutKbps(outKbps);
            trafficObj.setOutPps(outPps);
            resultList.add(trafficObj);
        }
        return resultList;
    }

    public Map<Long, CloudCleanConfigDevFlow> getDevFlowMap() {
        return this.devFlowMap;
    }

    public void setDevFlowMap(Map<Long, CloudCleanConfigDevFlow> devFlowMap) {
        this.devFlowMap = devFlowMap;
    }

    public Map<Long, List<DeviceIfTraffic>> getDeviceTrafficMap() {
        return this.deviceTrafficMap;
    }

    public void setDeviceTrafficMap(Map<Long, List<DeviceIfTraffic>> deviceTrafficMap) {
        this.deviceTrafficMap = deviceTrafficMap;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IfTrafficService getIfTrafficService() {
        return this.ifTrafficService;
    }

    public void setIfTrafficService(IfTrafficService ifTrafficService) {
        this.ifTrafficService = ifTrafficService;
    }

    public CloudCleanConfigDevFlow getThresholdFlow() {
        return this.thresholdFlow;
    }

    public void setThresholdFlow(CloudCleanConfigDevFlow thresholdFlow) {
        this.thresholdFlow = thresholdFlow;
    }

    public CloudCleanAlarmHandlerService getCloudCleanAlarmHandler() {
        return this.cloudCleanAlarmHandler;
    }

    public void setCloudCleanAlarmHandler(CloudCleanAlarmHandlerService cloudCleanAlarmHandler) {
        this.cloudCleanAlarmHandler = cloudCleanAlarmHandler;
    }
}

