/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.mediation.synchronize.snmp.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.mediation.synchronize.snmp.model.SnmpSynchronizeParameter;
import com.huawei.atic.south.model.SnmpPara;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.UserTarget;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class SnmpSynchronizeUtil {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private static SnmpSynchronizeUtil instance = new SnmpSynchronizeUtil();

    public List<String[]> getMibValueFromAgent(List<String> targetOidList, SnmpSynchronizeParameter snmpSynchronizeParameter) {
        List<String> snmpResult = this.getMibStringValueFromAgent(targetOidList, snmpSynchronizeParameter, -95);
        String[] tmpResult = new String[snmpResult.size()];
        snmpResult.toArray(tmpResult);
        ArrayList<String[]> result = new ArrayList<String[]>();
        result.add(tmpResult);
        return result;
    }

    public List<String> getMibResponseFromAgent(List<String> targetOidList, SnmpSynchronizeParameter snmpSynchronizeParameter) {
        return this.getMibStringValueFromAgent(targetOidList, snmpSynchronizeParameter, -95);
    }

    public List<String> getMibStringValueFromAgent(List<String> targetOidList, SnmpSynchronizeParameter snmpSynchronizeParameter, int pduType) {
        LOGGER.info((Object)("input targetOidList is : " + targetOidList));
        SnmpPara snmpPara = snmpSynchronizeParameter.getSnmpPara();
        int timeout = snmpPara.getTimeout();
        LOGGER.info((Object)("time out value is: " + timeout + " ms"));
        snmpPara.setTimeout(timeout * 1000);
        ResponseEvent response = null;
        response = snmpPara.getVersion() == 3 ? this.snmpv3Get(targetOidList, snmpSynchronizeParameter, pduType) : this.snmpv2Get(targetOidList, snmpSynchronizeParameter, pduType);
        snmpPara.setTimeout(timeout);
        if (null == response) {
            return Collections.EMPTY_LIST;
        }
        return this.getSnmpStringResultByResponse(response);
    }

    public boolean isSnmpReachable(String ipAddress, SnmpPara snmpPara) {
        SnmpSynchronizeParameter snmpSynPara = new SnmpSynchronizeParameter();
        snmpSynPara.setDeviceIp(ipAddress);
        snmpSynPara.setSnmpPara(snmpPara);
        String[] targetOidArray = new String[]{"1.3.6.1.2.1.1.2.0"};
        List<String> result = this.getMibStringValueFromAgent(Arrays.asList(targetOidArray), snmpSynPara, -95);
        return result != null && result.size() == 1 && result.get(0).length() > 0;
    }

    public OID getSnmpAuthProtocolOID(SnmpPara snmp) {
        int authProtocolNum = snmp.getAuthProtocolNum();
        if (authProtocolNum == 21) {
            return AuthMD5.ID;
        }
        if (authProtocolNum == 22) {
            return AuthSHA.ID;
        }
        return null;
    }

    public OID getSnmpPrivateProtocolOID(SnmpPara snmp) {
        int privateProtocolNum = snmp.getEncryptProtocolNum();
        if (privateProtocolNum == 50) {
            return PrivDES.ID;
        }
        if (privateProtocolNum == 48) {
            return PrivAES128.ID;
        }
        if (privateProtocolNum == 49) {
            return PrivAES256.ID;
        }
        return null;
    }

    public OctetString getOctString(String value) {
        if (value != null) {
            return new OctetString(value);
        }
        return null;
    }

    public UserTarget createUserTarget(SnmpPara snmpPara, String ipAddress) {
        UserTarget target = new UserTarget();
        UdpAddress targetaddress = new UdpAddress(ipAddress + "/" + snmpPara.getPort());
        target.setAddress((Address)targetaddress);
        target.setRetries(snmpPara.getRetries());
        target.setTimeout((long)snmpPara.getTimeout());
        target.setVersion(snmpPara.getVersion());
        target.setSecurityName(this.getOctString(snmpPara.getSecurityName()));
        return target;
    }

    public UsmUser createUsmUser(SnmpPara snmpPara) {
        String authPwd = null;
        String encryPwd = null;
        if (null != snmpPara.getAuthPwd()) {
            authPwd = DataProtectServiceConst.sdpDecryptLocalBuffer((String)snmpPara.getAuthPwd()).toString();
        }
        if (null != snmpPara.getEncryptPwd()) {
            encryPwd = DataProtectServiceConst.sdpDecryptLocalBuffer((String)snmpPara.getEncryptPwd()).toString();
        }
        return new UsmUser(this.getOctString(snmpPara.getSecurityName()), this.getSnmpAuthProtocolOID(snmpPara), this.getOctString(authPwd), this.getSnmpPrivateProtocolOID(snmpPara), this.getOctString(encryPwd));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEvent snmpv3Get(List<String> targetOidList, SnmpSynchronizeParameter snmpSynchronizeParameter, int pduType) {
        SnmpPara snmpPara = snmpSynchronizeParameter.getSnmpPara();
        Snmp snmp = null;
        try {
            ResponseEvent response;
            snmp = new Snmp((TransportMapping)new DefaultUdpTransportMapping());
            USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
            SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
            UsmUser user = this.createUsmUser(snmpPara);
            if (snmpPara.getContextEngineId() != null) {
                snmp.getUSM().addUser(this.getOctString(snmpPara.getSecurityName()), this.getOctString(snmpPara.getContextEngineId()), user);
            } else {
                snmp.getUSM().addUser(this.getOctString(snmpPara.getSecurityName()), null, user);
            }
            snmp.listen();
            UserTarget target = this.createUserTarget(snmpPara, snmpSynchronizeParameter.getDeviceIp());
            if (this.getSnmpAuthProtocolOID(snmpPara) == null) {
                target.setSecurityLevel(1);
            } else if (this.getSnmpPrivateProtocolOID(snmpPara) != null) {
                target.setSecurityLevel(3);
            } else {
                target.setSecurityLevel(2);
            }
            ScopedPDU pdu = new ScopedPDU();
            this.addOid2Pdu((PDU)pdu, targetOidList);
            pdu.setType(pduType);
            if (snmpPara.getContextName() != null) {
                pdu.setContextName(this.getOctString(snmpPara.getContextName()));
            }
            if (snmpPara.getContextEngineId() != null) {
                pdu.setContextEngineID(this.getOctString(snmpPara.getContextEngineId()));
            }
            ResponseEvent responseEvent = response = snmp.get((PDU)pdu, (Target)target);
            return responseEvent;
        }
        catch (Exception e) {
            LOGGER.error((Object)"snmp get v3 failed", (Throwable)e);
        }
        finally {
            if (null != snmp) {
                try {
                    snmp.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public void addOid2Pdu(PDU pdu, List<String> targetOidList) {
        for (String oidValue : targetOidList) {
            pdu.add(new VariableBinding(new OID(oidValue)));
        }
    }

    public Map<String, String> getSnmpResultByResponse(ResponseEvent responseEvent) {
        HashMap<String, String> snmpResult = new HashMap<String, String>();
        PDU response = responseEvent.getResponse();
        if (response == null) {
            LOGGER.info((Object)"TimeOut...:");
        } else if (response.getErrorStatus() == 0) {
            Vector vbs = response.getVariableBindings();
            for (VariableBinding vb : vbs) {
                snmpResult.put(vb.getOid().toString(), vb.getVariable().toString());
            }
        } else {
            LOGGER.info((Object)("Error:" + response.getErrorStatusText()));
        }
        return snmpResult;
    }

    public List<String> getSnmpStringResultByResponse(ResponseEvent responseEvent) {
        ArrayList<String> result = new ArrayList<String>();
        PDU response = responseEvent.getResponse();
        if (response == null) {
            LOGGER.info((Object)"TimeOut...:");
        } else if (response.getErrorStatus() == 0) {
            Vector vbs = response.getVariableBindings();
            for (VariableBinding vb : vbs) {
                result.add(vb.getVariable().toString());
            }
        } else {
            LOGGER.info((Object)("Error:" + response.getErrorStatusText()));
        }
        return result;
    }

    public CommunityTarget createCommunityTargetOfV2Snmp(SnmpPara snmpPara, String ipAddress) {
        CommunityTarget comtarget = new CommunityTarget();
        StringBuffer readComm = DataProtectServiceConst.sdpDecryptLocalBuffer((String)snmpPara.getReadComm());
        OctetString community = this.getOctString(readComm.toString());
        comtarget.setCommunity(community);
        if (snmpPara.getVersion() == 0) {
            comtarget.setVersion(0);
        } else {
            comtarget.setVersion(1);
        }
        UdpAddress targetaddress = new UdpAddress(ipAddress + "/" + snmpPara.getPort());
        comtarget.setAddress((Address)targetaddress);
        comtarget.setRetries(snmpPara.getRetries());
        comtarget.setTimeout((long)snmpPara.getTimeout());
        return comtarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEvent snmpv2Get(List<String> targetOidList, SnmpSynchronizeParameter snmpSynchronizeParameter, int pduType) {
        LOGGER.info((Object)("input targetOidList is(v2) : " + targetOidList));
        SnmpPara snmpPara = snmpSynchronizeParameter.getSnmpPara();
        Snmp snmp = null;
        try {
            ResponseEvent response;
            snmp = new Snmp((TransportMapping)new DefaultUdpTransportMapping());
            snmp.listen();
            CommunityTarget comtarget = this.createCommunityTargetOfV2Snmp(snmpPara, snmpSynchronizeParameter.getDeviceIp());
            PDU pdu = new PDU();
            this.addOid2Pdu(pdu, targetOidList);
            pdu.setType(pduType);
            ResponseEvent responseEvent = response = snmp.get(pdu, (Target)comtarget);
            return responseEvent;
        }
        catch (Exception e) {
            LOGGER.error((Object)"snmp get v2 failed Exception", (Throwable)e);
        }
        finally {
            if (null != snmp) {
                try {
                    snmp.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static SnmpSynchronizeUtil getInstance() {
        return instance;
    }
}

