/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.nem.discover.service.impl;

import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.resource.sdk.model.DeviceTypeRelation;
import com.hs.lego.cbb.resource.sdk.model.ManagedObject;
import com.hs.lego.com.south.sdk.ping.PingServiceImpl;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.nem.webnms.sdk.service.IPingService;
import com.huawei.atic.core.sdk.common.ServiceProvider;
import com.huawei.atic.mediation.synchronize.snmp.model.SnmpSynchronizeParameter;
import com.huawei.atic.mediation.synchronize.snmp.util.SnmpSynchronizeUtil;
import com.huawei.atic.nem.discover.model.DiscoveryPolicy;
import com.huawei.atic.nem.discover.model.DiscoveryResult;
import com.huawei.atic.nem.discover.sdk.service.INodeEditor;
import com.huawei.atic.nem.discover.util.DiscoveryUtil;
import com.huawei.atic.resource.model.Node;
import com.huawei.atic.resource.sdk.service.IResourceService;
import com.huawei.atic.south.model.SnmpPara;
import com.huawei.atic.south.model.TelnetPara;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public abstract class AbstractDiscoveryThread
implements Runnable {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private static final String THIRD_PART_DEVIE = "Other_Device_i18n";
    private static final String ANTIDDOS1880_OID = "1.3.6.1.4.1.2011.2.321.1.185";
    private static final String ANTIDDOS1820_OID = "1.3.6.1.4.1.2011.2.321.1.184";
    private static final String ANTIDDOS1825_OID = "1.3.6.1.4.1.2011.2.321.1.225";
    private static final String ANTIDDOS12004_OID = "1.3.6.1.4.1.2011.2.321.1.247,1.3.6.1.4.1.2011.2.321.1.248";
    private static final String ANTIDDOS12008_OID = "1.3.6.1.4.1.2011.2.321.1.249,1.3.6.1.4.1.2011.2.321.1.250";
    private static final String ANTIDDOS1800 = "AntiDDoS1800";
    private static final String ANTIDDOS1880 = "AntiDDoS1880";
    private static final String ANTIDDOS1820 = "AntiDDoS1820";
    private static final String ANTIDDOS1825 = "AntiDDoS1825";
    private static final String ANTIDDOS12000 = "AntiDDoS12000";
    private static final String ANTIDDOS12004 = "AntiDDoS12004";
    private static final String ANTIDDOS12008 = "AntiDDoS12008";
    private static final String THIRD_PART_OSVERSION = "Default Version";
    private static final long NUM_602020 = 602020L;
    protected List<INodeEditor> nodelist;
    private DiscoveryPolicy policy;
    private boolean cancel = false;
    private IPingService pingUtil = new PingServiceImpl();
    private IResourceService resourceService = null;

    public AbstractDiscoveryThread(DiscoveryPolicy policy) {
        this.policy = policy;
    }

    public DiscoveryPolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(DiscoveryPolicy policy) {
        this.policy = policy;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public void setCancel(boolean cancel) {
        this.cancel = cancel;
    }

    protected Node createNodeByIpBase(String ip, String uuid, String name, String mainDeyType, String subDevType) {
        Node node = new Node();
        node.setIpAddress(ip);
        node.setSysOid("");
        String newUuid = uuid + "_" + mainDeyType + "_" + subDevType;
        node.setUuid(newUuid);
        node.setName(name);
        node.setDiscoveredTime(new Timestamp(System.currentTimeMillis()));
        node.setMainType(mainDeyType);
        node.setSubType(subDevType);
        node.setLocation(this.getPolicy().getLocation());
        node.setIsTopMo(true);
        SnmpPara snmpPara = this.getPolicy().getSnmpPara();
        snmpPara.setTemplateName(UUID.randomUUID().toString());
        snmpPara.setDiscoveryPolicy(null);
        snmpPara.setId(null);
        snmpPara.setIsTemplate(false);
        snmpPara.setIsManagementProtocol(true);
        snmpPara.setNode(node);
        node.addManagementProtocol(SnmpPara.class.getName(), snmpPara);
        TelnetPara telnetPara = this.getPolicy().getTelnetPara();
        if (telnetPara != null) {
            telnetPara.setTemplateName(UUID.randomUUID().toString());
            telnetPara.setDiscoveryPolicy(null);
            telnetPara.setId(null);
            telnetPara.setIsTemplate(false);
            telnetPara.setIsManagementProtocol(true);
            telnetPara.setNode(node);
            node.addManagementProtocol(TelnetPara.class.getName(), telnetPara);
        }
        node.setTopoElementId(this.getPolicy().getTopoElementId());
        return node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void snmpDiscovery(String ip, String devName) {
        try {
            if (DiscoveryUtil.checkIpDuplicate(ip)) {
                throw new LegoCheckedException(1056L);
            }
            if (DiscoveryUtil.checkMaxCount()) {
                throw new LegoCheckedException(363L);
            }
            if (this.isIpReachable(ip)) {
                List<String> resultStringArrayList;
                block35: {
                    resultStringArrayList = null;
                    try {
                        ServiceProvider.getInstance().getResourceService().snmpReadTest(ip, this.getPolicy().getSnmpPara());
                        String[] targetOidArray = new String[]{"1.3.6.1.2.1.1.1.0", "1.3.6.1.2.1.1.2.0", "1.3.6.1.2.1.1.5.0"};
                        SnmpSynchronizeParameter snmpSynchronizeParameter = new SnmpSynchronizeParameter(ip, null, this.getPolicy().getManagementProtocolMap(), null, null, null, null, null, null, null, null, null);
                        resultStringArrayList = SnmpSynchronizeUtil.getInstance().getMibResponseFromAgent(Arrays.asList(targetOidArray), snmpSynchronizeParameter);
                    }
                    catch (Exception e) {
                        if (this.getPolicy().getDiscoveryNonSnmpDevice().booleanValue()) break block35;
                        throw e;
                    }
                }
                if (resultStringArrayList == null || resultStringArrayList.size() != 3) {
                    LOGGER.warn((Object)("can not get system info from mib in auto discovery, ip is : " + ip + ", snmpPara is : " + this.getPolicy().getSnmpPara()));
                    if (resultStringArrayList != null) {
                        LOGGER.warn((Object)"the mib node is: 1.3.6.1.2.1.1.1.0 && 1.3.6.1.2.1.1.2.0 && 1.3.6.1.2.1.1.5.0");
                        LOGGER.warn((Object)("the snmp result is: " + resultStringArrayList.toString()));
                    }
                    if (!this.getPolicy().getDiscoveryNonSnmpDevice().booleanValue()) throw new LegoCheckedException(1053L);
                    Node node = this.createNodeByIpBase(ip, ip, ip, THIRD_PART_DEVIE, THIRD_PART_DEVIE);
                    node.setDevOsVersion(THIRD_PART_OSVERSION);
                    if (this.nodelist != null && !this.nodelist.isEmpty()) {
                        INodeEditor nodeEditor = this.nodelist.get(0);
                        node = nodeEditor.editNode(node, this.getPolicy());
                    }
                    if (this.getResourceService().isLogSourceNameDuplicate(ip)) {
                        throw new LegoCheckedException(602020L);
                    }
                    ServiceProvider.getInstance().getResourceService().addMoAndSubMo((ManagedObject)node);
                    ServiceProvider.getInstance().getResourceService().addUserMO(this.policy.getOperator(), node.getMoId());
                    DiscoveryResult discoveryResult = new DiscoveryResult();
                    discoveryResult.setDiscoveryPolicy(this.getPolicy());
                    discoveryResult.setFinishTime(new Timestamp(System.currentTimeMillis()));
                    discoveryResult.setIpAddress(ip);
                    discoveryResult.setSuccess(true);
                    discoveryResult.setDeviceMainTypeI18n(THIRD_PART_DEVIE);
                    discoveryResult.setDeviceSubTypeI18n(THIRD_PART_DEVIE);
                    discoveryResult.setDeviceOsVersion(node.getDevOsVersion());
                    ServiceProvider.getInstance().getDiscoveryService().updateDiscoveryResultAndPolicy(discoveryResult, true);
                } else {
                    ManagedObject oldMo;
                    String sysDesc = (String)resultStringArrayList.get(0);
                    String sysObjectID = ((String)resultStringArrayList.get(1)).trim();
                    String sysName = (String)resultStringArrayList.get(2);
                    if (sysObjectID.contains(".iso.org.dod.internet.private.enterprises")) {
                        sysObjectID = sysObjectID.replace(".iso.org.dod.internet.private.enterprises", ".1.3.6.1.4.1");
                        sysObjectID = sysObjectID.replace("huawei.huaweiUtility", "2011.6");
                        sysObjectID = sysObjectID.replace("huawei", "2011");
                        sysObjectID = sysObjectID.replace("huaweiUtility", "6");
                        LOGGER.info((Object)("converted sysObjectID is : " + sysObjectID));
                    }
                    String uuid = ip;
                    DeviceTypeRelation devRelation = this.getResourceService().getDeviceTypeBySysOid(sysObjectID);
                    if (ANTIDDOS1880_OID.equals(sysObjectID) && -1 != sysDesc.indexOf(ANTIDDOS1800)) {
                        sysDesc = sysDesc.replace(ANTIDDOS1800, ANTIDDOS1880);
                    }
                    if (ANTIDDOS1820_OID.equals(sysObjectID) && -1 != sysDesc.indexOf(ANTIDDOS1800)) {
                        sysDesc = sysDesc.replace(ANTIDDOS1800, ANTIDDOS1820);
                    }
                    if (ANTIDDOS1825_OID.equals(sysObjectID) && -1 != sysDesc.indexOf(ANTIDDOS1800)) {
                        sysDesc = sysDesc.replace(ANTIDDOS1800, ANTIDDOS1825);
                    }
                    if (ANTIDDOS12004_OID.contains(sysObjectID) && -1 != sysDesc.indexOf(ANTIDDOS12000)) {
                        sysDesc = sysDesc.replace(ANTIDDOS12000, ANTIDDOS12004);
                    }
                    if (ANTIDDOS12008_OID.contains(sysObjectID) && -1 != sysDesc.indexOf(ANTIDDOS12000)) {
                        sysDesc = sysDesc.replace(ANTIDDOS12000, ANTIDDOS12008);
                    }
                    Node node = null;
                    if (devName != null && !devName.isEmpty()) {
                        sysName = devName;
                    }
                    if (this.getPolicy().isAddIpSuddix()) {
                        sysName = sysName + "-" + ip;
                    }
                    if (sysName.length() > 32) {
                        sysName = sysName.substring(0, 32);
                    }
                    if (devRelation != null) {
                        node = this.createNodeByIpBase(ip, uuid, sysName, devRelation.getParentType(), devRelation.getChildType());
                    } else {
                        if (this.getPolicy().getDeviceType() == null) {
                            throw new LegoCheckedException(1063L);
                        }
                        node = this.createNodeByIpBase(ip, uuid, sysName, THIRD_PART_DEVIE, THIRD_PART_DEVIE);
                        node.setDevOsVersion(THIRD_PART_OSVERSION);
                    }
                    node.setDiscoveredTime(new Timestamp(System.currentTimeMillis()));
                    node.setSysDescr(sysDesc);
                    node.setSysOid(sysObjectID);
                    if (devRelation != null) {
                        String osVersion = node.getFirewallDevOSVersionName(sysDesc);
                        if (null != osVersion) {
                            node.setDevOsVersion(osVersion);
                        } else {
                            node.setMainType(THIRD_PART_DEVIE);
                            node.setSubType(THIRD_PART_DEVIE);
                            node.setDevOsVersion(THIRD_PART_OSVERSION);
                        }
                    }
                    if ((oldMo = this.getResourceService().getMoByUuid(uuid, true)) != null) {
                        throw new LegoCheckedException(354L);
                    }
                    if (this.getResourceService().isLogSourceNameDuplicate(sysName)) {
                        throw new LegoCheckedException(602020L);
                    }
                    this.getResourceService().addMo((ManagedObject)node);
                    ServiceProvider.getInstance().getResourceService().addUserMO(this.policy.getOperator(), node.getMoId());
                    this.constructDiscoveryResult(node, true, null);
                    try {
                        TimeUnit.SECONDS.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        LOGGER.error((Object)("sleep was interrupted!" + e.getMessage()));
                    }
                }
            } else {
                LOGGER.warn((Object)("icmp ping is failed, ip is : " + ip));
                this.constructDiscoveryResult(ip, false, (Long)1051L);
            }
            try {
                TimeUnit.MILLISECONDS.sleep(1000L);
                return;
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)("exception when sleep!" + e.getMessage()));
            }
            return;
        }
        catch (LegoCheckedException legoException) {
            LOGGER.error((Object)("exception when discovery!" + legoException.getMessage()));
            this.constructDiscoveryResult(ip, false, (Long)legoException.getErrorCode());
            return;
        }
        catch (Exception e) {
            LOGGER.error((Object)("exception when discovery!" + e.getMessage()));
            this.constructDiscoveryResult(ip, false, (Long)1053L);
        }
    }

    public void stop() {
        this.cancel = true;
        this.policy.setFinished(true);
        this.policy.setEndDiscoveryTime(new Timestamp(System.currentTimeMillis()));
        this.policy.setDiscoveryPercentStr("100%");
        this.policy.setDiscoveryPercentInt(100);
        this.policy.setManualStopped(true);
    }

    public boolean isIpReachable(String ipAddress) {
        boolean reachable = false;
        int count = 0;
        while (!reachable && count < 3) {
            ++count;
            try {
                reachable = this.pingUtil.ping(ipAddress);
            }
            catch (Exception e) {
                LOGGER.error((Object)("pinging ip : " + ipAddress + "...... failed!" + e.getMessage()));
            }
            if (reachable) {
                LOGGER.info((Object)(AticUtil.getcleanedMessage((String)ipAddress) + " is reachable"));
                continue;
            }
            LOGGER.info((Object)(AticUtil.getcleanedMessage((String)ipAddress) + " is not reachable, try times is : " + count));
            if (count == 3) continue;
            try {
                TimeUnit.MICROSECONDS.sleep(500L);
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)("exception when sleep!" + e.getMessage()));
            }
        }
        return reachable;
    }

    protected IResourceService getResourceService() {
        if (this.resourceService == null) {
            this.resourceService = (IResourceService)ServiceContext.getInstance().getService("resourceService", IResourceService.class);
        }
        if (this.resourceService == null) {
            LOGGER.error((Object)"can not get resource service");
        }
        return this.resourceService;
    }

    protected void constructDiscoveryResult(String ipAddress, boolean result, Long errorCode) {
        DiscoveryResult discoveryResult = new DiscoveryResult();
        discoveryResult.setDiscoveryPolicy(this.getPolicy());
        discoveryResult.setFinishTime(new Timestamp(System.currentTimeMillis()));
        discoveryResult.setIpAddress(ipAddress);
        discoveryResult.setSuccess(result);
        if (errorCode != null) {
            discoveryResult.setErrorCode(errorCode);
        }
        ServiceProvider.getInstance().getDiscoveryService().updateDiscoveryResultAndPolicy(discoveryResult, true);
    }

    protected void constructDiscoveryResult(Node node, boolean result, Long errorCode) {
        DiscoveryResult discoveryResult = new DiscoveryResult();
        discoveryResult.setDiscoveryPolicy(this.getPolicy());
        discoveryResult.setFinishTime(new Timestamp(System.currentTimeMillis()));
        discoveryResult.setIpAddress(node.getIpAddress());
        discoveryResult.setSuccess(result);
        discoveryResult.setDeviceMainTypeI18n(node.getMainType());
        discoveryResult.setDeviceSubTypeI18n(node.getSubType());
        discoveryResult.setDeviceOsVersion(node.getDevOsVersion());
        ServiceProvider.getInstance().getDiscoveryService().updateDiscoveryResultAndPolicy(discoveryResult, true);
    }

    @Override
    public abstract void run();
}

