/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.nem.discover.service.impl;

import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.resource.sdk.model.DeviceTypeRelation;
import com.hs.lego.cbb.resource.sdk.model.ManagedObject;
import com.hs.lego.cbb.user.sdk.service.IUserMgr;
import com.hs.lego.com.south.sdk.ping.PingServiceImpl;
import com.hs.lego.comm.internal.jms.IMessageCenter;
import com.hs.lego.comm.internal.jms.MessageTopic;
import com.hs.lego.comm.internal.jms.MessageUnit;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ICacheService;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogResultLevel;
import com.hs.lego.nem.webnms.sdk.service.IPingService;
import com.huawei.atic.cbb.resource.dao.IResourceDao;
import com.huawei.atic.core.sdk.common.ServiceProvider;
import com.huawei.atic.mediation.synchronize.snmp.model.SnmpSynchronizeParameter;
import com.huawei.atic.mediation.synchronize.snmp.util.SnmpSynchronizeUtil;
import com.huawei.atic.nem.discover.dao.IDiscoveryDao;
import com.huawei.atic.nem.discover.model.DeviceSubType;
import com.huawei.atic.nem.discover.model.DeviceTypeAndUrl;
import com.huawei.atic.nem.discover.model.DiscoveryPolicy;
import com.huawei.atic.nem.discover.model.DiscoveryResult;
import com.huawei.atic.nem.discover.model.DynamicFieldOfDiscovery;
import com.huawei.atic.nem.discover.model.ImportedDiscoveryItem;
import com.huawei.atic.nem.discover.model.ParaTemplateAndUrl;
import com.huawei.atic.nem.discover.model.ProtocolAndUrl;
import com.huawei.atic.nem.discover.sdk.service.IDeviceTypeFilter;
import com.huawei.atic.nem.discover.sdk.service.IDiscoveryService;
import com.huawei.atic.nem.discover.sdk.service.IManagementProtocolAndPageUrlHandler;
import com.huawei.atic.nem.discover.sdk.service.IManualNodeEditor;
import com.huawei.atic.nem.discover.sdk.service.INodeEditor;
import com.huawei.atic.nem.discover.service.impl.AbstractDiscoveryThread;
import com.huawei.atic.nem.discover.service.impl.AutoDiscoveryThread;
import com.huawei.atic.nem.discover.service.impl.CleanDiscoveryCacheThread;
import com.huawei.atic.nem.discover.service.impl.DiscoveryModuleUncaughtExceptionHandler;
import com.huawei.atic.nem.discover.service.impl.IcmpDiscoveryThread;
import com.huawei.atic.nem.discover.service.impl.ImportDiscoveryThread;
import com.huawei.atic.nem.discover.util.DiscoveryUtil;
import com.huawei.atic.nem.discover.util.PropertyUtil;
import com.huawei.atic.nem.discover.util.WatchUtil;
import com.huawei.atic.resource.model.Node;
import com.huawei.atic.resource.sdk.service.IResourceService;
import com.huawei.atic.south.model.Protocol;
import com.huawei.atic.south.model.SnmpPara;
import com.huawei.atic.south.model.TelnetPara;
import com.huawei.atic.system.template.sdk.service.ITemplateService;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class DiscoveryServiceImpl
implements IDiscoveryService {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private static final Object LOCK_CACHE = new Object();
    private static boolean cleanDiscoveryCacheThreadStarted = false;
    private final Object lock = new Object();
    private ICacheService<String, Object> cacheService = null;
    private IDiscoveryDao discoveryDao = null;
    private IResourceDao resourceDao;
    private IMessageCenter messageCenter = null;
    private List<INodeEditor> nodeEditorList = new ArrayList<INodeEditor>();
    private List<IManualNodeEditor> manualNodeEditorList = new ArrayList<IManualNodeEditor>();
    private List<IDeviceTypeFilter> deviceTypeFilterList = new ArrayList<IDeviceTypeFilter>();
    private Map<String, Map<String, DynamicFieldOfDiscovery>> deviceTypeDynamicFieldMap = new HashMap<String, Map<String, DynamicFieldOfDiscovery>>();
    private Map<String, String> managementProtocolPageUrlMap = new HashMap<String, String>();
    private Map<String, String> managementProtocolCreatePageUrlMap = new HashMap<String, String>();
    private ExecutorService threadPool = Executors.newFixedThreadPool(5);
    private Map<Long, AbstractDiscoveryThread> activeDiscoveryThreadMap = new ConcurrentHashMap<Long, AbstractDiscoveryThread>();
    private Set<Long> lockedDeviceWhenRefresh = Collections.synchronizedSet(new HashSet());
    private Set<Long> lockedDeviceWhenDelete = Collections.synchronizedSet(new HashSet());
    private IResourceService resourceService = null;
    private ITemplateService templateService = null;
    private IUserMgr userMgr;
    private IPingService pingUtil = new PingServiceImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchOperationResult deleteDeviceNewWithoutMsg(List<Long> moIdList) {
        Object object = this.lock;
        synchronized (object) {
            LOGGER.info((Object)("will deleteDeviceNewWithoutMsg, moIdList is : " + moIdList));
            BatchOperationResult batchOpResult = new BatchOperationResult();
            ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
            int failCount = 0;
            int operCount = moIdList.size();
            IResourceService resourceServiceTemp = this.getResourceService();
            for (Long moId : moIdList) {
                BatchOperation operation;
                LOGGER.info((Object)("willllllll delete device moid is : " + moId));
                try {
                    ManagedObject lmo = this.resourceDao.getMoByIdAndType(ManagedObject.class, moId, null);
                    LOGGER.info((Object)("llllllllllllllmo is : " + lmo));
                    if (lmo == null) {
                        LOGGER.warn((Object)("tttttthe device has been already deleted, moId is : " + moId));
                        ++failCount;
                        operation = new BatchOperation();
                        operation.setErrorCode(1028L);
                        operation.setTargetId(moId.longValue());
                        resultList.add(operation);
                        continue;
                    }
                    String key = "mo_uuid_" + lmo.getUuid();
                    if (this.cacheService.containsKey((Object)key)) {
                        LOGGER.warn((Object)("the device is synchronizing data, moId is : " + moId));
                        ++failCount;
                        BatchOperation operation2 = new BatchOperation();
                        operation2.setErrorCode(1028L);
                        operation2.setTargetId(moId.longValue());
                        resultList.add(operation2);
                        continue;
                    }
                    resourceServiceTemp.deleteMoWithoutMsg(moId);
                }
                catch (Exception e) {
                    LOGGER.error((Object)("delete device faileddddddd, moId is : " + moId + ". " + e.getMessage()));
                    ++failCount;
                    operation = new BatchOperation();
                    operation.setErrorCode(1028L);
                    ManagedObject lmo = this.resourceDao.getMoByIdAndType(ManagedObject.class, moId, null);
                    if (lmo != null) {
                        operation.setTargetName(lmo.getName());
                    } else {
                        operation.setTargetName(String.valueOf(moId));
                    }
                    resultList.add(operation);
                }
            }
            batchOpResult.setResult(resultList);
            batchOpResult.setFailCount(failCount);
            batchOpResult.setTotalCount(operCount);
            batchOpResult.setSucceedCount(operCount - failCount);
            return batchOpResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchOperationResult deleteTemplate(List<BatchOperation> operationList, String className) {
        Object object = this.lock;
        synchronized (object) {
            if (this.templateService == null) {
                this.templateService = (ITemplateService)ServiceContext.getInstance().getService("templateService", ITemplateService.class);
            }
            if (null != this.templateService) {
                return this.templateService.deleteTemplate(operationList, className);
            }
            LOGGER.error((Object)"can not get system/templateService service");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceTypeAndUrl getDeviceTypeAndUrl() {
        Object object = this.lock;
        synchronized (object) {
            DeviceTypeAndUrl deviceTypeAndUrl = new DeviceTypeAndUrl();
            String hql = "from DeviceTypeRelation";
            List deviceTypeRelationList = this.discoveryDao.findByHql(hql);
            LOGGER.info((Object)("the deviceTypeRelationList is : " + deviceTypeRelationList));
            HashMap mainSubTypeMap = new HashMap();
            if (deviceTypeRelationList != null) {
                HashMap<String, String> typeUrlMap = new HashMap<String, String>();
                for (DeviceTypeRelation deviceTypeRelation : deviceTypeRelationList) {
                    String mainType = deviceTypeRelation.getParentType();
                    String subType = deviceTypeRelation.getChildType();
                    String pageUrl = deviceTypeRelation.getPageUrl();
                    String versions = deviceTypeRelation.getVersion();
                    String defaulVer = deviceTypeRelation.getDefaultVersion();
                    if (!mainSubTypeMap.containsKey(mainType)) {
                        mainSubTypeMap.put(mainType, new HashSet());
                    }
                    if (StringUtils.hasText((String)subType)) {
                        Set subTypeSet = (Set)mainSubTypeMap.get(mainType);
                        DeviceSubType subTypeObj = new DeviceSubType(subType, versions, defaulVer);
                        subTypeSet.add(subTypeObj);
                        if (!StringUtils.hasText((String)pageUrl)) continue;
                        typeUrlMap.put(subType, pageUrl);
                        continue;
                    }
                    if (!StringUtils.hasText((String)pageUrl)) continue;
                    typeUrlMap.put(mainType, pageUrl);
                }
                deviceTypeAndUrl.setTypeUrlMap(typeUrlMap);
            }
            HashMap mapHasUnmodifiableSet = new HashMap();
            for (Map.Entry entry : mainSubTypeMap.entrySet()) {
                mapHasUnmodifiableSet.put(entry.getKey(), Collections.unmodifiableSet((Set)entry.getValue()));
            }
            Map<String, Set<DeviceSubType>> unmodifiableMainSubTypeMap = Collections.unmodifiableMap(mapHasUnmodifiableSet);
            HashMap<String, Set<DeviceSubType>> hashMap = new HashMap<String, Set<DeviceSubType>>();
            for (IDeviceTypeFilter deviceTypeFilter : this.deviceTypeFilterList) {
                Map<String, Set<DeviceSubType>> productDeviceTypeMap = deviceTypeFilter.filterDeviceType(unmodifiableMainSubTypeMap);
                LOGGER.info((Object)("filtered product device type map is : " + productDeviceTypeMap));
                if (productDeviceTypeMap == null) continue;
                for (Map.Entry<String, Set<DeviceSubType>> productDeviceTypeEntry : productDeviceTypeMap.entrySet()) {
                    String productMainType = productDeviceTypeEntry.getKey();
                    if (hashMap.containsKey(productMainType)) {
                        ((Set)hashMap.get(productMainType)).addAll((Collection)productDeviceTypeEntry.getValue());
                        continue;
                    }
                    hashMap.put(productMainType, productDeviceTypeEntry.getValue());
                }
            }
            if (hashMap.isEmpty()) {
                deviceTypeAndUrl.setMainSubTypeMap(unmodifiableMainSubTypeMap);
            } else {
                deviceTypeAndUrl.setMainSubTypeMap(hashMap);
            }
            LOGGER.info((Object)("the result deviceTypeAndUrl is : " + deviceTypeAndUrl));
            return deviceTypeAndUrl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParaTemplateAndUrl getParaTemplateAndUrl() {
        Object object = this.lock;
        synchronized (object) {
            ParaTemplateAndUrl paraTemplateAndUrl = new ParaTemplateAndUrl();
            String hql = "from Protocol p where p.isTemplate = true";
            List protocolList = this.discoveryDao.findByHql(hql);
            LOGGER.info((Object)("the result protocolList is : " + protocolList));
            if (protocolList != null) {
                HashMap<String, List<Protocol>> templateTypeInstanceMap = new HashMap<String, List<Protocol>>();
                for (Protocol protocol : protocolList) {
                    if (protocol.getIsTemplate() == null || !protocol.getIsTemplate().booleanValue()) continue;
                    String className = protocol.getClass().getName();
                    if (!templateTypeInstanceMap.containsKey(className)) {
                        templateTypeInstanceMap.put(className, new ArrayList());
                    }
                    ((List)templateTypeInstanceMap.get(className)).add(protocol);
                }
                paraTemplateAndUrl.setTemplateTypeInstanceMap(templateTypeInstanceMap);
                paraTemplateAndUrl.setTemplateTypeUrlMap(this.managementProtocolCreatePageUrlMap);
            }
            LOGGER.info((Object)("the result paraTemplateAndUrl is : " + paraTemplateAndUrl));
            return paraTemplateAndUrl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Paging getDiscoveryPolicy(int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend) {
        Object object = this.lock;
        synchronized (object) {
            LOGGER.info((Object)("will getDiscoveryPolicy, firstRowIndex is : " + firstRowIndex + ", totalRow is : " + totalRow + ", orderByField is : " + AticUtil.getcleanedMessage((String)orderByField) + ", orderByAscend is : " + orderByAscend));
            Paging discoveryPolicyPaging = this.discoveryDao.getDiscoveryPolicy(firstRowIndex, totalRow, orderByField, orderByAscend);
            List policyList = discoveryPolicyPaging.getData();
            for (DiscoveryPolicy policy : policyList) {
                if (policy.getFinished().booleanValue()) continue;
                String discoveryPolicyID = "discoveryPolicyId_" + policy.getDiscoveryPolicyId();
                Long finishedIpCount = (Long)this.cacheService.get((Object)discoveryPolicyID);
                long percent100 = 0L;
                if (finishedIpCount == null) {
                    LOGGER.warn((Object)("finishedIpCount is null in the cache, discoveryPolicyID is : " + discoveryPolicyID));
                    percent100 = 100L;
                    policy.setDiscoveryPercentStr(percent100 + "%");
                    policy.setDiscoveryPercentInt((int)percent100);
                    ServiceProvider.getInstance().getCommonService().update(policy);
                    continue;
                }
                percent100 = finishedIpCount * 100L / policy.getTotalIpCount();
                policy.setDiscoveryPercentStr(percent100 + "%");
                policy.setDiscoveryPercentInt((int)percent100);
            }
            return discoveryPolicyPaging;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiscoveryPolicy getDiscoveryPolicy(Long discoveryPolicyId) {
        Object object = this.lock;
        synchronized (object) {
            String hql;
            List protocolList;
            List policyList = this.discoveryDao.findByHql("from DiscoveryPolicy policy where policy.discoveryPolicyId = " + discoveryPolicyId);
            if (policyList == null || policyList.isEmpty()) {
                LOGGER.warn((Object)("the discovery policy does not exit, discoveryPolicyId is : " + discoveryPolicyId));
                throw new LegoCheckedException(1055L);
            }
            DiscoveryPolicy policy = (DiscoveryPolicy)policyList.get(0);
            if (!policy.getFinished().booleanValue()) {
                String discoveryPolicyID = "discoveryPolicyId_" + policy.getDiscoveryPolicyId();
                Long finishedIpCount = (Long)this.cacheService.get((Object)discoveryPolicyID);
                long percent100 = 0L;
                if (finishedIpCount == null) {
                    LOGGER.warn((Object)("finishedIpCount is null in the cache, discoveryPolicyID is : " + discoveryPolicyID));
                    percent100 = 100L;
                } else {
                    percent100 = finishedIpCount * 100L / policy.getTotalIpCount();
                }
                policy.setDiscoveryPercentStr(percent100 + "%");
                policy.setDiscoveryPercentInt((int)percent100);
            }
            if (policy.getDiscoveryStyle() == 0) {
                String[] ipRangeArr;
                Map<String, String> ipRangeMap = policy.getIpRangeMap();
                String ipRangeString = policy.getIpRangeString();
                for (String ipRange : ipRangeArr = ipRangeString.split(";")) {
                    String[] ipPair = ipRange.split("-");
                    if (ipPair[0].equals(ipPair[1])) {
                        ipRangeMap.put(ipPair[0], null);
                        continue;
                    }
                    ipRangeMap.put(ipPair[0], ipPair[1]);
                }
            }
            if ((protocolList = this.discoveryDao.findByHql(hql = "from Protocol p where p.discoveryPolicy.discoveryPolicyId = " + policy.getDiscoveryPolicyId())) != null) {
                for (Protocol protocol : protocolList) {
                    policy.addManagementProtocol(protocol.getClass().getName(), protocol);
                }
                Map<String, Protocol> managementProtocolMap = policy.getManagementProtocolMap();
                if (managementProtocolMap != null) {
                    policy.setSnmpPara((SnmpPara)managementProtocolMap.get(SnmpPara.class.getName()));
                    policy.setTelnetPara((TelnetPara)managementProtocolMap.get(TelnetPara.class.getName()));
                }
            }
            return policy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Paging getDiscoveryResult(Long discoveryPolicyId, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend) {
        Object object = this.lock;
        synchronized (object) {
            LOGGER.info((Object)("discoveryPolicyId is : " + discoveryPolicyId));
            if (discoveryPolicyId == null) {
                return new Paging();
            }
            if (this.discoveryDao.get(DiscoveryPolicy.class, discoveryPolicyId) == null) {
                LOGGER.warn((Object)("the discovery policy does not exitttt, discoveryPolicyId is : " + discoveryPolicyId));
                throw new LegoCheckedException(1055L);
            }
            return this.discoveryDao.getDiscoveryResult(discoveryPolicyId, firstRowIndex, totalRow, orderByField, orderByAscend);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Paging getImportedDiscoveryItem(Long discoveryPolicyId, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend) {
        Object object = this.lock;
        synchronized (object) {
            return this.discoveryDao.getImportedDiscoveryItem(discoveryPolicyId, firstRowIndex, totalRow, orderByField, orderByAscend);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long discoveryFromExcel(DiscoveryPolicy policy, List<ImportedDiscoveryItem> itemList) {
        Object object = this.lock;
        synchronized (object) {
            if (itemList.isEmpty()) {
                LOGGER.error((Object)"the itemList is empty");
                throw new LegoCheckedException(1054L);
            }
            LOGGER.info((Object)("itemList size is : " + itemList.size()));
            LOGGER.info((Object)("will begin discoveryFromExcel, policy is : " + policy));
            policy.addManagementProtocol(SnmpPara.class.getName(), policy.getSnmpPara());
            if (policy.getTelnetPara() != null) {
                policy.addManagementProtocol(TelnetPara.class.getName(), policy.getTelnetPara());
            }
            policy.setDiscoveryStyle(1);
            policy.setBeginDiscoveryTime(new Timestamp(System.currentTimeMillis()));
            policy.setTotalIpCount((long)itemList.size() * 1L);
            policy.setDiscoveryPercentStr("0%");
            policy.setDiscoveryPercentInt(0);
            policy.setTopoElementId(policy.getTopoElementId());
            policy.setTopoElementName(policy.getTopoElementName());
            policy.setStartIP(itemList.get(0).getIpAddress());
            policy.setEndIP(itemList.get(itemList.size() - 1).getIpAddress());
            this.discoveryDao.save(policy);
            SnmpPara snmpPara = policy.getSnmpPara();
            snmpPara.setTemplateName(UUID.randomUUID().toString());
            snmpPara.setDiscoveryPolicy(policy);
            this.discoveryDao.save(snmpPara);
            TelnetPara telnetPara = policy.getTelnetPara();
            if (telnetPara != null) {
                telnetPara.setTemplateName(UUID.randomUUID().toString());
                telnetPara.setDiscoveryPolicy(policy);
                this.discoveryDao.save(policy.getTelnetPara());
            }
            HashMap<String, Long> ipDiscoveryResultMap = new HashMap<String, Long>();
            for (ImportedDiscoveryItem discoveryItem : itemList) {
                discoveryItem.setDiscoveryPolicy(policy);
                this.discoveryDao.save(discoveryItem);
                DiscoveryResult discoveryResult = new DiscoveryResult();
                discoveryResult.setDiscoveryPolicy(policy);
                discoveryResult.setIpAddress(discoveryItem.getIpAddress());
                this.discoveryDao.save(discoveryResult);
                ipDiscoveryResultMap.put(policy.getDiscoveryPolicyId() + "_" + discoveryItem.getIpAddress(), discoveryResult.getDiscoveryResultId());
            }
            this.cacheService.put((Object)("discoveryPolicyId_" + policy.getDiscoveryPolicyId()), (Object)0L);
            ImportDiscoveryThread discoveryThread = new ImportDiscoveryThread(policy, itemList, ipDiscoveryResultMap);
            discoveryThread.setService(this);
            this.activeDiscoveryThreadMap.put(policy.getDiscoveryPolicyId(), discoveryThread);
            this.threadPool.execute(discoveryThread);
            return policy.getDiscoveryPolicyId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long discovery(DiscoveryPolicy policy) {
        Object object = this.lock;
        synchronized (object) {
            LOGGER.info((Object)("will begin auto discovery, policy is : " + policy));
            policy.setDiscoveryStyle(0);
            policy.setBeginDiscoveryTime(new Timestamp(System.currentTimeMillis()));
            policy.addManagementProtocol(SnmpPara.class.getName(), policy.getSnmpPara());
            if (policy.getTelnetPara() != null) {
                policy.addManagementProtocol(TelnetPara.class.getName(), policy.getTelnetPara());
            }
            long totalIpCount = 0L;
            StringBuilder ipRangeStringBuilder = new StringBuilder();
            HashMap<String, String> tempSingleIpMap = new HashMap<String, String>();
            for (Map.Entry<String, String> entrySet : policy.getIpRangeMap().entrySet()) {
                String startIp = entrySet.getKey();
                String endIp = entrySet.getValue();
                if (!StringUtils.hasText((String)endIp)) {
                    endIp = startIp;
                    tempSingleIpMap.put(startIp, endIp);
                }
                ipRangeStringBuilder.append(startIp).append('-').append(endIp).append(';');
                long startIpLong = WatchUtil.getInstance().getAddrLong(startIp);
                long endIpLong = WatchUtil.getInstance().getAddrLong(endIp);
                totalIpCount += endIpLong + 1L - startIpLong;
            }
            policy.getIpRangeMap().putAll(tempSingleIpMap);
            ipRangeStringBuilder.deleteCharAt(ipRangeStringBuilder.length() - 1);
            policy.setTotalIpCount(totalIpCount);
            policy.setIpRangeString(ipRangeStringBuilder.toString());
            policy.setDiscoveryPercentStr("0%");
            policy.setDiscoveryPercentInt(0);
            this.discoveryDao.save(policy);
            SnmpPara snmpPara = policy.getSnmpPara();
            snmpPara.setTemplateName(UUID.randomUUID().toString());
            snmpPara.setDiscoveryPolicy(policy);
            this.discoveryDao.save(snmpPara);
            TelnetPara telnetPara = policy.getTelnetPara();
            if (telnetPara != null) {
                telnetPara.setTemplateName(UUID.randomUUID().toString());
                telnetPara.setDiscoveryPolicy(policy);
                this.discoveryDao.save(policy.getTelnetPara());
            }
            this.cacheService.put((Object)("discoveryPolicyId_" + policy.getDiscoveryPolicyId()), (Object)0L);
            AutoDiscoveryThread autoDiscoveryThread = new AutoDiscoveryThread(policy, this.nodeEditorList);
            autoDiscoveryThread.setService(this);
            this.activeDiscoveryThreadMap.put(policy.getDiscoveryPolicyId(), autoDiscoveryThread);
            this.threadPool.execute(autoDiscoveryThread);
            return policy.getDiscoveryPolicyId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDeviceVersion(DiscoveryPolicy policy, Long deviceType) {
        Object object = this.lock;
        synchronized (object) {
            LOGGER.info((Object)("will begin auto discovery, policy is : " + policy));
            String version = "";
            policy.setDiscoveryStyle(0);
            policy.setBeginDiscoveryTime(new Timestamp(System.currentTimeMillis()));
            policy.addManagementProtocol(SnmpPara.class.getName(), policy.getSnmpPara());
            if (policy.getTelnetPara() != null) {
                policy.addManagementProtocol(TelnetPara.class.getName(), policy.getTelnetPara());
            }
            long totalIpCount = 0L;
            StringBuilder ipRangeStringBuilder = new StringBuilder();
            HashMap<String, String> tempSingleIpMap = new HashMap<String, String>();
            for (Map.Entry<String, String> entrySet : policy.getIpRangeMap().entrySet()) {
                String startIp = entrySet.getKey();
                String endIp = entrySet.getValue();
                if (!StringUtils.hasText((String)endIp)) {
                    endIp = startIp;
                    tempSingleIpMap.put(startIp, endIp);
                }
                ipRangeStringBuilder.append(startIp).append('-').append(endIp).append(';');
                long startIpLong = WatchUtil.getInstance().getAddrLong(startIp);
                long endIpLong = WatchUtil.getInstance().getAddrLong(endIp);
                totalIpCount += endIpLong + 1L - startIpLong;
            }
            policy.getIpRangeMap().putAll(tempSingleIpMap);
            ipRangeStringBuilder.deleteCharAt(ipRangeStringBuilder.length() - 1);
            policy.setTotalIpCount(totalIpCount);
            policy.setIpRangeString(ipRangeStringBuilder.toString());
            policy.setDiscoveryPercentStr("0%");
            policy.setDiscoveryPercentInt(0);
            SnmpPara snmpPara = policy.getSnmpPara();
            snmpPara.setTemplateName(UUID.randomUUID().toString());
            snmpPara.setDiscoveryPolicy(policy);
            TelnetPara telnetPara = policy.getTelnetPara();
            if (telnetPara != null) {
                telnetPara.setTemplateName(UUID.randomUUID().toString());
                telnetPara.setDiscoveryPolicy(policy);
            }
            version = this.deviceVersion(policy, deviceType);
            LOGGER.info((Object)("will end auto discovery, policy is : " + policy));
            return version;
        }
    }

    private String deviceVersion(DiscoveryPolicy policy, Long deviceType) {
        String version = "";
        Map<String, String> ipRangeMap = policy.getIpRangeMap();
        for (Map.Entry<String, String> entrySet : ipRangeMap.entrySet()) {
            String startIp = entrySet.getKey();
            String endIp = entrySet.getValue();
            long startIpLong = WatchUtil.getInstance().getAddrLong(startIp);
            long endIpLong = WatchUtil.getInstance().getAddrLong(endIp);
            long ipCount = endIpLong + 1L - startIpLong;
            for (long j = 0L; j < ipCount; ++j) {
                String ip = WatchUtil.getInstance().convertAddr(startIpLong + j);
                if (DiscoveryUtil.checkIpDuplicate(ip)) {
                    throw new LegoCheckedException(1056L);
                }
                if (DiscoveryUtil.checkMaxCount()) {
                    throw new LegoCheckedException(363L);
                }
                if (this.isIpReachable(ip)) {
                    List<String> resultStringArrayList;
                    block10: {
                        resultStringArrayList = null;
                        try {
                            ServiceProvider.getInstance().getResourceService().snmpReadTest(ip, policy.getSnmpPara());
                            String[] targetOidArray = new String[]{"1.3.6.1.2.1.1.1.0", "1.3.6.1.2.1.1.2.0", "1.3.6.1.2.1.1.5.0"};
                            SnmpSynchronizeParameter snmpSynchronizeParameter = new SnmpSynchronizeParameter(ip, null, policy.getManagementProtocolMap(), null, null, null, null, null, null, null, null, null);
                            resultStringArrayList = SnmpSynchronizeUtil.getInstance().getMibResponseFromAgent(Arrays.asList(targetOidArray), snmpSynchronizeParameter);
                        }
                        catch (Exception e) {
                            if (policy.getDiscoveryNonSnmpDevice().booleanValue()) break block10;
                            throw e;
                        }
                    }
                    if (null == resultStringArrayList || resultStringArrayList.size() == 0) {
                        throw new LegoCheckedException(200000L);
                    }
                    if (resultStringArrayList.size() != 3) continue;
                    String sysDesc = (String)resultStringArrayList.get(0);
                    String sysObjectID = ((String)resultStringArrayList.get(1)).trim();
                    if ("1.3.6.1.4.1.2011.2.321.1.196".equals(sysObjectID) && deviceType != 8L) {
                        throw new LegoCheckedException(1063L);
                    }
                    if (!"1.3.6.1.4.1.2011.2.321.1.196".equals(sysObjectID) && deviceType == 8L) {
                        throw new LegoCheckedException(1063L);
                    }
                    String[] deviceInfo = this.analyseSysDesc(sysDesc);
                    if (deviceInfo == null) continue;
                    version = deviceInfo[1];
                    continue;
                }
                throw new LegoCheckedException(1051L);
            }
        }
        return version;
    }

    private String[] analyseSysDesc(String sysDesc) {
        String[] result = null;
        String regEx = ".+(AntiDDoS\\d+V?).* (V\\d+R\\d+C\\w+).*";
        Pattern pat = Pattern.compile(regEx);
        Matcher mat = pat.matcher(sysDesc);
        if (mat.find()) {
            result = new String[]{mat.group(1), mat.group(2)};
        }
        return result;
    }

    private boolean isIpReachable(String ipAddress) {
        boolean reachable = false;
        int count = 0;
        while (!reachable && count < 3) {
            ++count;
            try {
                reachable = this.pingUtil.ping(ipAddress);
            }
            catch (Exception e) {
                LOGGER.error((Object)("pinging ip : " + ipAddress + "...... failed!" + e.getMessage()));
            }
            if (reachable) {
                LOGGER.info((Object)(AticUtil.getcleanedMessage((String)ipAddress) + " is reachable"));
                continue;
            }
            LOGGER.info((Object)(AticUtil.getcleanedMessage((String)ipAddress) + " is not reachable, try times is : " + count));
            if (count == 3) continue;
            try {
                TimeUnit.MICROSECONDS.sleep(500L);
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)("exception when sleep!" + e.getMessage()));
            }
        }
        return reachable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDiscoveryResultAndPolicy(DiscoveryResult discoveryResult, boolean icmpPingSuccess) {
        Object object = this.lock;
        synchronized (object) {
            LOGGER.info((Object)("discovery result is : " + discoveryResult));
            DiscoveryPolicy discoveryPolicy = discoveryResult.getDiscoveryPolicy();
            if (discoveryPolicy.getDiscoveryStyle() == 1 && discoveryResult.getDiscoveryResultId() == null) {
                ImportDiscoveryThread importDiscoveryThread = (ImportDiscoveryThread)this.activeDiscoveryThreadMap.get(discoveryPolicy.getDiscoveryPolicyId());
                if (importDiscoveryThread == null) {
                    LOGGER.warn((Object)("the discovery policy may be stopped, discoveryPolicy is : " + discoveryPolicy));
                    return;
                }
                String discoveryPolicyID = discoveryPolicy.getDiscoveryPolicyId() + "_" + discoveryResult.getIpAddress();
                Long discoveryResultId = importDiscoveryThread.getIpDiscoveryResultIdMap().get(discoveryPolicyID);
                if (discoveryResultId == null) {
                    LOGGER.error((Object)("can not find discoveryResultId from ipDiscoveryResult in updateDiscoveryPolicyAndResult, discoveryPolicyID is " + discoveryPolicyID + ", ipDiscoveryResultIdMap is : " + importDiscoveryThread.getIpDiscoveryResultIdMap()));
                }
                discoveryResult.setDiscoveryResultId(discoveryResultId);
            }
            if (discoveryPolicy.getDiscoveryStyle() == 1) {
                this.discoveryDao.update(discoveryResult);
            } else {
                this.discoveryDao.save(discoveryResult);
            }
            this.updateDiscoveryPolicy(discoveryPolicy, discoveryResult.getSuccess());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDiscoveryPolicy(DiscoveryPolicy policy, boolean discoverSuccess) {
        Object object = this.lock;
        synchronized (object) {
            LOGGER.info((Object)("will updateDiscoveryStatus, discovery policy is : " + policy));
            DiscoveryPolicy discoveryPolicy = (DiscoveryPolicy)this.discoveryDao.get(DiscoveryPolicy.class, Long.valueOf(policy.getDiscoveryPolicyId()));
            if (discoveryPolicy == null) {
                LOGGER.warn((Object)("the discovery policy does not exist, policy is : " + policy));
                return;
            }
            String key = "discoveryPolicyId_" + discoveryPolicy.getDiscoveryPolicyId();
            if (!this.cacheService.containsKey((Object)key)) {
                LOGGER.warn((Object)("the discovery policy may finish or be stopped manually, policy is : " + discoveryPolicy));
                return;
            }
            this.cacheService.increaseCachedDataCount(key);
            Long discoveredIpCount = (Long)this.cacheService.get((Object)key);
            Long totalIpCount = discoveryPolicy.getTotalIpCount();
            LOGGER.info((Object)("discoveredIpCount is : " + discoveredIpCount + ", totalIpCount is : " + totalIpCount));
            if (discoveredIpCount >= totalIpCount) {
                this.cacheService.remove((Object)key);
                this.activeDiscoveryThreadMap.remove(discoveryPolicy.getDiscoveryPolicyId());
                discoveryPolicy.setFinished(true);
                discoveryPolicy.setEndDiscoveryTime(new Timestamp(System.currentTimeMillis()));
                discoveryPolicy.setDiscoveryPercentStr("100%");
                discoveryPolicy.setDiscoveryPercentInt(100);
            }
            if (discoverSuccess) {
                discoveryPolicy.setDiscoveredDeviceCount(discoveryPolicy.getDiscoveredDeviceCount() + 1);
            }
            this.discoveryDao.update(discoveryPolicy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long icmpDiscovery(DiscoveryPolicy policy) {
        Object object = this.lock;
        synchronized (object) {
            LOGGER.info((Object)("will begin icmp discovery, policy is : " + policy));
            policy.setDiscoveryStyle(3);
            policy.setBeginDiscoveryTime(new Timestamp(System.currentTimeMillis()));
            policy.setDiscoveryPercentStr("0%");
            policy.setDiscoveryPercentInt(0);
            if (policy.getSnmpPara() != null) {
                policy.addManagementProtocol(SnmpPara.class.getName(), policy.getSnmpPara());
            }
            long startIpLong = WatchUtil.getInstance().getAddrLong(policy.getStartIP());
            long totalIpCount = 1L;
            if (StringUtils.hasText((String)policy.getEndIP())) {
                long endIpLong = WatchUtil.getInstance().getAddrLong(policy.getEndIP());
                totalIpCount = endIpLong + 1L - startIpLong;
            }
            policy.setTotalIpCount(totalIpCount);
            this.discoveryDao.save(policy);
            SnmpPara snmpPara = policy.getSnmpPara();
            if (snmpPara != null) {
                snmpPara.setTemplateName(UUID.randomUUID().toString());
                snmpPara.setDiscoveryPolicy(policy);
                this.discoveryDao.save(snmpPara);
            }
            this.cacheService.put((Object)("discoveryPolicyId_" + policy.getDiscoveryPolicyId()), (Object)0L);
            IcmpDiscoveryThread icmpDiscoveryThread = new IcmpDiscoveryThread(policy, this.nodeEditorList);
            this.activeDiscoveryThreadMap.put(policy.getDiscoveryPolicyId(), icmpDiscoveryThread);
            this.threadPool.execute(icmpDiscoveryThread);
            return policy.getDiscoveryPolicyId();
        }
    }

    private void addManageProtocolByDiscoveryPolicy(Node node, DiscoveryPolicy policy) {
        TelnetPara telnetPara;
        SnmpPara snmpPara = policy.getSnmpPara();
        if (snmpPara != null) {
            snmpPara.setTemplateName(UUID.randomUUID().toString());
            snmpPara.setDiscoveryPolicy(null);
            snmpPara.setId(null);
            snmpPara.setIsTemplate(false);
            snmpPara.setIsManagementProtocol(true);
            snmpPara.setNode(node);
            node.addManagementProtocol(SnmpPara.class.getName(), snmpPara);
        }
        if ((telnetPara = policy.getTelnetPara()) != null) {
            telnetPara.setTemplateName(UUID.randomUUID().toString());
            telnetPara.setDiscoveryPolicy(null);
            telnetPara.setId(null);
            telnetPara.setIsTemplate(false);
            telnetPara.setIsManagementProtocol(true);
            telnetPara.setNode(node);
            node.addManagementProtocol(TelnetPara.class.getName(), telnetPara);
        }
    }

    private DiscoveryResult constructDiscoveryResult(Node node, DiscoveryPolicy policy, boolean result, Long errorCode) {
        DiscoveryResult discoveryResult = new DiscoveryResult();
        discoveryResult.setDiscoveryPolicy(policy);
        discoveryResult.setIpAddress(node.getIpAddress());
        discoveryResult.setSuccess(result);
        discoveryResult.setDeviceMainTypeI18n(node.getMainType());
        discoveryResult.setDeviceSubTypeI18n(node.getSubType());
        discoveryResult.setDeviceOsVersion(node.getDevOsVersion());
        discoveryResult.setFinishTime(new Timestamp(System.currentTimeMillis()));
        return discoveryResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long manualAddDiscovery(DiscoveryPolicy policy) {
        Object object = this.lock;
        synchronized (object) {
            LOGGER.info((Object)("will begin manual add node, policy is : " + policy));
            policy.setBeginDiscoveryTime(new Timestamp(System.currentTimeMillis()));
            policy.setDiscoveryStyle(2);
            policy.setDiscoveryPercentStr("0%");
            policy.setDiscoveryPercentInt(0);
            this.discoveryDao.save(policy);
            String sysoid = DiscoveryUtil.getSysOidByDeviceType(policy.getDeviceType(), policy.getDeviceSubType(), policy.getDeviceOsVersion());
            Node node = new Node();
            node.setSysOid(sysoid);
            node.setDescription("manual");
            node.setName(policy.getDeviceName());
            node.setDiscoveredTime(new Timestamp(System.currentTimeMillis()));
            node.setIpAddress(policy.getStartIP());
            node.setNetMask(policy.getDiscoveryNetmask());
            node.setMainType(policy.getDeviceType());
            node.setTopoElementId(policy.getTopoElementId());
            String subType = policy.getDeviceSubType();
            String uuid = policy.getStartIP() + "_" + policy.getDeviceType();
            if (subType == null || subType.equals("")) {
                node.setSubType(policy.getDeviceType());
            } else {
                node.setSubType(subType);
                uuid = uuid + "_" + subType;
            }
            node.setDevOsVersion(policy.getDeviceOsVersion());
            node.setUuid(uuid);
            node.setLocation(policy.getLocation());
            node.setIsTopMo(true);
            this.addManageProtocolByDiscoveryPolicy(node, policy);
            LOGGER.info((Object)("manualNodeEditorList size is : " + this.manualNodeEditorList));
            if (this.manualNodeEditorList.isEmpty()) {
                this.manualNodeEditorEmpty(node, policy);
            } else {
                for (IManualNodeEditor manualNodeEditor : this.manualNodeEditorList) {
                    DiscoveryResult discoveryResult = new DiscoveryResult();
                    Node nod = null;
                    LOGGER.info((Object)("the manualNodeEditor is : " + manualNodeEditor));
                    try {
                        nod = manualNodeEditor.editManualNode(node, policy);
                    }
                    catch (LegoCheckedException e) {
                        if (e.getErrorCode() == 354L) {
                            discoveryResult.setErrorCode(354L);
                        }
                        discoveryResult.setDiscoveryPolicy(policy);
                        discoveryResult.setIpAddress(policy.getStartIP());
                        discoveryResult.setSuccess(false);
                        discoveryResult.setDeviceMainTypeI18n(node.getMainType());
                        discoveryResult.setDeviceSubTypeI18n(node.getSubType());
                        discoveryResult.setDeviceOsVersion(node.getDevOsVersion());
                        discoveryResult.setFinishTime(new Timestamp(System.currentTimeMillis()));
                        this.discoveryDao.save(discoveryResult);
                        policy.setDiscoveredDeviceCount(0);
                        policy.setFinished(true);
                        policy.setEndDiscoveryTime(new Timestamp(System.currentTimeMillis()));
                        policy.setDiscoveryPercentStr("100%");
                        policy.setDiscoveryPercentInt(100);
                        this.discoveryDao.update(policy);
                        this.writeSysLog(policy);
                        throw e;
                    }
                    LOGGER.info((Object)("the manualNodeEditor edit node result is : " + nod));
                    discoveryResult.setDiscoveryPolicy(policy);
                    discoveryResult.setIpAddress(policy.getStartIP());
                    discoveryResult.setSuccess(false);
                    discoveryResult.setDeviceMainTypeI18n(node.getMainType());
                    discoveryResult.setDeviceSubTypeI18n(node.getSubType());
                    if (nod != null) {
                        try {
                            this.getResourceService().addMoAndSubMo((ManagedObject)nod);
                            this.getResourceService().addUserMO(policy.getOperator(), nod.getMoId());
                            discoveryResult.setSuccess(true);
                        }
                        catch (Exception e) {
                            LOGGER.error((Object)("exception when addMoAndSubMo in manual add node, node is : " + nod + ". " + e.getMessage()));
                            discoveryResult.setSuccess(false);
                            discoveryResult.setErrorCode(1053L);
                        }
                        if (discoveryResult.getSuccess().booleanValue()) {
                            HashMap<String, Object> messageMap = new HashMap<String, Object>();
                            messageMap.put("manualAddNode", nod);
                            messageMap.put("discoveryPolicy", policy);
                            MessageUnit mu = new MessageUnit();
                            mu.setCmdcode(101L);
                            mu.setObj(messageMap);
                            mu.setMt(MessageTopic.COMMAND);
                            mu.setSourceAppName(this.getClass().getName());
                            this.messageCenter.sendMessage(mu);
                            policy.setDiscoveredDeviceCount(1);
                        }
                    } else {
                        LOGGER.info((Object)("the manualNodeEditor return null, manualNodeEditor is : " + manualNodeEditor));
                        policy.setDiscoveredDeviceCount(0);
                    }
                    discoveryResult.setFinishTime(new Timestamp(System.currentTimeMillis()));
                    this.discoveryDao.save(discoveryResult);
                }
            }
            policy.setDiscoveredDeviceCount(1);
            policy.setFinished(true);
            policy.setEndDiscoveryTime(new Timestamp(System.currentTimeMillis()));
            policy.setDiscoveryPercentStr("100%");
            policy.setDiscoveryPercentInt(100);
            this.discoveryDao.update(policy);
            this.writeSysLog(policy);
            return policy.getDiscoveryPolicyId();
        }
    }

    private void prepareIpRangePolicy(DiscoveryPolicy policy) {
        long totalIpCount = 0L;
        HashMap<String, String> tempSingleIpMap = new HashMap<String, String>();
        StringBuilder ipRangeStringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entrySet : policy.getIpRangeMap().entrySet()) {
            String startIp = entrySet.getKey();
            String endIp = entrySet.getValue();
            if (!StringUtils.hasText((String)endIp)) {
                endIp = startIp;
                tempSingleIpMap.put(startIp, endIp);
            }
            ipRangeStringBuilder.append(startIp).append("-").append(endIp).append(";");
            long startIpLong = WatchUtil.getInstance().getAddrLong(startIp);
            long endIpLong = WatchUtil.getInstance().getAddrLong(endIp);
            totalIpCount += endIpLong + 1L - startIpLong;
        }
        policy.getIpRangeMap().putAll(tempSingleIpMap);
        policy.setTotalIpCount(totalIpCount);
        ipRangeStringBuilder.deleteCharAt(ipRangeStringBuilder.length() - 1);
        policy.setIpRangeString(ipRangeStringBuilder.toString());
    }

    private void writeSysLog(DiscoveryPolicy policy) {
        this.prepareIpRangePolicy(policy);
        SysOptLog oOptLog = new SysOptLog();
        Date date = new Date();
        oOptLog.setDate(date);
        oOptLog.setTarget(policy.getIpRangeString());
        oOptLog.setLevel(SysoplogLevel.normal.getValue());
        oOptLog.setModule("lego.dic.module.ResourceApplication");
        oOptLog.setOperation("lego.lab.discovery.disdetail");
        oOptLog.setDetail("lego.lab.discovery.ver.discoveryresult");
        long failureNum = policy.getTotalIpCount() - (long)policy.getDiscoveredDeviceCount().intValue();
        String[] para = new String[]{policy.getDiscoveredDeviceCount().toString(), failureNum + ""};
        oOptLog.setDetailPara(para);
        if (failureNum > 0L) {
            oOptLog.setResult(SysoplogResultLevel.failed.getValue());
        } else {
            oOptLog.setResult(SysoplogResultLevel.success.getValue());
        }
        oOptLog.setOperator(policy.getOperator());
        oOptLog.setTerminalIp(policy.getTerminalIp());
        ISysOptLog sysOpLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
        sysOpLog.writeOptLog(oOptLog);
    }

    private void manualNodeEditorEmpty(Node node, DiscoveryPolicy policy) {
        LOGGER.error((Object)"there is no manualNodeEditor");
        DiscoveryResult discoveryResult = null;
        this.checkMaxCount();
        discoveryResult = this.constructDiscoveryResult(node, policy, true, null);
        this.getResourceService().addMo((ManagedObject)node);
        this.getResourceService().addUserMO(policy.getOperator(), node.getMoId());
        this.discoveryDao.save(discoveryResult);
    }

    private void checkMaxCount() {
        long maxCount;
        long totalCount = DiscoveryUtil.getNodeCount();
        if (totalCount >= (maxCount = Long.parseLong(PropertyUtil.getInstance().getMaxNECount()))) {
            throw new LegoCheckedException(363L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchOperationResult deleteDiscoveryPolicy(List<DiscoveryPolicy> discoveryPolicyList) {
        Object object = this.lock;
        synchronized (object) {
            LOGGER.info((Object)("will deleteDiscoveryPolicy, discoveryPolicyList is : " + discoveryPolicyList));
            BatchOperationResult batchOpResult = new BatchOperationResult();
            ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
            int failCount = 0;
            int operCount = discoveryPolicyList.size();
            for (DiscoveryPolicy discoveryPolicy : discoveryPolicyList) {
                BatchOperation operation;
                try {
                    DiscoveryPolicy policyFromDB = (DiscoveryPolicy)this.discoveryDao.get(DiscoveryPolicy.class, Long.valueOf(discoveryPolicy.getDiscoveryPolicyId()));
                    if (policyFromDB == null) {
                        ++failCount;
                        operation = new BatchOperation();
                        operation.setErrorCode(1027L);
                        operation.setTargetName(discoveryPolicy.getIpRangeString());
                        resultList.add(operation);
                        continue;
                    }
                    this.discoveryDao.delete(policyFromDB);
                    operation = new BatchOperation();
                    operation.setTargetName(discoveryPolicy.getIpRangeString());
                    resultList.add(operation);
                }
                catch (Exception e) {
                    LOGGER.error((Object)("exception when deleteDiscoveryPolicy, discoveryPolicy is : " + discoveryPolicy + ". " + e.getMessage()));
                    ++failCount;
                    operation = new BatchOperation();
                    operation.setErrorCode(1027L);
                    operation.setTargetName(discoveryPolicy.getIpRangeString());
                    resultList.add(operation);
                }
            }
            batchOpResult.setResult(resultList);
            batchOpResult.setFailCount(failCount);
            batchOpResult.setTotalCount(operCount);
            batchOpResult.setSucceedCount(operCount - failCount);
            return batchOpResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchOperationResult stopDiscovery(List<DiscoveryPolicy> discoveryPolicyList) {
        Object object = this.lock;
        synchronized (object) {
            LOGGER.info((Object)("will stopDiscovery, discoveryPolicyList is : " + discoveryPolicyList));
            BatchOperationResult batchOpResult = new BatchOperationResult();
            ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
            int failCount = 0;
            int operCount = discoveryPolicyList.size();
            for (DiscoveryPolicy discoveryPolicy : discoveryPolicyList) {
                DiscoveryPolicy policyFromDB;
                AbstractDiscoveryThread discoveryThread = this.activeDiscoveryThreadMap.get(discoveryPolicy.getDiscoveryPolicyId());
                if (discoveryThread != null) {
                    BatchOperation operation;
                    discoveryThread.stop();
                    policyFromDB = (DiscoveryPolicy)this.discoveryDao.get(DiscoveryPolicy.class, Long.valueOf(discoveryPolicy.getDiscoveryPolicyId()));
                    if (policyFromDB == null) {
                        ++failCount;
                        operation = new BatchOperation();
                        operation.setErrorCode(1027L);
                        operation.setTargetName(discoveryPolicy.getIpRangeString());
                        resultList.add(operation);
                        LOGGER.info((Object)("the discovery policy may have been deleted, policy is : " + discoveryPolicy));
                        continue;
                    }
                    if (policyFromDB.getFinished().booleanValue()) continue;
                    policyFromDB.setFinished(true);
                    policyFromDB.setManualStopped(true);
                    policyFromDB.setEndDiscoveryTime(new Timestamp(System.currentTimeMillis()));
                    policyFromDB.setDiscoveryPercentStr("100%");
                    policyFromDB.setDiscoveryPercentInt(100);
                    ServiceProvider.getInstance().getCommonService().update(policyFromDB);
                    operation = new BatchOperation();
                    operation.setTargetName(discoveryPolicy.getIpRangeString());
                    resultList.add(operation);
                    continue;
                }
                LOGGER.warn((Object)("can not find discoveryThread in activeDiscoveryThreadMap, discoveryPolicy is : " + discoveryPolicy));
                policyFromDB = (DiscoveryPolicy)this.discoveryDao.get(DiscoveryPolicy.class, Long.valueOf(discoveryPolicy.getDiscoveryPolicyId()));
                policyFromDB.setFinished(true);
                policyFromDB.setEndDiscoveryTime(new Timestamp(System.currentTimeMillis()));
                ServiceProvider.getInstance().getCommonService().update(policyFromDB);
            }
            if (!DiscoveryServiceImpl.isCleanDiscoveryCacheThreadStarted()) {
                DiscoveryServiceImpl.setCleanDiscoveryCacheThreadStarted(true);
                CleanDiscoveryCacheThread cleanDiscoveryCacheThread = new CleanDiscoveryCacheThread(this.activeDiscoveryThreadMap, this.cacheService);
                Thread t = new Thread((Runnable)cleanDiscoveryCacheThread, "clean discovery cache thread");
                t.setUncaughtExceptionHandler(new DiscoveryModuleUncaughtExceptionHandler());
                t.start();
            }
            batchOpResult.setResult(resultList);
            batchOpResult.setFailCount(failCount);
            batchOpResult.setTotalCount(operCount);
            batchOpResult.setSucceedCount(operCount - failCount);
            return batchOpResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchOperationResult deleteDevice(List<Long> moIdList) {
        Object object = this.lock;
        synchronized (object) {
            LOGGER.info((Object)("will deleteDevice, moIdList is : " + moIdList));
            BatchOperationResult batchOpResult = new BatchOperationResult();
            ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
            int failCount = 0;
            int operCount = moIdList.size();
            IResourceService resourceServiceTemp = this.getResourceService();
            for (Long moId : moIdList) {
                BatchOperation operation;
                LOGGER.info((Object)("willllllll delete device moid is : " + moId));
                try {
                    ManagedObject lmo = this.resourceDao.getMoByIdAndType(ManagedObject.class, moId, null);
                    LOGGER.info((Object)("llllllllllllllmo is : " + lmo));
                    if (lmo == null) {
                        LOGGER.warn((Object)("tttttthe device has been already deleted, moId is : " + moId));
                        ++failCount;
                        operation = new BatchOperation();
                        operation.setErrorCode(1028L);
                        operation.setTargetId(moId.longValue());
                        resultList.add(operation);
                        continue;
                    }
                    String key = "mo_uuid_" + lmo.getUuid();
                    if (this.cacheService.containsKey((Object)key)) {
                        LOGGER.warn((Object)("the device is synchronizing data, moId is : " + moId));
                        ++failCount;
                        BatchOperation operation2 = new BatchOperation();
                        operation2.setErrorCode(1028L);
                        operation2.setTargetId(moId.longValue());
                        resultList.add(operation2);
                        continue;
                    }
                    resourceServiceTemp.deleteMo(moId);
                }
                catch (Exception e) {
                    LOGGER.error((Object)("delete device faileddddddd, moId is : " + moId + ". " + e.getMessage()));
                    ++failCount;
                    operation = new BatchOperation();
                    operation.setErrorCode(1028L);
                    ManagedObject lmo = this.resourceDao.getMoByIdAndType(ManagedObject.class, moId, null);
                    if (lmo != null) {
                        operation.setTargetName(lmo.getName());
                    } else {
                        operation.setTargetName(String.valueOf(moId));
                    }
                    resultList.add(operation);
                }
            }
            batchOpResult.setResult(resultList);
            batchOpResult.setFailCount(failCount);
            batchOpResult.setTotalCount(operCount);
            batchOpResult.setSucceedCount(operCount - failCount);
            return batchOpResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchOperationResult deleteDeviceNew(List<BatchOperation> bathOprLst, Long userId) {
        Object object = this.lock;
        synchronized (object) {
            LOGGER.info((Object)("will deleteDeviceNewwwwwwwwww, bathOprLst size is : " + bathOprLst.size()));
            BatchOperationResult batchOpResult = new BatchOperationResult();
            ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
            int failCount = 0;
            int operCount = bathOprLst.size();
            IResourceService resourceServiceTemp = this.getResourceService();
            boolean isAdmin = this.userMgr.checkUserIsAdmin(userId.longValue());
            List moids = null;
            if (!isAdmin) {
                moids = this.userMgr.getUserGrandObjects(userId.longValue());
            }
            for (BatchOperation op : bathOprLst) {
                BatchOperation operation;
                BatchOperation operation2;
                Long moId = op.getTargetId();
                LOGGER.info((Object)("will delete device moid is : " + moId));
                if (this.lockedDeviceWhenRefresh.contains(moId)) {
                    LOGGER.info((Object)("the mo is locked because the mo is in refresh, moId is : " + moId));
                    ++failCount;
                    operation2 = new BatchOperation();
                    operation2.setErrorCode(1033L);
                    operation2.setTargetName(op.getTargetName());
                    operation2.setTargetId(moId.longValue());
                    resultList.add(operation2);
                    continue;
                }
                if (null != moids && !isAdmin && !moids.contains(moId)) {
                    LOGGER.warn((Object)("user not the device authority, moId is : " + moId));
                    ++failCount;
                    operation2 = new BatchOperation();
                    operation2.setErrorCode(1028L);
                    operation2.setTargetName(op.getTargetName());
                    operation2.setTargetId(moId.longValue());
                    resultList.add(operation2);
                    continue;
                }
                try {
                    this.lockedDeviceWhenDelete.add(moId);
                    ManagedObject lmo = this.resourceDao.getMoByIdAndType(ManagedObject.class, moId, null);
                    LOGGER.info((Object)("llllllllllllllmoooo is : " + lmo));
                    if (lmo == null) {
                        LOGGER.warn((Object)("the device has been already deleted, moId is : " + moId));
                        ++failCount;
                        operation = new BatchOperation();
                        operation.setErrorCode(1028L);
                        operation.setTargetName(op.getTargetName());
                        operation.setTargetId(moId.longValue());
                        resultList.add(operation);
                        continue;
                    }
                    String key = "mo_uuid_" + lmo.getUuid();
                    if (this.cacheService.containsKey((Object)key)) {
                        LOGGER.warn((Object)("the device is synchronizing data, moId is : " + moId));
                        ++failCount;
                        BatchOperation operation3 = new BatchOperation();
                        operation3.setErrorCode(1028L);
                        operation3.setTargetName(op.getTargetName());
                        operation3.setTargetId(moId.longValue());
                        resultList.add(operation3);
                        continue;
                    }
                    resourceServiceTemp.deleteMo(moId);
                }
                catch (Exception e) {
                    LOGGER.error((Object)("delete device failed, moId is : " + moId + ". " + e.getMessage()));
                    ++failCount;
                    operation = new BatchOperation();
                    operation.setErrorCode(1028L);
                    operation.setTargetName(op.getTargetName());
                    operation.setTargetId(moId.longValue());
                    resultList.add(operation);
                    continue;
                }
                finally {
                    this.lockedDeviceWhenDelete.remove(moId);
                    continue;
                }
                operation2 = new BatchOperation();
                operation2.setTargetName(op.getTargetName());
                operation2.setTargetId(moId.longValue());
                resultList.add(operation2);
            }
            batchOpResult.setResult(resultList);
            batchOpResult.setFailCount(failCount);
            batchOpResult.setTotalCount(operCount);
            batchOpResult.setSucceedCount(operCount - failCount);
            return batchOpResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchOperationResult deleteDeviceNewByUuid(List<BatchOperation> bathOprLst) {
        Object object = this.lock;
        synchronized (object) {
            LOGGER.info((Object)("will deleteDeviceNewByUuid, bathOprLst size is : " + bathOprLst.size()));
            BatchOperationResult batchOpResult = new BatchOperationResult();
            ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
            int failCount = 0;
            int operCount = bathOprLst.size();
            IResourceService resourceServiceTemp = this.getResourceService();
            for (BatchOperation op : bathOprLst) {
                BatchOperation operation;
                String uuid = op.getTargetName();
                LOGGER.info((Object)("will delete device uuid is : " + uuid));
                Long moId = -1L;
                try {
                    ManagedObject mo = this.resourceDao.getMoByUuid(uuid, false);
                    LOGGER.info((Object)("mo is : " + mo));
                    if (mo == null) {
                        LOGGER.warn((Object)("the device has been already deleted, uuid is : " + uuid));
                        ++failCount;
                        operation = new BatchOperation();
                        operation.setErrorCode(1028L);
                        operation.setTargetName(op.getTargetName());
                        operation.setTargetId(op.getTargetId());
                        resultList.add(operation);
                        continue;
                    }
                    moId = mo.getMoId();
                    if (this.lockedDeviceWhenRefresh.contains(moId)) {
                        LOGGER.info((Object)("the mo is locked because the mo is in refresh, moId is : " + moId));
                        ++failCount;
                        operation = new BatchOperation();
                        operation.setErrorCode(1033L);
                        operation.setTargetName(op.getTargetName());
                        operation.setTargetId(moId.longValue());
                        resultList.add(operation);
                        continue;
                    }
                    String key = "mo_uuid_" + uuid;
                    if (this.cacheService.containsKey((Object)key)) {
                        LOGGER.warn((Object)("the device is synchronizing data, moId is : " + moId));
                        ++failCount;
                        BatchOperation operation2 = new BatchOperation();
                        operation2.setErrorCode(1028L);
                        operation2.setTargetName(op.getTargetName());
                        operation2.setTargetId(moId.longValue());
                        resultList.add(operation2);
                        continue;
                    }
                    this.lockedDeviceWhenDelete.add(moId);
                    resourceServiceTemp.deleteMo(moId);
                }
                catch (Exception e) {
                    LOGGER.error((Object)("delete device failed, uuid is : " + uuid + ". " + e.getMessage()));
                    ++failCount;
                    operation = new BatchOperation();
                    operation.setErrorCode(1028L);
                    operation.setTargetName(op.getTargetName());
                    operation.setTargetId(op.getTargetId());
                    resultList.add(operation);
                    continue;
                }
                finally {
                    this.lockedDeviceWhenDelete.remove(moId);
                    continue;
                }
                BatchOperation operation3 = new BatchOperation();
                operation3.setTargetName(op.getTargetName());
                operation3.setTargetId(op.getTargetId());
                resultList.add(operation3);
            }
            batchOpResult.setResult(resultList);
            batchOpResult.setFailCount(failCount);
            batchOpResult.setTotalCount(operCount);
            batchOpResult.setSucceedCount(operCount - failCount);
            return batchOpResult;
        }
    }

    private IResourceService getResourceService() {
        if (this.resourceService == null) {
            this.resourceService = (IResourceService)ServiceContext.getInstance().getService("resourceService", IResourceService.class);
        }
        if (this.resourceService == null) {
            LOGGER.error((Object)"can not get resource service");
        }
        return this.resourceService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getLocation() {
        Object object = this.lock;
        synchronized (object) {
            String sql = "select location from T_locationinfo";
            return this.discoveryDao.findBySql(sql);
        }
    }

    @Override
    public Map<String, Map<String, DynamicFieldOfDiscovery>> getDeviceTypeDynamicFieldMap() {
        return this.deviceTypeDynamicFieldMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheService(ICacheService<String, Object> cacheService) {
        Object object = this.lock;
        synchronized (object) {
            this.cacheService = cacheService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDiscoveryDao(IDiscoveryDao discoveryDao) {
        Object object = this.lock;
        synchronized (object) {
            this.discoveryDao = discoveryDao;
        }
    }

    public void onBind(INodeEditor topoObjectEditor, Map<String, String> map) {
        this.nodeEditorList.add(topoObjectEditor);
        LOGGER.info((Object)("topoObjectEditor size is : " + this.nodeEditorList.size()));
    }

    public void onUnbind(INodeEditor topoObjectEditor, Map<String, String> map) {
        this.nodeEditorList.remove(topoObjectEditor);
    }

    public void onStart(IManualNodeEditor manualNodeEditor, Map<String, String> map) {
        this.manualNodeEditorList.add(manualNodeEditor);
    }

    public void onStop(IManualNodeEditor manualNodeEditor, Map<String, String> map) {
        this.manualNodeEditorList.remove(manualNodeEditor);
    }

    public void onBinding(IDeviceTypeFilter deviceTypeFilter, Map<String, String> map) {
        this.deviceTypeFilterList.add(deviceTypeFilter);
    }

    public void onUnbinding(IDeviceTypeFilter deviceTypeFilter, Map<String, String> map) {
        this.deviceTypeFilterList.remove(deviceTypeFilter);
    }

    public void onStartup(IManagementProtocolAndPageUrlHandler managementProtocolAndPageUrlHandler, Map<String, String> map) {
        List<ProtocolAndUrl> protocolAndUrlList = managementProtocolAndPageUrlHandler.getManagementProtocolPageUrl();
        if (protocolAndUrlList != null) {
            for (ProtocolAndUrl protocolAndUrl : protocolAndUrlList) {
                this.managementProtocolPageUrlMap.put(protocolAndUrl.getPrococolFullClassName(), protocolAndUrl.getModifyPageUrl());
                this.managementProtocolCreatePageUrlMap.put(protocolAndUrl.getPrococolFullClassName(), protocolAndUrl.getCreatePageUrl());
            }
        }
    }

    public void onShutdown(IManagementProtocolAndPageUrlHandler managementProtocolAndPageUrlHandler, Map<String, String> map) {
        List<ProtocolAndUrl> protocolAndUrlList = managementProtocolAndPageUrlHandler.getManagementProtocolPageUrl();
        if (protocolAndUrlList != null) {
            for (ProtocolAndUrl protocolAndUrl : protocolAndUrlList) {
                this.managementProtocolPageUrlMap.remove(protocolAndUrl.getPrococolFullClassName());
                this.managementProtocolCreatePageUrlMap.remove(protocolAndUrl.getPrococolFullClassName());
            }
        }
    }

    public IMessageCenter getMessageCenter() {
        return this.messageCenter;
    }

    public void setMessageCenter(IMessageCenter messageCenter) {
        this.messageCenter = messageCenter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyManagementProtocol(Protocol protocol0) {
        Object object = this.lock;
        synchronized (object) {
            SnmpPara snmpPara;
            SnmpPara snmpPara0;
            LOGGER.info((Object)("will modifyManagementProtocol, protocol is : " + this.getSecureString(protocol0.toString())));
            Protocol protocol = (Protocol)this.discoveryDao.get(Protocol.class, protocol0.getId());
            if (protocol == null || protocol.getNode() == null) {
                LOGGER.warn((Object)("in modifyManagementProtocol the protocol or the node does not exist, protocol is : " + protocol0));
                throw new LegoCheckedException(1050L);
            }
            Node nod = protocol.getNode();
            this.discoveryDao.update(protocol0);
            if (protocol0 instanceof SnmpPara && protocol instanceof SnmpPara && !(snmpPara0 = (SnmpPara)protocol0).equals(snmpPara = (SnmpPara)protocol)) {
                HashMap<String, SnmpPara> msgMap = new HashMap<String, SnmpPara>();
                msgMap.put(nod.getUuid(), snmpPara0);
                MessageUnit mu = new MessageUnit();
                mu.setCmdcode(114L);
                mu.setObj(msgMap);
                mu.setMt(MessageTopic.DATA);
                mu.setSourceAppName(this.getClass().getName());
                LOGGER.info((Object)("when modifyManagementProtocol will send COMMAND_SNMP_PARA_CHANGED msg, msg body is : " + this.getSecureString(msgMap.toString())));
                this.messageCenter.sendMessage(mu);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addManagementProtocol(Protocol protocol, Long devId) {
        Object object = this.lock;
        synchronized (object) {
            LOGGER.info((Object)("will add new Protocol, protocol is : " + protocol + ", devId is : " + devId));
            Node dev = (Node)this.discoveryDao.get(Node.class, devId);
            if (dev == null) {
                LOGGER.warn((Object)("the device does not exist, devId is : " + devId));
                throw new LegoCheckedException(1050L);
            }
            Protocol curProtocol = dev.getManagementProtocol(protocol.getClass().getName());
            if (curProtocol != null) {
                LOGGER.warn((Object)("the protocl exist, protocol is : " + curProtocol));
                throw new LegoCheckedException(1036L);
            }
            protocol.setNode(dev);
            this.discoveryDao.saveOrUpdate(protocol);
        }
    }

    @Override
    public Map<String, String> getManagementProtocolPageUrlMap() {
        return this.managementProtocolPageUrlMap;
    }

    @Override
    public int getMaxImportedRow() {
        String maxImportedRow = PropertyUtil.getInstance().getMaxImportedRow();
        LOGGER.info((Object)("maxImportedRow is : " + maxImportedRow));
        return Integer.parseInt(maxImportedRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockDeviceBeforeRefresh(Long moId) {
        Object object = this.lock;
        synchronized (object) {
            this.lockedDeviceWhenRefresh.add(moId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockDeviceAfterRefresh(Long moId) {
        Object object = this.lock;
        synchronized (object) {
            this.lockedDeviceWhenRefresh.remove(moId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDeviceCanRefresh(Long moId) {
        Object object = this.lock;
        synchronized (object) {
            return !this.lockedDeviceWhenDelete.contains(moId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValidByDeviceTypeandDeviceSubType(String deviceType, String deviceSubType, String deviceVersion) {
        Object object = this.lock;
        synchronized (object) {
            String s = DiscoveryUtil.getSysOidByDeviceType(deviceType, deviceSubType, deviceVersion);
            return s != null && !s.equals("");
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCleanDiscoveryCacheThreadStarted() {
        Object object = LOCK_CACHE;
        synchronized (object) {
            return cleanDiscoveryCacheThreadStarted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCleanDiscoveryCacheThreadStarted(boolean cleanDiscoveryCacheThreadStarted) {
        Object object = LOCK_CACHE;
        synchronized (object) {
            DiscoveryServiceImpl.cleanDiscoveryCacheThreadStarted = cleanDiscoveryCacheThreadStarted;
        }
    }

    private String getSecureString(String str) {
        if (str != null) {
            return str.replace("\r", "").replace("\n", "");
        }
        return str;
    }

    public ITemplateService getTemplateService() {
        return this.templateService;
    }

    public void setTemplateService(ITemplateService templateService) {
        this.templateService = templateService;
    }

    public IUserMgr getUserMgr() {
        return this.userMgr;
    }

    public void setUserMgr(IUserMgr userMgr) {
        this.userMgr = userMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICacheService<String, Object> getCacheService() {
        Object object = this.lock;
        synchronized (object) {
            return this.cacheService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDiscoveryDao getDiscoveryDao() {
        Object object = this.lock;
        synchronized (object) {
            return this.discoveryDao;
        }
    }

    public void setResourceService(IResourceService resourceService) {
        this.resourceService = resourceService;
    }

    public IResourceDao getResourceDao() {
        return this.resourceDao;
    }

    public void setResourceDao(IResourceDao resourceDao) {
        this.resourceDao = resourceDao;
    }
}

