/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.nem.discover.service.impl;

import com.hs.lego.comm.internal.jms.MessageTopic;
import com.hs.lego.comm.internal.jms.MessageUnit;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.core.sdk.common.ServiceProvider;
import com.huawei.atic.nem.discover.model.DiscoveryPolicy;
import com.huawei.atic.nem.discover.model.DiscoveryResult;
import com.huawei.atic.nem.discover.sdk.service.INodeEditor;
import com.huawei.atic.nem.discover.service.impl.AbstractDiscoveryThread;
import com.huawei.atic.nem.discover.util.DiscoveryUtil;
import com.huawei.atic.nem.discover.util.MessageCenterProvider;
import com.huawei.atic.nem.discover.util.WatchUtil;
import com.huawei.atic.resource.model.Node;
import com.huawei.atic.south.model.Protocol;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.util.StringUtils;

public class IcmpDiscoveryThread
extends AbstractDiscoveryThread {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private List<INodeEditor> nodeEditorList = null;

    public IcmpDiscoveryThread(DiscoveryPolicy policy) {
        super(policy);
    }

    public IcmpDiscoveryThread(DiscoveryPolicy policy, List<INodeEditor> nodeEditorList) {
        this(policy);
        this.nodeEditorList = nodeEditorList;
    }

    @Override
    public void run() {
        long startIpLong = WatchUtil.getInstance().getAddrLong(super.getPolicy().getStartIP());
        for (long j = 0L; !super.isCancel() && j < super.getPolicy().getTotalIpCount(); ++j) {
            DiscoveryResult discoveryResult;
            String ip = WatchUtil.getInstance().convertAddr(startIpLong + j);
            try {
                if (super.isIpReachable(ip)) {
                    LOGGER.info((Object)("ping successful, will send msg, ip is : " + ip));
                    String sysoid = DiscoveryUtil.getSysOidByDeviceType(super.getPolicy().getDeviceType(), super.getPolicy().getDeviceSubType(), super.getPolicy().getDeviceOsVersion());
                    for (INodeEditor nodeEditor : this.nodeEditorList) {
                        Node node = new Node();
                        node.setIpAddress(ip);
                        node.setSysOid(sysoid);
                        try {
                            node = nodeEditor.editNode(node, super.getPolicy());
                        }
                        catch (Exception e) {
                            LOGGER.error((Object)("exception happened when editor node, node is : " + node + ", NodeEditor is : " + nodeEditor + ". " + e.getMessage()));
                        }
                        if (!StringUtils.hasText((String)node.getSysOid())) {
                            LOGGER.warn((Object)("sys oid is null or empty after edit node, node is : " + node + ", NodeEditor is : " + nodeEditor));
                        }
                        node.setLocation(super.getPolicy().getLocation());
                        for (Protocol managementProtocol : super.getPolicy().getManagementProtocolMap().values()) {
                            managementProtocol.setIsTemplate(false);
                            managementProtocol.setIsManagementProtocol(true);
                            managementProtocol.setId(null);
                            managementProtocol.setDiscoveryPolicy(null);
                        }
                        node.setManagementProtocolMap(super.getPolicy().getManagementProtocolMap());
                        node.setMainType(super.getPolicy().getDeviceType());
                        node.setSubType(super.getPolicy().getDeviceSubType());
                        node.setDevOsVersion(super.getPolicy().getDeviceOsVersion());
                        HashMap<String, Object> messageBody = new HashMap<String, Object>();
                        messageBody.put("icmpDiscoveredNode", node);
                        messageBody.put("discoveryPolicy", super.getPolicy());
                        LOGGER.info((Object)("will send message after edit node, message body is : " + messageBody));
                        MessageUnit mu = new MessageUnit();
                        mu.setCmdcode(101L);
                        mu.setObj(messageBody);
                        mu.setMt(MessageTopic.COMMAND);
                        mu.setSourceAppName(this.getClass().getName());
                        MessageCenterProvider.getMessageCenter().sendMessage(mu);
                        try {
                            TimeUnit.SECONDS.sleep(3000L);
                        }
                        catch (InterruptedException e) {
                            LOGGER.error((Object)("sleep was interrupted!" + e.getMessage()));
                        }
                    }
                    continue;
                }
                LOGGER.warn((Object)("icmp ping is failed, ip is : " + ip));
                ServiceProvider.getInstance().getDiscoveryService().updateDiscoveryPolicy(super.getPolicy(), false);
                continue;
            }
            catch (LegoCheckedException legoException) {
                LOGGER.error((Object)("exception when discovery!" + legoException.getMessage()));
                discoveryResult = new DiscoveryResult();
                discoveryResult.setDiscoveryPolicy(super.getPolicy());
                discoveryResult.setFinishTime(new Timestamp(System.currentTimeMillis()));
                discoveryResult.setIpAddress(ip);
                discoveryResult.setSuccess(false);
                discoveryResult.setErrorCode(legoException.getErrorCode());
                ServiceProvider.getInstance().getDiscoveryService().updateDiscoveryResultAndPolicy(discoveryResult, true);
                continue;
            }
            catch (Exception e) {
                LOGGER.error((Object)("exception when discovery!" + e.getMessage()));
                discoveryResult = new DiscoveryResult();
                discoveryResult.setDiscoveryPolicy(super.getPolicy());
                discoveryResult.setFinishTime(new Timestamp(System.currentTimeMillis()));
                discoveryResult.setIpAddress(ip);
                discoveryResult.setSuccess(false);
                discoveryResult.setErrorCode(1053L);
                ServiceProvider.getInstance().getDiscoveryService().updateDiscoveryResultAndPolicy(discoveryResult, true);
            }
        }
    }
}

