/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.nem.discover.service.impl;

import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.huawei.atic.nem.discover.model.DiscoveryPolicy;
import com.huawei.atic.nem.discover.model.ImportedDiscoveryItem;
import com.huawei.atic.nem.discover.sdk.service.IDiscoveryService;
import com.huawei.atic.nem.discover.service.impl.AbstractDiscoveryThread;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ImportDiscoveryThread
extends AbstractDiscoveryThread {
    Map<String, Long> ipDiscoveryResultIdMap = null;
    private List<ImportedDiscoveryItem> importedItemList = null;
    private IDiscoveryService service;
    private ISysOptLog sysOpLog = null;

    public ImportDiscoveryThread(DiscoveryPolicy policy) {
        super(policy);
    }

    public ImportDiscoveryThread(DiscoveryPolicy policy, List<ImportedDiscoveryItem> itemList, Map<String, Long> ipDiscoveryResultIdMap) {
        this(policy);
        this.importedItemList = itemList;
        this.ipDiscoveryResultIdMap = ipDiscoveryResultIdMap;
    }

    @Override
    public void run() {
        for (ImportedDiscoveryItem discoveryItem : this.importedItemList) {
            if (super.isCancel()) break;
            String ip = discoveryItem.getIpAddress();
            super.snmpDiscovery(ip, discoveryItem.getDeviceName());
        }
        SysOptLog oOptLog = new SysOptLog();
        Date date = new Date();
        oOptLog.setDate(date);
        oOptLog.setTarget(this.getPolicy().getStartIP() + "-" + this.getPolicy().getEndIP());
        oOptLog.setLevel(SysoplogLevel.normal.getValue());
        oOptLog.setModule("lego.dic.module.ResourceApplication");
        if (super.isCancel()) {
            oOptLog.setOperation("lego.lab.discovery.stoppolicy");
        } else {
            oOptLog.setOperation("lego.lab.discovery.disdetail");
        }
        DiscoveryPolicy po = this.service.getDiscoveryPolicy(this.getPolicy().getDiscoveryPolicyId());
        oOptLog.setDetail("lego.lab.discovery.ver.discoveryresult");
        long failureNum = po.getTotalIpCount() - (long)po.getDiscoveredDeviceCount().intValue();
        String[] para = new String[]{po.getDiscoveredDeviceCount().toString(), failureNum + ""};
        oOptLog.setDetailPara(para);
        if (failureNum > 0L) {
            oOptLog.setResult(0);
        } else {
            oOptLog.setResult(1);
        }
        oOptLog.setOperator(this.getPolicy().getOperator());
        oOptLog.setTerminalIp(this.getPolicy().getTerminalIp());
        if (null == this.sysOpLog) {
            this.sysOpLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
        }
        this.sysOpLog.writeOptLog(oOptLog);
    }

    public ISysOptLog getSysOpLog() {
        return this.sysOpLog;
    }

    public void setSysOpLog(ISysOptLog sysOpLog) {
        this.sysOpLog = sysOpLog;
    }

    public Map<String, Long> getIpDiscoveryResultIdMap() {
        return this.ipDiscoveryResultIdMap;
    }

    public void setService(IDiscoveryService service) {
        this.service = service;
    }
}

