/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.nem.discover.service.impl;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.persistance.dao.ICommonDao;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.exception.LegoUncheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.nem.discover.dao.ITemplateDao;
import com.huawei.atic.south.model.Protocol;
import com.huawei.atic.system.template.sdk.service.ITemplateService;
import com.huawei.atic.util.PropertyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;

public class TemplateServiceImpl
implements ITemplateService,
Serializable {
    private static final long serialVersionUID = -6616183528967537141L;
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    transient ITemplateDao templateDao = null;
    transient ICommonDao commonDao = null;

    @Override
    public boolean isNameExist(String templateName, String className) {
        return this.templateDao.isNameExist(templateName, className);
    }

    @Override
    public boolean addTemplate(Protocol template, String className) {
        if (null == template) {
            LOGGER.info((Object)"add template failed, template is null.");
            return false;
        }
        if (null == className) {
            LOGGER.info((Object)"add template failed, className is null.");
            return false;
        }
        template.setIsTemplate(true);
        return this.templateDao.addTemplate(template, className);
    }

    @Override
    public boolean modifyTemplate(Protocol template, String className) {
        if (null == template) {
            LOGGER.info((Object)"modify template failed, template is null.");
            return false;
        }
        if (null == className) {
            LOGGER.info((Object)"modify template failed, className is null.");
            return false;
        }
        template.setIsTemplate(true);
        return this.templateDao.updateTemplate(template, className);
    }

    @Override
    public BatchOperationResult deleteTemplate(List<BatchOperation> operationList, String className) {
        BatchOperationResult opResult = new BatchOperationResult();
        if (null == operationList) {
            return opResult;
        }
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int failNum = 0;
        for (BatchOperation batchOperation : operationList) {
            try {
                long templateId = batchOperation.getTargetId();
                this.templateDao.deleteTemplate(templateId, className);
            }
            catch (LegoCheckedException e) {
                ++failNum;
                batchOperation.setErrorCode(e.getErrorCode());
            }
            catch (LegoUncheckedException e) {
                ++failNum;
                batchOperation.setErrorCode(e.getErrorCode());
            }
            resultList.add(batchOperation);
        }
        int total = operationList.size();
        opResult.setResult(resultList);
        opResult.setFailCount(failNum);
        opResult.setTotalCount(total);
        opResult.setSucceedCount(total - failNum);
        return opResult;
    }

    @Override
    public Protocol getTemplateById(long templateId, String className) {
        if (null == className) {
            LOGGER.info((Object)"get single template failed, className is null.");
            return null;
        }
        Protocol template = this.templateDao.getTemplate(Long.valueOf(templateId), className);
        return template;
    }

    @Override
    public Paging getTemplateList(Properties prop, String className, int startIndex, int pageSize) {
        if (null == prop) {
            LOGGER.info((Object)"get template list failed, prop is null.");
            return null;
        }
        if (null == className || !this.checkParams(className)) {
            LOGGER.info((Object)"get template list failed, className is null.");
            return null;
        }
        prop.put("isTemplate", "true");
        StringBuffer queryString = new StringBuffer();
        String orderStr = "";
        String orderKey = "";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        int index = 0;
        queryString.append("from " + className + " as model where ");
        for (Map.Entry<Object, Object> entry : prop.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key.equals("templateName")) {
                queryString.append("model." + key + "= ?" + index + " and ");
                param.put(index++, String.valueOf(value));
                continue;
            }
            if ((key.equalsIgnoreCase("DESC") || key.equalsIgnoreCase("ASC")) && this.checkParams(String.valueOf(value))) {
                orderKey = key;
                orderStr = "order by " + value + " ";
                continue;
            }
            if (!this.checkParams(key)) continue;
            queryString.append("model." + key + "= ?" + index + " and ");
            param.put(index++, String.valueOf(value));
        }
        queryString.append("0=0 ");
        StringBuffer sBufTotle = new StringBuffer("select count(*) ");
        sBufTotle.append(queryString.toString());
        Paging roPaging = new Paging();
        roPaging.setCount((int)this.commonDao.getTotalCount(sBufTotle.toString(), param));
        queryString.append(orderStr);
        queryString.append(orderKey);
        List templateList = null;
        templateList = orderStr.contains("templateName") ? this.commonDao.findByHql(queryString.toString(), param) : this.commonDao.findPage(queryString.toString(), startIndex, pageSize, param);
        roPaging.setData(templateList);
        return roPaging;
    }

    private boolean checkParams(String name) {
        String regular = "^[A-Za-z0-9|_|.]+$";
        return Pattern.matches(regular, name);
    }

    @Override
    public Paging getAllTemplate(String className, int startIndex, int pageSize) {
        if (null == className) {
            LOGGER.info((Object)"get all template list failed, className is null.");
            return null;
        }
        return this.getTemplateList(new Properties(), className, startIndex, pageSize);
    }

    @Override
    public List<Protocol> getAllTemplate(String className) {
        if (null == className) {
            LOGGER.info((Object)"get all template list failed, className is null.");
            return null;
        }
        Properties prop = new Properties();
        prop.put("isTemplate", (Object)true);
        return this.templateDao.getTemplateList(className, prop);
    }

    @Override
    public Set<String> getAllTemplateType() {
        HashSet<String> typeList = new HashSet<String>();
        List<Protocol> templateList = this.templateDao.getAllTemplate();
        if (null != templateList) {
            for (Protocol protocol : templateList) {
                if (protocol.getIsTemplate() == null || !protocol.getIsTemplate().booleanValue()) continue;
                typeList.add(protocol.getTemplateType());
            }
        }
        return typeList;
    }

    @Override
    public Long addTemplateReturnKey(Protocol template, String className) {
        if (null == template) {
            LOGGER.info((Object)"add template failed, template is null.");
            return null;
        }
        if (null == className) {
            LOGGER.info((Object)"add template failed, className is null.");
            return null;
        }
        this.checkMaxCount(className);
        template.setIsTemplate(true);
        return this.templateDao.addTemplateReturnKey(template, className);
    }

    private void checkMaxCount(String className) {
        long maxCount;
        long totalCount = 0L;
        List<Protocol> templateList = this.getAllTemplate(className);
        totalCount = null == templateList || templateList.isEmpty() ? 0L : (long)templateList.size();
        if (totalCount >= (maxCount = Long.parseLong(PropertyUtil.getInstance().getMaxTemplateCount()))) {
            throw new LegoCheckedException(364L);
        }
    }

    public ITemplateDao getTemplateDao() {
        return this.templateDao;
    }

    public void setTemplateDao(ITemplateDao templateDao) {
        this.templateDao = templateDao;
    }

    public ICommonDao getCommonDao() {
        return this.commonDao;
    }

    public void setCommonDao(ICommonDao commonDao) {
        this.commonDao = commonDao;
    }
}

