/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.nem.discover.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public class WatchUtil {
    private static WatchUtil instance = new WatchUtil();
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private static boolean enableDNS = true;
    private final Object lock = new Object();

    public boolean isDNSEnabled() {
        return enableDNS;
    }

    public void setDNSEnabled(boolean boo) {
        WatchUtil.setDNSEnabledCp(boo);
    }

    public static void setDNSEnabledCp(boolean boo) {
        enableDNS = boo;
    }

    public String getDefaultNetMask(String net) {
        if (net == null || net.indexOf(".") == -1) {
            return null;
        }
        int[] addr = this.getAddrArray(net);
        if (addr.length == 0) {
            return "255.0.0.0";
        }
        if (addr[0] < 128) {
            return "255.0.0.0";
        }
        if (addr[0] < 192) {
            return "255.255.0.0";
        }
        return "255.255.255.0";
    }

    public long getNumIPs(String net, String netmask) {
        long allmask = this.getAddrLong("255.255.255.255");
        long lNetmask = this.getAddrLong(netmask);
        if (lNetmask == allmask) {
            return 0L;
        }
        long lNet = this.getAddrLong(net);
        long nsize = allmask ^ lNetmask;
        if (lNetmask == 0L || lNet == 0L || lNetmask > allmask || nsize > allmask) {
            return 0L;
        }
        return nsize;
    }

    public String getOneIpFromThisNet(String net, String netmask) {
        long netLong = this.getAddrLong(net);
        return this.convertAddr(netLong + 1L);
    }

    public String[] getRange(String net, String netmask, String startIp, String endIp) {
        long startLong = this.getAddrLong(startIp);
        long endLong = this.getAddrLong(endIp);
        ArrayList<String> result = new ArrayList<String>();
        for (long i = startLong; i <= endLong && this.inNet(i, net, netmask); ++i) {
            result.add(this.convertAddr(i));
        }
        String[] array = new String[result.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (String)result.get(i);
        }
        return array;
    }

    public String[] getIPList(String net, String netmask) {
        String[] v = null;
        long allmask = this.getAddrLong("255.255.255.255");
        long lNetmask = this.getAddrLong(netmask);
        if (lNetmask == allmask) {
            v = new String[]{net};
            return v;
        }
        long lNet = this.getAddrLong(net);
        long nsize = allmask ^ lNetmask;
        if (lNetmask == 0L || lNet == 0L || lNetmask > allmask || nsize > allmask) {
            return new String[0];
        }
        long maxNsize = 65536L;
        long netSize = 65025L;
        if (nsize > 65536L) {
            nsize = 65025L;
        }
        long minNsize = 2L;
        if (nsize == 2L) {
            v = new String[]{this.convertAddr(lNet + 1L)};
            return v;
        }
        if (lNet + nsize - 1L > allmask) {
            return new String[0];
        }
        v = new String[(int)nsize - 1];
        int i = 0;
        while ((long)i < nsize - 1L) {
            v[i] = this.convertAddr(lNet + 1L + (long)i);
            ++i;
        }
        return v;
    }

    public String getNetAddr(String ipaddr, String netmask) {
        if (ipaddr != null && ipaddr.contains(":")) {
            return this.getIPV6NetAddr(ipaddr, netmask);
        }
        if (ipaddr != null && netmask != null) {
            if (ipaddr.equals(netmask)) {
                netmask = "255.255.255.0";
            }
            if (netmask.equals("255.255.255.255")) {
                netmask = "255.255.255.0";
            }
            if (netmask.equals("0.0.0.0")) {
                netmask = "255.255.255.0";
            }
        }
        long lNetmask = this.getAddrLong(netmask);
        long address = this.getAddrLong(ipaddr);
        long lNet = address & lNetmask;
        return this.convertAddr(lNet);
    }

    public String convertAddr(long address) {
        int[] addr = new int[4];
        for (int i = 0; i < 4; ++i) {
            addr[i] = (int)(address >> 8 * (3 - i) & 0xFFL);
        }
        return addr[0] + "." + addr[1] + "." + addr[2] + "." + addr[3];
    }

    public long getAddrLong(String address) {
        int[] addr = this.getAddrArray(address);
        if (addr.length == 0) {
            return 0L;
        }
        long laddr = 0L;
        for (int i = 0; i < 4; ++i) {
            laddr |= (long)(addr[i] << 8 * (3 - i));
        }
        return laddr;
    }

    public int[] getAddrArray(String address) {
        int i;
        if (address == null) {
            return new int[0];
        }
        if (address.indexOf(":") != -1) {
            return this.getIPV6AddrArray(address);
        }
        StringTokenizer st = new StringTokenizer(address, ".");
        if (st.countTokens() != 4) {
            return new int[0];
        }
        int[] addr = new int[4];
        try {
            for (i = 0; i < 4; ++i) {
                addr[i] = Integer.parseInt(st.nextToken());
            }
        }
        catch (NumberFormatException ne) {
            return new int[0];
        }
        for (i = 0; i < 4; ++i) {
            if (addr[i] >= 0 && addr[i] <= 255) continue;
            return new int[0];
        }
        return addr;
    }

    public String getDNSName(String address) {
        String name;
        if (!enableDNS) {
            return address;
        }
        try {
            InetAddress addr = InetAddress.getByName(address);
            name = addr.getHostName().trim();
        }
        catch (UnknownHostException uhe) {
            name = address;
        }
        return name.toLowerCase(Locale.US);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIP(String name) {
        Object object = this.lock;
        synchronized (object) {
            String ip;
            try {
                InetAddress addr = InetAddress.getByName(name);
                ip = addr.getHostAddress().trim();
            }
            catch (UnknownHostException uhe) {
                ip = name;
            }
            return ip;
        }
    }

    public boolean inNet(String ipaddr, String net, String netmask) {
        if (ipaddr.indexOf(":") != -1 && net.indexOf(":") != -1) {
            return this.inIPV6Net(ipaddr, net, netmask);
        }
        if (ipaddr.indexOf(":") != -1 || net.indexOf(":") != -1) {
            return false;
        }
        return this.inNet(this.getAddrLong(ipaddr), net, netmask);
    }

    private boolean inNet(long laddr, String net, String netmask) {
        long allmask = this.getAddrLong("255.255.255.255");
        long lNetmask = this.getAddrLong(netmask);
        long lNet = this.getAddrLong(net);
        lNet &= lNetmask;
        long nsize = allmask ^ lNetmask;
        if (laddr == 0L) {
            return false;
        }
        return laddr < lNet + nsize && laddr >= lNet;
    }

    public String getMinMaxAddr(List<?> list, boolean max) {
        String retval = (String)list.get(0);
        long smallval = this.getAddrLong(retval);
        for (int i = 1; i < list.size(); ++i) {
            String nextaddr = (String)list.get(i);
            long nextval = this.getAddrLong(nextaddr);
            if (!max) {
                if (nextval >= smallval) continue;
                retval = nextaddr;
                smallval = nextval;
                continue;
            }
            if (nextval <= smallval) continue;
            retval = nextaddr;
            smallval = nextval;
        }
        return retval;
    }

    public int getAddressRangeIndex(String ipAddr, List<?> lowAddrVect, List<?> hiAddrVect) {
        if (lowAddrVect == null || hiAddrVect == null) {
            return -1;
        }
        long currentIp = this.getAddrLong(ipAddr);
        if (currentIp == 0L) {
            return -1;
        }
        for (int i = 0; i < lowAddrVect.size(); ++i) {
            long startIp = this.getAddrLong((String)lowAddrVect.get(i));
            long endIp = this.getAddrLong((String)hiAddrVect.get(i));
            if (currentIp > endIp || currentIp < startIp) continue;
            return i;
        }
        return -1;
    }

    public boolean isAddressInRange(String ipAddr, List<?> lowAddrVect, List<?> hiAddrVect) {
        if (lowAddrVect == null && hiAddrVect == null) {
            return true;
        }
        long currentIp = this.getAddrLong(ipAddr);
        if (currentIp == 0L || null == lowAddrVect || null == hiAddrVect) {
            return false;
        }
        for (int i = 0; i < lowAddrVect.size(); ++i) {
            long startIp = this.getAddrLong((String)lowAddrVect.get(i));
            long endIp = this.getAddrLong((String)hiAddrVect.get(i));
            if (currentIp > endIp || currentIp < startIp) continue;
            return true;
        }
        return false;
    }

    public String getMACAddrFromIPV6Addr(String ipaddr) {
        int[] addr = this.getIPV6AddrArray(ipaddr);
        if (addr.length != 16) {
            return null;
        }
        int[] macAddr = new int[]{addr[8], addr[9], addr[10], addr[13], addr[14], addr[15]};
        int a = macAddr[0];
        String s1 = Integer.toBinaryString(a);
        if (s1.length() < 2) {
            return null;
        }
        char[] c = s1.toCharArray();
        c[s1.length() - 2] = 48;
        s1 = new String(c);
        macAddr[0] = Integer.valueOf(s1, 2);
        StringBuilder returnValue = new StringBuilder();
        for (int i = 0; i < macAddr.length; ++i) {
            returnValue.append(Integer.toHexString(macAddr[i]));
            returnValue.append(' ');
        }
        return returnValue.substring(0, returnValue.length() - 1);
    }

    public String[] getNetAndMaskFromIPV6Addr(String ipaddr, int prefixLength) {
        int i;
        ArrayList<String> netmaskVector = new ArrayList<String>();
        int networkPart = prefixLength / 8;
        int diff = prefixLength % 8;
        for (i = 0; i < networkPart; ++i) {
            netmaskVector.add("ff");
        }
        if (diff != 0) {
            char[] c = new char[]{'0', '0', '0', '0', '0', '0', '0', '0'};
            for (int i2 = 0; i2 < diff; ++i2) {
                c[i2] = 49;
            }
            String s1 = new String(c);
            netmaskVector.add(Integer.toHexString(Integer.valueOf(s1, 2)));
        }
        for (i = netmaskVector.size(); i < 16; ++i) {
            netmaskVector.add("00");
        }
        String netmask = "";
        StringBuilder ntmask = new StringBuilder();
        for (int i3 = 0; i3 < netmaskVector.size(); i3 += 2) {
            ntmask.append((String)netmaskVector.get(i3));
            ntmask.append((String)netmaskVector.get(i3 + 1));
            ntmask.append(':');
        }
        netmask = ntmask.toString();
        String network = this.getNetAddr(ipaddr, netmask = netmask.substring(0, netmask.length() - 1));
        if (network == null) {
            return new String[0];
        }
        try {
            netmask = InetAddress.getByName(netmask).getHostAddress();
        }
        catch (UnknownHostException ue) {
            LOGGER.error((Object)ue.getMessage());
        }
        return new String[]{network, netmask};
    }

    public boolean compareMACAddrs(String macAddr1, String macAddr2) {
        String delim1 = " ";
        if (macAddr1.indexOf(":") != -1) {
            delim1 = ":";
        } else if (macAddr1.indexOf("-") != -1) {
            delim1 = "-";
        }
        StringTokenizer st1 = new StringTokenizer(macAddr1, delim1);
        if (st1.countTokens() != 6) {
            return false;
        }
        int[] addr1 = new int[6];
        for (int i = 0; i < 6; ++i) {
            addr1[i] = Integer.parseInt(st1.nextToken(), 16);
        }
        String delim2 = " ";
        if (macAddr2.indexOf(":") != -1) {
            delim2 = ":";
        } else if (macAddr2.indexOf("-") != -1) {
            delim2 = "-";
        }
        StringTokenizer st2 = new StringTokenizer(macAddr2, delim2);
        if (st2.countTokens() != 6) {
            return false;
        }
        int[] addr2 = new int[6];
        for (int i = 0; i < 6; ++i) {
            addr2[i] = Integer.parseInt(st2.nextToken(), 16);
        }
        long laddr1 = 0L;
        for (int i = 0; i < 6; ++i) {
            laddr1 |= (long)(addr1[i] << 8 * (3 - i));
        }
        long laddr2 = 0L;
        for (int i = 0; i < 6; ++i) {
            laddr2 |= (long)(addr2[i] << 8 * (3 - i));
        }
        return laddr1 == laddr2;
    }

    public boolean compareIPV6Addrs(String ipaddr1, String ipaddr2) {
        String macaddr1 = this.getMACAddrFromIPV6Addr(ipaddr1);
        String macaddr2 = this.getMACAddrFromIPV6Addr(ipaddr2);
        if (macaddr1 == null || macaddr2 == null) {
            return false;
        }
        return this.compareMACAddrs(macaddr1, macaddr2);
    }

    private String getIPV6NetAddr(String ipaddr, String netmask) {
        int[] addr2;
        int[] addr1 = this.getIPV6AddrArray(ipaddr);
        if (this.checkNull(addr1, addr2 = this.getIPV6AddrArray(netmask))) {
            return null;
        }
        if (this.checkLength(addr1, addr2)) {
            return null;
        }
        int[] addr = new int[addr1.length];
        int k = 0;
        for (int j = 0; j < addr1.length; j += 4) {
            int[] temp1 = new int[]{addr1[j], addr1[j + 1], addr1[j + 2], addr1[j + 3]};
            int[] temp2 = new int[]{addr2[j], addr2[j + 1], addr2[j + 2], addr2[j + 3]};
            long laddr1 = 0L;
            for (int i = 0; i < 4; ++i) {
                laddr1 |= (long)(temp1[i] << 8 * (3 - i));
            }
            long laddr2 = 0L;
            for (int i = 0; i < 4; ++i) {
                laddr2 |= (long)(temp2[i] << 8 * (3 - i));
            }
            long lNet = laddr1 & laddr2;
            for (int i = 0; i < 4; ++i) {
                addr[k++] = (int)lNet >> 8 * (3 - i) & 0xFF;
            }
        }
        String network = "";
        StringBuffer sbTemp = new StringBuffer(network);
        for (int i = 0; i < addr.length; i += 2) {
            String temp1 = Integer.toHexString(addr[i]);
            for (int j = temp1.length(); j < 2; ++j) {
                temp1 = "0" + temp1;
            }
            String temp2 = Integer.toHexString(addr[i + 1]);
            for (int j = temp2.length(); j < 2; ++j) {
                temp2 = "0" + temp2;
            }
            sbTemp.append(temp1).append(temp2).append(':');
        }
        network = sbTemp.toString().substring(0, sbTemp.length() - 1);
        try {
            network = InetAddress.getByName(network).getHostAddress();
        }
        catch (UnknownHostException ue) {
            LOGGER.error((Object)ue.getMessage());
        }
        return network;
    }

    private boolean checkLength(int[] addr1, int[] addr2) {
        return addr1.length != 16 || addr2.length != 16;
    }

    private boolean checkNull(int[] addr1, int[] addr2) {
        return addr1 == null || addr2 == null;
    }

    private int[] getIPV6AddrArray(String address) {
        int i;
        try {
            InetAddress inet = InetAddress.getByName(address);
            address = inet.getHostAddress();
        }
        catch (UnknownHostException e) {
            LOGGER.error((Object)e.getMessage());
        }
        StringTokenizer st = new StringTokenizer(address, ":");
        if (st.countTokens() != 8) {
            return new int[0];
        }
        String[] str = new String[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            str[i2] = st.nextToken();
        }
        int[] addr = new int[16];
        int k = 0;
        for (i = 0; i < str.length; ++i) {
            for (int j = str[i].length(); j < 4; ++j) {
                str[i] = "0" + str[i];
            }
            String s1 = str[i].substring(0, 2);
            String s2 = str[i].substring(2);
            try {
                addr[k++] = Integer.parseInt(s1, 16);
                addr[k++] = Integer.parseInt(s2, 16);
                continue;
            }
            catch (NumberFormatException ne) {
                return new int[0];
            }
        }
        for (i = 0; i < 16; ++i) {
            if (addr[i] >= 0 && addr[i] <= 255) continue;
            return new int[0];
        }
        return addr;
    }

    private boolean inIPV6Net(String ipaddr, String network, String netmask) {
        String net = this.getIPV6NetAddr(ipaddr, netmask);
        try {
            network = InetAddress.getByName(network).getHostAddress();
        }
        catch (UnknownHostException ue) {
            LOGGER.error((Object)ue.getMessage());
        }
        if (null != net) {
            return net.equals(network);
        }
        return false;
    }

    public static WatchUtil getInstance() {
        return instance;
    }
}

