/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.perfmonitor.dao;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.device.model.Interface;
import com.huawei.atic.sdk.perfmonitor.model.DeviceIfTraffic;
import com.huawei.atic.sdk.perfmonitor.model.PerfMonitorForm;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IfTrafficDao
extends CommonDaoImpl {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);

    public void saveIfTraffic(List<DeviceIfTraffic> trafficList) {
        if (null == trafficList) {
            return;
        }
        for (DeviceIfTraffic deviceIfTraffic : trafficList) {
            this.getHibernateTemplate().saveOrUpdate((Object)deviceIfTraffic);
        }
    }

    public void deleteDataByTime(Long time) {
        String hql = "delete from DeviceIfTraffic where monitorTime < ?0";
        this.updateByHql(hql, new Object[]{time});
    }

    public Map<Integer, String> getIfIndexById(long moId) {
        String hql = "from Interface where deviceId = ?0 order by ifIndex asc";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        HashMap<Integer, String> resultMap = new HashMap<Integer, String>();
        List result = null;
        param.put(0, moId + "");
        result = this.findByHql(hql, param);
        if (null == result || result.isEmpty()) {
            return null;
        }
        List integerList = result;
        for (Interface interf : integerList) {
            resultMap.put(interf.getIfIndex(), interf.getIfDescr());
        }
        return resultMap;
    }

    public List<DeviceIfTraffic> getIfTraffic(PerfMonitorForm form) {
        String hql = "from DeviceIfTraffic where deviceId = ?0 and ifIndex = ?1 and monitorTime >= ?2 and monitorTime <= ?3 order by monitorTime asc";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, form.getDeviceId() + "");
        param.put(1, form.getIfIndex() + "");
        param.put(2, form.getStartTime() + "");
        param.put(3, form.getEndTime() + "");
        List result = null;
        this.logger.info((Object)("hql param: " + param + " in the getIfTraffic"));
        result = this.findByHql(hql, param);
        return result;
    }

    public Interface getOperStatus(long moId, String ifIndex) {
        String hql = "from Interface where deviceId = ?0 and ifIndex = ?1";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        List result = null;
        param.put(0, moId + "");
        param.put(1, ifIndex + "");
        result = this.findByHql(hql, param);
        if (null == result || result.isEmpty()) {
            return null;
        }
        return (Interface)result.get(0);
    }
}

