/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.resource.model;

import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.resource.sdk.model.TopoObject;
import com.hs.lego.cbb.util.ArrayDeepClone;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.south.model.Protocol;
import java.sql.Timestamp;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Node
extends TopoObject
implements Cloneable {
    public static final String PRIVATE_ENTERPRISE_STR = ".iso.org.dod.internet.private.enterprises";
    public static final String PRIVATE_ENTERPRISE_OID = ".1.3.6.1.4.1";
    private static final String OSVERSION_PATTERN_VRC = "V[0-9]{1,3}R[0-9]{1,3}C[0-9]{1,2}";
    private static final String OSVERSION_PATTERN_VR = "V[0-9]{1,3}R[0-9]{1,3}";
    private static final long serialVersionUID = 6353073827056979277L;
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private Timestamp discoveredTime = null;
    private String discoveredTimeStr = null;
    private String sysDescr;
    private String sysName;
    private String sysOid;
    private String devOsVersion;
    private String devLocation;
    private String extendProp;
    private Map<String, Protocol> managementProtocolMap = new HashMap<String, Protocol>();
    private Protocol discoveryProtocol = null;

    public Node() {
        this.setType(this.getClass().getName());
    }

    public Protocol getDiscoveryProtocol() {
        return this.discoveryProtocol;
    }

    public void setDiscoveryProtocol(Protocol discoveryProtocol) {
        this.discoveryProtocol = discoveryProtocol;
    }

    public String getDiscoveredTimeStr() {
        if (this.discoveredTime != null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.discoveredTimeStr = format.format(this.discoveredTime);
        }
        return this.discoveredTimeStr;
    }

    public Timestamp getDiscoveredTime() {
        return (Timestamp)ArrayDeepClone.deepClone((Object)this.discoveredTime);
    }

    public void setDiscoveredTime(Timestamp discoveredTime) {
        this.discoveredTime = (Timestamp)ArrayDeepClone.deepClone((Object)discoveredTime);
    }

    public Map<String, Protocol> getManagementProtocolMap() {
        return this.managementProtocolMap;
    }

    public void setManagementProtocolMap(Map<String, Protocol> managementProtocolMap) {
        this.managementProtocolMap = managementProtocolMap;
    }

    public void addManagementProtocol(String protocolParamName, Protocol managementProtocol) {
        this.managementProtocolMap.put(protocolParamName, managementProtocol);
    }

    public void removeManagementProtocol(String protocolParamName) {
        this.managementProtocolMap.remove(protocolParamName);
    }

    public Protocol getManagementProtocol(String protocolParamName) {
        return this.managementProtocolMap.get(protocolParamName);
    }

    public String getSysDescr() {
        return this.sysDescr;
    }

    public void setSysDescr(String sysDescr) {
        this.sysDescr = sysDescr;
    }

    public String getSysName() {
        return this.sysName;
    }

    public void setSysName(String sysName) {
        this.sysName = sysName;
    }

    public String getSysOid() {
        return this.sysOid;
    }

    public void setSysOid(String sysOid) {
        if (sysOid != null && (sysOid = Normalizer.normalize(sysOid, Normalizer.Form.NFKC)).contains(PRIVATE_ENTERPRISE_STR)) {
            sysOid = sysOid.replace(PRIVATE_ENTERPRISE_STR, PRIVATE_ENTERPRISE_OID);
            LOGGER.info((Object)("converted sysOid is : " + AticUtil.getcleanedMessage((String)sysOid)));
        }
        this.sysOid = sysOid;
    }

    public Node clone() throws CloneNotSupportedException {
        Node node = (Node)super.clone();
        if (this.managementProtocolMap != null) {
            HashMap<String, Protocol> clonedProtocolMap = new HashMap<String, Protocol>();
            node.setManagementProtocolMap(clonedProtocolMap);
            for (Map.Entry<String, Protocol> entry : this.managementProtocolMap.entrySet()) {
                clonedProtocolMap.put(entry.getKey(), entry.getValue().clone());
            }
        }
        return node;
    }

    public String toString() {
        return super.toString() + "-->Node [discoveredTime=" + this.discoveredTime + ", managementProtocolMap=" + this.managementProtocolMap + ", sysOid=" + this.sysOid + ", devOsVersion=" + this.devOsVersion + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        if (this.discoveredTime == null ? other.discoveredTime != null : !this.discoveredTime.equals(other.discoveredTime)) {
            return false;
        }
        if (this.sysDescr == null ? other.sysDescr != null : !this.sysDescr.equals(other.sysDescr)) {
            return false;
        }
        if (this.sysName == null ? other.sysName != null : !this.sysName.equals(other.sysName)) {
            return false;
        }
        return !(this.sysOid == null ? other.sysOid != null : !this.sysOid.equals(other.sysOid));
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String getFirewallDevOSVersionName(String strDevSysDescr) {
        String devOSVersionName = null;
        Pattern pattern1 = Pattern.compile(OSVERSION_PATTERN_VRC);
        Matcher matcher1 = pattern1.matcher(strDevSysDescr);
        boolean matchFound1 = matcher1.find();
        if (!matchFound1) {
            pattern1 = Pattern.compile(OSVERSION_PATTERN_VR);
            matcher1 = pattern1.matcher(strDevSysDescr);
            matchFound1 = matcher1.find();
        }
        if (matchFound1) {
            devOSVersionName = matcher1.group(0);
        }
        return devOSVersionName;
    }

    public void setDevOsVersion(String devOsVersion) {
        this.devOsVersion = devOsVersion;
    }

    public String getDevOsVersion() {
        return this.devOsVersion;
    }

    public void setDevLocation(String devLocation) {
        this.devLocation = devLocation;
    }

    public String getDevLocation() {
        return this.devLocation;
    }

    public void setExtendProp(String extendProp) {
        this.extendProp = extendProp;
    }

    public String getExtendProp() {
        return this.extendProp;
    }
}

